/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.DividerGridItemDecoration;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.ImageDirectoryAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.adapter.VideoPickAdapter;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class VideoPickActivity
extends BaseActivity {
    public static final String THUMBNAIL_PATH = "FilePick";
    public static final String IS_NEED_CAMERA = "IsNeedCamera";
    public static final String IS_TAKEN_AUTO_SELECTED = "IsTakenAutoSelected";
    private final int COLUMN_NUMBER = 2;
    private RecyclerView mRecyclerView;
    private VideoPickAdapter mAdapter;
    private ImageDirectoryAdapter directoryAdapter;
    private boolean isNeedCamera;
    private boolean isTakenAutoSelected;
    private ArrayList<VideoFile> mSelectedList = new ArrayList();
    private ProgressBar mProgressBar;
    private GridLayoutManager layoutManager;
    private boolean isDirectory;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        this.loadData();
    }

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.isNeedCamera = this.getIntent().getBooleanExtra(IS_NEED_CAMERA, false);
        this.isTakenAutoSelected = this.getIntent().getBooleanExtra(IS_TAKEN_AUTO_SELECTED, true);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pb_file_pick);
        this.setSupportActionBar(this.myToolbar);
        this.setToolbar(this.myToolbar, "Video Picker");
        this.layoutManager = new GridLayoutManager((Context)this, 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerGridItemDecoration((Context)this));
        this.mAdapter = new VideoPickAdapter((Context)this, this.isNeedCamera);
        this.directoryAdapter = new ImageDirectoryAdapter((Context)this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        this.directoryAdapter.setOnSelectStateListener(new OnSelectStateListener<Directory>(){

            @Override
            public void OnSelectStateChanged(boolean bl, Directory directory) {
                VideoPickActivity.this.isDirectory = true;
                VideoPickActivity.this.layoutManager.setSpanCount(3);
                VideoPickActivity.this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)VideoPickActivity.this.layoutManager);
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(directory.getFiles());
                VideoPickActivity.this.mAdapter.refresh(arrayList);
                VideoPickActivity.this.mRecyclerView.setAdapter((RecyclerView.Adapter)VideoPickActivity.this.mAdapter);
                VideoPickActivity.this.runLayoutAnimation(VideoPickActivity.this.mRecyclerView);
            }
        });
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<VideoFile>(){

            @Override
            public void OnSelectStateChanged(boolean bl, VideoFile videoFile) {
                VideoPickActivity.this.mSelectedList.add(videoFile);
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra("ResultPickVideo", VideoPickActivity.this.mSelectedList);
                VideoPickActivity.this.setResult(-1, intent);
                VideoPickActivity.this.finish();
            }
        });
        File file = new File(this.getExternalCacheDir().getAbsolutePath() + File.separator + THUMBNAIL_PATH);
        if (!file.exists()) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
    }

    public void onBackPressed() {
        if (this.isDirectory) {
            this.isDirectory = false;
            this.layoutManager.setSpanCount(2);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        switch (n) {
            case 513: {
                if (n2 != -1) break;
                Intent intent2 = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                File file = new File(this.mAdapter.mVideoPath);
                Uri uri = Uri.fromFile((File)file);
                intent2.setData(uri);
                this.sendBroadcast(intent2);
                this.loadData();
            }
        }
    }

    private void loadData() {
        FileFilter.getVideos((FragmentActivity)this, new FilterResultCallback<VideoFile>(){

            @Override
            public void onResult(List<Directory<VideoFile>> list) {
                VideoPickActivity.this.mProgressBar.setVisibility(8);
                if (VideoPickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> arrayList = new ArrayList<Directory>();
                    Directory directory = new Directory();
                    directory.setName(VideoPickActivity.this.getResources().getString(R.string.vw_all));
                    arrayList.add(directory);
                    arrayList.addAll(list);
                    VideoPickActivity.this.mFolderHelper.fillData(arrayList);
                }
                VideoPickActivity.this.refreshData(list);
            }
        });
    }

    private void refreshData(List<Directory<VideoFile>> list) {
        if (list.size() > 4) {
            ArrayList<Directory<VideoFile>> arrayList = new ArrayList<Directory<VideoFile>>();
            arrayList.addAll(list);
            this.directoryAdapter.refresh(arrayList);
        } else {
            boolean bl = this.isTakenAutoSelected;
            ArrayList<VideoFile> arrayList = new ArrayList<VideoFile>();
            for (Directory<VideoFile> object : list) {
                arrayList.addAll(object.getFiles());
                if (!bl) continue;
                bl = this.findAndAddTaken(object.getFiles());
            }
            for (VideoFile videoFile : this.mSelectedList) {
                int n = arrayList.indexOf(videoFile);
                if (n == -1) continue;
                ((VideoFile)arrayList.get(n)).setSelected(true);
            }
            this.mAdapter.refresh(arrayList);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        }
        this.runLayoutAnimation(this.mRecyclerView);
    }

    private boolean findAndAddTaken(List<VideoFile> list) {
        for (VideoFile videoFile : list) {
            if (!videoFile.getPath().equals(this.mAdapter.mVideoPath)) continue;
            this.mSelectedList.add(videoFile);
            return true;
        }
        return false;
    }

    private void runLayoutAnimation(RecyclerView recyclerView) {
        Context context = recyclerView.getContext();
        LayoutAnimationController layoutAnimationController = AnimationUtils.loadLayoutAnimation((Context)context, (int)R.anim.hippo_layout_animation_from_bottom);
        recyclerView.setLayoutAnimation(layoutAnimationController);
        recyclerView.getAdapter().notifyDataSetChanged();
        recyclerView.scheduleLayoutAnimation();
    }
}

