/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.utils.filepicker.DividerListItemDecoration;
import com.hippo.utils.filepicker.FileUtils;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.NormalFilePickAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NormalFilePickActivity
extends BaseActivity {
    public static String id1 = "test_channel_01";
    private static final String TAG = NormalFilePickActivity.class.getSimpleName();
    public static final int DEFAULT_MAX_NUMBER = 9;
    private static final int REQUEST_CODE = 6384;
    public static final String SUFFIX = "Suffix";
    private int mMaxNumber;
    private RecyclerView mRecyclerView;
    private NormalFilePickAdapter mAdapter;
    private ArrayList<NormalFile> mSelectedList = new ArrayList();
    private ProgressBar mProgressBar;
    private String[] mSuffix;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                NormalFilePickActivity.this.loadData();
            }
        }, 2000L);
    }

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.mMaxNumber = this.getIntent().getIntExtra("MaxNumber", 9);
        this.mSuffix = this.getIntent().getStringArrayExtra(SUFFIX);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.setToolbar(this.myToolbar, "Documents");
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pb_file_pick);
        this.mProgressBar.setVisibility(0);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerListItemDecoration((Context)this, 1, R.drawable.vw_divider_rv_file));
        this.mAdapter = new NormalFilePickAdapter((Context)this, this.mMaxNumber);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<NormalFile>(){

            @Override
            public void OnSelectStateChanged(boolean bl, NormalFile normalFile) {
                if (normalFile == null) {
                    NormalFilePickActivity.this.openFileManager();
                } else {
                    NormalFilePickActivity.this.mSelectedList.add(normalFile);
                    Intent intent = new Intent();
                    intent.putParcelableArrayListExtra("ResultPickFILE", NormalFilePickActivity.this.mSelectedList);
                    NormalFilePickActivity.this.setResult(-1, intent);
                    NormalFilePickActivity.this.finish();
                }
            }
        });
    }

    private void loadData() {
        FileFilter.getFiles((FragmentActivity)this, new FilterResultCallback<NormalFile>(){

            @Override
            public void onResult(List<Directory<NormalFile>> list) {
                if (NormalFilePickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> arrayList = new ArrayList<Directory>();
                    Directory directory = new Directory();
                    directory.setName(NormalFilePickActivity.this.getResources().getString(R.string.vw_all));
                    arrayList.add(directory);
                    arrayList.addAll(list);
                    NormalFilePickActivity.this.mFolderHelper.fillData(arrayList);
                }
                NormalFilePickActivity.this.refreshData(list);
            }
        }, this.mSuffix);
    }

    private void refreshData(List<Directory<NormalFile>> list) {
        this.mProgressBar.setVisibility(8);
        ArrayList<NormalFile> arrayList = new ArrayList<NormalFile>();
        for (Directory<NormalFile> object : list) {
            arrayList.addAll(object.getFiles());
        }
        for (NormalFile normalFile : this.mSelectedList) {
            int n = arrayList.indexOf(normalFile);
            if (n == -1) continue;
            ((NormalFile)arrayList.get(n)).setSelected(true);
        }
        this.mAdapter.refresh(arrayList);
    }

    private void openFileManager() {
        Intent intent = FileUtils.createGetContentIntent();
        Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)"");
        try {
            this.startActivityForResult(intent2, 6384);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void onActivityResult(int n, int n2, Intent intent) {
        block3: {
            super.onActivityResult(n, n2, intent);
            if (n == 6384 && n2 == -1 && intent != null && intent.getData() != null) {
                try {
                    Uri uri = intent.getData();
                    String string2 = FileUtils.getPath((Context)this, uri);
                    NormalFile normalFile = new NormalFile();
                    String string3 = Util.extractFileNameWithoutSuffix(string2);
                    normalFile.setPath(string2);
                    normalFile.setName(string3);
                    normalFile.setSize(new File(string2).length());
                    this.mSelectedList.add(normalFile);
                    Intent intent2 = new Intent();
                    intent2.putParcelableArrayListExtra("ResultPickFILE", this.mSelectedList);
                    this.setResult(-1, intent2);
                    this.finish();
                }
                catch (Exception exception) {
                    if (!HippoConfig.DEBUG) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    private void createchannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(id1, (CharSequence)"Testing", 2);
            notificationChannel.setDescription("Testing description");
            notificationChannel.enableLights(true);
            notificationChannel.setShowBadge(true);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }
}

