/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.DividerListItemDecoration;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.AudioPickAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import com.hippo.utils.filepicker.filter.entity.Directory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AudioPickActivity
extends BaseActivity {
    public static final String IS_NEED_RECORDER = "IsNeedRecorder";
    public static final String IS_TAKEN_AUTO_SELECTED = "IsTakenAutoSelected";
    private RecyclerView mRecyclerView;
    private AudioPickAdapter mAdapter;
    private ArrayList<AudioFile> mSelectedList = new ArrayList();
    private Toolbar myToolbar;
    private MediaPlayer mediaPlayer;

    @Override
    public void permissionGranted() {
        this.loadData();
    }

    @Override
    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.setToolbar(this.myToolbar, "Audio Picker");
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerListItemDecoration((Context)this, 1, R.drawable.vw_divider_rv_file));
        this.mAdapter = new AudioPickAdapter((Context)this, this.mRecyclerView);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<AudioFile>(){

            @Override
            public void OnSelectStateChanged(boolean bl, AudioFile audioFile) {
                if (!bl) {
                    if (AudioPickActivity.this.mediaPlayer.isPlaying()) {
                        AudioPickActivity.this.mediaPlayer.stop();
                        AudioPickActivity.this.mediaPlayer.reset();
                    }
                    return;
                }
                Uri uri = Uri.parse((String)audioFile.getPath());
                AudioPickActivity.this.mediaPlayer = AudioPickActivity.this.getMediaPlayer();
                AudioPickActivity.this.mediaPlayer.setAudioStreamType(3);
                if (AudioPickActivity.this.mediaPlayer.isPlaying()) {
                    AudioPickActivity.this.mediaPlayer.stop();
                    AudioPickActivity.this.mediaPlayer.reset();
                }
                try {
                    AudioPickActivity.this.mediaPlayer.setDataSource((Context)AudioPickActivity.this, uri);
                    AudioPickActivity.this.mediaPlayer.prepareAsync();
                    AudioPickActivity.this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mediaPlayer) {
                            AudioPickActivity.this.mediaPlayer = mediaPlayer;
                            AudioPickActivity.this.mediaPlayer.start();
                        }
                    });
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                AudioPickActivity.this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mediaPlayer) {
                        AudioPickActivity.this.mediaPlayer.release();
                    }
                });
                AudioPickActivity.this.mSelectedList.clear();
                AudioPickActivity.this.mSelectedList.add(audioFile);
            }
        });
    }

    private void loadData() {
        FileFilter.getAudios((FragmentActivity)this, new FilterResultCallback<AudioFile>(){

            @Override
            public void onResult(List<Directory<AudioFile>> list) {
                if (AudioPickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> arrayList = new ArrayList<Directory>();
                    Directory directory = new Directory();
                    directory.setName(AudioPickActivity.this.getResources().getString(R.string.vw_all));
                    arrayList.add(directory);
                    arrayList.addAll(list);
                    AudioPickActivity.this.mFolderHelper.fillData(arrayList);
                }
                AudioPickActivity.this.refreshData(list);
            }
        });
    }

    private void refreshData(List<Directory<AudioFile>> list) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Directory<AudioFile> object : list) {
            arrayList.addAll(object.getFiles());
        }
        for (AudioFile audioFile : this.mSelectedList) {
            int n = arrayList.indexOf(audioFile);
            if (n == -1) continue;
            ((AudioFile)arrayList.get(n)).setSelected(true);
        }
        this.mAdapter.refresh(arrayList);
    }

    protected void onPause() {
        super.onPause();
        this.stopMedia();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.hippo_done, menu2);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.menu_done) {
            Intent intent = new Intent();
            intent.putParcelableArrayListExtra("ResultPickAudio", this.mSelectedList);
            this.setResult(-1, intent);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPlayer getMediaPlayer() {
        if (this.mediaPlayer == null) {
            AudioPickActivity audioPickActivity = this;
            synchronized (audioPickActivity) {
                if (this.mediaPlayer == null) {
                    this.mediaPlayer = new MediaPlayer();
                }
            }
        }
        return this.mediaPlayer;
    }

    private void stopMedia() {
        try {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

