/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

public class DividerListItemDecoration
extends RecyclerView.ItemDecoration {
    private int mOrientation;
    private Drawable mDivider;
    private static final int[] ATTRS = new int[]{16843284};

    public DividerListItemDecoration(Context context, int n, int n2) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Orientation Only Support LinearLayoutManager.VERTICAL or LinearLayoutManager.HORIZONTAL");
        }
        this.mOrientation = n;
        if (n2 == -1) {
            TypedArray typedArray = context.obtainStyledAttributes(ATTRS);
            this.mDivider = typedArray.getDrawable(0);
            typedArray.recycle();
        } else {
            this.mDivider = ContextCompat.getDrawable((Context)context, (int)n2);
        }
    }

    public DividerListItemDecoration(Context context, int n) {
        this(context, n, -1);
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            this.drawHorizontalDivider(canvas, recyclerView);
        } else {
            this.drawVerticalDivider(canvas, recyclerView);
        }
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            rect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
        } else {
            rect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
        }
    }

    public void onDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        super.onDrawOver(canvas, recyclerView, state);
    }

    private void drawHorizontalDivider(Canvas canvas, RecyclerView recyclerView) {
        int n = recyclerView.getPaddingLeft();
        int n2 = recyclerView.getWidth() - recyclerView.getPaddingRight();
        int n3 = recyclerView.getChildCount();
        for (int j = 0; j < n3; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n4 = view.getBottom() + layoutParams.bottomMargin;
            int n5 = n4 + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(n, n4, n2, n5);
            this.mDivider.draw(canvas);
        }
    }

    private void drawVerticalDivider(Canvas canvas, RecyclerView recyclerView) {
        int n = recyclerView.getPaddingTop();
        int n2 = recyclerView.getHeight() - recyclerView.getPaddingBottom();
        int n3 = recyclerView.getChildCount();
        for (int j = 0; j < n3; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n4 = view.getRight() + layoutParams.rightMargin;
            int n5 = n4 + this.mDivider.getIntrinsicWidth();
            this.mDivider.setBounds(n4, n, n5, n2);
            this.mDivider.draw(canvas);
        }
    }
}

