/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class DividerGridItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable mDivider;
    private int mSpacing = 3;

    public DividerGridItemDecoration(Context context) {
        TypedArray typedArray = context.obtainStyledAttributes(ATTRS);
        this.mDivider = typedArray.getDrawable(0);
        typedArray.recycle();
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        this.drawHorizontal(canvas, recyclerView);
        this.drawVertical(canvas, recyclerView);
    }

    private int getSpanCount(RecyclerView recyclerView) {
        int n = -1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            n = ((GridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            n = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return n;
    }

    public void drawHorizontal(Canvas canvas, RecyclerView recyclerView) {
        int n = recyclerView.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n2 = view.getLeft() - layoutParams.leftMargin;
            int n3 = view.getRight() + layoutParams.rightMargin + this.mDivider.getIntrinsicWidth();
            int n4 = view.getBottom() + layoutParams.bottomMargin;
            int n5 = n4 + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(n2, n4, n3, n5);
            this.mDivider.draw(canvas);
        }
    }

    public void drawVertical(Canvas canvas, RecyclerView recyclerView) {
        int n = recyclerView.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n2 = view.getTop() - layoutParams.topMargin;
            int n3 = view.getBottom() + layoutParams.bottomMargin;
            int n4 = view.getRight() + layoutParams.rightMargin;
            int n5 = n4 + this.mDivider.getIntrinsicWidth();
            this.mDivider.setBounds(n4, n2, n5, n3);
            this.mDivider.draw(canvas);
        }
    }

    private boolean isLastColum(RecyclerView recyclerView, int n, int n2, int n3) {
        int n4;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        return layoutManager instanceof GridLayoutManager ? (n + 1) % n2 == 0 : layoutManager instanceof StaggeredGridLayoutManager && ((n4 = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? (n + 1) % n2 == 0 : n >= (n3 -= n3 % n2));
    }

    private boolean isLastRaw(RecyclerView recyclerView, int n, int n2, int n3) {
        int n4;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        return layoutManager instanceof GridLayoutManager ? n >= (n3 -= n3 % n2) : layoutManager instanceof StaggeredGridLayoutManager && ((n4 = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? n >= (n3 -= n3 % n2) : (n + 1) % n2 == 0);
    }

    public void getItemOffsets(Rect rect, int n, RecyclerView recyclerView) {
        rect.set(this.mSpacing, this.mSpacing, this.mSpacing, this.mSpacing);
    }
}

