/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.filepicker.CompressorListener;
import com.hippo.utils.filepicker.ImageUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.io.IOException;

public class Compressor
implements FuguAppConstant {
    private float maxWidth = 612.0f;
    private float maxHeight = 816.0f;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private int quality = 80;
    private String destinationDirectoryPath = Util.getDirectoryPath((String)FOLDER_TYPE.get("image"));
    private CompressorListener compressorListener;

    public Compressor setMaxWidth(float f2) {
        this.maxWidth = f2;
        return this;
    }

    public Compressor setMaxHeight(float f2) {
        this.maxHeight = f2;
        return this;
    }

    public Compressor setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
        return this;
    }

    public Compressor setQuality(int n) {
        this.quality = n;
        return this;
    }

    public Compressor setListener(CompressorListener compressorListener) {
        this.compressorListener = compressorListener;
        return this;
    }

    public Compressor setDestinationDirectoryPath(String string2) {
        this.destinationDirectoryPath = string2;
        return this;
    }

    public void compressToFile(File file, ImageFile imageFile) throws IOException {
        String string2 = this.destinationDirectoryPath + File.separator + imageFile.getName() + "_" + imageFile.getMuid() + ".jpg";
        if (!TextUtils.isEmpty((CharSequence)imageFile.getPath())) {
            string2 = imageFile.getDestinationPath();
        }
        ImageUtil.compressImage(file, imageFile, this.maxWidth, this.maxHeight, this.compressFormat, this.quality, string2, this.compressorListener);
    }
}

