/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.fileUpload;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;
import java.util.Set;

public class Prefs {
    private static final String TAG = "HIPPO_PREF";
    static Prefs singleton = null;
    static SharedPreferences preferences;
    static SharedPreferences.Editor editor;

    Prefs(Context context) {
        preferences = context.getSharedPreferences(TAG, 0);
        editor = preferences.edit();
    }

    public static Prefs with(Context context) {
        if (singleton == null) {
            singleton = new Builder(context).build();
        }
        return singleton;
    }

    public boolean contains(String string2) {
        return preferences.contains(string2);
    }

    public void save(String string2, boolean bl) {
        editor.putBoolean(string2, bl).apply();
    }

    public void save(String string2, String string3) {
        editor.putString(string2, string3).apply();
    }

    public void save(String string2, int n) {
        editor.putInt(string2, n).apply();
    }

    public void save(String string2, float f2) {
        editor.putFloat(string2, f2).apply();
    }

    public void save(String string2, long l) {
        editor.putLong(string2, l).apply();
    }

    public void save(String string2, Set<String> set) {
        editor.putStringSet(string2, set).apply();
    }

    public boolean getBoolean(String string2, boolean bl) {
        return preferences.getBoolean(string2, bl);
    }

    public String getString(String string2, String string3) {
        return preferences.getString(string2, string3);
    }

    public int getInt(String string2, int n) {
        return preferences.getInt(string2, n);
    }

    public float getFloat(String string2, float f2) {
        return preferences.getFloat(string2, f2);
    }

    public long getLong(String string2, long l) {
        return preferences.getLong(string2, l);
    }

    public Set<String> getStringSet(String string2, Set<String> set) {
        return preferences.getStringSet(string2, set);
    }

    public Map<String, ?> getAll() {
        return preferences.getAll();
    }

    public void remove(String string2) {
        editor.remove(string2).apply();
    }

    public void removeAll() {
        editor.clear();
        editor.apply();
    }

    private static class Builder {
        private final Context context;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Prefs build() {
            return new Prefs(this.context);
        }
    }
}

