/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.content.DialogInterface;
import androidx.fragment.app.Fragment;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.easypermissions.RationaleDialogConfig;
import com.hippo.utils.easypermissions.RationaleDialogFragment;
import com.hippo.utils.easypermissions.RationaleDialogFragmentCompat;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.util.Arrays;

class RationaleDialogClickListener
implements DialogInterface.OnClickListener {
    private Object mHost;
    private RationaleDialogConfig mConfig;
    private EasyPermissions.PermissionCallbacks mCallbacks;
    private EasyPermissions.RationaleCallbacks mRationaleCallbacks;

    RationaleDialogClickListener(RationaleDialogFragmentCompat rationaleDialogFragmentCompat, RationaleDialogConfig rationaleDialogConfig, EasyPermissions.PermissionCallbacks permissionCallbacks, EasyPermissions.RationaleCallbacks rationaleCallbacks) {
        this.mHost = rationaleDialogFragmentCompat.getParentFragment() != null ? rationaleDialogFragmentCompat.getParentFragment() : rationaleDialogFragmentCompat.getActivity();
        this.mConfig = rationaleDialogConfig;
        this.mCallbacks = permissionCallbacks;
        this.mRationaleCallbacks = rationaleCallbacks;
    }

    RationaleDialogClickListener(RationaleDialogFragment rationaleDialogFragment, RationaleDialogConfig rationaleDialogConfig, EasyPermissions.PermissionCallbacks permissionCallbacks, EasyPermissions.RationaleCallbacks rationaleCallbacks) {
        this.mHost = rationaleDialogFragment.getActivity();
        this.mConfig = rationaleDialogConfig;
        this.mCallbacks = permissionCallbacks;
        this.mRationaleCallbacks = rationaleCallbacks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClick(DialogInterface dialogInterface, int n) {
        int n2 = this.mConfig.requestCode;
        if (n == -1) {
            String[] stringArray = this.mConfig.permissions;
            if (this.mRationaleCallbacks != null) {
                this.mRationaleCallbacks.onRationaleAccepted(n2);
            }
            if (this.mHost instanceof Fragment) {
                PermissionHelper.newInstance((Fragment)this.mHost).directRequestPermissions(n2, stringArray);
                return;
            } else {
                if (!(this.mHost instanceof Activity)) throw new RuntimeException("Host must be an Activity or Fragment!");
                PermissionHelper.newInstance((Activity)this.mHost).directRequestPermissions(n2, stringArray);
            }
            return;
        } else {
            if (this.mRationaleCallbacks != null) {
                this.mRationaleCallbacks.onRationaleDenied(n2);
            }
            this.notifyPermissionDenied();
        }
    }

    private void notifyPermissionDenied() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onPermissionsDenied(this.mConfig.requestCode, Arrays.asList(this.mConfig.permissions));
        }
    }
}

