/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import com.hippo.R;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.util.Arrays;

public final class PermissionRequest {
    private final PermissionHelper mHelper;
    private final String[] mPerms;
    private final int mRequestCode;
    private final String mRationale;
    private final String mPositiveButtonText;
    private final String mNegativeButtonText;
    private final int mTheme;

    private PermissionRequest(PermissionHelper permissionHelper, String[] stringArray, int n, String string2, String string3, String string4, int n2) {
        this.mHelper = permissionHelper;
        this.mPerms = (String[])stringArray.clone();
        this.mRequestCode = n;
        this.mRationale = string2;
        this.mPositiveButtonText = string3;
        this.mNegativeButtonText = string4;
        this.mTheme = n2;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PermissionHelper getHelper() {
        return this.mHelper;
    }

    @NonNull
    public String[] getPerms() {
        return (String[])this.mPerms.clone();
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    @NonNull
    public String getRationale() {
        return this.mRationale;
    }

    @NonNull
    public String getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    @NonNull
    public String getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    @StyleRes
    public int getTheme() {
        return this.mTheme;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PermissionRequest permissionRequest = (PermissionRequest)object;
        return Arrays.equals(this.mPerms, permissionRequest.mPerms) && this.mRequestCode == permissionRequest.mRequestCode;
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.mPerms);
        n = 31 * n + this.mRequestCode;
        return n;
    }

    public String toString() {
        return "PermissionRequest{mHelper=" + this.mHelper + ", mPerms=" + Arrays.toString(this.mPerms) + ", mRequestCode=" + this.mRequestCode + ", mRationale='" + this.mRationale + '\'' + ", mPositiveButtonText='" + this.mPositiveButtonText + '\'' + ", mNegativeButtonText='" + this.mNegativeButtonText + '\'' + ", mTheme=" + this.mTheme + '}';
    }

    public static final class Builder {
        private final PermissionHelper mHelper;
        private final int mRequestCode;
        private final String[] mPerms;
        private String mRationale;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private int mTheme = -1;

        public Builder(@NonNull Activity activity, int n, String ... stringArray) {
            this.mHelper = PermissionHelper.newInstance(activity);
            this.mRequestCode = n;
            this.mPerms = stringArray;
        }

        public Builder(@NonNull Fragment fragment, int n, String ... stringArray) {
            this.mHelper = PermissionHelper.newInstance(fragment);
            this.mRequestCode = n;
            this.mPerms = stringArray;
        }

        @NonNull
        public Builder setRationale(@Nullable String string2) {
            this.mRationale = string2;
            return this;
        }

        @NonNull
        public Builder setRationale(@StringRes int n) {
            this.mRationale = this.mHelper.getContext().getString(n);
            return this;
        }

        @NonNull
        public Builder setPositiveButtonText(@Nullable String string2) {
            this.mPositiveButtonText = string2;
            return this;
        }

        @NonNull
        public Builder setPositiveButtonText(@StringRes int n) {
            this.mPositiveButtonText = this.mHelper.getContext().getString(n);
            return this;
        }

        @NonNull
        public Builder setNegativeButtonText(@Nullable String string2) {
            this.mNegativeButtonText = string2;
            return this;
        }

        @NonNull
        public Builder setNegativeButtonText(@StringRes int n) {
            this.mNegativeButtonText = this.mHelper.getContext().getString(n);
            return this;
        }

        @NonNull
        public Builder setTheme(@StyleRes int n) {
            this.mTheme = n;
            return this;
        }

        @NonNull
        public PermissionRequest build() {
            if (this.mRationale == null) {
                this.mRationale = this.mHelper.getContext().getString(R.string.hippo_rationale_ask);
            }
            if (this.mPositiveButtonText == null) {
                this.mPositiveButtonText = this.mHelper.getContext().getString(17039370);
            }
            if (this.mNegativeButtonText == null) {
                this.mNegativeButtonText = this.mHelper.getContext().getString(0x1040000);
            }
            return new PermissionRequest(this.mHelper, this.mPerms, this.mRequestCode, this.mRationale, this.mPositiveButtonText, this.mNegativeButtonText, this.mTheme);
        }
    }
}

