/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.countrypicker;

import android.content.Context;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import com.hippo.R;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPickerDialog;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class CurrencyPicker
implements CountryPickerDialog.CountryPickerDialogInteractionListener {
    private final Country[] CURRENCIES = new Country[]{new Country(1, "$", "USD", "United States dollar"), new Country(2, "\u200e\u20ac", "EUR", "Euro"), new Country(3, "\u00a5\u200e", "JPY", "Japanese yen"), new Country(4, "\u00a3", "GBP", "Pound sterling"), new Country(5, "$", "AUD", "Australian dollar"), new Country(6, "C$", "CAD", "Canadian dollar"), new Country(7, "Fr.", "CHF", "Swiss franc"), new Country(8, "\u00a5", "CNY", "Chinese yuan"), new Country(9, "kr", "SEK", "Swedish krona"), new Country(10, "Mex$", "MXN", "Mexican peso"), new Country(11, "NZ$", "NZD", "New Zealand dollar"), new Country(12, "S$", "SGD", "Singapore dollar"), new Country(13, "HK$", "HKD", "Hong Kong dollar"), new Country(14, "kr", "NOK", "Norwegian krone"), new Country(15, "\u20a9", "KRW", "South Korean won"), new Country(16, "\u20b9", "INR", "Indian rupee"), new Country(17, "\u20bd", "RUB", "Russian ruble"), new Country(18, "R", "ZAR", "South African rand"), new Country(19, "KSh", "KES", "Kenyan Shilling"), new Country(20, "ZK", "ZMW", "Zambian Kwacha"), new Country(21, "AED", "AED", "Arab Emirates Dirham"), new Country(22, "E\u00a3", "EGP", "Egyptian Pound"), new Country(23, "S", "PEN", "Peruvian Sol"), new Country(24, "UGX", "UGX", "Ugandan Shilling"), new Country(25, "\u0639.\u062f", "IQD", "Iraqi Dinar"), new Country(26, "\ufdfc", "QAR", "Qatari Riyal"), new Country(27, "$", "COP", "Colombian Peso"), new Country(28, "kr", "SEK", "Swedish Krona"), new Country(29, "\u20a6", "NGN", "Nigerian Naira"), new Country(30, "RM", "MYR", "Malaysian Ringgit"), new Country(31, "re", "RES", "res")};
    public static final int SORT_BY_NONE = 0;
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_ISO = 2;
    public static final int SORT_BY_DIAL_CODE = 3;
    private static final String COUNTRY_TAG = "COUNTRY_PICKER";
    private Context context;
    private int sortBy = 0;
    private OnCountryPickerListener onCountryPickerListener;
    private boolean canSearch = true;
    private List<Country> countries;

    private CurrencyPicker() {
    }

    CurrencyPicker(Builder builder) {
        this.sortBy = builder.sortBy;
        if (builder.onCountryPickerListener != null) {
            this.onCountryPickerListener = builder.onCountryPickerListener;
        }
        this.context = builder.context;
        this.canSearch = builder.canSearch;
        this.countries = new ArrayList<Country>(Arrays.asList(this.CURRENCIES));
        this.sortCountries(this.countries);
    }

    @Override
    public void sortCountries(@NonNull List<Country> list) {
        Collections.sort(list, new Comparator<Country>(){

            @Override
            public int compare(Country country, Country country2) {
                return country.getName().trim().compareToIgnoreCase(country2.getName().trim());
            }
        });
    }

    @Override
    public List<Country> getAllCountries() {
        return this.countries;
    }

    @Override
    public boolean canSearch() {
        return this.canSearch;
    }

    public void showDialog(@NonNull FragmentManager fragmentManager) {
        if (this.countries == null || this.countries.isEmpty()) {
            throw new IllegalArgumentException(this.context.getString(R.string.hippo_error_no_countries_found));
        }
        CountryPickerDialog countryPickerDialog = CountryPickerDialog.newInstance();
        if (this.onCountryPickerListener != null) {
            countryPickerDialog.setCountryPickerListener(this.onCountryPickerListener);
        }
        countryPickerDialog.setDialogInteractionListener(this);
        countryPickerDialog.show(fragmentManager, COUNTRY_TAG);
    }

    public void setCountries(@NonNull List<Country> list) {
        this.countries.clear();
        this.countries.addAll(list);
        this.sortCountries(this.countries);
    }

    public Country getCountryFromSIM() {
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        if (telephonyManager != null && telephonyManager.getSimState() != 1) {
            return this.getCountryByISO(telephonyManager.getSimCountryIso());
        }
        return null;
    }

    public Country getCountryByLocale(@NonNull Locale locale) {
        String string2 = locale.getISO3Country().substring(0, 2).toLowerCase();
        return this.getCountryByISO(string2);
    }

    public Country getCountryByName(@NonNull String string2) {
        string2 = string2.toUpperCase();
        Country country = new Country();
        country.setName(string2);
        int n = Arrays.binarySearch(this.CURRENCIES, country, new NameComparator());
        if (n < 0) {
            return null;
        }
        return this.CURRENCIES[n];
    }

    public Country getCountryByISO(@NonNull String string2) {
        string2 = string2.toUpperCase();
        Country country = new Country();
        country.setCode(string2);
        int n = Arrays.binarySearch(this.CURRENCIES, country, new ISOCodeComparator());
        if (n < 0) {
            return null;
        }
        return this.CURRENCIES[n];
    }

    public static class NameComparator
    implements Comparator<Country> {
        @Override
        public int compare(Country country, Country country2) {
            return country.getName().compareTo(country2.getName());
        }
    }

    public static class ISOCodeComparator
    implements Comparator<Country> {
        @Override
        public int compare(Country country, Country country2) {
            return country.getCode().compareTo(country2.getCode());
        }
    }

    public static class Builder {
        private Context context;
        private int sortBy = 0;
        private boolean canSearch = true;
        private OnCountryPickerListener onCountryPickerListener;

        public Builder with(@NonNull Context context) {
            this.context = context;
            return this;
        }

        public Builder sortBy(@NonNull int n) {
            this.sortBy = n;
            return this;
        }

        public Builder listener(@NonNull OnCountryPickerListener onCountryPickerListener) {
            this.onCountryPickerListener = onCountryPickerListener;
            return this;
        }

        public Builder canSearch(@NonNull boolean bl) {
            this.canSearch = bl;
            return this;
        }

        public CurrencyPicker build() {
            return new CurrencyPicker(this);
        }
    }
}

