/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.countrypicker;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.OnItemClickListener;
import java.util.List;

public class CountriesAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener listener;
    private List<Country> countries;
    private Context context;

    public CountriesAdapter(Context context, List<Country> list, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.countries = list;
        this.listener = onItemClickListener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_item_country, viewGroup, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        final Country country = this.countries.get(n);
        if (!TextUtils.isEmpty((CharSequence)country.getSymbol())) {
            viewHolder.countryNameText.setText((CharSequence)(country.getName() + "(" + country.getSymbol() + ")"));
        } else {
            viewHolder.countryNameText.setText((CharSequence)(country.getName() + " (" + country.getDialCode() + ")"));
            country.loadFlagByCode(this.context);
            if (country.getFlag() != -1) {
                viewHolder.countryFlagImageView.setImageResource(country.getFlag());
            }
        }
        viewHolder.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CountriesAdapter.this.listener.onItemClicked(country);
            }
        });
    }

    public int getItemCount() {
        return this.countries.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView countryFlagImageView;
        private TextView countryNameText;
        private LinearLayout rootView;

        ViewHolder(View view) {
            super(view);
            this.countryFlagImageView = (ImageView)view.findViewById(R.id.country_flag);
            this.countryNameText = (TextView)view.findViewById(R.id.country_title);
            this.rootView = (LinearLayout)view.findViewById(R.id.rootView);
        }
    }
}

