/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.beatAnimation;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Indicator
extends Drawable
implements Animatable {
    private HashMap<ValueAnimator, ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new HashMap();
    private ArrayList<ValueAnimator> mAnimators;
    private int alpha = 255;
    private static final Rect ZERO_BOUNDS_RECT = new Rect();
    protected Rect drawBounds = ZERO_BOUNDS_RECT;
    private boolean mHasAnimators;
    private Paint mPaint = new Paint();

    public Indicator() {
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public void setColor(int n) {
        this.mPaint.setColor(n);
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getOpacity() {
        return -1;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public void draw(Canvas canvas) {
        this.draw(canvas, this.mPaint);
    }

    public abstract void draw(Canvas var1, Paint var2);

    public abstract ArrayList<ValueAnimator> onCreateAnimators();

    public void start() {
        this.ensureAnimators();
        if (this.mAnimators == null) {
            return;
        }
        if (this.isStarted()) {
            return;
        }
        this.startAnimators();
        this.invalidateSelf();
    }

    private void startAnimators() {
        for (int j = 0; j < this.mAnimators.size(); ++j) {
            ValueAnimator valueAnimator = this.mAnimators.get(j);
            ValueAnimator.AnimatorUpdateListener animatorUpdateListener = this.mUpdateListeners.get(valueAnimator);
            if (animatorUpdateListener != null) {
                valueAnimator.addUpdateListener(animatorUpdateListener);
            }
            valueAnimator.start();
        }
    }

    private void stopAnimators() {
        if (this.mAnimators != null) {
            for (ValueAnimator valueAnimator : this.mAnimators) {
                if (valueAnimator == null || !valueAnimator.isStarted()) continue;
                valueAnimator.removeAllUpdateListeners();
                valueAnimator.end();
            }
        }
    }

    private void ensureAnimators() {
        if (!this.mHasAnimators) {
            this.mAnimators = this.onCreateAnimators();
            this.mHasAnimators = true;
        }
    }

    public void stop() {
        this.stopAnimators();
    }

    private boolean isStarted() {
        Iterator<ValueAnimator> iterator = this.mAnimators.iterator();
        if (iterator.hasNext()) {
            ValueAnimator valueAnimator = iterator.next();
            return valueAnimator.isStarted();
        }
        return false;
    }

    public boolean isRunning() {
        Iterator<ValueAnimator> iterator = this.mAnimators.iterator();
        if (iterator.hasNext()) {
            ValueAnimator valueAnimator = iterator.next();
            return valueAnimator.isRunning();
        }
        return false;
    }

    public void addUpdateListener(ValueAnimator valueAnimator, ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
        this.mUpdateListeners.put(valueAnimator, animatorUpdateListener);
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.setDrawBounds(rect);
    }

    public void setDrawBounds(Rect rect) {
        this.setDrawBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setDrawBounds(int n, int n2, int n3, int n4) {
        this.drawBounds = new Rect(n, n2, n3, n4);
    }

    public void postInvalidate() {
        this.invalidateSelf();
    }

    public Rect getDrawBounds() {
        return this.drawBounds;
    }

    public int getWidth() {
        return this.drawBounds.width();
    }

    public int getHeight() {
        return this.drawBounds.height();
    }

    public int centerX() {
        return this.drawBounds.centerX();
    }

    public int centerY() {
        return this.drawBounds.centerY();
    }

    public float exactCenterX() {
        return this.drawBounds.exactCenterX();
    }

    public float exactCenterY() {
        return this.drawBounds.exactCenterY();
    }
}

