/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.beatAnimation;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.hippo.utils.beatAnimation.Indicator;
import java.util.ArrayList;

public class BallPulseIndicator
extends Indicator {
    public static final float SCALE = 1.0f;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float f2 = 4.0f;
        float f3 = ((float)Math.min(this.getWidth(), this.getHeight()) - f2 * 2.0f) / 6.0f;
        float f4 = (float)(this.getWidth() / 2) - (f3 * 2.0f + f2);
        float f5 = this.getHeight() / 2;
        for (int j = 0; j < 3; ++j) {
            canvas.save();
            float f6 = f4 + f3 * 2.0f * (float)j + f2 * (float)j;
            canvas.translate(f6, f5);
            canvas.scale(this.scaleFloats[j], this.scaleFloats[j]);
            canvas.drawCircle(0.0f, 0.0f, f3, paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> arrayList = new ArrayList<ValueAnimator>();
        int[] nArray = new int[]{120, 240, 360};
        for (int j = 0; j < 3; ++j) {
            final int n = j;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            valueAnimator.setDuration(750L);
            valueAnimator.setRepeatCount(-1);
            valueAnimator.setStartDelay((long)nArray[j]);
            this.addUpdateListener(valueAnimator, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    ((BallPulseIndicator)BallPulseIndicator.this).scaleFloats[n] = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    BallPulseIndicator.this.postInvalidate();
                }
            });
            arrayList.add(valueAnimator);
        }
        return arrayList;
    }
}

