/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.beatAnimation;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.hippo.R;
import com.hippo.utils.beatAnimation.BallPulseIndicator;
import com.hippo.utils.beatAnimation.Indicator;

public class AVLoadingIndicatorView
extends View {
    private static final String TAG = "AVLoadingIndicatorView";
    private static final BallPulseIndicator DEFAULT_INDICATOR = new BallPulseIndicator();
    private static final int MIN_SHOW_TIME = 500;
    private static final int MIN_DELAY = 500;
    private long mStartTime = -1L;
    private boolean mPostedHide = false;
    private boolean mPostedShow = false;
    private boolean mDismissed = false;
    private final Runnable mDelayedHide = new Runnable(){

        @Override
        public void run() {
            AVLoadingIndicatorView.this.mPostedHide = false;
            AVLoadingIndicatorView.this.mStartTime = -1L;
            AVLoadingIndicatorView.this.setVisibility(8);
        }
    };
    private final Runnable mDelayedShow = new Runnable(){

        @Override
        public void run() {
            AVLoadingIndicatorView.this.mPostedShow = false;
            if (!AVLoadingIndicatorView.this.mDismissed) {
                AVLoadingIndicatorView.this.mStartTime = System.currentTimeMillis();
                AVLoadingIndicatorView.this.setVisibility(0);
            }
        }
    };
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private Indicator mIndicator;
    private int mIndicatorColor;
    private boolean mShouldStartAnimationDrawable;

    public AVLoadingIndicatorView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public AVLoadingIndicatorView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet, 0, R.style.AVLoadingIndicatorView);
    }

    public AVLoadingIndicatorView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet, n, R.style.AVLoadingIndicatorView);
    }

    @TargetApi(value=21)
    public AVLoadingIndicatorView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init(context, attributeSet, n, R.style.AVLoadingIndicatorView);
    }

    private void init(Context context, AttributeSet attributeSet, int n, int n2) {
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AVLoadingIndicatorView, n, n2);
        this.mMinWidth = typedArray.getDimensionPixelSize(R.styleable.AVLoadingIndicatorView_minWidth, this.mMinWidth);
        this.mMaxWidth = typedArray.getDimensionPixelSize(R.styleable.AVLoadingIndicatorView_maxWidth, this.mMaxWidth);
        this.mMinHeight = typedArray.getDimensionPixelSize(R.styleable.AVLoadingIndicatorView_minHeight, this.mMinHeight);
        this.mMaxHeight = typedArray.getDimensionPixelSize(R.styleable.AVLoadingIndicatorView_maxHeight, this.mMaxHeight);
        String string2 = typedArray.getString(R.styleable.AVLoadingIndicatorView_indicatorName);
        this.mIndicatorColor = typedArray.getColor(R.styleable.AVLoadingIndicatorView_indicatorColor, -1);
        this.setIndicator(string2);
        if (this.mIndicator == null) {
            this.setIndicator(DEFAULT_INDICATOR);
        }
        typedArray.recycle();
    }

    public Indicator getIndicator() {
        return this.mIndicator;
    }

    public void setIndicator(Indicator indicator) {
        if (this.mIndicator != indicator) {
            if (this.mIndicator != null) {
                this.mIndicator.setCallback(null);
                this.unscheduleDrawable(this.mIndicator);
            }
            this.mIndicator = indicator;
            this.setIndicatorColor(this.mIndicatorColor);
            if (indicator != null) {
                indicator.setCallback((Drawable.Callback)this);
            }
            this.postInvalidate();
        }
    }

    public void setIndicatorColor(int n) {
        this.mIndicatorColor = n;
        this.mIndicator.setColor(n);
    }

    public void setIndicator(String string2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!string2.contains(".")) {
            object = ((Object)((Object)this)).getClass().getPackage().getName();
            stringBuilder.append((String)object).append(".indicators").append(".");
        }
        stringBuilder.append(string2);
        try {
            object = Class.forName(stringBuilder.toString());
            Indicator indicator = (Indicator)((Object)((Class)object).newInstance());
            this.setIndicator(indicator);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)TAG, (String)"Didn't find your class , check the name again !");
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void smoothToShow() {
        this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000));
        this.setVisibility(0);
    }

    public void smoothToHide() {
        this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001));
        this.setVisibility(8);
    }

    public void hide() {
        this.mDismissed = true;
        this.removeCallbacks(this.mDelayedShow);
        long l = System.currentTimeMillis() - this.mStartTime;
        if (l >= 500L || this.mStartTime == -1L) {
            this.setVisibility(8);
        } else if (!this.mPostedHide) {
            this.postDelayed(this.mDelayedHide, 500L - l);
            this.mPostedHide = true;
        }
    }

    public void show() {
        this.mStartTime = -1L;
        this.mDismissed = false;
        this.removeCallbacks(this.mDelayedHide);
        if (!this.mPostedShow) {
            this.postDelayed(this.mDelayedShow, 500L);
            this.mPostedShow = true;
        }
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mIndicator || super.verifyDrawable(drawable2);
    }

    void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndicator instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
        }
        this.postInvalidate();
    }

    void stopAnimation() {
        if (this.mIndicator instanceof Animatable) {
            this.mIndicator.stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    public void setVisibility(int n) {
        if (this.getVisibility() != n) {
            super.setVisibility(n);
            if (n == 8 || n == 4) {
                this.stopAnimation();
            } else {
                this.startAnimation();
            }
        }
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (n == 8 || n == 4) {
            this.stopAnimation();
        } else {
            this.startAnimation();
        }
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect rect = drawable2.getBounds();
            int n = this.getScrollX() + this.getPaddingLeft();
            int n2 = this.getScrollY() + this.getPaddingTop();
            this.invalidate(rect.left + n, rect.top + n2, rect.right + n, rect.bottom + n2);
        } else {
            super.invalidateDrawable(drawable2);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.updateDrawableBounds(n, n2);
    }

    private void updateDrawableBounds(int n, int n2) {
        int n3 = n -= this.getPaddingRight() + this.getPaddingLeft();
        int n4 = n2 -= this.getPaddingTop() + this.getPaddingBottom();
        int n5 = 0;
        int n6 = 0;
        if (this.mIndicator != null) {
            float f2;
            int n7;
            int n8 = this.mIndicator.getIntrinsicWidth();
            float f3 = (float)n8 / (float)(n7 = this.mIndicator.getIntrinsicHeight());
            if (f3 != (f2 = (float)n / (float)n2)) {
                if (f2 > f3) {
                    int n9 = (int)((float)n2 * f3);
                    n6 = (n - n9) / 2;
                    n3 = n6 + n9;
                } else {
                    int n10 = (int)((float)n * (1.0f / f3));
                    n5 = (n2 - n10) / 2;
                    n4 = n5 + n10;
                }
            }
            this.mIndicator.setBounds(n6, n5, n3, n4);
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTrack(canvas);
    }

    void drawTrack(Canvas canvas) {
        Indicator indicator = this.mIndicator;
        if (indicator != null) {
            int n = canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            indicator.draw(canvas);
            canvas.restoreToCount(n);
            if (this.mShouldStartAnimationDrawable && indicator instanceof Animatable) {
                ((Animatable)indicator).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
    }

    protected synchronized void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Indicator indicator = this.mIndicator;
        if (indicator != null) {
            n3 = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, indicator.getIntrinsicWidth()));
            n4 = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, indicator.getIntrinsicHeight()));
        }
        this.updateDrawableState();
        int n5 = AVLoadingIndicatorView.resolveSizeAndState((int)(n3 += this.getPaddingLeft() + this.getPaddingRight()), (int)n, (int)0);
        int n6 = AVLoadingIndicatorView.resolveSizeAndState((int)(n4 += this.getPaddingTop() + this.getPaddingBottom()), (int)n2, (int)0);
        this.setMeasuredDimension(n5, n6);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    private void updateDrawableState() {
        int[] nArray = this.getDrawableState();
        if (this.mIndicator != null && this.mIndicator.isStateful()) {
            this.mIndicator.setState(nArray);
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float f2, float f3) {
        super.drawableHotspotChanged(f2, f3);
        if (this.mIndicator != null) {
            this.mIndicator.setHotspot(f2, f3);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
        this.removeCallbacks();
    }

    protected void onDetachedFromWindow() {
        this.stopAnimation();
        super.onDetachedFromWindow();
        this.removeCallbacks();
    }

    private void removeCallbacks() {
        this.removeCallbacks(this.mDelayedHide);
        this.removeCallbacks(this.mDelayedShow);
    }
}

