/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.util.HashMap;

public class KeyboardUtil
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int MAGIC_NUMBER = 200;
    private SoftKeyboardToggleListener mCallback;
    private View mRootView;
    private Boolean prevValue = null;
    private float mScreenDensity;
    private static HashMap<SoftKeyboardToggleListener, KeyboardUtil> sListenerMap = new HashMap();

    public void onGlobalLayout() {
        boolean bl;
        Rect rect = new Rect();
        this.mRootView.getWindowVisibleDisplayFrame(rect);
        int n = this.mRootView.getRootView().getHeight() - (rect.bottom - rect.top);
        float f2 = (float)n / this.mScreenDensity;
        boolean bl2 = bl = f2 > 200.0f;
        if (this.mCallback != null && (this.prevValue == null || bl != this.prevValue)) {
            this.prevValue = bl;
            this.mCallback.onToggleSoftKeyboard(bl);
        }
    }

    public static void addKeyboardToggleListener(Activity activity, SoftKeyboardToggleListener softKeyboardToggleListener) {
        KeyboardUtil.removeKeyboardToggleListener(softKeyboardToggleListener);
        sListenerMap.put(softKeyboardToggleListener, new KeyboardUtil(activity, softKeyboardToggleListener));
    }

    public static void removeKeyboardToggleListener(SoftKeyboardToggleListener softKeyboardToggleListener) {
        if (sListenerMap.containsKey(softKeyboardToggleListener)) {
            KeyboardUtil keyboardUtil = sListenerMap.get(softKeyboardToggleListener);
            keyboardUtil.removeListener();
            sListenerMap.remove(softKeyboardToggleListener);
        }
    }

    public static void removeAllKeyboardToggleListeners() {
        for (SoftKeyboardToggleListener softKeyboardToggleListener : sListenerMap.keySet()) {
            sListenerMap.get(softKeyboardToggleListener).removeListener();
        }
        sListenerMap.clear();
    }

    public static void toggleKeyboardVisibility(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(2, 0);
        }
    }

    public static void forceCloseKeyboard(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private void removeListener() {
        this.mCallback = null;
        this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private KeyboardUtil(Activity activity, SoftKeyboardToggleListener softKeyboardToggleListener) {
        this.mCallback = softKeyboardToggleListener;
        this.mRootView = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mScreenDensity = activity.getResources().getDisplayMetrics().density;
    }

    public static interface SoftKeyboardToggleListener {
        public void onToggleSoftKeyboard(boolean var1);
    }
}

