/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mInsets;

    public GridDividerItemDecoration(Context context) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.fugu_grid_divider);
        this.mInsets = context.getResources().getDimensionPixelSize(R.dimen.fugu_card_inset);
    }

    public void onDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        this.drawVertical(canvas, recyclerView);
        this.drawHorizontal(canvas, recyclerView);
    }

    private void drawVertical(Canvas canvas, RecyclerView recyclerView) {
        if (recyclerView.getChildCount() == 0) {
            return;
        }
        int n = recyclerView.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n2 = view.getLeft() - layoutParams.leftMargin - this.mInsets;
            int n3 = view.getRight() + layoutParams.rightMargin + this.mInsets;
            int n4 = view.getBottom() + layoutParams.bottomMargin + this.mInsets;
            int n5 = n4 + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(n2, n4, n3, n5);
            this.mDivider.draw(canvas);
        }
    }

    private void drawHorizontal(Canvas canvas, RecyclerView recyclerView) {
        int n = recyclerView.getChildCount();
        for (int j = 0; j < n; ++j) {
            View view = recyclerView.getChildAt(j);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n2 = view.getRight() + layoutParams.rightMargin + this.mInsets;
            int n3 = n2 + this.mDivider.getIntrinsicWidth();
            int n4 = view.getTop() - layoutParams.topMargin - this.mInsets;
            int n5 = view.getBottom() + layoutParams.bottomMargin + this.mInsets;
            this.mDivider.setBounds(n2, n4, n3, n5);
            this.mDivider.draw(canvas);
        }
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        rect.set(this.mInsets, this.mInsets, this.mInsets, this.mInsets);
    }
}

