/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.Util;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class FuguImageUtils
implements FuguAppConstant {
    private static final String TAG = FuguImageUtils.class.getSimpleName();
    private Activity activity;

    public FuguImageUtils(Activity activity) {
        this.activity = activity;
    }

    public void startCamera() {
        HippoLog.e(TAG, "startCamera");
        if (!this.isCameraAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"Camera feature unavailable!", (int)0).show();
            return;
        }
        if (!this.isExternalStorageAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"External storage unavailable!", (int)0).show();
            return;
        }
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.activity.getPackageManager()) != null) {
            String string2 = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
            String string3 = UUID.randomUUID().toString() + "." + new Date().getTime();
            String string4 = "Hippochat_" + string3 + ".jpg";
            File file = new File(Util.getDirectoryPath((String)FOLDER_TYPE.get("image")), string4);
            HippoLog.d(TAG, "Path: " + file.getPath());
            HippoLog.d(TAG, "AbsolutePath: " + file.getAbsolutePath());
            CommonData.setTime(file.getAbsolutePath());
            CommonData.setImageMuid(string3);
            try {
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            intent.putExtra("output", (Parcelable)FileProvider.getUriForFile((Context)this.activity, (String)CommonData.getProvider(), (File)file));
            this.activity.startActivityForResult(intent, 257);
        }
    }

    private boolean isCameraAvailable() {
        HippoLog.e(TAG, "isCameraAvailable");
        return this.activity.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    private boolean isExternalStorageAvailable() {
        HippoLog.e(TAG, "isExternalStorageAvailable");
        return "mounted".equals(Environment.getExternalStorageState());
    }
}

