/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.graphics.RectF;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.TextView;

public class BetterLinkMovementMethod
extends LinkMovementMethod {
    private static BetterLinkMovementMethod singleInstance;
    private static final int LINKIFY_NONE = -2;
    private OnLinkClickListener onLinkClickListener;
    private OnLinkLongClickListener onLinkLongClickListener;
    private final RectF touchedLineBounds = new RectF();
    private boolean isUrlHighlighted;
    private ClickableSpan clickableSpanUnderTouchOnActionDown;
    private int activeTextViewHashcode;
    private LongPressTimer ongoingLongPressTimer;
    private boolean wasLongPressRegistered;

    public static BetterLinkMovementMethod newInstance() {
        return new BetterLinkMovementMethod();
    }

    public static BetterLinkMovementMethod linkify(int n, TextView ... textViewArray) {
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        for (TextView textView : textViewArray) {
            BetterLinkMovementMethod.addLinks(n, betterLinkMovementMethod, textView);
        }
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(TextView ... textViewArray) {
        return BetterLinkMovementMethod.linkify(15, textViewArray);
    }

    public static BetterLinkMovementMethod linkifyHtmlNone(TextView ... textViewArray) {
        return BetterLinkMovementMethod.linkify(-2, textViewArray);
    }

    public static BetterLinkMovementMethod linkify(int n, ViewGroup viewGroup) {
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(n, viewGroup, betterLinkMovementMethod);
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(ViewGroup viewGroup) {
        return BetterLinkMovementMethod.linkify(-2, viewGroup);
    }

    public static BetterLinkMovementMethod linkify(int n, Activity activity) {
        ViewGroup viewGroup = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        BetterLinkMovementMethod betterLinkMovementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(n, viewGroup, betterLinkMovementMethod);
        return betterLinkMovementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(Activity activity) {
        return BetterLinkMovementMethod.linkify(-2, activity);
    }

    public static BetterLinkMovementMethod getInstance() {
        if (singleInstance == null) {
            singleInstance = new BetterLinkMovementMethod();
        }
        return singleInstance;
    }

    public BetterLinkMovementMethod setOnLinkClickListener(OnLinkClickListener onLinkClickListener) {
        if (this == singleInstance) {
            throw new UnsupportedOperationException("Setting a click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
        }
        this.onLinkClickListener = onLinkClickListener;
        return this;
    }

    public BetterLinkMovementMethod setOnLinkLongClickListener(OnLinkLongClickListener onLinkLongClickListener) {
        if (this == singleInstance) {
            throw new UnsupportedOperationException("Setting a long-click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
        }
        this.onLinkLongClickListener = onLinkLongClickListener;
        return this;
    }

    private static void rAddLinks(int n, ViewGroup viewGroup, BetterLinkMovementMethod betterLinkMovementMethod) {
        for (int j = 0; j < viewGroup.getChildCount(); ++j) {
            View view = viewGroup.getChildAt(j);
            if (view instanceof ViewGroup) {
                BetterLinkMovementMethod.rAddLinks(n, (ViewGroup)view, betterLinkMovementMethod);
                continue;
            }
            if (!(view instanceof TextView)) continue;
            TextView textView = (TextView)view;
            BetterLinkMovementMethod.addLinks(n, betterLinkMovementMethod, textView);
        }
    }

    private static void addLinks(int n, BetterLinkMovementMethod betterLinkMovementMethod, TextView textView) {
        textView.setMovementMethod((MovementMethod)betterLinkMovementMethod);
        if (n != -2) {
            Linkify.addLinks((TextView)textView, (int)n);
        }
    }

    public boolean onTouchEvent(final TextView textView, Spannable spannable, MotionEvent motionEvent) {
        ClickableSpan clickableSpan;
        if (this.activeTextViewHashcode != textView.hashCode()) {
            this.activeTextViewHashcode = textView.hashCode();
            textView.setAutoLinkMask(0);
        }
        this.clickableSpanUnderTouchOnActionDown = clickableSpan = this.findClickableSpanUnderTouch(textView, spannable, motionEvent);
        boolean bl = this.clickableSpanUnderTouchOnActionDown != null;
        switch (motionEvent.getAction()) {
            case 0: {
                if (clickableSpan != null) {
                    this.highlightUrl(textView, clickableSpan, spannable);
                }
                if (bl && this.onLinkLongClickListener != null) {
                    LongPressTimer.OnTimerReachedListener onTimerReachedListener = new LongPressTimer.OnTimerReachedListener(){

                        @Override
                        public void onTimerReached() {
                            BetterLinkMovementMethod.this.wasLongPressRegistered = true;
                            textView.performHapticFeedback(0);
                            BetterLinkMovementMethod.this.removeUrlHighlightColor(textView);
                            BetterLinkMovementMethod.this.dispatchUrlLongClick(textView, clickableSpan);
                        }
                    };
                    this.startTimerForRegisteringLongClick(textView, onTimerReachedListener);
                }
                return bl;
            }
            case 1: {
                if (!this.wasLongPressRegistered && bl && clickableSpan == this.clickableSpanUnderTouchOnActionDown) {
                    this.dispatchUrlClick(textView, clickableSpan);
                }
                this.cleanupOnTouchUp(textView);
                return bl;
            }
            case 3: {
                this.cleanupOnTouchUp(textView);
                return false;
            }
            case 2: {
                if (clickableSpan != this.clickableSpanUnderTouchOnActionDown) {
                    this.removeLongPressCallback(textView);
                }
                if (!this.wasLongPressRegistered) {
                    if (clickableSpan != null) {
                        this.highlightUrl(textView, clickableSpan, spannable);
                    } else {
                        this.removeUrlHighlightColor(textView);
                    }
                }
                return bl;
            }
        }
        return false;
    }

    private void cleanupOnTouchUp(TextView textView) {
        this.wasLongPressRegistered = false;
        this.removeUrlHighlightColor(textView);
        this.removeLongPressCallback(textView);
    }

    protected ClickableSpan findClickableSpanUnderTouch(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        n -= textView.getTotalPaddingLeft();
        n2 -= textView.getTotalPaddingTop();
        Layout layout2 = textView.getLayout();
        int n3 = layout2.getLineForVertical(n2 += textView.getScrollY());
        int n4 = layout2.getOffsetForHorizontal(n3, (float)(n += textView.getScrollX()));
        this.touchedLineBounds.left = layout2.getLineLeft(n3);
        this.touchedLineBounds.top = layout2.getLineTop(n3);
        this.touchedLineBounds.right = layout2.getLineWidth(n3) + this.touchedLineBounds.left;
        this.touchedLineBounds.bottom = layout2.getLineBottom(n3);
        if (this.touchedLineBounds.contains((float)n, (float)n2)) {
            Object[] objectArray;
            for (Object object : objectArray = spannable.getSpans(n4, n4, ClickableSpan.class)) {
                if (!(object instanceof ClickableSpan)) continue;
                return (ClickableSpan)object;
            }
            return null;
        }
        return null;
    }

    protected void highlightUrl(TextView textView, ClickableSpan clickableSpan, Spannable spannable) {
        if (this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = true;
        int n = spannable.getSpanStart((Object)clickableSpan);
        int n2 = spannable.getSpanEnd((Object)clickableSpan);
        spannable.setSpan((Object)new BackgroundColorSpan(textView.getHighlightColor()), n, n2, 18);
        textView.setText((CharSequence)spannable);
        Selection.setSelection((Spannable)spannable, (int)n, (int)n2);
    }

    protected void removeUrlHighlightColor(TextView textView) {
        BackgroundColorSpan[] backgroundColorSpanArray;
        if (!this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = false;
        Spannable spannable = (Spannable)textView.getText();
        for (BackgroundColorSpan backgroundColorSpan : backgroundColorSpanArray = (BackgroundColorSpan[])spannable.getSpans(0, spannable.length(), BackgroundColorSpan.class)) {
            spannable.removeSpan((Object)backgroundColorSpan);
        }
        textView.setText((CharSequence)spannable);
        Selection.removeSelection((Spannable)spannable);
    }

    protected void startTimerForRegisteringLongClick(TextView textView, LongPressTimer.OnTimerReachedListener onTimerReachedListener) {
        this.ongoingLongPressTimer = new LongPressTimer();
        this.ongoingLongPressTimer.setOnTimerReachedListener(onTimerReachedListener);
        textView.postDelayed((Runnable)this.ongoingLongPressTimer, (long)ViewConfiguration.getLongPressTimeout());
    }

    protected void removeLongPressCallback(TextView textView) {
        if (this.ongoingLongPressTimer != null) {
            textView.removeCallbacks((Runnable)this.ongoingLongPressTimer);
            this.ongoingLongPressTimer = null;
        }
    }

    protected void dispatchUrlClick(TextView textView, ClickableSpan clickableSpan) {
        boolean bl;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, clickableSpan);
        boolean bl2 = bl = this.onLinkClickListener != null && this.onLinkClickListener.onClick(textView, clickableSpanWithText.text());
        if (!bl) {
            clickableSpanWithText.span().onClick((View)textView);
        }
    }

    protected void dispatchUrlLongClick(TextView textView, ClickableSpan clickableSpan) {
        boolean bl;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, clickableSpan);
        boolean bl2 = bl = this.onLinkLongClickListener != null && this.onLinkLongClickListener.onLongClick(textView, clickableSpanWithText.text());
        if (!bl) {
            // empty if block
        }
    }

    protected static class ClickableSpanWithText {
        private ClickableSpan span;
        private String text;

        protected static ClickableSpanWithText ofSpan(TextView textView, ClickableSpan clickableSpan) {
            Spanned spanned = (Spanned)textView.getText();
            String string2 = "";
            try {
                if (clickableSpan instanceof URLSpan) {
                    string2 = ((URLSpan)clickableSpan).getURL();
                } else {
                    int n = spanned.getSpanStart((Object)clickableSpan);
                    int n2 = spanned.getSpanEnd((Object)clickableSpan);
                    string2 = spanned.subSequence(n, n2).toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new ClickableSpanWithText(clickableSpan, string2);
        }

        private ClickableSpanWithText(ClickableSpan clickableSpan, String string2) {
            this.span = clickableSpan;
            this.text = string2;
        }

        ClickableSpan span() {
            return this.span;
        }

        String text() {
            return this.text;
        }
    }

    protected static final class LongPressTimer
    implements Runnable {
        private OnTimerReachedListener onTimerReachedListener;

        protected LongPressTimer() {
        }

        @Override
        public void run() {
            this.onTimerReachedListener.onTimerReached();
        }

        public void setOnTimerReachedListener(OnTimerReachedListener onTimerReachedListener) {
            this.onTimerReachedListener = onTimerReachedListener;
        }

        static interface OnTimerReachedListener {
            public void onTimerReached();
        }
    }

    public static interface OnLinkLongClickListener {
        public boolean onLongClick(TextView var1, String var2);
    }

    public static interface OnLinkClickListener {
        public boolean onClick(TextView var1, String var2);
    }
}

