/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.logicImplView;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.support.callback.HippoSupportInteractor;
import com.hippo.support.db.HippoDatabase;
import com.hippo.support.model.SupportDataList;
import com.hippo.support.model.SupportResponse;
import com.hippo.utils.HippoLog;
import java.util.Map;
import retrofit2.Callback;

public class HippoSupportInteractorImpl
implements HippoSupportInteractor {
    private HippoSupportInteractor.OnFinishedListener onFinishedListener;
    private HippoDatabase database;
    private SupportDataList dataList;
    private int hitCount = 0;

    @Override
    public void getSupportData(Activity activity, int n, String string2, HippoSupportInteractor.OnFinishedListener onFinishedListener) {
        this.onFinishedListener = onFinishedListener;
        this.database = HippoDatabase.getInstance((Context)activity);
        this.getData(activity, n, string2);
    }

    private void getData(Activity activity, int n, String string2) {
        this.hasUserData(activity, n, string2, this.hitCount);
    }

    private void fetchLocalSupportData(Activity activity, int n, String string2) {
        SupportDataList supportDataList = !TextUtils.isEmpty((CharSequence)string2) ? this.database.getSupportDataItems(string2.toLowerCase().trim()) : this.database.getSupportDataItems(0);
        if (supportDataList == null || supportDataList.getList() == null) {
            this.hasUserData(activity, n, string2, this.hitCount, true);
        } else {
            this.onFinishedListener.onSuccess(supportDataList);
        }
    }

    private void hasUserData(Activity activity, int n, String string2, int n2) {
        this.hasUserData(activity, n, string2, n2, false);
    }

    private void hasUserData(final Activity activity, final int n, final String string2, final int n2, final boolean bl) {
        if (HippoConfig.getInstance().getUserData() == null || TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getUserData().getEnUserId()) || TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAppKey())) {
            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    HippoSupportInteractorImpl.this.afterHasUserData(activity, n, string2, n2, bl);
                }

                @Override
                public void onFailure() {
                    HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), false);
        } else {
            this.afterHasUserData(activity, n, string2, n2, bl);
        }
    }

    private void afterHasUserData(Activity activity, int n, String string2, int n2, boolean bl) {
        if (!CommonData.getUserDetails().getData().isFAQEnabled()) {
            this.onFinishedListener.onSuccess(null);
            return;
        }
        int n3 = CommonData.getLocalVersion();
        int n4 = CommonData.getUserDetails().getData().getInAppSupportVersion();
        if (bl) {
            this.fetchSupportData(activity, n4, string2, n2);
        } else if (n4 > n3) {
            this.fetchSupportData(activity, n4, string2, n2);
        } else {
            this.fetchLocalSupportData(activity, n4, string2);
        }
        HippoLog.v("TAG", n3 + " < localVersion versionCode >" + n4);
    }

    private void fetchSupportData(Activity activity, final int n, final String string2, int n2) {
        String string3 = null;
        try {
            string3 = CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null && CommonData.getUserDetails().getData().getEn_user_id() != null ? CommonData.getUserDetails().getData().getEn_user_id() : HippoConfig.getInstance().getUserData().getEnUserId();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)string3) && n2 < 2) {
            this.hasUserData(activity, n, string2, n2 + 1);
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", string3).add("app_version", 251).add("device_type", 1).add("is_active", 1).build();
        RestClient.getApiInterface().fetchSupportData(commonParams.getMap()).enqueue((Callback)new ResponseResolver<SupportResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(SupportResponse supportResponse) {
                try {
                    String string22 = string2 == null ? supportResponse.getDefaultFaqName() : string2;
                    CommonData.setDefaultCategory(supportResponse.getDefaultFaqName());
                    if (!TextUtils.isEmpty((CharSequence)string22)) {
                        for (Map.Entry<String, SupportDataList> entry : supportResponse.getItemData().entrySet()) {
                            SupportDataList supportDataList = entry.getValue();
                            if (!supportDataList.getCategoryName().equalsIgnoreCase(string22)) continue;
                            HippoSupportInteractorImpl.this.dataList = supportDataList;
                            break;
                        }
                    }
                    if (supportResponse.getItemData().isEmpty()) {
                        HippoSupportInteractorImpl.this.onFinishedListener.onSuccess(null);
                        return;
                    }
                    if (HippoSupportInteractorImpl.this.dataList == null) {
                        HippoSupportInteractorImpl.this.dataList = supportResponse.getItemData().get(supportResponse.getItemData().keySet().iterator().next());
                    }
                    HippoSupportInteractorImpl.this.onFinishedListener.onSuccess(HippoSupportInteractorImpl.this.dataList);
                    new BackgroundInsert().execute(new String[]{new Gson().toJson((Object)supportResponse), String.valueOf(n)});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
                }
            }

            @Override
            public void failure(APIError aPIError) {
                HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
            }
        });
    }

    private class BackgroundInsert
    extends AsyncTask<String, String, Boolean> {
        int version = -1;

        private BackgroundInsert() {
        }

        protected Boolean doInBackground(String ... stringArray) {
            try {
                SupportResponse supportResponse = (SupportResponse)new Gson().fromJson(stringArray[0], SupportResponse.class);
                Map<String, SupportDataList> map = supportResponse.getItemData();
                HippoSupportInteractorImpl.this.database.insertUpdateSupportData(map);
                try {
                    this.version = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        protected void onPostExecute(Boolean bl) {
            super.onPostExecute((Object)bl);
            if (bl.booleanValue()) {
                CommonData.setCurrentVersion(this.version);
            }
            if (HippoSupportInteractorImpl.this.database != null) {
                HippoSupportInteractorImpl.this.database.close();
            }
        }
    }
}

