/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Adapter.HippoSupportAdapter;
import com.hippo.support.Utils.Constants;
import com.hippo.support.Utils.SupportKeys;
import com.hippo.support.callback.HippoSupportView;
import com.hippo.support.callback.OnActionTypeCallback;
import com.hippo.support.callback.OnItemListener;
import com.hippo.support.callback.SupportPresenter;
import com.hippo.support.fragment.BaseFragment;
import com.hippo.support.logicImplView.HippoSupportInteractorImpl;
import com.hippo.support.logicImplView.HippoSupportViewImpl;
import com.hippo.support.model.Category;
import com.hippo.support.model.Item;
import com.hippo.support.model.SupportDataList;
import com.hippo.support.model.callbackModel.OpenChatParams;
import com.hippo.support.model.callbackModel.SendQueryChat;
import java.util.ArrayList;
import java.util.List;

public class HippoSupportFragment
extends BaseFragment
implements View.OnClickListener,
HippoSupportView,
OnItemListener {
    private static final String TAG = HippoSupportFragment.class.getSimpleName();
    private HippoSupportAdapter supportAdapter;
    private SupportPresenter supportView;
    private OnActionTypeCallback typeCallback;
    private HippoColorConfig hippoColorConfig;
    private String categoryData;
    private int serverDBVersion = -1;
    private String defaultFaqName = null;
    private String transactionId = null;
    private boolean hasPoweredVia;
    private Toolbar toolbar;
    private View rootView;
    private TextView poweredBy;
    private TextView mNoDataTextView;
    private RecyclerView recyclerView;
    private ProgressBar progressBar;
    private Gson gson;
    private ArrayList<Item> supportResponses;
    private ArrayList<String> pathList;
    private String title = "";

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.gson = new Gson();
        if (this.getArguments() != null) {
            if (this.getArguments().containsKey("default_support")) {
                this.supportResponses = (ArrayList)this.gson.fromJson(this.getArguments().getString("default_support"), Constants.listType);
            }
            if (this.getArguments().containsKey("support_title")) {
                this.title = this.getArguments().getString("support_title");
            }
            if (this.getArguments().containsKey("support_db_version")) {
                this.serverDBVersion = this.getArguments().getInt("support_db_version");
            }
            if (this.getArguments().containsKey("support_transaction_id")) {
                this.transactionId = this.getArguments().getString("support_transaction_id");
            }
            if (this.getArguments().containsKey("support_category_id")) {
                this.defaultFaqName = this.getArguments().getString("support_category_id");
            }
            if (this.getArguments().containsKey("support_category_data")) {
                this.categoryData = this.getArguments().getString("support_category_data");
            }
            if (this.getArguments().containsKey("powered_via")) {
                this.hasPoweredVia = this.getArguments().getBoolean("powered_via");
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.rootView = layoutInflater.inflate(R.layout.fugu_support_fragment, viewGroup, false);
        return this.rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.typeCallback = (OnActionTypeCallback)context;
    }

    public void onDetach() {
        super.onDetach();
        if (this.typeCallback != null) {
            this.typeCallback = null;
        }
    }

    public void onHiddenChanged(boolean bl) {
        super.onHiddenChanged(bl);
        if (!bl) {
            CommonData.removeLastPath();
        }
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        super.onActivityCreated(bundle);
        this.toolbar = (Toolbar)this.rootView.findViewById(R.id.my_toolbar);
        this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progress_bar);
        this.supportAdapter = new HippoSupportAdapter(this);
        this.recyclerView = (RecyclerView)this.rootView.findViewById(R.id.recycler_view);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.supportAdapter);
        this.mNoDataTextView = (TextView)this.rootView.findViewById(R.id.tvNoDataFound);
        this.hippoColorConfig = CommonData.getColorConfig();
        this.mNoDataTextView.setTextColor(this.hippoColorConfig.getHippoThemeColorPrimary());
        this.poweredBy = (TextView)this.rootView.findViewById(R.id.tvPoweredBy);
        this.supportView = new HippoSupportViewImpl((Activity)this.getActivity(), this, new HippoSupportInteractorImpl());
        this.initView(this.serverDBVersion);
    }

    private void initView(int n) {
        if (this.supportResponses == null) {
            this.supportView.fetchData(this.defaultFaqName, n);
        } else {
            this.setInnerData(this.supportResponses);
        }
        if (this.hasPoweredVia) {
            this.setPoweredByText(this.poweredBy);
        } else {
            this.poweredBy.setVisibility(8);
        }
        this.poweredBy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"https://fuguchat.com"));
                HippoSupportFragment.this.startActivity(intent);
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.supportView != null) {
            this.supportView.onDestroy();
        }
    }

    @Override
    public void showProgress() {
        this.progressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.progressBar.setVisibility(8);
    }

    @Override
    public void setData(SupportDataList supportDataList) {
        if (supportDataList == null || supportDataList.getList() == null || supportDataList.getList().size() == 0) {
            this.mNoDataTextView.setVisibility(0);
            this.setToolbar(this.toolbar, "Support");
        } else {
            if (this.supportAdapter != null) {
                this.supportAdapter.setAdapterData((ArrayList)supportDataList.getList());
            }
            this.setToolbarTitle(supportDataList.getCategoryName());
            Category category = new Category(supportDataList.getCategoryId(), supportDataList.getCategoryName(), "");
            this.categoryData = this.gson.toJson((Object)category);
        }
        this.setPoweredByText(this.poweredBy);
    }

    @Override
    public void openChatSupport(OpenChatParams openChatParams) {
        ChatByUniqueIdAttributes chatByUniqueIdAttributes = new ChatByUniqueIdAttributes.Builder().setTransactionId(openChatParams.getTransactionId()).setUserUniqueKey(openChatParams.getUserUniqueKey()).setChannelName(openChatParams.getChannelName()).setTags(openChatParams.getTagsList()).setSupportTicket(true).setCustomAttributes(openChatParams.getCustomAttributes()).build();
        HippoConfig.getInstance().openChatByUniqueId(chatByUniqueIdAttributes);
    }

    private void setInnerData(ArrayList<Item> arrayList) {
        if (this.supportAdapter != null) {
            this.supportAdapter.setAdapterData(arrayList);
        }
        this.setToolbarTitle(this.title);
    }

    private void setToolbarTitle(String string2) {
        this.setToolbar(this.toolbar, string2);
        this.pathList = CommonData.getPathList();
        this.pathList.add(string2);
        CommonData.setSupportPath(this.pathList);
    }

    @Override
    public void showError() {
        Toast.makeText((Context)this.getActivity(), (CharSequence)"Something went wrong. Please try again", (int)0).show();
    }

    @Override
    public void onClick(int n, List<Item> list, String string2) {
        this.typeCallback.onActionType((ArrayList)list, this.gson.toJson(this.pathList), string2, this.transactionId, this.categoryData);
    }

    @Override
    public void onOtherTypeClick(int n, Item item) {
        switch (SupportKeys.SupportActionType.get(n)) {
            case DESCRIPTION: {
                this.typeCallback.openDetailPage(item, this.gson.toJson(this.pathList), this.transactionId, this.categoryData);
                break;
            }
            case CHAT_SUPPORT: {
                Category category = (Category)this.gson.fromJson(this.categoryData, Category.class);
                SendQueryChat sendQueryChat = new SendQueryChat(SupportKeys.SupportQueryType.CHAT, category, this.transactionId, CommonData.getUserUniqueKey(), item.getSupportId(), this.pathList);
                this.supportView.openChat(sendQueryChat);
                break;
            }
            case SHOW_CONVERSATION: {
                HippoConfig.getInstance().showConversations((Activity)this.getActivity(), "Chat Support");
                break;
            }
        }
    }

    @Override
    public void onDescription(Item item) {
        this.typeCallback.openDetailPage(item, this.gson.toJson(this.pathList), this.transactionId, this.categoryData);
    }

    @Override
    public void chatSupport(Item item) {
        Category category = (Category)this.gson.fromJson(this.categoryData, Category.class);
        SendQueryChat sendQueryChat = new SendQueryChat(SupportKeys.SupportQueryType.CHAT, category, this.transactionId, CommonData.getUserUniqueKey(), item.getSupportId(), this.pathList);
        if (item.getContent().getSubHeading() != null && item.getContent().getSubHeading().getText() != null) {
            sendQueryChat.setSubHeader(item.getContent().getSubHeading().getText());
        }
        this.supportView.openChat(sendQueryChat);
    }

    @Override
    public void showConversaton(Item item) {
        HippoConfig.getInstance().showConversations((Activity)this.getActivity(), "Chat Support");
    }

    public void onClick(View view) {
        this.getActivity().onBackPressed();
    }
}

