/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Utils.Constants;
import com.hippo.support.callback.OnActionTypeCallback;
import com.hippo.support.fragment.HippoSupportDetailFragment;
import com.hippo.support.fragment.HippoSupportFragment;
import com.hippo.support.model.Item;
import java.util.ArrayList;

public class HippoSupportActivity
extends AppCompatActivity
implements OnActionTypeCallback {
    private static final String TAG = HippoSupportActivity.class.getSimpleName();

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.fugu_support_activity);
        String string2 = this.getIntent().getStringExtra("support_id");
        String string3 = this.getIntent().getStringExtra("support_transaction_id");
        this.initView(string2, string3);
    }

    private void initView(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = CommonData.getDefaultCategory();
        }
        CommonData.clearPathList();
        this.loadFragment(null, null, null, 0, string2, string3, null, true);
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.hippo_home, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case 16908332: {
                this.hideKeyboard((Activity)this);
                this.onBackPressed();
                break;
            }
            default: {
                return super.onOptionsItemSelected(menuItem);
            }
        }
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void loadFragment(ArrayList<Item> arrayList, String string2, String string3, int n, String string4, String string5, String string6, boolean bl) {
        HippoSupportFragment hippoSupportFragment = new HippoSupportFragment();
        Bundle bundle = new Bundle();
        if (arrayList != null) {
            try {
                bundle.putString("default_support", new Gson().toJson(arrayList, Constants.listType));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bundle.putString("default_support", new Gson().toJson(arrayList));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("support_path", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("support_title", string3);
        }
        if (n > 0) {
            bundle.putInt("support_db_version", n);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            bundle.putString("support_category_id", string4);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            bundle.putString("support_transaction_id", string5);
        }
        bundle.putString("support_category_data", string6);
        bundle.putBoolean("powered_via", bl);
        hippoSupportFragment.setArguments(bundle);
        this.openFragment(hippoSupportFragment);
    }

    private void openFragment(Fragment fragment) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(R.id.container, fragment, fragment.getClass().getName());
        fragmentTransaction.addToBackStack(fragment.getClass().getName());
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            fragmentTransaction.hide(this.getSupportFragmentManager().findFragmentByTag(this.getSupportFragmentManager().getBackStackEntryAt(this.getSupportFragmentManager().getBackStackEntryCount() - 1).getName()));
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    @Override
    public void onActionType(ArrayList<Item> arrayList, String string2, String string3, String string4, String string5) {
        this.loadFragment(arrayList, string2, string3, -1, "", string4, string5, false);
    }

    @Override
    public void openDetailPage(Item item, String string2, String string3, String string4) {
        HippoSupportDetailFragment hippoSupportDetailFragment = new HippoSupportDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putString("default_support", new Gson().toJson((Object)item));
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("support_path", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("support_transaction_id", string3);
        }
        bundle.putString("support_category_data", string4);
        hippoSupportDetailFragment.setArguments(bundle);
        this.openFragment(hippoSupportDetailFragment);
    }

    @Override
    public void removeFragment() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        for (int j = 0; j < fragmentManager.getBackStackEntryCount() - 1; ++j) {
            fragmentManager.popBackStack();
        }
    }

    private void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            if (view == null) {
                return;
            }
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

