/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Utils.SupportKeys;
import com.hippo.support.callback.OnItemListener;
import com.hippo.support.model.Item;
import java.util.ArrayList;

public class HippoSupportAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = HippoSupportAdapter.class.getSimpleName();
    private Context context;
    private OnItemListener onItemListener;
    private HippoColorConfig hippoColorConfig = CommonData.getColorConfig();
    private ArrayList<Item> supportResponses;

    public HippoSupportAdapter(OnItemListener onItemListener) {
        this.onItemListener = onItemListener;
    }

    public void setAdapterData(ArrayList<Item> arrayList) {
        this.supportResponses = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_layout_support, viewGroup, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        viewHolder.textView.setText((CharSequence)this.supportResponses.get(n).getTitle());
    }

    public int getItemCount() {
        return this.supportResponses == null ? 0 : this.supportResponses.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout mainLayout;
        private TextView textView;
        private View viewDivider;

        public ViewHolder(View view) {
            super(view);
            this.mainLayout = (LinearLayout)view.findViewById(R.id.main_layout);
            this.textView = (TextView)view.findViewById(R.id.support_text_view);
            this.textView.setTextColor(HippoSupportAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.viewDivider = view.findViewById(R.id.viewDivider);
            this.viewDivider.setBackgroundColor(HippoSupportAdapter.this.hippoColorConfig.getHippoBorderColor());
            this.textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getActionType();
                    switch (SupportKeys.SupportActionType.get(n)) {
                        case LIST: {
                            HippoSupportAdapter.this.onItemListener.onClick(((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getActionType(), ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getItems(), ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getTitle());
                            break;
                        }
                        case DESCRIPTION: 
                        case CHAT_SUPPORT: 
                        case SHOW_CONVERSATION: {
                            HippoSupportAdapter.this.onItemListener.onOtherTypeClick(n, (Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition()));
                            break;
                        }
                    }
                }
            });
        }
    }
}

