/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import com.hippo.retrofit.RetrofitUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class MultipartParams {
    HashMap<String, RequestBody> map = new HashMap();

    private MultipartParams(Builder builder, int n) {
        builder.map.put("source_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(n)));
        builder.map.put("app_version", RetrofitUtils.getRequestBodyFromString(String.valueOf(251)));
        builder.map.put("device_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(1)));
        this.map = builder.map;
    }

    public HashMap<String, RequestBody> getMap() {
        return this.map;
    }

    public static class Builder {
        HashMap<String, RequestBody> map = new HashMap();

        public Builder add(String string2, Object object) {
            if (object == null || String.valueOf(object).isEmpty()) {
                return this;
            }
            this.map.put(string2, RetrofitUtils.getRequestBodyFromString(String.valueOf(object)));
            return this;
        }

        public Builder addFile(String string2, File file) {
            if (file == null) {
                return this;
            }
            this.map.put(string2 + "\"; filename=\"" + file.getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(file)), (File)file));
            return this;
        }

        public Builder addArrayOfFiles(String string2, ArrayList<File> arrayList) {
            if (arrayList == null || arrayList.size() == 0) {
                return this;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                if (arrayList.get(j) == null) continue;
                this.map.put(string2 + "\"; filename=\"" + arrayList.get(j).getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(arrayList.get(j))), (File)arrayList.get(j)));
            }
            return this;
        }

        public MultipartParams build() {
            return new MultipartParams(this, 1);
        }

        public MultipartParams build(int n) {
            return new MultipartParams(this, 1);
        }
    }
}

