/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.Message;
import com.hippo.receiver.NetworkUtil;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import faye.ConnectionManager;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class FuguNetworkStateReceiver
extends BroadcastReceiver
implements FuguAppConstant {
    private static final String TAG = FuguNetworkStateReceiver.class.getSimpleName();
    @NonNull
    private HashMap<Long, LinkedHashMap<String, JSONObject>> unsentMessageMap = new HashMap();
    private Long channelId;
    private HashMap<Long, LinkedHashMap<String, JSONObject>> allUnsentMessageMap = new HashMap();
    private LinkedHashMap<String, JSONObject> sendingMessages = new LinkedHashMap();
    private String tempDate = "";
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    public static HashMap<Long, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap();
    private LinkedHashMap<String, Message> sendingMessagesList = new LinkedHashMap();
    private LinkedHashMap<String, Message> sentMessages = new LinkedHashMap();
    public static HashMap<Long, LinkedHashMap<String, ListItem>> AGENTUNSENT_MESSAGES = new HashMap();
    private LinkedHashMap<String, ListItem> agentsendingMessagesList = new LinkedHashMap();
    private LinkedHashMap<String, ListItem> agentsentMessages = new LinkedHashMap();

    public void onReceive(Context context, Intent intent) {
        Paper.init((Context)context);
        int n = NetworkUtil.getConnectivityStatusString(context);
        try {
            ConnectionManager.INSTANCE.changeStatus(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (HippoConfig.getInstance().getCallData() != null) {
                HippoLog.i("TAG", "Sending network update = " + n);
                HippoConfig.getInstance().getCallData().networkStatus(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            HippoLog.d("app", "Network connectivity change");
            if (intent.getExtras() != null) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getExtras().get("networkInfo");
                boolean bl = networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED;
                Intent intent2 = new Intent("network_state_changed");
                intent2.putExtra("isConnected", bl);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectedServer() {
        try {
            if (AgentCommonData.isAgentFlow()) {
                this.setAgentDateExpireDate();
            } else {
                this.setDateExpireDate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onDisconnectedServer() {
    }

    public void onReceivedMessage(String string2, String string3) {
        if (AgentCommonData.isAgentFlow()) {
            UserData userData = AgentCommonData.getUserData();
            if (userData != null && string3.substring(1).equals(userData.getUserChannel())) {
                return;
            }
            this.onAgentMessageReceived(string2, string3);
        } else {
            this.onMessageReceived(string2, string3);
        }
    }

    private void onMessageReceived(String string2, String string3) {
        Long l = null;
        l = Long.parseLong(string3.substring(1));
        try {
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("message") && !jSONObject.getString("message").isEmpty() || jSONObject.has("image_url") && !jSONObject.getString("image_url").isEmpty()) {
                String string4 = jSONObject.getString("muid");
                if (FuguChatActivity.currentChannelId != l) {
                    if (l != this.channelId && jSONObject.optInt("message_type") == 10) {
                        return;
                    }
                    Message message = this.sendingMessagesList.get(jSONObject.getString("muid"));
                    message.setMessageStatus(1);
                    String string5 = message.getSentAtUtc();
                    String string6 = DateUtils.getInstance().convertToLocal(string5, this.inputFormat, this.outputFormat);
                    if (!this.tempDate.equalsIgnoreCase(string6)) {
                        this.sentMessages.put(string6, new Message(string6, true));
                    }
                    this.sentMessages.put(jSONObject.getString("muid"), message);
                    this.sendingMessages.remove(string4);
                    UNSENT_MESSAGES.remove(string4);
                    this.unsentMessageMap.remove(string4);
                    this.sendingMessages();
                } else {
                    if (this.sentMessages != null || this.sentMessages.size() > 0) {
                        CommonData.addExistingMessages(l, this.sentMessages);
                    }
                    this.allUnsentMessageMap.remove(l);
                    this.sendMessages();
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onAgentMessageReceived(String string2, String string3) {
        Long l = null;
        l = Long.parseLong(string3.substring(1));
        try {
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("message") && !jSONObject.getString("message").isEmpty() || jSONObject.has("image_url") && !jSONObject.getString("image_url").isEmpty()) {
                String string4 = jSONObject.getString("muid");
                if (AgentChatActivity.currentChannelId != l) {
                    if (l != this.channelId && jSONObject.optInt("message_type") == 10) {
                        return;
                    }
                    ListItem listItem = this.agentsendingMessagesList.get(jSONObject.getString("muid"));
                    ((EventItem)listItem).getEvent().setMessageStatus(1);
                    String string5 = ((EventItem)listItem).getEvent().getSentAtUtc();
                    String string6 = DateUtils.getInstance().convertToLocal(string5, this.inputFormat, this.outputFormat);
                    if (!this.tempDate.equalsIgnoreCase(string6)) {
                        this.agentsentMessages.put(string6, new HeaderItem(string6));
                    }
                    this.agentsentMessages.put(jSONObject.getString("muid"), listItem);
                    this.sendingMessages.remove(string4);
                    AGENTUNSENT_MESSAGES.remove(string4);
                    this.unsentMessageMap.remove(string4);
                    this.sendingAgentMessages();
                } else {
                    if (this.agentsentMessages != null || this.agentsentMessages.size() > 0) {
                        AgentCommonData.addExistingMessages(l, this.agentsentMessages);
                    }
                    this.allUnsentMessageMap.remove(l);
                    this.sendAgentMessages();
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onPongReceived() {
    }

    public void onWebSocketError() {
    }

    public void onErrorReceived(String string2, String string3) {
    }

    public void onNotConnected() {
    }

    private void setAgentDateExpireDate() throws Exception {
        Long l = 0L;
        l = AgentChatActivity.currentChannelId;
        for (Long l2 : this.unsentMessageMap.keySet()) {
            if (l.compareTo(l2) == 0) continue;
            LinkedHashMap<String, ListItem> linkedHashMap = AGENTUNSENT_MESSAGES.get(l2);
            LinkedHashMap<String, JSONObject> linkedHashMap2 = this.unsentMessageMap.get(l2);
            if (linkedHashMap2 != null && linkedHashMap2.size() == 0) {
                AgentCommonData.removeUnsentMessageChannel(l2);
                AgentCommonData.removeUnsentMessageMapChannel(l2);
                continue;
            }
            LinkedHashMap<String, JSONObject> linkedHashMap3 = new LinkedHashMap<String, JSONObject>();
            for (String string2 : linkedHashMap.keySet()) {
                ListItem listItem = linkedHashMap.get(string2);
                String string3 = ((EventItem)listItem).getEvent().getSentAtUtc();
                int n = ((EventItem)listItem).getEvent().getIsMessageExpired();
                if (n == 0 && DateUtils.getTimeDiff(string3)) {
                    ((EventItem)listItem).getEvent().setIsMessageExpired(1);
                    try {
                        JSONObject jSONObject = linkedHashMap2.get(string2);
                        jSONObject.put("is_message_expired", 1);
                        linkedHashMap2.put(string2, jSONObject);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                linkedHashMap3.put(string2, linkedHashMap2.get(string2));
            }
            this.allUnsentMessageMap.put(l2, linkedHashMap3);
            if (AgentChatActivity.currentChannelId.compareTo(l2) == 0) continue;
            AGENTUNSENT_MESSAGES.put(l2, linkedHashMap);
            this.unsentMessageMap.put(l2, linkedHashMap2);
            AgentCommonData.setUnsentMessageByChannel(l2, linkedHashMap);
            AgentCommonData.setUnsentMessageMapByChannel(l2, linkedHashMap2);
        }
        this.agentsentMessages.clear();
        this.sendAgentMessages();
    }

    private void setDateExpireDate() throws Exception {
        Long l = 0L;
        l = AgentCommonData.isAgentFlow() ? AgentChatActivity.currentChannelId : FuguChatActivity.currentChannelId;
        for (Long l2 : this.unsentMessageMap.keySet()) {
            if (l.compareTo(l2) == 0) continue;
            LinkedHashMap<String, Message> linkedHashMap = UNSENT_MESSAGES.get(l2);
            LinkedHashMap<String, JSONObject> linkedHashMap2 = this.unsentMessageMap.get(l2);
            if (linkedHashMap2 != null && linkedHashMap2.size() == 0) {
                CommonData.removeUnsentMessageChannel(l2);
                CommonData.removeUnsentMessageMapChannel(l2);
                continue;
            }
            if (linkedHashMap == null || linkedHashMap.size() == 0) {
                return;
            }
            for (String string2 : linkedHashMap.keySet()) {
                JSONObject jSONObject;
                Message message = linkedHashMap.get(string2);
                String string3 = message.getSentAtUtc();
                int n = message.getIsMessageExpired();
                if (message.getMessageType() != 10 && n == 0 && DateUtils.getTimeDiff(string3)) {
                    message.setIsMessageExpired(1);
                    try {
                        jSONObject = linkedHashMap2.get(string2);
                        if (jSONObject == null) continue;
                        jSONObject.put("is_message_expired", 1);
                        linkedHashMap2.put(string2, jSONObject);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (message.getMessageType() != 10 || (jSONObject = linkedHashMap2.get(string2)) != null) continue;
                message.setMessageStatus(5);
            }
            this.allUnsentMessageMap.put(l2, linkedHashMap2);
            if (FuguChatActivity.currentChannelId.compareTo(l2) == 0) continue;
            UNSENT_MESSAGES.put(l2, linkedHashMap);
            this.unsentMessageMap.put(l2, linkedHashMap2);
            CommonData.setUnsentMessageByChannel(l2, linkedHashMap);
            CommonData.setUnsentMessageMapByChannel(l2, linkedHashMap2);
        }
        this.sentMessages.clear();
        this.sendMessages();
    }

    private void sendAgentMessages() throws Exception {
        if (this.allUnsentMessageMap != null && this.allUnsentMessageMap.size() > 0) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        Iterator iterator = FuguNetworkStateReceiver.this.allUnsentMessageMap.keySet().iterator();
                        if (!iterator.hasNext()) break block8;
                        Long l = (Long)iterator.next();
                        FuguNetworkStateReceiver.this.channelId = l;
                        if (AgentChatActivity.currentChannelId.compareTo(l) != 0) {
                            FuguNetworkStateReceiver.this.channelId = l;
                            if (AgentChatActivity.currentChannelId.compareTo(FuguNetworkStateReceiver.this.channelId) != 0) {
                                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(l));
                            }
                            FuguNetworkStateReceiver.this.sendingMessages = (LinkedHashMap)FuguNetworkStateReceiver.this.allUnsentMessageMap.get(l);
                            FuguNetworkStateReceiver.this.agentsendingMessagesList = AGENTUNSENT_MESSAGES.get(l);
                            ArrayList arrayList = new ArrayList(FuguNetworkStateReceiver.this.agentsentMessages.keySet());
                            Collections.reverse(arrayList);
                            for (String string2 : arrayList) {
                                if (!(FuguNetworkStateReceiver.this.agentsentMessages.get(string2) instanceof HeaderItem)) continue;
                                FuguNetworkStateReceiver.this.tempDate = string2;
                                break;
                            }
                            try {
                                FuguNetworkStateReceiver.this.sendingAgentMessages();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            FuguNetworkStateReceiver.this.allUnsentMessageMap.remove(FuguNetworkStateReceiver.this.channelId);
                            try {
                                FuguNetworkStateReceiver.this.sendAgentMessages();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            }, 1000L);
        }
    }

    private void sendMessages() throws Exception {
        if (this.allUnsentMessageMap != null && this.allUnsentMessageMap.size() > 0) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        Iterator iterator = FuguNetworkStateReceiver.this.allUnsentMessageMap.keySet().iterator();
                        if (!iterator.hasNext()) break block8;
                        Long l = (Long)iterator.next();
                        FuguNetworkStateReceiver.this.channelId = l;
                        if (FuguChatActivity.currentChannelId.compareTo(l) != 0) {
                            FuguNetworkStateReceiver.this.channelId = l;
                            if (FuguChatActivity.currentChannelId.compareTo(FuguNetworkStateReceiver.this.channelId) != 0) {
                                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(l));
                            }
                            FuguNetworkStateReceiver.this.sendingMessages = (LinkedHashMap)FuguNetworkStateReceiver.this.allUnsentMessageMap.get(l);
                            FuguNetworkStateReceiver.this.sendingMessagesList = UNSENT_MESSAGES.get(l);
                            ArrayList arrayList = new ArrayList(FuguNetworkStateReceiver.this.sentMessages.keySet());
                            Collections.reverse(arrayList);
                            for (String string2 : arrayList) {
                                if (!((Message)FuguNetworkStateReceiver.this.sentMessages.get(string2)).isDateView()) continue;
                                FuguNetworkStateReceiver.this.tempDate = string2;
                                break;
                            }
                            try {
                                FuguNetworkStateReceiver.this.sendingMessages();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            FuguNetworkStateReceiver.this.allUnsentMessageMap.remove(FuguNetworkStateReceiver.this.channelId);
                            try {
                                FuguNetworkStateReceiver.this.sendMessages();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            }, 1000L);
        }
    }

    private void sendingAgentMessages() throws Exception {
        if (this.sendingMessages.size() == 0) {
            this.allUnsentMessageMap.remove(this.channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(this.channelId));
            AgentCommonData.removeUnsentMessageMapChannel(this.channelId);
            AgentCommonData.removeUnsentMessageChannel(this.channelId);
            if (this.agentsentMessages != null && this.agentsentMessages.size() > 0) {
                AgentCommonData.addExistingMessages(this.channelId, this.agentsentMessages);
            }
            this.sendAgentMessages();
        } else {
            for (String string2 : this.sendingMessages.keySet()) {
                JSONObject jSONObject = this.sendingMessages.get(string2);
                if (jSONObject.has("local_url") && !TextUtils.isEmpty((CharSequence)jSONObject.optString("local_url", ""))) continue;
                HippoLog.e(TAG, "**************");
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(this.channelId), jSONObject);
                break;
            }
        }
    }

    private void sendingMessages() throws Exception {
        if (this.sendingMessages.size() == 0) {
            this.allUnsentMessageMap.remove(this.channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(this.channelId));
            CommonData.removeUnsentMessageMapChannel(this.channelId);
            CommonData.removeUnsentMessageChannel(this.channelId);
            if (this.sentMessages != null && this.sentMessages.size() > 0) {
                CommonData.addExistingMessages(this.channelId, this.sentMessages);
            }
            this.sendMessages();
        } else {
            for (String string2 : this.sendingMessages.keySet()) {
                JSONObject jSONObject = this.sendingMessages.get(string2);
                if (jSONObject.has("local_url") && !TextUtils.isEmpty((CharSequence)jSONObject.optString("local_url", ""))) continue;
                if (jSONObject.optInt("is_message_expired", 0) != 0) break;
                HippoLog.e(TAG, "**************");
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(this.channelId), jSONObject);
                break;
            }
        }
    }
}

