/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.CaptureUserData;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.GroupingTag;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.HippoNotificationConfig;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.activity.ChannelActivity;
import com.hippo.agent.adapter.PagerAdapter;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.eventbus.BusProvider;
import com.hippo.eventbus.ConversationEvent;
import com.hippo.eventbus.OnViewUpdate;
import com.hippo.fragment.OpenChannelFragment;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UnreadCountModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.CustomViewPager;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.fileUpload.Prefs;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import retrofit2.Callback;

public class ChannelTypeFragment
extends BaseFragment
implements ViewPager.OnPageChangeListener,
FuguAppConstant {
    private CustomViewPager viewPager;
    private TabLayout tabLayout;
    private View rootView;
    private ChannelActivity channelActivity;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;
    private final int IS_HIT_REQUIRED = 200;
    public static boolean isRefresh = false;
    public static Long readChannelId = -1L;
    public static Long readLabelId = -1L;
    private boolean isScreenOpen = false;
    private boolean isFirstTimeOpen = true;
    private boolean isFromHistory = false;
    private Long openedChannelId = -1L;
    private PagerAdapter pagerAdapter;
    private ArrayList<Fragment> pagerFragments = new ArrayList();
    String[] titles = new String[2];
    private String title;
    private TextView tvToolbarName;
    private RelativeLayout myToolbar;
    private ImageView logout;
    private ImageView ivBackBtn;
    private LinearLayout llBtn;
    private boolean hasPager;
    private HippoColorConfig hippoColorConfig;
    ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();
    BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!ChannelTypeFragment.this.isScreenOpen) {
                    return;
                }
                JSONObject jSONObject = new JSONObject(intent.getStringExtra("message"));
                HippoLog.d("receiver", "Got message: " + jSONObject.toString());
                boolean bl = false;
                boolean bl2 = false;
                if (jSONObject.has("notification_type") && jSONObject.getInt("notification_type") == 5) {
                    ChannelTypeFragment.this.getConversations();
                } else {
                    FuguConversation fuguConversation;
                    int n;
                    if (jSONObject.has("channel_id") && jSONObject.getLong("channel_id") > 0L && (n = ChannelTypeFragment.this.fuguConversationList.indexOf(new FuguConversation(jSONObject.getLong("channel_id")))) != -1) {
                        bl = true;
                    }
                    if (jSONObject.has("label_id") && jSONObject.getLong("label_id") > 0L) {
                        for (n = 0; n < ChannelTypeFragment.this.fuguConversationList.size(); ++n) {
                            fuguConversation = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(n);
                            if (fuguConversation.getLabelId().longValue() != jSONObject.getLong("label_id")) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl && !bl2) {
                        ChannelTypeFragment.this.getConversations();
                    } else if (jSONObject.has("new_message") && jSONObject.has("channel_id")) {
                        n = ChannelTypeFragment.this.fuguConversationList.indexOf(new FuguConversation(jSONObject.getLong("channel_id")));
                        if (n > -1) {
                            fuguConversation = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(n);
                            fuguConversation.setDateTime(jSONObject.getString("date_time").replace("+00:00", ".000Z"));
                            if (jSONObject.has("new_message")) {
                                fuguConversation.setMessage(jSONObject.getString("new_message"));
                            }
                            if (HippoNotificationConfig.pushChannelId.compareTo(jSONObject.getLong("channel_id")) != 0) {
                                fuguConversation.setUnreadCount(fuguConversation.getUnreadCount() + 1);
                            } else {
                                fuguConversation.setUnreadCount(0);
                            }
                            fuguConversation.setLast_sent_by_id(jSONObject.getLong("last_sent_by_id"));
                            fuguConversation.setLast_sent_by_full_name(jSONObject.getString("last_sent_by_full_name"));
                            BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                            ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        } else {
                            ChannelTypeFragment.this.getConversations();
                        }
                    } else if (jSONObject.has("new_message") && jSONObject.has("label_id")) {
                        n = -1;
                        for (int j = 0; j < ChannelTypeFragment.this.fuguConversationList.size(); ++j) {
                            if (((FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(j)).getLabelId().compareTo(jSONObject.getLong("label_id")) != 0) continue;
                            n = j;
                            break;
                        }
                        if (n > -1) {
                            FuguConversation fuguConversation2 = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(n);
                            fuguConversation2.setDateTime(jSONObject.getString("date_time").replace("+00:00", ".000Z"));
                            if (jSONObject.has("new_message")) {
                                fuguConversation2.setMessage(jSONObject.getString("new_message"));
                            }
                            if (HippoNotificationConfig.pushLabelId.compareTo(jSONObject.getLong("label_id")) != 0) {
                                fuguConversation2.setUnreadCount(fuguConversation2.getUnreadCount() + 1);
                            } else {
                                fuguConversation2.setUnreadCount(0);
                            }
                            fuguConversation2.setLast_sent_by_id(jSONObject.getLong("last_sent_by_id"));
                            fuguConversation2.setLast_sent_by_full_name(jSONObject.getString("last_sent_by_full_name"));
                            BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                            ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        } else {
                            ChannelTypeFragment.this.getConversations();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setHasOptionsMenu(false);
        if (this.getArguments() != null) {
            this.title = this.getArguments().getString("title", "");
            this.isFromHistory = this.getArguments().getBoolean("from_history", false);
            this.openedChannelId = this.getArguments().getLong("channelId", -1L);
            this.appVersion = this.getArguments().getInt("appVersion", 0);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.rootView = layoutInflater.inflate(R.layout.fragment_channel_pager, viewGroup, false);
        return this.rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.channelActivity = (ChannelActivity)this.getActivity();
    }

    public void onDetach() {
        super.onDetach();
        this.channelActivity = null;
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.mMessageReceiver, new IntentFilter("notification_received"));
        HippoConfig.getInstance().setChannelActivity(true);
        this.myToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        this.logout = (ImageView)view.findViewById(R.id.logout);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.llBtn = (LinearLayout)view.findViewById(R.id.llBtn);
        this.title = CommonData.getChatTitle();
        this.tvToolbarName.setText((CharSequence)this.title);
        this.myToolbar.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.tvToolbarName.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        this.ivBackBtn.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        this.viewPager = (CustomViewPager)view.findViewById(R.id.pagerView);
        this.tabLayout = (TabLayout)view.findViewById(R.id.tabs);
        this.tabLayout.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.viewPager.setPagingEnabled(true);
        this.viewPager.addOnPageChangeListener(this);
        this.pagerFragments = new ArrayList();
        OpenChannelFragment openChannelFragment = new OpenChannelFragment();
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("isClosedChannel", true);
        openChannelFragment.setArguments(bundle2);
        HippoConfigAttributes hippoConfigAttributes = CommonData.getAttributes();
        try {
            if (hippoConfigAttributes != null && hippoConfigAttributes.getAdditionalInfo() != null) {
                this.hasPager = hippoConfigAttributes.getAdditionalInfo().isHasChannelPager();
                if (hippoConfigAttributes.getAdditionalInfo().hasLogoutBtn()) {
                    this.llBtn.setVisibility(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pagerFragments.add(new OpenChannelFragment());
        if (this.hasPager) {
            this.pagerFragments.add(openChannelFragment);
            this.tabLayout.setVisibility(0);
        } else {
            this.tabLayout.setVisibility(8);
        }
        this.titles[0] = "OnGoing";
        this.titles[1] = "Past";
        this.pagerAdapter = new PagerAdapter(this.getChildFragmentManager(), this.pagerFragments, this.titles);
        this.viewPager.setAdapter((androidx.viewpager.widget.PagerAdapter)this.pagerAdapter);
        this.tabLayout.setupWithViewPager((ViewPager)this.viewPager);
        this.setTabColor();
        this.decideAppFlow();
        this.logout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChannelTypeFragment.this.showDialog();
            }
        });
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    ChannelTypeFragment.this.getActivity().onBackPressed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void setTabColor() {
        this.tabLayout.setSelectedTabIndicatorColor(CommonData.getColorConfig().getHippoToolbarHighlighted());
        this.tabLayout.setTabTextColors(CommonData.getColorConfig().getHippoToolbardisable(), CommonData.getColorConfig().getHippoToolbarHighlighted());
    }

    public void onPageScrolled(int n, float f2, int n2) {
    }

    public void onPageSelected(int n) {
    }

    public void onPageScrollStateChanged(int n) {
    }

    private void decideAppFlow() {
        if (CommonData.getUserDetails() != null) {
            this.setUpUI();
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setApiHit() {
        if (CommonData.getUserDetails() != null) {
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setUpUI() {
        FuguPutUserDetailsResponse.Data data = CommonData.getUserDetails().getData();
        this.label = data.getBusinessName();
        this.businessName = data.getBusinessName();
        this.userId = data.getUserId();
        this.enUserId = data.getEn_user_id();
        if (!TextUtils.isEmpty((CharSequence)data.getFullName())) {
            this.userName = data.getFullName();
        }
        this.fuguConversationList.clear();
        if (CommonData.getConversationList().size() > 0 && !this.isFromHistory) {
            this.fuguConversationList.addAll(CommonData.getConversationList());
        } else if (CommonData.getConversationList().size() > 0) {
            this.fuguConversationList.addAll(CommonData.getConversationList());
        }
        BusProvider.getInstance().post((Object)new OnViewUpdate(4));
    }

    private void getConversations() {
        this.getConversations(this.isFromHistory);
    }

    private void getConversations(boolean bl) {
        if (this.isNetworkAvailable()) {
            CommonParams.Builder builder = new CommonParams.Builder();
            builder.add("app_secret_key", HippoConfig.getInstance().getAppKey());
            builder.add("en_user_id", this.enUserId);
            builder.add("app_version", 251);
            if (this.isFromHistory) {
                builder.add("status", "[2]");
            }
            builder.add("device_type", 1);
            CommonParams commonParams = builder.build();
            RestClient.getApiInterface().getConversations(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguGetConversationsResponse>((Activity)this.getActivity(), Boolean.valueOf(bl), Boolean.valueOf(false)){

                @Override
                public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                    try {
                        ArrayList<FuguConversation> arrayList = new ArrayList<FuguConversation>();
                        arrayList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                        if (ChannelTypeFragment.this.isFromHistory && CommonData.getUpdatedDetails().getData().isMultiChannelLabelMapping()) {
                            for (int j = arrayList.size() - 1; j >= 0; --j) {
                                HippoLog.e("TAG", "status -> " + ((FuguConversation)arrayList.get(j)).getChannelStatus());
                                if (((FuguConversation)arrayList.get(j)).getChannelStatus() == ChannelStatus.OPEN.getOrdinal() || ChannelTypeFragment.this.openedChannelId.equals(((FuguConversation)arrayList.get(j)).getChannelId())) {
                                    arrayList.remove(j);
                                    continue;
                                }
                                String string2 = ((FuguConversation)arrayList.get(j)).getMessage().replaceAll("<", "&lt;");
                                String string3 = string2.replaceAll(">", "&gt;");
                                ((FuguConversation)arrayList.get(j)).setMessage(string3);
                            }
                        } else {
                            for (int j = 0; j < arrayList.size(); ++j) {
                                String string4 = ((FuguConversation)arrayList.get(j)).getMessage().replaceAll("<", "&lt;");
                                String string5 = string4.replaceAll(">", "&gt;");
                                ((FuguConversation)arrayList.get(j)).setMessage(string5);
                            }
                            CommonData.setConversationList(arrayList);
                        }
                        ChannelTypeFragment.this.fuguConversationList.clear();
                        ChannelTypeFragment.this.fuguConversationList.addAll(arrayList);
                        ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError aPIError) {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(3));
                }
            });
        } else {
            BusProvider.getInstance().post((Object)new OnViewUpdate(3));
        }
    }

    private void updateCount(ArrayList<FuguConversation> arrayList) {
        try {
            int n = 0;
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            for (int j = 0; j < arrayList.size(); ++j) {
                if (arrayList.get(j).getUnreadCount() <= 0) continue;
                UnreadCountModel unreadCountModel = new UnreadCountModel(arrayList.get(j).getChannelId(), arrayList.get(j).getLabelId(), arrayList.get(j).getUnreadCount());
                this.unreadCountModels.add(unreadCountModel);
                n += arrayList.get(j).getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createConversation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("New Conversation");
        ChatByUniqueIdAttributes chatByUniqueIdAttributes = new ChatByUniqueIdAttributes.Builder().setTransactionId("").setUserUniqueKey(HippoConfig.getInstance().getUserData().getUserUniqueKey()).setTags(arrayList).setInsertBotId(true).build();
        HippoConfig.getInstance().openChatByUniqueId(chatByUniqueIdAttributes);
    }

    public void onDestroy() {
        super.onDestroy();
        HippoConfig.getInstance().setChannelActivity(false);
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.mMessageReceiver);
        readChannelId = null;
        readLabelId = null;
    }

    public void onResume() {
        super.onResume();
        NotificationManager notificationManager = (NotificationManager)this.getActivity().getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancelAll();
        }
        super.onResume();
        this.isScreenOpen = true;
        if (isRefresh) {
            isRefresh = false;
            try {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    FuguConversation fuguConversation = this.fuguConversationList.get(j);
                    if (readChannelId > -1L && fuguConversation.getChannelId() > -1L && fuguConversation.getChannelId().compareTo(readChannelId) == 0) {
                        fuguConversation.setUnreadCount(0);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    } else {
                        if (readLabelId <= -1L || fuguConversation.getLabelId() <= -1L || fuguConversation.getLabelId().compareTo(readLabelId) != 0) continue;
                        fuguConversation.setUnreadCount(0);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.updateCount(this.fuguConversationList);
        }
        if (!this.isFirstTimeOpen) {
            this.setApiHit();
        }
        this.isFirstTimeOpen = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 200 && n2 == -1) {
            FuguConversation fuguConversation = (FuguConversation)new Gson().fromJson(intent.getStringExtra("conversation"), FuguConversation.class);
            if (fuguConversation != null && fuguConversation.getLabelId().compareTo(-1L) != 0) {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    if (this.fuguConversationList.get(j).getLabelId().compareTo(fuguConversation.getLabelId()) != 0) continue;
                    this.fuguConversationList.get(j).setChannelId(fuguConversation.getChannelId());
                    this.fuguConversationList.get(j).setMessage(fuguConversation.getDefaultMessage());
                    this.fuguConversationList.get(j).setDateTime(fuguConversation.getDateTime());
                    this.fuguConversationList.get(j).setChannelStatus(fuguConversation.getChannelStatus());
                    this.fuguConversationList.get(j).setIsTimeSet(1);
                    this.fuguConversationList.get(j).setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                    this.fuguConversationList.get(j).setUserId(fuguConversation.getLast_sent_by_id());
                    this.fuguConversationList.get(j).setEnUserId(fuguConversation.getEnUserId());
                    this.fuguConversationList.get(j).setLast_message_status(fuguConversation.getLast_message_status());
                    this.fuguConversationList.get(j).setChatType(fuguConversation.getChatType());
                    BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            } else if (fuguConversation != null && fuguConversation.getLabelId().compareTo(-1L) == 0) {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    if (this.fuguConversationList.get(j).getChannelId().compareTo(fuguConversation.getChannelId()) != 0) continue;
                    this.fuguConversationList.get(j).setChannelId(fuguConversation.getChannelId());
                    this.fuguConversationList.get(j).setMessage(fuguConversation.getDefaultMessage());
                    this.fuguConversationList.get(j).setDateTime(fuguConversation.getDateTime());
                    this.fuguConversationList.get(j).setChannelStatus(fuguConversation.getChannelStatus());
                    this.fuguConversationList.get(j).setIsTimeSet(1);
                    this.fuguConversationList.get(j).setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                    this.fuguConversationList.get(j).setLast_message_status(fuguConversation.getLast_message_status());
                    this.fuguConversationList.get(j).setChatType(fuguConversation.getChatType());
                    BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            }
        }
        try {
            if (CommonData.getIsNewChat()) {
                this.getConversations();
                CommonData.setIsNewchat(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onConversationEvent(ConversationEvent conversationEvent) {
        if (conversationEvent.type == 1) {
            this.onRefresh();
        } else if (conversationEvent.type == 2) {
            this.createConversation();
        }
    }

    public void onRefresh() {
        this.getConversations(false);
    }

    private void sendUserDetails() {
        if (this.isNetworkAvailable()) {
            Object object;
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = null;
            try {
                jsonObject = gson.toJsonTree((Object)new FuguDeviceDetails(this.appVersion).getDeviceDetails()).getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            CaptureUserData captureUserData = null;
            if (captureUserData == null) {
                captureUserData = HippoConfig.getInstance().getUserData();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HippoConfig.getInstance();
            if (HippoConfig.getmResellerToken() != null) {
                hashMap.put("reseller_token", HippoConfig.getmResellerToken());
                hashMap.put("reference_id", String.valueOf(HippoConfig.getmReferenceId()));
            } else {
                hashMap.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            }
            hashMap.put("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity()));
            hashMap.put("app_type", HippoConfig.getInstance().getAppType());
            hashMap.put("device_type", 1);
            hashMap.put("app_version", "2.5.1");
            hashMap.put("device_details", jsonObject);
            if (captureUserData != null) {
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getUserUniqueKey()) && !captureUserData.getUserUniqueKey().trim().isEmpty()) {
                    hashMap.put("user_unique_key", captureUserData.getUserUniqueKey());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getFullName()) && !captureUserData.getFullName().trim().isEmpty()) {
                    hashMap.put("full_name", captureUserData.getFullName());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getEmail()) && !captureUserData.getEmail().trim().isEmpty()) {
                    hashMap.put("email", captureUserData.getEmail());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getPhoneNumber()) && !captureUserData.getPhoneNumber().trim().isEmpty()) {
                    hashMap.put("phone_number", captureUserData.getPhoneNumber());
                }
                if (!TextUtils.isEmpty((CharSequence)CommonData.getImagePath()) && !TextUtils.isEmpty((CharSequence)CommonData.getImagePath())) {
                    hashMap.put("user_image", CommonData.getImagePath());
                }
                if (!captureUserData.getTags().isEmpty()) {
                    object = new ArrayList();
                    for (GroupingTag groupingTag : captureUserData.getTags()) {
                        GroupingTag groupingTag2 = new GroupingTag();
                        if (!TextUtils.isEmpty((CharSequence)groupingTag.getTagName())) {
                            groupingTag2.setTagName(groupingTag.getTagName());
                        }
                        if (groupingTag.getTeamId() != null) {
                            groupingTag2.setTeamId(groupingTag.getTeamId());
                        }
                        if (TextUtils.isEmpty((CharSequence)groupingTag.getTagName()) && groupingTag.getTeamId() == null) continue;
                        ((ArrayList)object).add(groupingTag2);
                    }
                    hashMap.put("grouping_tags", new Gson().toJson(object));
                } else {
                    hashMap.put("grouping_tags", "[]");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(object = CommonData.getAttributes().getDeviceToken()))) {
                hashMap.put("device_token", object);
            }
            if (captureUserData != null && !captureUserData.getCustom_attributes().isEmpty()) {
                hashMap.put("custom_attributes", new JSONObject(captureUserData.getCustom_attributes()));
            }
            if (HippoConfig.getmResellerToken() != null) {
                this.apiPutUserDetailReseller(hashMap);
            } else {
                this.apiPutUserDetail(hashMap);
            }
        } else {
            BusProvider.getInstance().post((Object)new OnViewUpdate(1));
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> hashMap) {
        CommonParams commonParams = new CommonParams.Builder().putMap(hashMap).build();
        RestClient.getApiInterface().putUserDetails(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ChannelTypeFragment.this.setUpUI();
                ChannelTypeFragment.this.fuguConversationList.clear();
                ChannelTypeFragment.this.fuguConversationList.addAll(fuguPutUserDetailsResponse.getData().getFuguConversations());
                ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
            }

            @Override
            public void failure(APIError aPIError) {
                if (aPIError.getStatusCode() == 403) {
                    Toast.makeText((Context)ChannelTypeFragment.this.getActivity(), (CharSequence)aPIError.getMessage(), (int)0).show();
                    ChannelTypeFragment.this.getActivity().finish();
                } else {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(1));
                }
            }
        });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> hashMap) {
        CommonParams commonParams = new CommonParams.Builder().putMap(hashMap).build();
        RestClient.getApiInterface().putUserDetailsReseller(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ChannelTypeFragment.this.setUpUI();
                ChannelTypeFragment.this.fuguConversationList.clear();
                ChannelTypeFragment.this.fuguConversationList.addAll(fuguPutUserDetailsResponse.getData().getFuguConversations());
                ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
            }

            @Override
            public void failure(APIError aPIError) {
                if (aPIError.getStatusCode() == 403) {
                    Toast.makeText((Context)ChannelTypeFragment.this.getActivity(), (CharSequence)aPIError.getMessage(), (int)0).show();
                    ChannelTypeFragment.this.getActivity().finish();
                } else {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(1));
                }
            }
        });
    }

    private void showDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"Are you sure you want to logout?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Prefs.with((Context)ChannelTypeFragment.this.getActivity()).remove("access_token");
                Prefs.with((Context)ChannelTypeFragment.this.getActivity()).remove("user_unique_key");
                HippoConfig.clearHippoData((Activity)ChannelTypeFragment.this.getActivity());
                ChannelTypeFragment.this.getActivity().finish();
                LibApp.getInstance().openMainScreen();
            }
        }).setNegativeButton((CharSequence)"N0", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        }).setCancelable(false).show();
    }
}

