/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.DeeplinKData;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.MobileCampaignBuilder;
import com.hippo.NotificationListener;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.adapter.CampaignAdapter;
import com.hippo.apis.ApiGetMobileNotification;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnClearNotificationListener;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.swipetoshow.SwipeHolder;
import com.hippo.utils.swipetoshow.SwipeOnItemTouchAdapter;
import java.util.ArrayList;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CampaignFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
OnItemClickListener {
    private static final String TAG = CampaignFragment.class.getSimpleName();
    private View rootView;
    private TextView tvToolbarName;
    private RelativeLayout myToolbar;
    private ImageView delete;
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recyclerView;
    private CampaignAdapter campaignAdapter;
    private MobileCampaignBuilder campaignBuilder;
    private int startOffset = 0;
    private int offset = 19;
    private int endOffset;
    private ArrayList<Data> arrayList = new ArrayList();
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private TextView titleError;
    private ImageView ivBackBtn;
    HippoConfigAttributes attributes;

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        this.rootView = layoutInflater.inflate(R.layout.hippo_campaigns_layout, viewGroup, false);
        return this.rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.campaignBuilder = HippoConfig.getInstance().getMobileCampaignBuilder();
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.titleError = (TextView)view.findViewById(R.id.title_error);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.endOffset = this.startOffset + this.offset;
        this.refreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.refreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.refreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.refreshLayout.setSize(1);
        this.myToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        String string2 = "Notification";
        String string3 = "No Notifications";
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getNotificationTitle())) {
            string2 = this.campaignBuilder.getNotificationTitle();
        }
        if (this.campaignBuilder != null && !TextUtils.isEmpty((CharSequence)this.campaignBuilder.getEmptyNotificationText())) {
            string3 = this.campaignBuilder.getEmptyNotificationText();
        }
        this.tvToolbarName.setText((CharSequence)string2);
        this.myToolbar.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.tvToolbarName.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        this.titleError.setText((CharSequence)string3);
        this.delete = (ImageView)view.findViewById(R.id.delete);
        this.layoutManager = new LinearLayoutManager(this.getContext());
        this.layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.campaignAdapter = new CampaignAdapter((Activity)this.getActivity(), null, this.recyclerView, this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.campaignAdapter);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.ivBackBtn.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        this.delete.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        this.refreshLayout.setRefreshing(true);
        this.fetchData();
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                super.onScrolled(recyclerView, n, n2);
                if (n2 > 0) {
                    CampaignFragment.this.visibleItemCount = CampaignFragment.this.layoutManager.getChildCount();
                    CampaignFragment.this.totalItemCount = CampaignFragment.this.layoutManager.getItemCount();
                    CampaignFragment.this.pastVisiblesItems = CampaignFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (!CampaignFragment.this.isPagingApiInProgress && CampaignFragment.this.hasMorePages && CampaignFragment.this.visibleItemCount + CampaignFragment.this.pastVisiblesItems >= CampaignFragment.this.totalItemCount) {
                        CampaignFragment.this.startOffset = CampaignFragment.this.endOffset + 1;
                        CampaignFragment.this.endOffset = CampaignFragment.this.startOffset + CampaignFragment.this.offset;
                        CampaignFragment.this.fetchData();
                    }
                }
            }
        });
        this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new SwipeOnItemTouchAdapter((Context)this.getActivity(), this.recyclerView, (RecyclerView.LayoutManager)this.layoutManager){

            @Override
            public void onItemHiddenClick(SwipeHolder swipeHolder, int n) {
                CampaignFragment.this.clearData(((Data)CampaignFragment.this.arrayList.get(n)).getChannelId(), n);
                swipeHolder.reset();
            }

            @Override
            public void onItemClick(int n) {
            }
        });
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CampaignFragment.this.deleteAll();
            }
        });
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    CampaignFragment.this.getActivity().onBackPressed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private HippoConfigAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = CommonData.getAttributes();
        }
        return this.attributes;
    }

    public void onRefresh() {
        if (this.isNetworkAvailable()) {
            this.startOffset = 0;
            this.endOffset = this.startOffset + this.offset;
            this.fetchData();
        } else {
            this.refreshLayout.setRefreshing(false);
        }
    }

    public static JSONObject objectToJSONObject(Object object) {
        Object object2 = null;
        JSONObject jSONObject = null;
        try {
            object2 = new JSONTokener(object.toString()).nextValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object2 instanceof JSONObject) {
            jSONObject = (JSONObject)object2;
        }
        return jSONObject;
    }

    @Override
    public void onClickListener(int n) {
        block13: {
            Object object;
            try {
                if (this.campaignBuilder != null && this.campaignBuilder.getListener() != null) {
                    object = new Gson().toJson((Object)this.arrayList.get(n).getCustomAttributes());
                    this.campaignBuilder.getListener().onItemClickListener((String)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Intent intent;
                if (this.arrayList.get(n).getCustomAttributes() == null || TextUtils.isEmpty((CharSequence)this.arrayList.get(n).getCustomAttributes().getDeeplink()) || !this.arrayList.get(n).getCustomAttributes().getDeeplink().equals("3x67AU1") || CommonData.getAttributes().getDeepLinks() == null || (object = CommonData.getAttributes().getDeepLinks().get(this.arrayList.get(n).getCustomAttributes().getDeeplink())) == null || TextUtils.isEmpty((CharSequence)((DeeplinKData)object).getPakageName()) || TextUtils.isEmpty((CharSequence)((DeeplinKData)object).getClassFullPath())) break block13;
                FuguPutUserDetailsResponse.Data data = CommonData.getUserDetails().getData();
                String string2 = data.getBusinessName();
                long l = data.getUserId();
                String string3 = data.getEn_user_id();
                FuguConversation fuguConversation = new FuguConversation();
                fuguConversation.setLabel(this.arrayList.get(n).getTitle());
                fuguConversation.setLabelId(Long.valueOf(this.arrayList.get(n).getChannelId()));
                fuguConversation.setDefaultMessage("");
                fuguConversation.setBusinessName(string2);
                fuguConversation.setUserId(l);
                fuguConversation.setEnUserId(string3);
                fuguConversation.setOpenChat(true);
                fuguConversation.setUserName(data.getFullName());
                fuguConversation.setIsTimeSet(1);
                fuguConversation.setChatType(0);
                fuguConversation.setStatus(1);
                boolean bl = false;
                try {
                    intent = CampaignFragment.objectToJSONObject(this.arrayList.get(n).getCustomAttributes().getData());
                    if (intent.optInt("skip_bot", 0) == 1) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                intent = new Intent();
                if (bl) {
                    intent.putExtra("is_skip_bot", 1);
                }
                intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                String string4 = ((DeeplinKData)object).getPakageName();
                String string5 = ((DeeplinKData)object).getClassFullPath();
                intent.setComponent(new ComponentName(string4, string5));
                this.startActivity(intent);
                if (this.campaignBuilder != null) {
                    if (this.campaignBuilder.isCloseActivityOnClick()) {
                        this.getActivity().finish();
                    } else if (this.campaignBuilder.isCloseOnlyDeepLink() && !TextUtils.isEmpty((CharSequence)this.arrayList.get(n).getCustomAttributes().getDeeplink())) {
                        this.getActivity().finish();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void onLoadMore() {
    }

    private void fetchData() {
        if (this.isNetworkAvailable()) {
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = true;
                this.campaignAdapter.showPaginationProgressBar(true, true);
            }
            new ApiGetMobileNotification((Activity)this.getActivity(), new NotificationListener(){

                @Override
                public void onSucessListener(PromotionResponse promotionResponse) {
                    try {
                        if (CampaignFragment.this.arrayList == null) {
                            CampaignFragment.this.arrayList = new ArrayList();
                        }
                        if (CampaignFragment.this.startOffset == 0) {
                            CampaignFragment.this.arrayList.clear();
                        }
                        if (CampaignFragment.this.startOffset != 0) {
                            CampaignFragment.this.isPagingApiInProgress = false;
                            CampaignFragment.this.campaignAdapter.showPaginationProgressBar(false, true);
                        }
                        CampaignFragment.this.arrayList.addAll(promotionResponse.getData());
                        if (CampaignFragment.this.arrayList.size() == 0) {
                            CampaignFragment.this.titleError.setVisibility(0);
                            CampaignFragment.this.delete.setVisibility(8);
                        } else {
                            CampaignFragment.this.titleError.setVisibility(8);
                            CampaignFragment.this.delete.setVisibility(0);
                        }
                        if (CampaignFragment.this.campaignAdapter != null) {
                            CampaignFragment.this.campaignAdapter.setData(CampaignFragment.this.arrayList);
                        }
                        CampaignFragment.this.refreshLayout.setRefreshing(false);
                        CampaignFragment.this.hasMorePages = promotionResponse.getData().size() == CampaignFragment.this.offset;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void onFailureListener() {
                    CampaignFragment.this.refreshLayout.setRefreshing(false);
                    if (CampaignFragment.this.startOffset != 0) {
                        CampaignFragment.this.isPagingApiInProgress = false;
                        CampaignFragment.this.campaignAdapter.showPaginationProgressBar(false, true);
                    }
                    if (CampaignFragment.this.arrayList.size() == 0) {
                        CampaignFragment.this.titleError.setVisibility(0);
                    } else {
                        CampaignFragment.this.titleError.setVisibility(8);
                    }
                }

                @Override
                public void onItemClickListener(String string2) {
                }
            }).getNotificationData(this.startOffset, this.endOffset);
        } else {
            ToastUtil.getInstance((Context)this.getActivity()).showToast(R.string.fugu_not_connected_to_internet);
            this.refreshLayout.setRefreshing(false);
            if (this.startOffset != 0) {
                this.isPagingApiInProgress = false;
                this.campaignAdapter.showPaginationProgressBar(false, true);
            }
        }
    }

    private void deleteAll() {
        new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"Are you sure you want to clear all notifications?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                CampaignFragment.this.clearData(-1L, -1);
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        }).create().show();
    }

    public void clearData(long l, int n) {
        if (this.isNetworkAvailable()) {
            new ApiGetMobileNotification((Activity)this.getActivity(), new OnClearNotificationListener(){

                @Override
                public void onSucessListener(int n) {
                    if (n > -1) {
                        CampaignFragment.this.campaignAdapter.notifyItemRemoved(n);
                        CampaignFragment.this.arrayList.remove(n);
                        ToastUtil.getInstance((Context)CampaignFragment.this.getActivity()).showToast("Notification deleted");
                    } else {
                        CampaignFragment.this.arrayList.clear();
                        CampaignFragment.this.campaignAdapter.notifyDataSetChanged();
                    }
                    if (CampaignFragment.this.arrayList.size() == 0) {
                        CampaignFragment.this.delete.setVisibility(8);
                        CampaignFragment.this.titleError.setVisibility(0);
                    }
                }

                @Override
                public void onFailure() {
                }
            }).clearNotification(l, n);
        } else {
            ToastUtil.getInstance((Context)this.getActivity()).showToast(R.string.fugu_not_connected_to_internet);
        }
    }
}

