/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.PaymentGatewayAdapter;
import com.hippo.apis.GetPaymentGateway;
import com.hippo.callback.OnPaymentItemClickListener;
import com.hippo.callback.OnPaymentListListener;
import com.hippo.database.CommonData;
import com.hippo.model.HippoPayment;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.util.ArrayList;

public class BottomSheetPopup
extends BottomSheetDialogFragment
implements OnPaymentItemClickListener {
    private RecyclerView recyclerView;
    private PaymentGatewayAdapter paymentAdapter;
    private String url;
    private String payment;
    private String currency;
    private LinearLayout paymentLayout;
    private TextView paymentMethod;
    private ProgressWheel progress;

    public static BottomSheetPopup newInstance(Bundle bundle) {
        BottomSheetPopup bottomSheetPopup = new BottomSheetPopup();
        bottomSheetPopup.setArguments(bundle);
        return bottomSheetPopup;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (this.getArguments() != null) {
            this.url = this.getArguments().getString("url");
            this.payment = this.getArguments().getString("payment");
            this.currency = this.getArguments().getString("currency");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        new BottomSheetDialog(this.requireContext(), this.getTheme());
        return layoutInflater.inflate(R.layout.hippo_payment_bottom_sheet, viewGroup, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.paymentLayout = (LinearLayout)view.findViewById(R.id.paymentLayout);
        this.paymentMethod = (TextView)view.findViewById(R.id.payment_method);
        this.progress = (ProgressWheel)view.findViewById(R.id.progress);
        this.showPayemtMethods(true);
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onItemClickListener(AddedPaymentGateway addedPaymentGateway) {
        try {
            FuguChatActivity fuguChatActivity = (FuguChatActivity)this.getActivity();
            fuguChatActivity.openPaymentDialog(this.url, (HippoPayment)new Gson().fromJson(this.payment, HippoPayment.class), addedPaymentGateway);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dismiss();
    }

    private void showPayemtMethods(boolean bl) {
        ArrayList<AddedPaymentGateway> arrayList = new ArrayList<AddedPaymentGateway>();
        for (AddedPaymentGateway addedPaymentGateway : CommonData.getPaymentList()) {
            if (!addedPaymentGateway.getCurrencyallowed().contains(this.currency.toUpperCase())) continue;
            arrayList.add(addedPaymentGateway);
        }
        if (arrayList.size() == 0) {
            this.recyclerView.setVisibility(8);
            this.paymentLayout.setVisibility(0);
            if (bl) {
                this.progress.setVisibility(0);
                this.paymentMethod.setText((CharSequence)this.getString(R.string.hippo_fetching_payment_methods));
                this.fetchUpdateGateways();
            } else {
                this.progress.setVisibility(8);
                this.paymentMethod.setText((CharSequence)this.getString(R.string.hippo_no_payment_methods));
            }
        } else {
            this.paymentAdapter = new PaymentGatewayAdapter(arrayList, this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
            this.recyclerView.setVisibility(0);
            this.paymentLayout.setVisibility(8);
        }
    }

    private void fetchUpdateGateways() {
        GetPaymentGateway.INSTANCE.getPaymentGatewaysList(new OnPaymentListListener(){

            @Override
            public void onSuccessListener() {
                BottomSheetPopup.this.showPayemtMethods(false);
            }

            @Override
            public void onErrorListener() {
                BottomSheetPopup.this.showPayemtMethods(false);
            }
        });
    }
}

