/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.material.appbar.AppBarLayout;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.CustomField;
import com.hippo.model.HippoUserProfileModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.RoundedCornersTransformation;
import java.io.Serializable;
import java.util.ArrayList;
import retrofit2.Callback;

public class ProfileFragmentDialog
extends DialogFragment
implements AppBarLayout.OnOffsetChangedListener {
    private HippoUserProfileModel profileModel;
    private ImageView imageView;
    private LinearLayout contentLayout;
    protected AppBarLayout appBarLayout;
    protected Toolbar toolbar;
    View view;

    public static ProfileFragmentDialog newInstance(HippoUserProfileModel hippoUserProfileModel) {
        ProfileFragmentDialog profileFragmentDialog = new ProfileFragmentDialog();
        Bundle bundle = new Bundle();
        bundle.putSerializable("profileModel", (Serializable)hippoUserProfileModel);
        bundle.putBoolean("fullScreen", true);
        profileFragmentDialog.setArguments(bundle);
        return profileFragmentDialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_profile_fragment, viewGroup, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onResume() {
        super.onResume();
    }

    public void onDismiss(DialogInterface dialogInterface) {
        super.onDismiss(dialogInterface);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ivBackBtn) {
            // empty if block
        }
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        try {
            if (this.getArguments() != null) {
                this.profileModel = (HippoUserProfileModel)this.getArguments().getSerializable("profileModel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setStyle(0, R.style.FullScreenDialogStyle);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.imageView = (ImageView)view.findViewById(R.id.image);
        this.contentLayout = (LinearLayout)view.findViewById(R.id.contentLayout);
        this.appBarLayout = (AppBarLayout)view.findViewById(R.id.appbar);
        this.toolbar = (Toolbar)view.findViewById(R.id.toolbar);
        this.appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.getActivity(), 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.hippo_placeholder));
        Glide.with((FragmentActivity)this.getActivity()).load(this.profileModel.getImageUrl()).apply((BaseRequestOptions)requestOptions).into(this.imageView);
        this.getAgentInfo();
    }

    private void getAgentInfo() {
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", this.profileModel.getEnUserId()).add("channel_id", this.profileModel.getChannelID()).build();
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentInfoResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

            @Override
            public void success(AgentInfoResponse agentInfoResponse) {
                ArrayList arrayList = new ArrayList();
                for (CustomField customField : agentInfoResponse.getData().getCustomFields()) {
                    if (!customField.getShowToCustomer().booleanValue()) continue;
                    ProfileFragmentDialog.this.contentLayout.addView(ProfileFragmentDialog.this.getViews(customField.getDisplayName(), customField.getValue()));
                }
            }

            @Override
            public void failure(APIError aPIError) {
            }
        });
    }

    private View getViews(String string2, String string3) {
        LayoutInflater layoutInflater = (LayoutInflater)this.getActivity().getBaseContext().getSystemService("layout_inflater");
        this.view = layoutInflater.inflate(R.layout.hippo_content_main, null, false);
        TextView textView = (TextView)this.view.findViewById(R.id.title);
        TextView textView2 = (TextView)this.view.findViewById(R.id.detail);
        textView.setText((CharSequence)string2);
        textView2.setText((CharSequence)string3);
        return this.view;
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int n) {
    }
}

