/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.database;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.hippo.CaptureUserData;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.MobileCampaignBuilder;
import com.hippo.database.PaperDbConstant;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.AppUpdateModel;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetMessageResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.Message;
import com.hippo.model.PaymentData;
import com.hippo.model.UnreadCountModel;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import io.paperdb.Paper;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.json.JSONObject;

public final class CommonData
implements PaperDbConstant {
    public static List<FuguConversation> CONVERSATION_LIST = Collections.emptyList();
    public static FuguPutUserDetailsResponse USER_DETAILS = null;
    public static String SERVER_URL = "";
    public static String APP_SECRET_KEY = "";
    public static String APP_TYPE = "1";
    public static TreeMap<Long, FuguGetMessageResponse> GET_MESSAGE_RESPONSE_MAP = new TreeMap();
    public static TreeMap<Long, FuguGetMessageResponse> GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
    public static TreeMap<Long, TreeMap<String, Message>> UNSENT_MESSAGE_MAP = new TreeMap();
    public static HippoColorConfig COLOR_CONFIG = new HippoColorConfig();
    public static String isNewChatKey = "IS_NEW_CHAT";
    public static String providerKey = "PROVIDER_KEY";
    public static String pushKey = "PUSH_KEY";
    public static String NOTIFICATION_FIRST_CLICK = "hippo_notification_first_click";
    public static String pushChannelKey = "PUSH_CHANNEL_KEY";
    public static String isAppOpenKey = "isAppOpen";
    public static TreeMap<Long, ArrayList<Message>> FUGU_MESSAGE_LIST = new TreeMap();
    public static final String clearFuguDataKey = "clearHippoData";
    public static final String HIPPO_UNREAD_COUNT = "hippo_unread_count";
    private static String keyQuickReply = "saveQuickReplay";
    public static HashMap<Long, LinkedHashMap<String, JSONObject>> UNSENT_MESSAGE_JSON = new HashMap();
    public static HashMap<Long, LinkedHashMap<String, Message>> SENT_MESSAGES = new HashMap();
    public static HashMap<Long, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap();
    public static HashMap<Long, Long> LABEL_CHANNEL_ID = new HashMap();
    public static TreeMap<String, AgentInfoResponse> GET_AGENT_RESPONSE_MAP = new TreeMap();
    public static Type listType = new TypeToken<List<UnreadCountModel>>(){}.getType();

    private CommonData() {
    }

    public static void setMessageResponse(Long l, FuguGetMessageResponse fuguGetMessageResponse) {
        GET_MESSAGE_RESPONSE_MAP.put(l, fuguGetMessageResponse);
        Paper.book((String)"hippo.paperdb").write("fugu_get_message_response_map", GET_MESSAGE_RESPONSE_MAP);
    }

    public static FuguGetMessageResponse getMessageResponse(Long l) {
        if (GET_MESSAGE_RESPONSE_MAP.isEmpty()) {
            try {
                GET_MESSAGE_RESPONSE_MAP = (TreeMap)Paper.book((String)"hippo.paperdb").read("fugu_get_message_response_map", new TreeMap());
            }
            catch (Exception exception) {
                GET_MESSAGE_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_MESSAGE_RESPONSE_MAP.get(l);
    }

    public static FuguGetMessageResponse getLabelIdResponse(Long l) {
        if (GET_LABEL_ID_RESPONSE_MAP.isEmpty()) {
            try {
                GET_LABEL_ID_RESPONSE_MAP = (TreeMap)Paper.book((String)"hippo.paperdb").read("fugu_get_label_id_response_map", new TreeMap());
            }
            catch (Exception exception) {
                GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_LABEL_ID_RESPONSE_MAP.get(l);
    }

    public static void setServerUrl(String string2) {
        SERVER_URL = string2;
        Paper.book((String)"hippo.paperdb").write("fugu_server_url", (Object)SERVER_URL);
    }

    public static String getServerUrl() {
        if (TextUtils.isEmpty((CharSequence)SERVER_URL.trim())) {
            try {
                SERVER_URL = (String)Paper.book((String)"hippo.paperdb").read("fugu_server_url", (Object)"https://api.hippochat.io");
            }
            catch (Exception exception) {
                SERVER_URL = "https://api.hippochat.io";
            }
        }
        return SERVER_URL;
    }

    public static void setAppSecretKey(String string2) {
        APP_SECRET_KEY = string2;
        Paper.book((String)"hippo.paperdb").write("fugu_app_secret_key", (Object)APP_SECRET_KEY);
    }

    public static String getAppSecretKey() {
        if (APP_SECRET_KEY.isEmpty()) {
            APP_SECRET_KEY = (String)Paper.book((String)"hippo.paperdb").read("fugu_app_secret_key", (Object)"");
        }
        return APP_SECRET_KEY;
    }

    public static void setAppType(String string2) {
        APP_TYPE = string2;
        Paper.book((String)"hippo.paperdb").write("fugu_app_type_string", (Object)APP_TYPE);
    }

    public static String getAppType() {
        APP_TYPE = (String)Paper.book((String)"hippo.paperdb").read("fugu_app_type_string", (Object)"1");
        return APP_TYPE;
    }

    public static int getPushFlags() {
        try {
            return (Integer)Paper.book((String)"hippo.paperdb").read("hippo_push_flags", (Object)-1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void setPushFlags(int n) {
        Paper.book((String)"hippo.paperdb").write("hippo_push_flags", (Object)n);
    }

    public static void setCachedMessages(boolean bl, Long l, ArrayList<Message> arrayList) {
        if (bl && GET_LABEL_ID_RESPONSE_MAP.get(l) != null && GET_LABEL_ID_RESPONSE_MAP.get(l).getData() != null) {
            GET_LABEL_ID_RESPONSE_MAP.get(l).getData().getMessages().clear();
            GET_LABEL_ID_RESPONSE_MAP.get(l).getData().getMessages().addAll(arrayList);
        } else if (GET_MESSAGE_RESPONSE_MAP.get(l) != null && GET_MESSAGE_RESPONSE_MAP.get(l).getData() != null) {
            GET_MESSAGE_RESPONSE_MAP.get(l).getData().getMessages().clear();
            GET_MESSAGE_RESPONSE_MAP.get(l).getData().getMessages().addAll(arrayList);
        }
    }

    public static void setConversationList(List<FuguConversation> list) {
        CONVERSATION_LIST = list;
        Paper.book((String)"hippo.paperdb").write("fugu_conversation_list", list);
    }

    public static List<FuguConversation> getConversationList() {
        if (CONVERSATION_LIST.isEmpty()) {
            try {
                CONVERSATION_LIST = (List)Paper.book((String)"hippo.paperdb").read("fugu_conversation_list", Collections.emptyList());
            }
            catch (Exception exception) {
                CONVERSATION_LIST = Collections.emptyList();
            }
        }
        return CONVERSATION_LIST;
    }

    public static FuguPutUserDetailsResponse getUserDetails() {
        if (USER_DETAILS == null) {
            USER_DETAILS = (FuguPutUserDetailsResponse)Paper.book((String)"hippo.paperdb").read("fugu_user_details", null);
        }
        return USER_DETAILS;
    }

    public static void setColorConfig(HippoColorConfig hippoColorConfig) {
        COLOR_CONFIG = hippoColorConfig;
        Paper.book((String)"hippo.paperdb").write("fugu_color_config", (Object)hippoColorConfig);
    }

    public static HippoColorConfig getColorConfig() {
        if (COLOR_CONFIG == null) {
            COLOR_CONFIG = (HippoColorConfig)Paper.book((String)"hippo.paperdb").read("fugu_color_config", null);
        }
        return COLOR_CONFIG;
    }

    public static void setUserDetails(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
        USER_DETAILS = fuguPutUserDetailsResponse;
        Paper.book((String)"hippo.paperdb").write("fugu_user_details", (Object)fuguPutUserDetailsResponse);
    }

    public static FuguPutUserDetailsResponse getUpdatedDetails() {
        USER_DETAILS = (FuguPutUserDetailsResponse)Paper.book((String)"hippo.paperdb").read("fugu_user_details", null);
        return USER_DETAILS;
    }

    public static void clearData() throws Exception {
        USER_DETAILS = null;
        CONVERSATION_LIST = Collections.emptyList();
        GET_MESSAGE_RESPONSE_MAP = new TreeMap();
        GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
        UNSENT_MESSAGE_MAP = new TreeMap();
        SERVER_URL = "";
        APP_SECRET_KEY = "";
        COLOR_CONFIG = new HippoColorConfig();
        APP_TYPE = "";
        Paper.book((String)"hippo.paperdb").destroy();
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = null;
        try {
            jsonObject = gson.toJsonTree((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return jsonObject;
    }

    public static String deviceDetailString(Context context) {
        Gson gson = new GsonBuilder().create();
        String string2 = null;
        try {
            string2 = gson.toJson((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return string2;
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return 0;
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "";
        }
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (Exception exception) {
            HippoLog.e("IP Address", exception.toString());
        }
        return null;
    }

    public static void setIsNewchat(boolean bl) {
        Paper.book((String)"hippo.paperdb").write(isNewChatKey, (Object)bl);
    }

    public static boolean getIsNewChat() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read(isNewChatKey);
    }

    public static void setProvider(String string2) {
        Paper.book((String)"hippo.paperdb").write(providerKey, (Object)string2);
    }

    public static String getProvider() {
        return (String)Paper.book((String)"hippo.paperdb").read(providerKey);
    }

    public static void setPushBoolean(boolean bl) {
        Paper.book((String)"hippo.paperdb").write(pushKey, (Object)bl);
    }

    public static boolean getPushBoolean() {
        if (Paper.book((String)"hippo.paperdb").read(pushKey) == null) {
            return false;
        }
        return (Boolean)Paper.book((String)"hippo.paperdb").read(pushKey);
    }

    public static void setNotificationFirstClick(boolean bl) {
        Paper.book((String)"hippo.paperdb").write(NOTIFICATION_FIRST_CLICK, (Object)bl);
    }

    public static boolean isFirstTimeWithNotification() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read(NOTIFICATION_FIRST_CLICK, (Object)false);
    }

    public static void setPushChannel(Long l) {
        Paper.book((String)"hippo.paperdb").write(pushChannelKey, (Object)l);
    }

    public static Long getPushChannel() {
        if (Paper.book((String)"hippo.paperdb").read(pushChannelKey) == null) {
            return -1L;
        }
        return (Long)Paper.book((String)"hippo.paperdb").read(pushChannelKey);
    }

    public static void clearPushChannel() {
        Paper.book((String)"hippo.paperdb").delete(pushChannelKey);
    }

    public static void setTransactionIdsMap(HashMap<String, Long> hashMap) {
        Paper.book((String)"hippo.paperdb").write("TransactionIdsMap", hashMap);
    }

    public static HashMap<String, Long> getTransactionIdsMap() {
        try {
            return (HashMap)Paper.book((String)"hippo.paperdb").read("TransactionIdsMap");
        }
        catch (Exception exception) {
            return new HashMap<String, Long>();
        }
    }

    public static boolean getIsAppOpen() {
        if (Paper.book((String)"hippo.paperdb").read(isAppOpenKey) == null) {
            return true;
        }
        return (Boolean)Paper.book((String)"hippo.paperdb").read(isAppOpenKey);
    }

    public static void setIsAppOpen(boolean bl) {
        Paper.book((String)"hippo.paperdb").write(isAppOpenKey, (Object)bl);
    }

    public static void setClearHippoDataKey(boolean bl) {
        Paper.book((String)"hippo.paperdb").write(clearFuguDataKey, (Object)bl);
    }

    public static boolean getClearHippoDataKey() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read(clearFuguDataKey, (Object)false);
    }

    public static void saveDeviceToken(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_device_token", (Object)string2);
    }

    public static String getDeviceToken() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_device_token", (Object)"");
    }

    public static void setUnreadCount(ArrayList<UnreadCountModel> arrayList) {
        Paper.book((String)"hippo.paperdb").write(HIPPO_UNREAD_COUNT, arrayList);
    }

    public static ArrayList<UnreadCountModel> getUnreadCountModel() {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)Paper.book((String)"hippo.paperdb").read(HIPPO_UNREAD_COUNT, new ArrayList());
        }
        catch (Exception exception) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public static void setIsDataCleared(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("isDataCleared", (Object)bl);
    }

    public static boolean getIsDataCleared() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("isDataCleared", (Object)false);
    }

    public static void setChatTitle(String string2) {
        Paper.book((String)"hippo.paperdb").write("chat_title", (Object)string2);
    }

    public static String getChatTitle() {
        return (String)Paper.book((String)"hippo.paperdb").read("chat_title", (Object)"Support");
    }

    public static void saveResellerData(String string2, int n) {
        Paper.book((String)"hippo.paperdb").write("fugu_resellerToken", (Object)string2);
        Paper.book((String)"hippo.paperdb").write("fugu_referenceId", (Object)n);
    }

    public static void saveFuguConfigAttribute(HippoConfigAttributes hippoConfigAttributes) {
        Paper.book((String)"hippo.paperdb").write("hippo_config_attribute", (Object)hippoConfigAttributes);
    }

    public static HippoConfigAttributes getAttributes() {
        return (HippoConfigAttributes)Paper.book((String)"hippo.paperdb").read("hippo_config_attribute");
    }

    public static void saveUserData(CaptureUserData captureUserData) {
        Paper.book((String)"hippo.paperdb").write("hippo_userData", (Object)captureUserData);
        CommonData.setUserId(String.valueOf(captureUserData.getUserId()));
    }

    public static CaptureUserData getUserData() {
        try {
            return (CaptureUserData)Paper.book((String)"hippo.paperdb").read("hippo_userData", (Object)new CaptureUserData());
        }
        catch (Exception exception) {
            return new CaptureUserData();
        }
    }

    public static int getReferenceId() {
        return (Integer)Paper.book((String)"hippo.paperdb").read("fugu_referenceId", (Object)1);
    }

    public static String getResellerToken() {
        return (String)Paper.book((String)"hippo.paperdb").read("fugu_resellerToken", null);
    }

    public static void setCurrentVersion(int n) {
        Paper.book((String)"hippo.paperdb").write("hippo_db_version", (Object)n);
    }

    public static int getLocalVersion() {
        return (Integer)Paper.book((String)"hippo.paperdb").read("hippo_db_version", (Object)-1);
    }

    public static String getDefaultCategory() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_user_default_category", null);
    }

    public static void setDefaultCategory(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_user_default_category", (Object)string2);
    }

    public static void setSupportPath(ArrayList<String> arrayList) {
        Paper.book((String)"hippo.paperdb").write("hippo_support_path", arrayList);
        HippoLog.d("TAG", "Path = " + new Gson().toJson(arrayList));
    }

    public static ArrayList<String> getPathList() {
        return (ArrayList)Paper.book((String)"hippo.paperdb").read("hippo_support_path", new ArrayList());
    }

    public static void removeLastPath() {
        ArrayList<String> arrayList = CommonData.getPathList();
        arrayList.remove(arrayList.size() - 1);
        CommonData.setSupportPath(arrayList);
    }

    public static void clearPathList() {
        Paper.book((String)"hippo.paperdb").delete("hippo_support_path");
    }

    public static void saveUserUniqueKey(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_user_unique_key", (Object)string2);
    }

    public static String getUserUniqueKey() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_user_unique_key");
    }

    public static Message getQuickReplyData() {
        return (Message)Paper.book((String)"hippo.paperdb").read(keyQuickReply);
    }

    public static void setQuickReplyData(Message message) {
        Paper.book((String)"hippo.paperdb").write(keyQuickReply, (Object)message);
    }

    public static void clearQuickReplyData() {
        Paper.book((String)"hippo.paperdb").delete(keyQuickReply);
    }

    public static void setUnsentMessageMapByChannel(Long l, LinkedHashMap<String, JSONObject> linkedHashMap) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        if (linkedHashMap != null && linkedHashMap.values().size() > 0) {
            UNSENT_MESSAGE_JSON.put(l, linkedHashMap);
            Paper.book((String)"hippo.paperdb").write("hippo_unsent_message_map", UNSENT_MESSAGE_JSON);
        }
    }

    public static void removeUnsentMessageMapChannel(Long l) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        UNSENT_MESSAGE_JSON.remove(l);
        Paper.book((String)"hippo.paperdb").write("hippo_unsent_message_map", UNSENT_MESSAGE_JSON);
    }

    public static LinkedHashMap<String, JSONObject> getUnsentMessageMapByChannel(Long l) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        return UNSENT_MESSAGE_JSON.get(l);
    }

    public static HashMap<Long, LinkedHashMap<String, JSONObject>> getUnsentMessageMap() {
        try {
            UNSENT_MESSAGE_JSON = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_unsent_message_map", new HashMap());
        }
        catch (Exception exception) {
            UNSENT_MESSAGE_JSON = new HashMap();
        }
        return UNSENT_MESSAGE_JSON;
    }

    public static void clearAllUnsentMessages() {
        Paper.book((String)"hippo.paperdb").delete("hippo_unsent_message_map");
        Paper.book((String)"hippo.paperdb").delete("hippo_unsent_messages");
    }

    public static void setAllUnsentMessageByChannel(LinkedHashMap<String, Message> linkedHashMap) {
        Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", linkedHashMap);
    }

    public static void setUnsentMessageByChannel(Long l, LinkedHashMap<String, Message> linkedHashMap) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        if (linkedHashMap != null && linkedHashMap.values().size() > 0) {
            UNSENT_MESSAGES.put(l, linkedHashMap);
            Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", UNSENT_MESSAGES);
        }
    }

    public static void removeUnsentMessageChannel(Long l) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        UNSENT_MESSAGES.remove(l);
        Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", UNSENT_MESSAGES);
    }

    public static LinkedHashMap<String, Message> getUnsentMessageByChannel(Long l) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        return UNSENT_MESSAGES.get(l);
    }

    public static HashMap<Long, LinkedHashMap<String, Message>> getUnsentMessages() {
        try {
            UNSENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_unsent_messages", new HashMap());
        }
        catch (Exception exception) {
            UNSENT_MESSAGES = new HashMap();
        }
        return UNSENT_MESSAGES;
    }

    public static void addExistingMessages(Long l, LinkedHashMap<String, Message> linkedHashMap) {
        LinkedHashMap<String, Message> linkedHashMap2 = CommonData.getSentMessageByChannel(l);
        linkedHashMap2.putAll(linkedHashMap);
        CommonData.setSentMessageByChannel(l, linkedHashMap2);
    }

    public static void setSentMessageByChannel(Long l, LinkedHashMap<String, Message> linkedHashMap) {
        SENT_MESSAGES = CommonData.getSentMessages();
        SENT_MESSAGES.put(l, linkedHashMap);
        Paper.book((String)"hippo.paperdb").write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static void removeSentMessageChannel(Long l) {
        SENT_MESSAGES = CommonData.getSentMessages();
        SENT_MESSAGES.remove(l);
        Paper.book((String)"hippo.paperdb").write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static LinkedHashMap<String, Message> getSentMessageByChannel(Long l) {
        SENT_MESSAGES = CommonData.getSentMessages();
        return SENT_MESSAGES.get(l);
    }

    public static HashMap<Long, LinkedHashMap<String, Message>> getSentMessages() {
        try {
            SENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_sent_messages", new HashMap());
        }
        catch (Exception exception) {
            SENT_MESSAGES = new HashMap();
        }
        return SENT_MESSAGES;
    }

    public static String getCallStatus() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_call_status");
    }

    public static void setCallStatus(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_call_status", (Object)string2);
    }

    public static String getCallType() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_call_type");
    }

    public static void setUserId(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_user_id", (Object)string2);
    }

    public static void setCallType(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_call_type", (Object)string2);
    }

    public static boolean isEncodeToHtml() {
        try {
            return CommonData.getUserDetails().getData().isEncodeToHtml();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getDirectCallBtnDisabled() {
        try {
            return CommonData.getUserDetails().getData().isNavCallBtnDisabled();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean getVideoCallStatus() {
        try {
            return CommonData.getUserDetails().getData().isVideoCallEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getAudioCallStatus() {
        try {
            return CommonData.getUserDetails().getData().isAudioCallEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static HashMap<Long, FuguGetMessageResponse> getAgentData() {
        try {
            return (HashMap)Paper.book((String)"hippo.paperdb").read("agent_name_data", new HashMap());
        }
        catch (Exception exception) {
            return new HashMap<Long, FuguGetMessageResponse>();
        }
    }

    public static FuguGetMessageResponse getSingleAgentData(Long l) {
        HashMap<Long, FuguGetMessageResponse> hashMap = CommonData.getAgentData();
        return hashMap.get(l);
    }

    public static void saveVideoCallAgent(Long l, FuguGetMessageResponse fuguGetMessageResponse) {
        HashMap<Long, FuguGetMessageResponse> hashMap = CommonData.getAgentData();
        hashMap.put(l, fuguGetMessageResponse);
        Paper.book((String)"hippo.paperdb").write("agent_name_data", hashMap);
    }

    public static void setCallAnswered(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("hippo_call_answer", (Object)bl);
    }

    public static boolean isCallAnswered() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_call_answer", (Object)false);
    }

    public static void setTime(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_time_stamp", (Object)string2);
    }

    public static String getTime() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_time_stamp");
    }

    public static void setImageMuid(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_image_muid", (Object)string2);
    }

    public static String getImageMuid() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_image_muid");
    }

    public static void setFirstTimeCreated(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("hippo_create_first_time", (Object)bl);
    }

    public static boolean isFirstTimeCreated() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_create_first_time", (Object)true);
    }

    public static void saveUploadingFile(ArrayList<FileuploadModel> arrayList) {
        Paper.book((String)"hippo.paperdb").write("service_files_data", arrayList);
    }

    public static ArrayList<FileuploadModel> getSavedFile() {
        return (ArrayList)Paper.book((String)"hippo.paperdb").read("service_files_data", new ArrayList());
    }

    public static String getUserCountryCode() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_country_code", (Object)"");
    }

    public static String getUserContCode() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_cont_code", (Object)"");
    }

    public static void setUserCountryCode(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_country_code", (Object)string2);
    }

    public static void setUserContCode(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_cont_code", (Object)string2);
    }

    public static void savePutUserParams(HashMap<String, Object> hashMap) {
        Paper.book((String)"hippo.paperdb").write("hippo_user_putdata", hashMap);
    }

    public static HashMap<String, Object> getPutUserParams() {
        return (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_user_putdata", new HashMap());
    }

    public static void setPaymentData(PaymentData paymentData) {
        Paper.book((String)"hippo.paperdb").write("hippo_payment_data", (Object)paymentData);
    }

    public static PaymentData getPaymentData() {
        return (PaymentData)Paper.book((String)"hippo.paperdb").read("hippo_payment_data", (Object)new PaymentData());
    }

    public static void clearPaymentData() {
        Paper.book((String)"hippo.paperdb").delete("hippo_payment_data");
    }

    public static void setLeftTimeInSec(long l) {
        Paper.book((String)"hippo.paperdb").write("hippo_left_time", (Object)l);
        Paper.book((String)"hippo.paperdb").write("hippo_left_time_added", (Object)System.currentTimeMillis());
    }

    public static long getLeftTime() {
        return (Long)Paper.book((String)"hippo.paperdb").read("hippo_left_time");
    }

    public static long getAddedLeftTime() {
        return (Long)Paper.book((String)"hippo.paperdb").read("hippo_left_time_added");
    }

    public static void clearLeftTimeInSec() {
        Paper.book((String)"hippo.paperdb").delete("hippo_left_time");
        Paper.book((String)"hippo.paperdb").delete("hippo_left_time_added");
    }

    public static void setUserImagePath(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_user_image_path", (Object)string2);
    }

    public static String getImagePath() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_user_image_path", (Object)"");
    }

    public static void setBotId(Integer n) {
        if (n != null) {
            Paper.book((String)"hippo.paperdb").write("hippo_bot_id", (Object)n);
        } else {
            Paper.book((String)"hippo.paperdb").delete("hippo_bot_id");
        }
    }

    public static int getBotId() {
        return (Integer)Paper.book((String)"hippo.paperdb").read("hippo_bot_id", (Object)-1);
    }

    public static void skipBot(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("hippo_skip_bot", (Object)bl);
    }

    public static boolean getSkipBot() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_skip_bot", (Object)false);
    }

    public static MobileCampaignBuilder getCampaignBuilder() {
        MobileCampaignBuilder mobileCampaignBuilder = new MobileCampaignBuilder.Builder().setTitle(CommonData.getMobilePushTitle()).build();
        return mobileCampaignBuilder;
    }

    public static void setMobileCampaignBuilder(MobileCampaignBuilder mobileCampaignBuilder) {
        Paper.book((String)"hippo.paperdb").write("campaignBuilder", (Object)mobileCampaignBuilder);
    }

    public static String getMobilePushTitle() {
        return (String)Paper.book((String)"hippo.paperdb").read("campaignBuilderTitle", (Object)"Inbox");
    }

    public static void setMobilePushTitle(String string2) {
        Paper.book((String)"hippo.paperdb").write("campaignBuilderTitle", (Object)string2);
    }

    public static String getActionId() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_actionId", (Object)"");
    }

    public static void setActionId(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_actionId", (Object)string2);
    }

    public static String getUrl() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_action_url", (Object)"");
    }

    public static void setUrl(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_action_url", (Object)string2);
    }

    public static void setChannelId(Long l, Long l2) {
        HashMap<Long, Long> hashMap = CommonData.getChhannelLabelds();
        hashMap.put(l, l2);
        Paper.book((String)"hippo.paperdb").write("hippo_channel_labels", hashMap);
    }

    private static HashMap<Long, Long> getChhannelLabelds() {
        try {
            return (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_channel_labels", new HashMap());
        }
        catch (Exception exception) {
            return new HashMap<Long, Long>();
        }
    }

    public static Long getChannelId(Long l) {
        try {
            HashMap<Long, Long> hashMap = CommonData.getChhannelLabelds();
            Long l2 = -1L;
            l2 = hashMap.get(l);
            if (l2 == null) {
                l2 = -1L;
            }
            return l2;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static void setNewBackBtn(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("hippo_nav_btn_required", (Object)bl);
    }

    public static boolean isBackBtn() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_nav_btn_required", (Object)true);
    }

    public static void saveVersionInfo(AppUpdateModel appUpdateModel) {
        Paper.book((String)"hippo.paperdb").write("hippo_version_check", (Object)appUpdateModel);
    }

    public static AppUpdateModel getVersionInfo() {
        try {
            return (AppUpdateModel)Paper.book((String)"hippo.paperdb").read("hippo_version_check", null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveAgentData(String string2, AgentInfoResponse agentInfoResponse) {
        GET_AGENT_RESPONSE_MAP.put(string2, agentInfoResponse);
        Paper.book((String)"hippo.paperdb").write("fugu_get_agent_response_map", GET_AGENT_RESPONSE_MAP);
    }

    public static AgentInfoResponse getSavedAgentData(String string2) {
        if (GET_AGENT_RESPONSE_MAP.isEmpty()) {
            try {
                GET_AGENT_RESPONSE_MAP = (TreeMap)Paper.book((String)"hippo.paperdb").read("fugu_get_agent_response_map", new TreeMap());
                if (GET_AGENT_RESPONSE_MAP.size() > 40) {
                    Paper.book((String)"hippo.paperdb").write("fugu_get_agent_response_map", new TreeMap());
                }
            }
            catch (Exception exception) {
                GET_AGENT_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_AGENT_RESPONSE_MAP.get(string2);
    }

    public static String getAppName() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_app_name");
    }

    public static void setAppName(String string2) {
        Paper.book((String)"hippo.paperdb").write("hippo_app_name", (Object)string2);
    }

    public static void savePaymentList(List<AddedPaymentGateway> list) {
        Paper.book((String)"hippo.paperdb").write("hippo_payment_list", list);
    }

    public static List<AddedPaymentGateway> getPaymentList() {
        try {
            return (List)Paper.book((String)"hippo.paperdb").read("hippo_payment_list", new ArrayList());
        }
        catch (Exception exception) {
            return new ArrayList<AddedPaymentGateway>();
        }
    }

    public static void setConstantLabelId(Long l) {
        Paper.book((String)"hippo.paperdb").write("constant_label_id", (Object)l);
    }

    public static Long getConstantLabelId() {
        return (Long)Paper.book((String)"hippo.paperdb").read("constant_label_id", (Object)-1L);
    }

    public static void directScreens(boolean bl) {
        Paper.book((String)"hippo.paperdb").write("directScreens", (Object)bl);
    }

    public static boolean hasDirectScreen() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("directScreens", (Object)false);
    }
}

