/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.customLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hippo.R;

public class ChatRelativeLayout
extends RelativeLayout {
    private TextView parentTextView;
    private View childView;
    private TypedArray typedArray;
    private RelativeLayout.LayoutParams parentLayoutParams;
    private RelativeLayout.LayoutParams childLayoutParams;
    private int parentWidth;
    private int childWidth;
    private int parentHeight;
    private int childHeight;

    public ChatRelativeLayout(Context context) {
        super(context);
    }

    public ChatRelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ChatRelativeLayout, 0, 0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        try {
            this.parentTextView = (TextView)this.findViewById(this.typedArray.getResourceId(R.styleable.ChatRelativeLayout_parent, -1));
            this.childView = this.findViewById(this.typedArray.getResourceId(R.styleable.ChatRelativeLayout_child, -1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getSize((int)n);
        if (this.parentTextView == null || this.childView == null || n3 <= 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            int n4 = n3 - this.getPaddingStart() - this.getPaddingEnd();
            this.parentLayoutParams = (RelativeLayout.LayoutParams)this.parentTextView.getLayoutParams();
            this.parentWidth = this.parentTextView.getMeasuredWidth() + this.parentLayoutParams.getMarginStart() + this.parentLayoutParams.getMarginEnd();
            this.parentHeight = this.parentTextView.getMeasuredHeight() + this.parentLayoutParams.topMargin + this.parentLayoutParams.bottomMargin;
            this.childLayoutParams = (RelativeLayout.LayoutParams)this.childView.getLayoutParams();
            this.childWidth = this.childView.getMeasuredWidth() + this.childLayoutParams.getMarginStart() + this.childLayoutParams.getMarginEnd();
            this.childHeight = this.childView.getMeasuredHeight() + this.childLayoutParams.topMargin + this.childLayoutParams.bottomMargin;
            int n5 = this.parentTextView.getLineCount();
            float f2 = n5 > 0 ? this.parentTextView.getLayout().getLineWidth(n5 - 1) : 0.0f;
            n3 = this.getPaddingStart() + this.getPaddingEnd();
            int n6 = this.getPaddingTop() + this.getPaddingBottom();
            if (n5 > 1 && f2 + (float)this.childWidth < (float)this.parentTextView.getMeasuredWidth()) {
                n3 += this.parentWidth;
                n6 += this.parentHeight;
            } else if (n5 == 1 && this.parentWidth + this.childWidth >= n4) {
                n3 += this.parentTextView.getMeasuredWidth();
                n6 += this.parentHeight + this.childHeight;
            } else if (n5 > 1 && f2 + (float)this.childWidth >= (float)n4) {
                n3 += this.parentWidth;
                n6 += this.parentHeight + this.childHeight;
            } else {
                n3 += this.parentWidth + this.childWidth;
                n6 += this.parentHeight;
            }
            this.setMeasuredDimension(n3, n6);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000));
        } else {
            int n7 = n3 - this.getPaddingLeft() - this.getPaddingRight();
            this.parentLayoutParams = (RelativeLayout.LayoutParams)this.parentTextView.getLayoutParams();
            this.parentWidth = this.parentTextView.getMeasuredWidth() + this.parentLayoutParams.leftMargin + this.parentLayoutParams.rightMargin;
            this.parentHeight = this.parentTextView.getMeasuredHeight() + this.parentLayoutParams.topMargin + this.parentLayoutParams.bottomMargin;
            this.childLayoutParams = (RelativeLayout.LayoutParams)this.childView.getLayoutParams();
            this.childWidth = this.childView.getMeasuredWidth() + this.childLayoutParams.leftMargin + this.childLayoutParams.rightMargin;
            this.childHeight = this.childView.getMeasuredHeight() + this.childLayoutParams.topMargin + this.childLayoutParams.bottomMargin;
            int n8 = this.parentTextView.getLineCount();
            float f3 = n8 > 0 ? this.parentTextView.getLayout().getLineWidth(n8 - 1) : 0.0f;
            n3 = this.getPaddingLeft() + this.getPaddingRight();
            int n9 = this.getPaddingTop() + this.getPaddingBottom();
            if (n8 > 1 && f3 + (float)this.childWidth < (float)this.parentTextView.getMeasuredWidth()) {
                n3 += this.parentWidth;
                n9 += this.parentHeight;
            } else if (n8 == 1 && this.parentWidth + this.childWidth >= n7) {
                n3 += this.parentTextView.getMeasuredWidth();
                n9 += this.parentHeight + this.childHeight;
            } else if (n8 > 1 && f3 + (float)this.childWidth >= (float)n7) {
                n3 += this.parentWidth;
                n9 += this.parentHeight + this.childHeight;
            } else {
                n3 += this.parentWidth + this.childWidth;
                n9 += this.parentHeight;
            }
            this.setMeasuredDimension(n3, n9);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000));
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (Build.VERSION.SDK_INT >= 17) {
            if (this.parentTextView != null && this.childView != null) {
                this.parentTextView.layout(this.getPaddingStart(), this.getPaddingTop(), this.parentTextView.getWidth() + this.getPaddingStart(), this.parentTextView.getHeight() + this.getPaddingTop());
                this.childView.layout(n3 - n - this.childWidth - this.getPaddingRight(), n4 - n2 - this.getPaddingBottom() - this.childHeight, n3 - n - this.getPaddingRight(), n4 - n2 - this.getPaddingBottom());
            }
        } else if (this.parentTextView != null && this.childView != null) {
            this.parentTextView.layout(this.getPaddingLeft(), this.getPaddingTop(), this.parentTextView.getWidth() + this.getPaddingLeft(), this.parentTextView.getHeight() + this.getPaddingTop());
            this.childView.layout(n3 - n - this.childWidth - this.getPaddingRight(), n4 - n2 - this.getPaddingBottom() - this.childHeight, n3 - n - this.getPaddingRight(), n4 - n2 - this.getPaddingBottom());
        }
    }
}

