/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.recylerviewAnimation;

import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.hippo.agent.recylerviewAnimation.AnimateViewHolder;
import com.hippo.agent.recylerviewAnimation.ViewHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseItemAnimator
extends SimpleItemAnimator {
    private static final boolean DEBUG = false;
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    protected ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    protected ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();
    protected Interpolator mInterpolator = new DecelerateInterpolator();

    public BaseItemAnimator() {
        this.setSupportsChangeAnimations(false);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void runPendingAnimations() {
        View view;
        ArrayList<MoveInfo> arrayList;
        boolean bl;
        boolean bl2 = !this.mPendingRemovals.isEmpty();
        boolean bl3 = !this.mPendingMoves.isEmpty();
        boolean bl4 = !this.mPendingChanges.isEmpty();
        boolean bl5 = bl = !this.mPendingAdditions.isEmpty();
        if (!(bl2 || bl3 || bl || bl4)) {
            return;
        }
        for (RecyclerView.ViewHolder object2 : this.mPendingRemovals) {
            this.doAnimateRemove(object2);
        }
        this.mPendingRemovals.clear();
        if (bl3) {
            arrayList = new ArrayList();
            arrayList.addAll(this.mPendingMoves);
            this.mMovesList.add(arrayList);
            this.mPendingMoves.clear();
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    boolean bl = BaseItemAnimator.this.mMovesList.remove(arrayList);
                    if (!bl) {
                        return;
                    }
                    for (MoveInfo moveInfo : arrayList) {
                        BaseItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    arrayList.clear();
                }
            };
            if (bl2) {
                view = ((MoveInfo)arrayList.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)runnable2, (long)this.getRemoveDuration());
            } else {
                runnable2.run();
            }
        }
        if (bl4) {
            arrayList = new ArrayList<MoveInfo>();
            arrayList.addAll(this.mPendingChanges);
            this.mChangesList.add(arrayList);
            this.mPendingChanges.clear();
            Runnable runnable3 = new Runnable(){

                @Override
                public void run() {
                    boolean bl = BaseItemAnimator.this.mChangesList.remove(arrayList);
                    if (!bl) {
                        return;
                    }
                    for (ChangeInfo changeInfo : arrayList) {
                        BaseItemAnimator.this.animateChangeImpl(changeInfo);
                    }
                    arrayList.clear();
                }
            };
            if (bl2) {
                view = ((ChangeInfo)arrayList.get((int)0)).oldHolder;
                ViewCompat.postOnAnimationDelayed((View)view.itemView, (Runnable)runnable3, (long)this.getRemoveDuration());
            } else {
                runnable3.run();
            }
        }
        if (bl) {
            arrayList = new ArrayList();
            arrayList.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(arrayList);
            this.mPendingAdditions.clear();
            Runnable runnable4 = new Runnable(){

                @Override
                public void run() {
                    boolean bl = BaseItemAnimator.this.mAdditionsList.remove(arrayList);
                    if (!bl) {
                        return;
                    }
                    for (RecyclerView.ViewHolder viewHolder : arrayList) {
                        BaseItemAnimator.this.doAnimateAdd(viewHolder);
                    }
                    arrayList.clear();
                }
            };
            if (bl2 || bl3 || bl4) {
                long l = bl2 ? this.getRemoveDuration() : 0L;
                long l2 = bl3 ? this.getMoveDuration() : 0L;
                long l3 = bl4 ? this.getChangeDuration() : 0L;
                long l4 = l + Math.max(l2, l3);
                View view2 = ((RecyclerView.ViewHolder)arrayList.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view2, (Runnable)runnable4, (long)l4);
            } else {
                runnable4.run();
            }
        }
    }

    protected void preAnimateRemoveImpl(RecyclerView.ViewHolder viewHolder) {
    }

    protected void preAnimateAddImpl(RecyclerView.ViewHolder viewHolder) {
    }

    protected abstract void animateRemoveImpl(RecyclerView.ViewHolder var1);

    protected abstract void animateAddImpl(RecyclerView.ViewHolder var1);

    private void preAnimateRemove(RecyclerView.ViewHolder viewHolder) {
        ViewHelper.clear(viewHolder.itemView);
        if (viewHolder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)viewHolder).preAnimateRemoveImpl(viewHolder);
        } else {
            this.preAnimateRemoveImpl(viewHolder);
        }
    }

    private void preAnimateAdd(RecyclerView.ViewHolder viewHolder) {
        ViewHelper.clear(viewHolder.itemView);
        if (viewHolder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)viewHolder).preAnimateAddImpl(viewHolder);
        } else {
            this.preAnimateAddImpl(viewHolder);
        }
    }

    private void doAnimateRemove(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)viewHolder).animateRemoveImpl(viewHolder, new DefaultRemoveVpaListener(viewHolder));
        } else {
            this.animateRemoveImpl(viewHolder);
        }
        this.mRemoveAnimations.add(viewHolder);
    }

    private void doAnimateAdd(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)viewHolder).animateAddImpl(viewHolder, new DefaultAddVpaListener(viewHolder));
        } else {
            this.animateAddImpl(viewHolder);
        }
        this.mAddAnimations.add(viewHolder);
    }

    public boolean animateRemove(RecyclerView.ViewHolder viewHolder) {
        this.endAnimation(viewHolder);
        this.preAnimateRemove(viewHolder);
        this.mPendingRemovals.add(viewHolder);
        return true;
    }

    protected long getRemoveDelay(RecyclerView.ViewHolder viewHolder) {
        return Math.abs((long)viewHolder.getOldPosition() * this.getRemoveDuration() / 4L);
    }

    public boolean animateAdd(RecyclerView.ViewHolder viewHolder) {
        this.endAnimation(viewHolder);
        this.preAnimateAdd(viewHolder);
        this.mPendingAdditions.add(viewHolder);
        return true;
    }

    protected long getAddDelay(RecyclerView.ViewHolder viewHolder) {
        return Math.abs((long)viewHolder.getAdapterPosition() * this.getAddDuration() / 4L);
    }

    public boolean animateMove(RecyclerView.ViewHolder viewHolder, int n, int n2, int n3, int n4) {
        View view = viewHolder.itemView;
        n = (int)((float)n + ViewCompat.getTranslationX((View)viewHolder.itemView));
        n2 = (int)((float)n2 + ViewCompat.getTranslationY((View)viewHolder.itemView));
        this.endAnimation(viewHolder);
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            this.dispatchMoveFinished(viewHolder);
            return false;
        }
        if (n5 != 0) {
            ViewCompat.setTranslationX((View)view, (float)(-n5));
        }
        if (n6 != 0) {
            ViewCompat.setTranslationY((View)view, (float)(-n6));
        }
        this.mPendingMoves.add(new MoveInfo(viewHolder, n, n2, n3, n4));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder viewHolder, int n, int n2, int n3, int n4) {
        View view = viewHolder.itemView;
        final int n5 = n3 - n;
        final int n6 = n4 - n2;
        if (n5 != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (n6 != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        this.mMoveAnimations.add(viewHolder);
        final ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)view);
        viewPropertyAnimatorCompat.setDuration(this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                BaseItemAnimator.this.dispatchMoveStarting(viewHolder);
            }

            @Override
            public void onAnimationCancel(View view) {
                if (n5 != 0) {
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                }
                if (n6 != 0) {
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                viewPropertyAnimatorCompat.setListener(null);
                BaseItemAnimator.this.dispatchMoveFinished(viewHolder);
                BaseItemAnimator.this.mMoveAnimations.remove(viewHolder);
                BaseItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2, int n, int n2, int n3, int n4) {
        float f2 = ViewCompat.getTranslationX((View)viewHolder.itemView);
        float f3 = ViewCompat.getTranslationY((View)viewHolder.itemView);
        float f4 = ViewCompat.getAlpha((View)viewHolder.itemView);
        this.endAnimation(viewHolder);
        int n5 = (int)((float)(n3 - n) - f2);
        int n6 = (int)((float)(n4 - n2) - f3);
        ViewCompat.setTranslationX((View)viewHolder.itemView, (float)f2);
        ViewCompat.setTranslationY((View)viewHolder.itemView, (float)f3);
        ViewCompat.setAlpha((View)viewHolder.itemView, (float)f4);
        if (viewHolder2 != null && viewHolder2.itemView != null) {
            this.endAnimation(viewHolder2);
            ViewCompat.setTranslationX((View)viewHolder2.itemView, (float)(-n5));
            ViewCompat.setTranslationY((View)viewHolder2.itemView, (float)(-n6));
            ViewCompat.setAlpha((View)viewHolder2.itemView, (float)0.0f);
        }
        this.mPendingChanges.add(new ChangeInfo(viewHolder, viewHolder2, n, n2, n3, n4));
        return true;
    }

    private void animateChangeImpl(final ChangeInfo changeInfo) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat;
        View view;
        RecyclerView.ViewHolder viewHolder = changeInfo.oldHolder;
        View view2 = viewHolder == null ? null : viewHolder.itemView;
        RecyclerView.ViewHolder viewHolder2 = changeInfo.newHolder;
        View view3 = view = viewHolder2 != null ? viewHolder2.itemView : null;
        if (view2 != null) {
            this.mChangeAnimations.add(changeInfo.oldHolder);
            viewPropertyAnimatorCompat = ViewCompat.animate((View)view2).setDuration(this.getChangeDuration());
            viewPropertyAnimatorCompat.translationX((float)(changeInfo.toX - changeInfo.fromX));
            viewPropertyAnimatorCompat.translationY((float)(changeInfo.toY - changeInfo.fromY));
            viewPropertyAnimatorCompat.alpha(0.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                @Override
                public void onAnimationEnd(View view) {
                    viewPropertyAnimatorCompat.setListener(null);
                    ViewCompat.setAlpha((View)view, (float)1.0f);
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (view != null) {
            this.mChangeAnimations.add(changeInfo.newHolder);
            viewPropertyAnimatorCompat = ViewCompat.animate((View)view);
            viewPropertyAnimatorCompat.translationX(0.0f).translationY(0.0f).setDuration(this.getChangeDuration()).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view2) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                @Override
                public void onAnimationEnd(View view2) {
                    viewPropertyAnimatorCompat.setListener(null);
                    ViewCompat.setAlpha((View)view, (float)1.0f);
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    private void endChangeAnimation(List<ChangeInfo> list, RecyclerView.ViewHolder viewHolder) {
        for (int j = list.size() - 1; j >= 0; --j) {
            ChangeInfo changeInfo = list.get(j);
            if (!this.endChangeAnimationIfNecessary(changeInfo, viewHolder) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            list.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder viewHolder) {
        boolean bl = false;
        if (changeInfo.newHolder == viewHolder) {
            changeInfo.newHolder = null;
        } else if (changeInfo.oldHolder == viewHolder) {
            changeInfo.oldHolder = null;
            bl = true;
        } else {
            return false;
        }
        ViewCompat.setAlpha((View)viewHolder.itemView, (float)1.0f);
        ViewCompat.setTranslationX((View)viewHolder.itemView, (float)0.0f);
        ViewCompat.setTranslationY((View)viewHolder.itemView, (float)0.0f);
        this.dispatchChangeFinished(viewHolder, bl);
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder viewHolder) {
        ArrayList<MoveInfo> arrayList;
        int n;
        View view = viewHolder.itemView;
        ViewCompat.animate((View)view).cancel();
        for (n = this.mPendingMoves.size() - 1; n >= 0; --n) {
            arrayList = this.mPendingMoves.get(n);
            if (((MoveInfo)((Object)arrayList)).holder != viewHolder) continue;
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(viewHolder);
            this.mPendingMoves.remove(n);
        }
        this.endChangeAnimation(this.mPendingChanges, viewHolder);
        if (this.mPendingRemovals.remove(viewHolder)) {
            ViewHelper.clear(viewHolder.itemView);
            this.dispatchRemoveFinished(viewHolder);
        }
        if (this.mPendingAdditions.remove(viewHolder)) {
            ViewHelper.clear(viewHolder.itemView);
            this.dispatchAddFinished(viewHolder);
        }
        for (n = this.mChangesList.size() - 1; n >= 0; --n) {
            arrayList = this.mChangesList.get(n);
            this.endChangeAnimation((List<ChangeInfo>)arrayList, viewHolder);
            if (!arrayList.isEmpty()) continue;
            this.mChangesList.remove(n);
        }
        block2: for (n = this.mMovesList.size() - 1; n >= 0; --n) {
            arrayList = this.mMovesList.get(n);
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = arrayList.get(j);
                if (moveInfo.holder != viewHolder) continue;
                ViewCompat.setTranslationY((View)view, (float)0.0f);
                ViewCompat.setTranslationX((View)view, (float)0.0f);
                this.dispatchMoveFinished(viewHolder);
                arrayList.remove(j);
                if (!arrayList.isEmpty()) continue block2;
                this.mMovesList.remove(n);
                continue block2;
            }
        }
        for (n = this.mAdditionsList.size() - 1; n >= 0; --n) {
            arrayList = this.mAdditionsList.get(n);
            if (!arrayList.remove(viewHolder)) continue;
            ViewHelper.clear(viewHolder.itemView);
            this.dispatchAddFinished(viewHolder);
            if (!arrayList.isEmpty()) continue;
            this.mAdditionsList.remove(n);
        }
        if (this.mRemoveAnimations.remove(viewHolder)) {
            // empty if block
        }
        if (this.mAddAnimations.remove(viewHolder)) {
            // empty if block
        }
        if (this.mChangeAnimations.remove(viewHolder)) {
            // empty if block
        }
        if (this.mMoveAnimations.remove(viewHolder)) {
            // empty if block
        }
        this.dispatchFinishedWhenDone();
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        RecyclerView.ViewHolder viewHolder;
        MoveInfo moveInfo;
        int n;
        int n2;
        Object object;
        MoveInfo moveInfo2;
        int n3;
        int n4 = this.mPendingMoves.size();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            moveInfo2 = this.mPendingMoves.get(n3);
            object = moveInfo2.holder.itemView;
            ViewCompat.setTranslationY((View)object, (float)0.0f);
            ViewCompat.setTranslationX((View)object, (float)0.0f);
            this.dispatchMoveFinished(moveInfo2.holder);
            this.mPendingMoves.remove(n3);
        }
        n4 = this.mPendingRemovals.size();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            moveInfo2 = this.mPendingRemovals.get(n3);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)moveInfo2);
            this.mPendingRemovals.remove(n3);
        }
        n4 = this.mPendingAdditions.size();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            moveInfo2 = this.mPendingAdditions.get(n3);
            ViewHelper.clear(((RecyclerView.ViewHolder)moveInfo2).itemView);
            this.dispatchAddFinished((RecyclerView.ViewHolder)moveInfo2);
            this.mPendingAdditions.remove(n3);
        }
        n4 = this.mPendingChanges.size();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(n3));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        n3 = this.mMovesList.size();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            object = this.mMovesList.get(n2);
            n4 = ((ArrayList)object).size();
            for (n = n4 - 1; n >= 0; --n) {
                moveInfo = (MoveInfo)((ArrayList)object).get(n);
                viewHolder = moveInfo.holder;
                View view = viewHolder.itemView;
                ViewCompat.setTranslationY((View)view, (float)0.0f);
                ViewCompat.setTranslationX((View)view, (float)0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                ((ArrayList)object).remove(n);
                if (!((ArrayList)object).isEmpty()) continue;
                this.mMovesList.remove(object);
            }
        }
        n3 = this.mAdditionsList.size();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            object = this.mAdditionsList.get(n2);
            n4 = ((ArrayList)object).size();
            for (n = n4 - 1; n >= 0; --n) {
                moveInfo = (RecyclerView.ViewHolder)((ArrayList)object).get(n);
                viewHolder = ((RecyclerView.ViewHolder)moveInfo).itemView;
                ViewCompat.setAlpha((View)viewHolder, (float)1.0f);
                this.dispatchAddFinished((RecyclerView.ViewHolder)moveInfo);
                if (n < ((ArrayList)object).size()) {
                    ((ArrayList)object).remove(n);
                }
                if (!((ArrayList)object).isEmpty()) continue;
                this.mAdditionsList.remove(object);
            }
        }
        n3 = this.mChangesList.size();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            object = this.mChangesList.get(n2);
            n4 = ((ArrayList)object).size();
            for (n = n4 - 1; n >= 0; --n) {
                this.endChangeAnimationIfNecessary((ChangeInfo)((ArrayList)object).get(n));
                if (!((ArrayList)object).isEmpty()) continue;
                this.mChangesList.remove(object);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    void cancelAll(List<RecyclerView.ViewHolder> list) {
        for (int j = list.size() - 1; j >= 0; --j) {
            ViewCompat.animate((View)list.get((int)j).itemView).cancel();
        }
    }

    protected class DefaultRemoveVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultRemoveVpaListener(RecyclerView.ViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @Override
        public void onAnimationStart(View view) {
            BaseItemAnimator.this.dispatchRemoveStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            ViewHelper.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            ViewHelper.clear(view);
            BaseItemAnimator.this.dispatchRemoveFinished(this.mViewHolder);
            BaseItemAnimator.this.mRemoveAnimations.remove(this.mViewHolder);
            BaseItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    protected class DefaultAddVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultAddVpaListener(RecyclerView.ViewHolder viewHolder) {
            this.mViewHolder = viewHolder;
        }

        @Override
        public void onAnimationStart(View view) {
            BaseItemAnimator.this.dispatchAddStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            ViewHelper.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            ViewHelper.clear(view);
            BaseItemAnimator.this.dispatchAddFinished(this.mViewHolder);
            BaseItemAnimator.this.mAddAnimations.remove(this.mViewHolder);
            BaseItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    private static class VpaListenerAdapter
    implements ViewPropertyAnimatorListener {
        private VpaListenerAdapter() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    private static class ChangeInfo {
        public RecyclerView.ViewHolder oldHolder;
        public RecyclerView.ViewHolder newHolder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private ChangeInfo(RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2) {
            this.oldHolder = viewHolder;
            this.newHolder = viewHolder2;
        }

        private ChangeInfo(RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2, int n, int n2, int n3, int n4) {
            this(viewHolder, viewHolder2);
            this.fromX = n;
            this.fromY = n2;
            this.toX = n3;
            this.toY = n4;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MoveInfo(RecyclerView.ViewHolder viewHolder, int n, int n2, int n3, int n4) {
            this.holder = viewHolder;
            this.fromX = n;
            this.fromY = n2;
            this.toX = n3;
            this.toY = n4;
        }
    }
}

