/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.NotificationType;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.adapter.ChatListAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.helper.ConversationListHelper;
import com.hippo.agent.listeners.AgentServerListener;
import com.hippo.agent.listeners.ConversationListerner;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.agent.model.getConversationResponse.CustomerUniqueKey;
import com.hippo.agent.recylerviewAnimation.FadeInLeftAnimator;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.HippoLog;
import com.hippo.utils.Utils;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.json.JSONObject;

public class MyChatFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
ChatListAdapter.Callback,
AgentServerListener,
OnUserChannelListener {
    private static final String TAG = MyChatFragment.class.getSimpleName();
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView listView;
    private ChatListAdapter chatListAdapter;
    private LinearLayout llNoConversation;
    private WrapContentLinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private ConversationListerner listerner;
    private ChatListAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> conversationChatList = new ArrayList();
    private TextView title_error;
    private TextView detail_error;
    private boolean isPagingApiInProgress;
    private boolean isLastItemReached;
    private Snackbar snackbar;
    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};
    private int[] labelsIntArray = new int[0];
    private UserData userData;
    private int fragmentType = FragmentType.MY_CHAT.getOrdinal();
    private String userUniqueId;
    RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int n) {
            super.onScrollStateChanged(recyclerView, n);
            HippoLog.v("scroll state ", "changed");
        }

        public void onScrolled(RecyclerView recyclerView, int n, int n2) {
            if (n2 > 0) {
                if (!MyChatFragment.this.isNetworkAvailable()) {
                    return;
                }
                MyChatFragment.this.visibleItemCount = MyChatFragment.this.layoutManager.getChildCount();
                MyChatFragment.this.totalItemCount = MyChatFragment.this.layoutManager.getItemCount();
                MyChatFragment.this.pastVisiblesItems = MyChatFragment.this.layoutManager.findFirstVisibleItemPosition();
                if (!MyChatFragment.this.isPagingApiInProgress && !MyChatFragment.this.isLastItemReached && MyChatFragment.this.visibleItemCount + MyChatFragment.this.pastVisiblesItems >= MyChatFragment.this.totalItemCount && MyChatFragment.this.conversationChatList != null && MyChatFragment.this.conversationChatList.size() > 1) {
                    int n3 = MyChatFragment.this.conversationChatList.size() + 1;
                    MyChatFragment.this.toggleProgressBarVisibility(true);
                    MyChatFragment.this.getConversationData(n3, false);
                }
            } else if (MyChatFragment.this.getSnackbar() != null && MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 1) {
                MyChatFragment.this.getSnackbar().dismiss();
            }
        }
    };
    private int newMessageCount = 0;
    public boolean notifiacrionClicked;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (this.getArguments() != null) {
            this.fragmentType = this.getArguments().getInt("fragment_type", FragmentType.MY_CHAT.getOrdinal());
            this.userUniqueId = this.getArguments().getString("user_unique_key");
            GetConversationResponse getConversationResponse = (GetConversationResponse)new Gson().fromJson(this.getArguments().getString("conversation"), GetConversationResponse.class);
            this.conversationChatList = new ArrayList();
            this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_list_fragment, viewGroup, false);
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.listView = (RecyclerView)view.findViewById(R.id.list_view);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.swipeRefreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.swipeRefreshLayout.setSize(1);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.title_error = (TextView)view.findViewById(R.id.title_error);
        this.detail_error = (TextView)view.findViewById(R.id.detail_error);
        this.layoutManager = new WrapContentLinearLayoutManager((Context)this.getActivity(), 1, false);
        this.listView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.listView.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.listView.getItemAnimator().setAddDuration(500L);
        this.listView.getItemAnimator().setRemoveDuration(500L);
        this.listView.setHasFixedSize(false);
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        if (this.userData != null && !TextUtils.isEmpty((CharSequence)this.userData.getAccessToken())) {
            this.chatListAdapter = new ChatListAdapter(this.userData.getUserId(), true, this.fragmentType, this.conversationChatList, this, this.listView);
            this.listView.setAdapter((RecyclerView.Adapter)this.chatListAdapter);
            this.listView.addOnScrollListener(this.onScrollListener);
            this.listerner = new ConversationListHelper();
            if (this.fragmentType == FragmentType.MY_CHAT.getOrdinal()) {
                this.listerner.getOfflineData(this.fragmentType);
            }
        } else {
            this.llNoConversation.setVisibility(0);
            this.title_error.setVisibility(8);
            this.detail_error.setText((CharSequence)"Something went wrong. Please try again");
        }
    }

    private void setConnectionManager(boolean bl) {
        this.isLastItemReached = false;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, bl);
    }

    private void getConversationData(int n, boolean bl) {
        this.getConversationData(n, bl, -1);
    }

    private void getConversationData(int n, boolean bl, int n2) {
        this.getConversationData(n, bl, n2, false);
    }

    private void getConversationData(int n, boolean bl, int n2, boolean bl2) {
        Object object;
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String string2 = String.valueOf(this.userData.getEnUserId());
        String string3 = this.userData.getAccessToken();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("en_user_id", string2);
        hashMap.put("access_token", string3);
        hashMap.put("status", "[1]");
        hashMap.put("device_type", 1);
        hashMap.put("type", Arrays.toString(this.typeIntArray));
        if (n != 0) {
            hashMap.put("page_start", String.valueOf(n));
        }
        if (n2 > 0) {
            hashMap.put("page_end", String.valueOf(n2));
        }
        if (this.fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
            object = new ArrayList<String>();
            ((ArrayList)object).add(this.userUniqueId);
            hashMap.put("search_user_unique_key", new Gson().toJson(object));
        }
        object = new CommonParams.Builder().addAll(hashMap).build();
        this.getConversationList(((CommonParams)object).getMap(), n > 0, bl, bl2, n2);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        HippoConfig.getInstance().addUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().addUIListener(OnUserChannelListener.class, this);
    }

    public void onDetach() {
        super.onDetach();
        HippoConfig.getInstance().removeUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().removeUIListener(OnUserChannelListener.class, this);
        if (this.fragmentType == FragmentType.MY_CHAT.getOrdinal()) {
            AgentCommonData.setAgentConversationList(this.fragmentType, this.conversationChatList);
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onHiddenChanged(boolean bl) {
        super.onHiddenChanged(bl);
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onPause() {
        super.onPause();
    }

    public boolean isPagingApiInProgress() {
        return this.isPagingApiInProgress;
    }

    public void setPagingApiInProgress(boolean bl) {
        this.isPagingApiInProgress = bl;
    }

    public Snackbar getSnackbar() {
        return this.snackbar;
    }

    public void newConversationSnackBar() {
        ++this.newMessageCount;
        String string2 = this.newMessageCount > 1 ? this.newMessageCount + " new Chats" : this.newMessageCount + " new Chat";
        this.snackbar = Snackbar.make((View)this.getActivity().getWindow().getDecorView().findViewById(0x1020002), (CharSequence)string2, (int)0).setAction((CharSequence)this.getResources().getString(R.string.fugu_tap_to_view), new View.OnClickListener(){

            public void onClick(View view) {
                MyChatFragment.this.newMessageCount = 0;
                MyChatFragment.this.listView.smoothScrollToPosition(0);
            }
        });
        this.snackbar.setActionTextColor(-1);
        View view = this.snackbar.getView();
        view.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170453));
        TextView textView = (TextView)view.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        Button button = (Button)view.findViewById(R.id.snackbar_action);
        this.snackbar.setDuration(-2);
        this.snackbar.show();
    }

    private void getConversationList(HashMap<String, Object> hashMap, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.listerner != null) {
            if (bl2) {
                LoadingBox.showOn((Activity)this.getActivity());
            }
            try {
                if (!(this.conversationChatList == null || this.conversationChatList.size() <= 0 || bl || bl2 || bl3)) {
                    ((AgentListActivity)this.getActivity()).allChatFlag = true;
                    ((AgentListActivity)this.getActivity()).setConnectionMessage(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isPagingApiInProgress = true;
            this.listerner.getAgentConversation(hashMap, bl, this.fragmentType, n);
        }
    }

    private void getConversationResponse(GetConversationResponse getConversationResponse, boolean bl, int n, int n2) {
        if (this.fragmentType != n) {
            return;
        }
        try {
            HippoLog.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
            if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                this.setConversationChatData((ArrayList)getConversationResponse.getData().getConversation(), bl, n2);
                this.toggleProgressBarVisibility(false);
                this.setPagingApiInProgress(false);
                if (getConversationResponse.getData().getConversation().size() == 0) {
                    this.isLastItemReached = true;
                }
            }
            if (this.getActivity() != null) {
                ((AgentListActivity)this.getActivity()).hideLoader(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LoadingBox.hide();
        this.swipeRefreshLayout.setRefreshing(false);
    }

    public void setConversationChatData(ArrayList<Conversation> arrayList, boolean bl) {
        this.setConversationChatData(arrayList, bl, -1);
    }

    public void setConversationChatData(ArrayList<Conversation> arrayList, final boolean bl, final int n) {
        if (!bl) {
            this.conversationChatList.clear();
        }
        this.conversationChatList.addAll(arrayList);
        if (this.getView() != null && this.chatListAdapter != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    if (!bl && n < 1) {
                        MyChatFragment.this.listView.scrollToPosition(0);
                    }
                }
            });
        } else if (this.conversationChatList == null || this.conversationChatList.size() == 0) {
            this.setLlNoConversation(null);
        }
        this.addUnreadCount(arrayList);
    }

    private void setLlNoConversation(final String string2) {
        if (this.llNoConversation != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (string2 != null) {
                        if (MyChatFragment.this.conversationChatList == null || MyChatFragment.this.conversationChatList.size() == 0) {
                            MyChatFragment.this.llNoConversation.setVisibility(0);
                            MyChatFragment.this.swipeRefreshLayout.setVisibility(8);
                        } else {
                            MyChatFragment.this.llNoConversation.setVisibility(8);
                        }
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            MyChatFragment.this.detail_error.setText((CharSequence)string2);
                        }
                    } else if (MyChatFragment.this.conversationChatList == null || MyChatFragment.this.conversationChatList.size() == 0) {
                        MyChatFragment.this.llNoConversation.setVisibility(0);
                    } else {
                        MyChatFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    public void toggleProgressBarVisibility(boolean bl) {
        if (bl) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ChatListAdapter.ProgressBarItem();
            }
            if (!this.conversationChatList.contains(this.progressBarItem)) {
                this.conversationChatList.add(this.progressBarItem);
                this.listView.post(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyItemInserted(MyChatFragment.this.conversationChatList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationChatList.contains(this.progressBarItem)) {
            this.conversationChatList.remove(this.progressBarItem);
            this.chatListAdapter.notifyItemRemoved(this.conversationChatList.size() - 1);
        }
    }

    public void onRefresh() {
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, -1, true);
    }

    @Override
    public void onClick(int n, int n2, Conversation conversation) {
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        this.chatListAdapter.notifyDataSetChanged();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (conversation.getCustomerUniqueKeys() != null) {
                for (CustomerUniqueKey customerUniqueKey : conversation.getCustomerUniqueKeys()) {
                    arrayList.add(customerUniqueKey.getUserUniqueKey());
                }
                this.setConversationChatCount(conversation.getChannelId().intValue(), arrayList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        conversation.setUnreadCount(0);
        Intent intent = new Intent((Context)this.getActivity(), AgentChatActivity.class);
        intent.putExtra("fragment_type", n2);
        intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
        this.startActivityForResult(intent, 100);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        HippoLog.v("onActivityResult", "enter");
        if (n == 100) {
            if (n2 == MessageMode.OPEN_CHAT.getOrdinal()) {
                int n3 = Integer.parseInt(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(n3, MessageMode.OPEN_CHAT.getOrdinal(), n2);
            } else if (n2 == MessageMode.CLOSED_CHAT.getOrdinal()) {
                int n4 = Integer.parseInt(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(n4, MessageMode.CLOSED_CHAT.getOrdinal(), n2);
            } else if (n2 == Overlay.ASSIGNMENT.getOrdinal()) {
                int n5 = Integer.parseInt(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(n5, MessageMode.OPEN_CHAT.getOrdinal(), n2);
            }
        }
    }

    private void setOverlayTransition(int n, int n2, int n3) {
        boolean bl = false;
        Conversation conversation = null;
        for (int j = 0; j < this.conversationChatList.size(); ++j) {
            Conversation conversation2;
            if (!(this.conversationChatList.get(j) instanceof Conversation)) continue;
            conversation = conversation2 = (Conversation)this.conversationChatList.get(j);
            if (!conversation2.getChannelId().equals(n)) continue;
            bl = true;
            if (n3 != Overlay.ASSIGNMENT.getOrdinal()) {
                conversation2.setStatus(n2);
            }
            conversation2.setOverlay(n3);
            break;
        }
        if (bl) {
            this.chatListAdapter.notifyDataSetChanged();
            this.removeConversation(n);
            if (n3 != Overlay.ASSIGNMENT.getOrdinal()) {
                this.removeOverlay(conversation);
            } else {
                this.removeConversation(n);
            }
        }
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    public void removeConversation(final int n) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (int j = 0; j < MyChatFragment.this.conversationChatList.size(); ++j) {
                            if (!(MyChatFragment.this.conversationChatList.get(j) instanceof Conversation) || (long)n != ((Conversation)MyChatFragment.this.conversationChatList.get(j)).getChannelId()) continue;
                            MyChatFragment.this.conversationChatList.remove(j);
                            MyChatFragment.this.chatListAdapter.notifyItemRemoved(j);
                            HashMap<Integer, Integer> hashMap = AgentCommonData.removeTotalUnreadCount(n);
                            MyChatFragment.this.sendUnreadCount(hashMap);
                            break;
                        }
                    }
                });
            }
        }, 1000L);
    }

    public void setConversationChatCount(Integer n, ArrayList<String> arrayList) {
        try {
            for (Object object : this.conversationChatList) {
                if (!(object instanceof Conversation) || !((Conversation)object).getChannelId().equals(n)) continue;
                int n2 = ((Conversation)object).getUnreadCount();
                for (UnreadListener unreadListener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
                    if (unreadListener == null) continue;
                    unreadListener.updateOpenChannelCount(arrayList, n2);
                }
                ((Conversation)object).setUnreadCount(0);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void conversationList(GetConversationResponse getConversationResponse, boolean bl, int n, int n2) {
        this.getConversationResponse(getConversationResponse, bl, n, n2);
    }

    @Override
    public void onError(APIError aPIError, int n) {
        if (this.fragmentType != n) {
            return;
        }
        this.setLlNoConversation(aPIError.getMessage() == null ? "" : aPIError.getMessage());
    }

    @Override
    public void offlineConversationList(int n, ArrayList<Object> arrayList) {
        boolean bl = true;
        if (n == FragmentType.MY_CHAT.getOrdinal()) {
            if (arrayList != null && arrayList.size() > 0) {
                this.conversationChatList.addAll(arrayList);
                this.chatListAdapter.notifyDataSetChanged();
                bl = false;
            }
            this.setConnectionManager(bl);
        }
    }

    @Override
    public void onAssignChat(JSONObject jSONObject) {
        int n = -1;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        try {
            if (jSONObject.optInt("assigned_to") != this.userData.getUserId().intValue()) {
                for (int j = 0; j < this.conversationChatList.size(); ++j) {
                    Conversation conversation;
                    if (!(this.conversationChatList.get(j) instanceof Conversation) || (conversation = (Conversation)this.conversationChatList.get(j)).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
                    n = j;
                    break;
                }
                this.conversationChatList.remove(n);
                this.remove(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onControlChannelData(JSONObject jSONObject) {
        this.setControlChannelData(jSONObject);
    }

    @Override
    public void onRefreshData() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, this.conversationChatList.size());
    }

    @Override
    public void onReadAll(JSONObject jSONObject) {
        if (jSONObject != null) {
            if (this.userData == null) {
                this.userData = AgentCommonData.getUserData();
            }
            if (jSONObject.optInt("user_id", 0) == this.userData.getUserId().intValue()) {
                for (Object object : this.conversationChatList) {
                    Conversation conversation;
                    if (!(object instanceof Conversation) || (conversation = (Conversation)object).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
                    if (this.fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
                        HashMap<Integer, Integer> hashMap = AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                        this.sendUnreadCount(hashMap);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            if (conversation.getCustomerUniqueKeys() != null) {
                                for (CustomerUniqueKey customerUniqueKey : conversation.getCustomerUniqueKeys()) {
                                    arrayList.add(customerUniqueKey.getUserUniqueKey());
                                }
                                this.setConversationChatCount(conversation.getChannelId().intValue(), arrayList);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    conversation.setUnreadCount(0);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void updateCount(Long l) {
        try {
            for (Object object : this.conversationChatList) {
                Conversation conversation;
                if (!(object instanceof Conversation) || (conversation = (Conversation)object).getChannelId().compareTo(l) != 0) continue;
                conversation.setUnreadCount(0);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    }
                });
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setControlChannelData(JSONObject jSONObject) {
        try {
            ArrayList<Conversation> arrayList;
            boolean bl = true;
            for (Object iterator : this.conversationChatList) {
                Object object;
                if (!(iterator instanceof Conversation) || ((Conversation)(object = (Conversation)iterator)).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
                bl = false;
                ((Conversation)object).setMessage(jSONObject.optString("message", ""));
                ((Conversation)object).setAgentId(jSONObject.optInt("agent_id", 0));
                ((Conversation)object).setLast_sent_by_id(jSONObject.optInt("last_sent_by_id"));
                ((Conversation)object).setLast_sent_by_full_name(jSONObject.optString("last_sent_by_full_name"));
                ((Conversation)object).setLast_sent_by_user_type(jSONObject.getInt("last_sent_by_user_type"));
                ((Conversation)object).setLastUpdatedAt(jSONObject.optString("date_time", ""));
                if (jSONObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue() && jSONObject.optInt("is_my_chat", 0) == 1 && (long)jSONObject.optInt("channel_id", -1) != AgentChatActivity.pushChannelId) {
                    ((Conversation)object).setUnreadCount(((Conversation)object).getUnreadCount() + 1);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                }
                if (this.userData == null) {
                    this.userData = AgentCommonData.getUserData();
                }
                if (jSONObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue()) break;
                ((Conversation)object).setUnreadCount(0);
                break;
            }
            if (bl && this.fragmentType == FragmentType.USER_CHAT.getOrdinal() && AgentCommonData.getUnreadCount(this.userUniqueId).getHippoUserId() != jSONObject.optInt("user_id")) {
                return;
            }
            if (jSONObject.optInt("is_my_chat", 0) == 0) {
                return;
            }
            if (bl) {
                HippoLog.v("New chat arrived", "send to unasssigned");
                arrayList = new Conversation();
                ((Conversation)((Object)arrayList)).setChannelId(jSONObject.optLong("channel_id"));
                ((Conversation)((Object)arrayList)).setChannelName(jSONObject.optString("channel_name", ""));
                ((Conversation)((Object)arrayList)).setUserId(jSONObject.optInt("user_id"));
                ((Conversation)((Object)arrayList)).setLastUpdatedAt(jSONObject.optString("date_time", ""));
                ((Conversation)((Object)arrayList)).setMessage(jSONObject.optString("message", ""));
                ((Conversation)((Object)arrayList)).setLabel(jSONObject.optString("label", ""));
                ((Conversation)((Object)arrayList)).setStatus(jSONObject.optInt("status", 1));
                ((Conversation)((Object)arrayList)).setBotChannelName(jSONObject.optString("bot_channel_name", ""));
                if (jSONObject.optInt("is_my_chat", 0) == 1) {
                    ((Conversation)((Object)arrayList)).setUnreadCount(jSONObject.optInt("unread_count", 1));
                } else {
                    ((Conversation)((Object)arrayList)).setUnreadCount(jSONObject.optInt("unread_count", 0));
                }
                ((Conversation)((Object)arrayList)).setAgentId(jSONObject.optInt("agent_id", 0));
                ((Conversation)((Object)arrayList)).setOverlay(Overlay.DEFAULT.getOrdinal());
                this.conversationChatList.add(0, arrayList);
                this.setLlNoConversation(null);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyItemInserted(0);
                        if (MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 0) {
                            MyChatFragment.this.listView.scrollToPosition(0);
                        } else if (MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() > 0) {
                            MyChatFragment.this.newConversationSnackBar();
                        }
                    }
                });
            } else if (jSONObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()) {
                this.setOverlayTransition(jSONObject.getInt("channel_id"), MessageMode.OPEN_CHAT.getOrdinal(), Overlay.ASSIGNMENT.getOrdinal());
            } else {
                arrayList = new ArrayList<Conversation>();
                for (Object object : this.conversationChatList) {
                    if (!(object instanceof Conversation)) continue;
                    Conversation conversation = (Conversation)object;
                    arrayList.add(conversation);
                }
                Collections.sort(arrayList, new Comparator<Conversation>(){

                    @Override
                    public int compare(Conversation conversation, Conversation conversation2) {
                        if (conversation.getLastUpdatedAt() == null || conversation2.getLastUpdatedAt() == null) {
                            return 0;
                        }
                        return conversation2.getLastUpdatedAt().compareTo(conversation.getLastUpdatedAt());
                    }
                });
                this.setConversationChatData(arrayList, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void remove(final int n) {
        Conversation conversation = (Conversation)this.conversationChatList.get(n);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.chatListAdapter.notifyItemChanged(n);
            }
        });
        this.removeConversation(conversation.getChannelId().intValue());
    }

    private void addUnreadCount(ArrayList<Conversation> arrayList) {
        HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
        for (Conversation conversation : arrayList) {
            hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
        }
        AgentCommonData.addTotalUnreadCount(hashMap);
        this.sendUnreadCount(null);
    }

    private void sendUnreadCount(HashMap<Integer, Integer> hashMap) {
        if (hashMap == null) {
            hashMap = AgentCommonData.getTotalUnreadCount();
        }
        int n = 0;
        for (Integer n2 : hashMap.values()) {
            n += n2.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(n);
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

