/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.adapter.BroadcastStatusAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.fragment.BroadcastDetailsFragment;
import com.hippo.agent.helper.BroadcastListenerHelper;
import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.loadingBox.LoadingBox;
import java.io.Serializable;
import java.util.ArrayList;

public class BroadcastStatusFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
BroadcastListener.BroadcastResponse,
OnItemClickListener {
    private static final String TAG = BroadcastStatusFragment.class.getSimpleName();
    private BroadcastStatusAdapter statusAdapter;
    private BroadcastListener broadcastListener;
    private UserData userData;
    private ArrayList<BroadCastObjectModel> broadcastInfos = new ArrayList();
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView listView;
    private LinearLayout llNoConversation;
    private AgentBroadcastActivity activity;
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private int offset = 0;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_list_fragment, viewGroup, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.activity = (AgentBroadcastActivity)this.getActivity();
        this.activity.updateToolBar("Broadcast History");
        this.broadcastListener = new BroadcastListenerHelper();
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.refreshLayout.setEnabled(false);
        this.listView = (RecyclerView)view.findViewById(R.id.list_view);
        this.statusAdapter = new BroadcastStatusAdapter(this.listView, this);
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.layoutManager.setOrientation(1);
        this.listView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.listView.setAdapter((RecyclerView.Adapter)this.statusAdapter);
        this.getBroadcastStatus(this.offset);
        this.listView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                super.onScrolled(recyclerView, n, n2);
                if (n2 > 0) {
                    BroadcastStatusFragment.this.visibleItemCount = BroadcastStatusFragment.this.layoutManager.getChildCount();
                    BroadcastStatusFragment.this.totalItemCount = BroadcastStatusFragment.this.layoutManager.getItemCount();
                    BroadcastStatusFragment.this.pastVisiblesItems = BroadcastStatusFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (!BroadcastStatusFragment.this.isPagingApiInProgress && BroadcastStatusFragment.this.hasMorePages && BroadcastStatusFragment.this.visibleItemCount + BroadcastStatusFragment.this.pastVisiblesItems >= BroadcastStatusFragment.this.totalItemCount) {
                        BroadcastStatusFragment.this.getBroadcastStatus(BroadcastStatusFragment.this.broadcastInfos.size());
                    }
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.broadcastListener = null;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onRefresh() {
        this.getBroadcastStatus(0);
    }

    public void onHiddenChanged(boolean bl) {
        super.onHiddenChanged(bl);
        if (!bl) {
            this.activity.updateToolBar("Broadcast History");
        }
    }

    private void getBroadcastStatus(int n) {
        this.offset = n;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String string2 = this.userData.getAccessToken();
        if (n != 0) {
            this.isPagingApiInProgress = true;
            this.statusAdapter.showPaginationProgressBar(true, true);
        } else {
            LoadingBox.showOn((Activity)this.getActivity());
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", string2).add("page_offset", n).build();
        this.broadcastListener.getBroadcastList(commonParams.getMap(), this);
    }

    @Override
    public void groupingResponse(BroadcastModel broadcastModel) {
    }

    @Override
    public void sendBroadcastResponse(BroadcastResponseModel broadcastResponseModel) {
    }

    @Override
    public void broadcastListResponse(BroadcastResponseModel broadcastResponseModel) {
        LoadingBox.hide();
        if (this.offset != 0) {
            this.isPagingApiInProgress = false;
            this.statusAdapter.showPaginationProgressBar(false, true);
        } else if (broadcastResponseModel.getData() == null || broadcastResponseModel.getData().getBroadcastedChannels() == null || broadcastResponseModel.getData().getBroadcastedChannels().size() == 0) {
            this.llNoConversation.setVisibility(0);
        } else {
            this.llNoConversation.setVisibility(8);
        }
        if (this.broadcastInfos == null) {
            this.broadcastInfos = new ArrayList();
        }
        if (this.offset == 0) {
            this.broadcastInfos.clear();
        }
        this.broadcastInfos.addAll(broadcastResponseModel.getData().getBroadcastedChannels());
        this.statusAdapter.setData(this.broadcastInfos);
        this.hasMorePages = broadcastResponseModel.getData().getBroadcastedChannels().size() == broadcastResponseModel.getData().getPageSize().intValue();
    }

    @Override
    public void broadcastStatusResponse(BroadcastResponseModel broadcastResponseModel) {
    }

    @Override
    public void onFailure(int n, String string2) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)string2, (int)0).show();
        LoadingBox.hide();
        switch (n) {
            case 1: {
                break;
            }
        }
    }

    @Override
    public void onClickItem(int n) {
        try {
            BroadcastDetailsFragment broadcastDetailsFragment = new BroadcastDetailsFragment();
            Bundle bundle = new Bundle();
            BroadCastObjectModel broadCastObjectModel = this.broadcastInfos.get(n);
            bundle.putSerializable("objectModel", (Serializable)broadCastObjectModel);
            broadcastDetailsFragment.setArguments(bundle);
            this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)broadcastDetailsFragment, BroadcastDetailsFragment.class.getName()).addToBackStack(BroadcastDetailsFragment.class.getName()).hide(this.getActivity().getSupportFragmentManager().findFragmentByTag(this.getActivity().getSupportFragmentManager().getBackStackEntryAt(this.getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName())).commitAllowingStateLoss();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

