/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.NotificationType;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.adapter.ChatListAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.helper.ConversationListHelper;
import com.hippo.agent.listeners.AgentServerListener;
import com.hippo.agent.listeners.ConversationListerner;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.agent.recylerviewAnimation.FadeInLeftAnimator;
import com.hippo.retrofit.APIError;
import com.hippo.utils.HippoLog;
import com.hippo.utils.Utils;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.json.JSONObject;

public class AllChatFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
ChatListAdapter.Callback,
AgentServerListener,
OnUserChannelListener {
    private static final String TAG = AllChatFragment.class.getSimpleName();
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView listView;
    private ChatListAdapter chatListAdapter;
    private LinearLayout llNoConversation;
    private WrapContentLinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private ConversationListerner listerner;
    private ChatListAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> conversationChatList = new ArrayList();
    private TextView title_error;
    private TextView detail_error;
    private boolean isPagingApiInProgress;
    private boolean isLastItemReached;
    private Snackbar snackbar;
    private int newMessageCount = 0;
    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.ALL.getOrdinal()};
    private int[] labelsIntArray = new int[0];
    private UserData userData;
    RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int n) {
            super.onScrollStateChanged(recyclerView, n);
            HippoLog.v("scroll state ", "changed");
        }

        public void onScrolled(RecyclerView recyclerView, int n, int n2) {
            if (n2 > 0) {
                if (!AllChatFragment.this.isNetworkAvailable()) {
                    return;
                }
                AllChatFragment.this.visibleItemCount = AllChatFragment.this.layoutManager.getChildCount();
                AllChatFragment.this.totalItemCount = AllChatFragment.this.layoutManager.getItemCount();
                AllChatFragment.this.pastVisiblesItems = AllChatFragment.this.layoutManager.findFirstVisibleItemPosition();
                if (!AllChatFragment.this.isPagingApiInProgress && !AllChatFragment.this.isLastItemReached && AllChatFragment.this.visibleItemCount + AllChatFragment.this.pastVisiblesItems >= AllChatFragment.this.totalItemCount) {
                    int n3 = AllChatFragment.this.conversationChatList.size() + 1;
                    AllChatFragment.this.toggleProgressBarVisibility(true);
                    AllChatFragment.this.getConversationData(n3, false);
                }
            } else if (AllChatFragment.this.getSnackbar() != null && AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 1) {
                AllChatFragment.this.getSnackbar().dismiss();
            }
        }
    };
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.hippo_list_fragment, viewGroup, false);
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.listView = (RecyclerView)view.findViewById(R.id.list_view);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.swipeRefreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.swipeRefreshLayout.setSize(1);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.title_error = (TextView)view.findViewById(R.id.title_error);
        this.detail_error = (TextView)view.findViewById(R.id.detail_error);
        this.layoutManager = new WrapContentLinearLayoutManager((Context)this.getActivity(), 1, false);
        this.listView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.listView.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.listView.getItemAnimator().setAddDuration(500L);
        this.listView.getItemAnimator().setRemoveDuration(500L);
        this.listView.setHasFixedSize(false);
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        if (this.userData != null && !TextUtils.isEmpty((CharSequence)this.userData.getAccessToken())) {
            this.chatListAdapter = new ChatListAdapter(this.userData.getUserId(), true, FragmentType.ALL_CHAT.getOrdinal(), this.conversationChatList, this, this.listView);
            this.listView.setAdapter((RecyclerView.Adapter)this.chatListAdapter);
            this.listView.addOnScrollListener(this.onScrollListener);
            this.listerner = new ConversationListHelper();
            this.listerner.getOfflineData(FragmentType.ALL_CHAT.getOrdinal());
        } else {
            this.llNoConversation.setVisibility(0);
            this.title_error.setVisibility(8);
            this.detail_error.setText((CharSequence)"Something went wrong. Please try again");
        }
    }

    private void setConnectionManager(boolean bl) {
        this.isLastItemReached = false;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, bl);
    }

    private void getConversationData(int n, boolean bl) {
        this.getConversationData(n, bl, -1, false);
    }

    private void getConversationData(int n, boolean bl, int n2, boolean bl2) {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String string2 = String.valueOf(this.userData.getEnUserId());
        String string3 = this.userData.getAccessToken();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("en_user_id", string2);
        hashMap.put("access_token", string3);
        hashMap.put("status", "[1]");
        hashMap.put("device_type", 1);
        hashMap.put("type", Arrays.toString(this.typeIntArray));
        if (n != 0) {
            hashMap.put("page_start", String.valueOf(n));
        }
        if (n2 > 0) {
            hashMap.put("page_end", String.valueOf(n2));
        }
        this.getConversationList(hashMap, n > 0, bl, bl2, n2);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        HippoConfig.getInstance().addUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().addUIListener(OnUserChannelListener.class, this);
    }

    public void onDetach() {
        super.onDetach();
        HippoConfig.getInstance().removeUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().removeUIListener(OnUserChannelListener.class, this);
        AgentCommonData.setAgentConversationList(FragmentType.ALL_CHAT.getOrdinal(), this.conversationChatList);
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onHiddenChanged(boolean bl) {
        super.onHiddenChanged(bl);
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onPause() {
        super.onPause();
    }

    private Snackbar getSnackbar() {
        return this.snackbar;
    }

    private void newConversationSnackBar() {
        ++this.newMessageCount;
        String string2 = this.newMessageCount > 1 ? this.newMessageCount + " new Chats" : this.newMessageCount + " new Chat";
        this.snackbar = Snackbar.make((View)this.getActivity().getWindow().getDecorView().findViewById(0x1020002), (CharSequence)string2, (int)0).setAction((CharSequence)this.getResources().getString(R.string.fugu_tap_to_view), new View.OnClickListener(){

            public void onClick(View view) {
                AllChatFragment.this.newMessageCount = 0;
                AllChatFragment.this.listView.smoothScrollToPosition(0);
            }
        });
        this.snackbar.setActionTextColor(-1);
        View view = this.snackbar.getView();
        view.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170453));
        TextView textView = (TextView)view.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        Button button = (Button)view.findViewById(R.id.snackbar_action);
        this.snackbar.setDuration(-2);
        this.snackbar.show();
    }

    private void getConversationList(HashMap<String, Object> hashMap, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.listerner != null && !this.isPagingApiInProgress) {
            if (bl2) {
                LoadingBox.showOn((Activity)this.getActivity());
            }
            try {
                if (!(this.conversationChatList == null || this.conversationChatList.size() <= 0 || bl || bl2 || bl3 || this.getActivity() == null)) {
                    ((AgentListActivity)this.getActivity()).allChatFlag = true;
                    ((AgentListActivity)this.getActivity()).setConnectionMessage(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isPagingApiInProgress = true;
            this.listerner.getAgentConversation(hashMap, bl, FragmentType.ALL_CHAT.getOrdinal(), n);
        }
    }

    private void getConversationResponse(GetConversationResponse getConversationResponse, boolean bl, int n, int n2) {
        if (n != FragmentType.ALL_CHAT.getOrdinal()) {
            return;
        }
        try {
            this.isPagingApiInProgress = false;
            HippoLog.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
            if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                this.setConversationChatData((ArrayList)getConversationResponse.getData().getConversation(), bl, n2);
                this.toggleProgressBarVisibility(false);
                if (getConversationResponse.getData().getConversation().size() == 0) {
                    this.isLastItemReached = true;
                }
            }
            if (this.getActivity() != null) {
                ((AgentListActivity)this.getActivity()).hideLoader(2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LoadingBox.hide();
        this.swipeRefreshLayout.setRefreshing(false);
    }

    private void setConversationChatData(ArrayList<Conversation> arrayList, boolean bl) {
        this.setConversationChatData(arrayList, bl, -1);
    }

    private void setConversationChatData(ArrayList<Conversation> arrayList, final boolean bl, final int n) {
        if (!bl) {
            this.conversationChatList.clear();
        }
        this.conversationChatList.addAll(arrayList);
        if (this.getView() != null && this.chatListAdapter != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    if (!bl && n < 1) {
                        AllChatFragment.this.listView.scrollToPosition(0);
                    }
                }
            });
        }
        this.setLlNoConversation(null);
        this.addUnreadCount(arrayList, bl);
    }

    private void setLlNoConversation(final String string2) {
        if (this.llNoConversation != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (string2 != null) {
                        if (AllChatFragment.this.conversationChatList == null || AllChatFragment.this.conversationChatList.size() == 0) {
                            AllChatFragment.this.llNoConversation.setVisibility(0);
                            AllChatFragment.this.swipeRefreshLayout.setVisibility(8);
                        } else {
                            AllChatFragment.this.llNoConversation.setVisibility(8);
                        }
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            AllChatFragment.this.detail_error.setText((CharSequence)string2);
                        }
                    } else if (AllChatFragment.this.conversationChatList == null || AllChatFragment.this.conversationChatList.size() == 0) {
                        AllChatFragment.this.llNoConversation.setVisibility(0);
                        AllChatFragment.this.swipeRefreshLayout.setVisibility(8);
                    } else {
                        AllChatFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    private void toggleProgressBarVisibility(boolean bl) {
        if (bl) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ChatListAdapter.ProgressBarItem();
            }
            if (!this.conversationChatList.contains(this.progressBarItem)) {
                this.conversationChatList.add(this.progressBarItem);
                this.listView.post(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyItemInserted(AllChatFragment.this.conversationChatList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationChatList.contains(this.progressBarItem)) {
            this.conversationChatList.remove(this.progressBarItem);
            this.chatListAdapter.notifyItemRemoved(this.conversationChatList.size() - 1);
        }
    }

    public void onRefresh() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        this.getConversationData(0, false, -1, true);
    }

    @Override
    public void onClick(int n, int n2, Conversation conversation) {
        conversation.setUnreadCount(0);
        this.chatListAdapter.notifyDataSetChanged();
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        Intent intent = new Intent((Context)this.getActivity(), AgentChatActivity.class);
        intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
        intent.putExtra("fragment_type", n2);
        this.startActivityForResult(intent, 100);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        HippoLog.v("onActivityResult", "enter");
        if (n == 100) {
            if (n2 == MessageMode.OPEN_CHAT.getOrdinal()) {
                Long l = Long.parseLong(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(l, MessageMode.OPEN_CHAT.getOrdinal(), n2);
            } else if (n2 == MessageMode.CLOSED_CHAT.getOrdinal()) {
                Long l = Long.parseLong(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(l, MessageMode.CLOSED_CHAT.getOrdinal(), n2);
            } else if (n2 == Overlay.ASSIGNMENT.getOrdinal()) {
                Long l = Long.parseLong(intent.getExtras().getString("channel_id"));
                this.setOverlayTransition(l, MessageMode.OPEN_CHAT.getOrdinal(), n2);
            }
        }
    }

    private void setOverlayTransition(Long l, int n, int n2) {
        boolean bl = false;
        Conversation conversation = null;
        for (int j = 0; j < this.conversationChatList.size(); ++j) {
            Conversation conversation2;
            if (!(this.conversationChatList.get(j) instanceof Conversation) || (conversation2 = (Conversation)this.conversationChatList.get(j)).getChannelId().compareTo(l) != 0) continue;
            bl = true;
            if (n2 != Overlay.ASSIGNMENT.getOrdinal()) {
                conversation2.setStatus(n);
            }
            conversation2.setOverlay(n2);
            break;
        }
        if (bl) {
            this.chatListAdapter.notifyDataSetChanged();
            this.removeConversation(l);
            if (n2 != Overlay.ASSIGNMENT.getOrdinal()) {
                this.removeOverlay(conversation);
            } else {
                this.removeConversation(l);
            }
        }
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    private void removeConversation(final Long l) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (int j = 0; j < AllChatFragment.this.conversationChatList.size(); ++j) {
                            if (!(AllChatFragment.this.conversationChatList.get(j) instanceof Conversation) || l != ((Conversation)AllChatFragment.this.conversationChatList.get(j)).getChannelId()) continue;
                            AllChatFragment.this.conversationChatList.remove(j);
                            AllChatFragment.this.chatListAdapter.notifyItemRemoved(j);
                            HashMap<Integer, Integer> hashMap = AgentCommonData.removeTotalUnreadCount(l.intValue());
                            AllChatFragment.this.sendUnreadCount(hashMap);
                            break;
                        }
                    }
                });
            }
        }, 1000L);
    }

    private void setConversationChatCount(Conversation conversation) {
        try {
            for (Object object : this.conversationChatList) {
                if (!(object instanceof Conversation) || !((Conversation)object).getChannelId().equals(conversation.getChannelId())) continue;
                ((Conversation)object).setUnreadCount(0);
                HashMap<Integer, Integer> hashMap = AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                this.sendUnreadCount(hashMap);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void conversationList(GetConversationResponse getConversationResponse, boolean bl, int n, int n2) {
        this.getConversationResponse(getConversationResponse, bl, n, n2);
    }

    @Override
    public void onError(APIError aPIError, int n) {
        if (n != FragmentType.ALL_CHAT.getOrdinal()) {
            return;
        }
        this.setLlNoConversation(aPIError.getMessage() == null ? "" : aPIError.getMessage());
    }

    @Override
    public void offlineConversationList(int n, ArrayList<Object> arrayList) {
        boolean bl = true;
        if (n == FragmentType.ALL_CHAT.getOrdinal()) {
            if (n == FragmentType.ALL_CHAT.getOrdinal() && arrayList != null && arrayList.size() > 0) {
                this.conversationChatList.addAll(arrayList);
                this.chatListAdapter.notifyDataSetChanged();
                bl = false;
            }
            this.setConnectionManager(bl);
        }
    }

    @Override
    public void onAssignChat(JSONObject jSONObject) {
        HippoLog.e(TAG, "onAssignChat jsonObject: " + jSONObject);
        ArrayList<Conversation> arrayList = new ArrayList<Conversation>();
        for (Object object : this.conversationChatList) {
            if (!(object instanceof Conversation)) continue;
            Conversation conversation = (Conversation)object;
            arrayList.add(conversation);
        }
        for (int j = 0; j < arrayList.size(); ++j) {
            Object object;
            if (((Conversation)arrayList.get(j)).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
            object = arrayList.get(j);
            ((Conversation)object).setMessage(jSONObject.optString("message", ""));
            ((Conversation)object).setAgentId(jSONObject.optInt("assigned_to", 0));
            ((Conversation)object).setAgentName(jSONObject.optString("assigned_to_name"));
            ((Conversation)object).setLabel(jSONObject.optString("label", ""));
            if (jSONObject.optInt("notification_type", 0) == 3) {
                ((Conversation)object).setLast_sent_by_id(jSONObject.optInt("assigned_by"));
                ((Conversation)object).setLast_sent_by_full_name(jSONObject.optString("assigned_by_name"));
                ((Conversation)object).setLast_sent_by_user_type(2);
            } else {
                ((Conversation)object).setLast_sent_by_id(jSONObject.optInt("last_sent_by_id"));
                ((Conversation)object).setLast_sent_by_full_name(jSONObject.optString("last_sent_by_full_name"));
                ((Conversation)object).setLast_sent_by_user_type(jSONObject.optInt("last_sent_by_user_type"));
            }
            ((Conversation)object).setLastUpdatedAt(jSONObject.optString("date_time", ""));
            ((Conversation)object).setUnreadCount(0);
            break;
        }
        Collections.sort(arrayList, new Comparator<Conversation>(){

            @Override
            public int compare(Conversation conversation, Conversation conversation2) {
                if (conversation.getLastUpdatedAt() == null || conversation2.getLastUpdatedAt() == null) {
                    return 0;
                }
                return conversation2.getLastUpdatedAt().compareTo(conversation.getLastUpdatedAt());
            }
        });
        this.setConversationChatData(arrayList, false);
    }

    @Override
    public void onControlChannelData(JSONObject jSONObject) {
        this.setControlChannelData(jSONObject);
    }

    @Override
    public void onRefreshData() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, this.conversationChatList.size(), false);
    }

    @Override
    public void onReadAll(JSONObject jSONObject) {
        if (jSONObject != null) {
            if (this.userData == null) {
                this.userData = AgentCommonData.getUserData();
            }
            if (jSONObject.optInt("user_id", 0) == this.userData.getUserId().intValue()) {
                for (Object object : this.conversationChatList) {
                    Conversation conversation;
                    if (!(object instanceof Conversation) || (conversation = (Conversation)object).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
                    conversation.setUnreadCount(0);
                    HashMap<Integer, Integer> hashMap = AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                    this.sendUnreadCount(hashMap);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void updateCount(Long l) {
        try {
            for (Object object : this.conversationChatList) {
                Conversation conversation;
                if (!(object instanceof Conversation) || (conversation = (Conversation)object).getChannelId().compareTo(l) != 0) continue;
                conversation.setUnreadCount(0);
                HashMap<Integer, Integer> hashMap = AgentCommonData.addTotalUnreadCount(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                this.sendUnreadCount(hashMap);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    }
                });
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setControlChannelData(JSONObject jSONObject) {
        try {
            ArrayList<Conversation> arrayList;
            Object object;
            boolean bl = true;
            for (Object iterator : this.conversationChatList) {
                Object object2;
                if (!(iterator instanceof Conversation) || ((Conversation)(object2 = (Conversation)iterator)).getChannelId().compareTo(jSONObject.optLong("channel_id")) != 0) continue;
                bl = false;
                ((Conversation)object2).setMessage(jSONObject.optString("message", ""));
                ((Conversation)object2).setAgentId(jSONObject.optInt("agent_id", 0));
                ((Conversation)object2).setLast_sent_by_id(jSONObject.optInt("last_sent_by_id"));
                ((Conversation)object2).setLast_sent_by_full_name(jSONObject.optString("last_sent_by_full_name"));
                ((Conversation)object2).setLast_sent_by_user_type(jSONObject.optInt("last_sent_by_user_type"));
                ((Conversation)object2).setLastUpdatedAt(jSONObject.optString("date_time", ""));
                if (jSONObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue() && jSONObject.optInt("is_my_chat", 0) == 1 && (long)jSONObject.optInt("channel_id", -1) != AgentChatActivity.pushChannelId) {
                    ((Conversation)object2).setUnreadCount(((Conversation)object2).getUnreadCount() + 1);
                    object = AgentCommonData.addTotalUnreadCount(((Conversation)object2).getChannelId().intValue(), ((Conversation)object2).getUnreadCount());
                    this.sendUnreadCount((HashMap<Integer, Integer>)object);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AllChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                }
                if (this.userData == null) {
                    this.userData = AgentCommonData.getUserData();
                }
                if (jSONObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue()) break;
                ((Conversation)object2).setUnreadCount(0);
                break;
            }
            if (bl) {
                HippoLog.v("New chat arrived", "send to unasssigned");
                arrayList = new Conversation();
                ((Conversation)((Object)arrayList)).setChannelId(jSONObject.optLong("channel_id"));
                ((Conversation)((Object)arrayList)).setChannelName(jSONObject.optString("channel_name", ""));
                ((Conversation)((Object)arrayList)).setUserId(jSONObject.optInt("user_id"));
                ((Conversation)((Object)arrayList)).setLastUpdatedAt(jSONObject.optString("date_time", ""));
                ((Conversation)((Object)arrayList)).setMessage(jSONObject.optString("message", ""));
                ((Conversation)((Object)arrayList)).setLabel(jSONObject.optString("label", ""));
                ((Conversation)((Object)arrayList)).setStatus(jSONObject.optInt("status", 1));
                ((Conversation)((Object)arrayList)).setBotChannelName(jSONObject.optString("bot_channel_name", ""));
                if (jSONObject.optInt("is_my_chat", 0) == 1) {
                    ((Conversation)((Object)arrayList)).setUnreadCount(jSONObject.optInt("unread_count", 1));
                } else {
                    ((Conversation)((Object)arrayList)).setUnreadCount(jSONObject.optInt("unread_count", 0));
                }
                ((Conversation)((Object)arrayList)).setAgentId(jSONObject.optInt("agent_id", 0));
                ((Conversation)((Object)arrayList)).setOverlay(Overlay.DEFAULT.getOrdinal());
                this.conversationChatList.add(0, arrayList);
                this.setLlNoConversation(null);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AllChatFragment.this.chatListAdapter.notifyItemInserted(0);
                        if (AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 0) {
                            AllChatFragment.this.listView.scrollToPosition(0);
                        } else if (AllChatFragment.this.layoutManager.findFirstVisibleItemPosition() > 0) {
                            AllChatFragment.this.newConversationSnackBar();
                        }
                    }
                });
                HashMap<Integer, Integer> hashMap = AgentCommonData.addTotalUnreadCount(((Conversation)((Object)arrayList)).getChannelId().intValue(), ((Conversation)((Object)arrayList)).getUnreadCount());
                this.sendUnreadCount(hashMap);
            } else if (jSONObject.optInt("notification_type") != NotificationType.ASSIGNMENT.getOrdinal()) {
                arrayList = new ArrayList<Conversation>();
                for (Object object2 : this.conversationChatList) {
                    if (!(object2 instanceof Conversation)) continue;
                    object = (Conversation)object2;
                    arrayList.add((Conversation)object);
                }
                Collections.sort(arrayList, new Comparator<Conversation>(){

                    @Override
                    public int compare(Conversation conversation, Conversation conversation2) {
                        if (conversation.getLastUpdatedAt() == null || conversation2.getLastUpdatedAt() == null) {
                            return 0;
                        }
                        return conversation2.getLastUpdatedAt().compareTo(conversation.getLastUpdatedAt());
                    }
                });
                this.setConversationChatData(arrayList, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void remove(final int n) {
        Conversation conversation = (Conversation)this.conversationChatList.get(n);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AllChatFragment.this.chatListAdapter.notifyItemChanged(n);
            }
        });
        this.removeConversation(conversation.getChannelId());
    }

    private void sendUnreadCount(HashMap<Integer, Integer> hashMap) {
        if (hashMap == null) {
            hashMap = AgentCommonData.getTotalUnreadCount();
        }
        int n = 0;
        for (Integer n2 : hashMap.values()) {
            n += n2.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(n);
        }
    }

    private void addUnreadCount(ArrayList<Conversation> arrayList, boolean bl) {
        HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
        for (Conversation conversation : arrayList) {
            hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
        }
        AgentCommonData.addTotalUnreadCount(hashMap);
        this.sendUnreadCount(null);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

