/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.media.MediaPlayer;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.downloader.Error;
import com.downloader.OnDownloadListener;
import com.downloader.OnPauseListener;
import com.downloader.OnProgressListener;
import com.downloader.OnStartOrResumeListener;
import com.downloader.PRDownloader;
import com.downloader.Progress;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.ImageDisplayActivity;
import com.hippo.activity.VideoPlayerActivity;
import com.hippo.adapter.CustomActionButtonsAdapter;
import com.hippo.adapter.CustomActionDescriptionAdapter;
import com.hippo.adapter.FuguMessageAdapter;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.CustomAction;
import com.hippo.model.Image;
import com.hippo.utils.CommonMediaPlayer;
import com.hippo.utils.DateUtils;
import com.hippo.utils.GridDividerItemDecoration;
import com.hippo.utils.HippoLog;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.Utils;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FuguAgentMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements OnRecyclerListener,
FuguAppConstant {
    private static final String TAG = FuguAgentMessageAdapter.class.getSimpleName();
    private AgentChatActivity context;
    private final int TYPE_HEADER = 0;
    private final int ITEM_TYPE_SELF = 2;
    private final int ITEM_ASSIGNMENT = 3;
    private final int FUGU_VIDEO_CALL_VIEW = 18;
    private final int HIPPO_FILE_SENT_VIEW = 10;
    private final int HIPPO_VIDEO_MESSGAE_SELF = 12;
    private final int HIPPO_UNKNOWN_MESSAGE_SELF = -2;
    private final int HIPPO_UNKNOWN_MESSAGE_OTHER = -1;
    private final int ITEM_TYPE_OTHER = 1;
    private final int FUGU_OTHER_VIDEO_CALL_VIEW = 19;
    private final int HIPPO_FILE_RECEIVED_VIEW = 11;
    private final int HIPPO_VIDEO_MESSGAE_OTHER = 13;
    private final int HIPPO_USER_CONCENT_VIEW = 20;
    private DateUtils dateUtil = DateUtils.getInstance();
    private OnRetryListener mOnRetry;
    private HippoColorConfig hippoColorConfig;
    private Conversation conversation;
    private FuguMessageAdapter.onVideoCall onVideoCall;
    private String customerName;
    private String agentName;
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnabled = true;
    private int agentId;
    @NonNull
    private List<ListItem> items = Collections.emptyList();
    private RecyclerView recyclerView;
    int currentProgress = -1;

    public FuguAgentMessageAdapter(AgentChatActivity agentChatActivity, @NonNull List<ListItem> list, RecyclerView recyclerView, Conversation conversation) {
        this.items = list;
        this.recyclerView = recyclerView;
        this.context = agentChatActivity;
        this.hippoColorConfig = CommonData.getColorConfig();
        this.conversation = conversation;
    }

    public void updateList(@NonNull List<ListItem> list) {
        this.items = list;
    }

    public void setCustomeName(String string2) {
        this.customerName = string2;
    }

    public void setAgentName(String string2) {
        this.agentName = string2;
    }

    public void setIsChatAssignToMe(boolean bl) {
        this.isChatAssignToMe = bl;
    }

    public void isVideoCallEnabled(boolean bl) {
        this.isVideoCallEnabled = bl;
    }

    public void setOnVideoCallListener(FuguMessageAdapter.onVideoCall onVideoCall2) {
        this.onVideoCall = onVideoCall2;
    }

    public void setOnRetryListener(OnRetryListener onRetryListener) {
        this.mOnRetry = onRetryListener;
    }

    @Override
    public void onItemClick(View view, View view2, int n) {
        int n2 = this.recyclerView.getChildLayoutPosition(view2);
        if (n2 != -1) {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Message message = ((EventItem)this.items.get(n2)).getEvent();
            String string2 = Util.getFileName(message.getFileName(), message.getMuid());
            String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(message.getDocumentType()));
            Intent intent = new Intent((Context)this.context, VideoPlayerActivity.class);
            intent.putExtra("url", string3);
            intent.putExtra("title", message.getFileName());
            this.context.startActivity(intent);
        }
    }

    @Override
    public void onItemClick(View view, int n) {
    }

    private void removeDefaultMsgTime() {
        for (int j = 0; j < 2 && j <= this.items.size(); ++j) {
            if (this.items.get(j).getType() != 1) continue;
            ((EventItem)this.items.get(j)).getEvent().setSentAtUtc("");
            break;
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        switch (n) {
            case 0: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_date, viewGroup, false);
                return new DateViewHolder(view);
            }
            case 1: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_left, viewGroup, false);
                return new OtherMessageViewHolder(view);
            }
            case 3: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_assignment, viewGroup, false);
                return new AssignmentViewHolder(view);
            }
            case 2: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_right, viewGroup, false);
                return new SelfMessageViewHolder(view);
            }
            case 18: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_self_side, viewGroup, false);
                return new SelfVideoViewHolder(view);
            }
            case 19: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_other_side, viewGroup, false);
                return new VideoViewHolder(view);
            }
            case 10: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_sent, viewGroup, false);
                return new SentFileViewHolder(view);
            }
            case 11: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_received, viewGroup, false);
                return new ReceivedFileViewHolder(view);
            }
            case 12: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_self, viewGroup, false);
                return new SelfVideoMessageViewHolder(view);
            }
            case 13: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_other, viewGroup, false);
                return new OtherVideoMessageViewHolder(view, this);
            }
            case -2: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_right, viewGroup, false);
                return new SelfMessageViewHolder(view);
            }
            case -1: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_left, viewGroup, false);
                return new OtherMessageViewHolder(view);
            }
            case 20: {
                View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_agent_bot_item, viewGroup, false);
                return new UserConcentViewHolder(view);
            }
        }
        return null;
    }

    @TargetApi(value=21)
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, final int n) {
        int n2 = this.getItemViewType(n);
        switch (n2) {
            case 18: {
                SelfVideoViewHolder selfVideoViewHolder = (SelfVideoViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                selfVideoViewHolder.tvMsg.setText((CharSequence)this.getMessage(message, 18));
                if (message.getSentAtUtc().isEmpty()) {
                    selfVideoViewHolder.tvTime.setVisibility(8);
                } else {
                    selfVideoViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    selfVideoViewHolder.tvTime.setVisibility(0);
                }
                if (message.getVideoCallDuration() > 0) {
                    selfVideoViewHolder.ivCallIcon.setVisibility(0);
                    selfVideoViewHolder.tvDuration.setVisibility(0);
                    selfVideoViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(message.getVideoCallDuration()) + " at "));
                } else {
                    selfVideoViewHolder.ivCallIcon.setVisibility(8);
                    selfVideoViewHolder.tvDuration.setVisibility(8);
                }
                if (!(this.isChatAssignToMe && AgentCommonData.getUserData().isVideoCallEnabled() && this.isVideoCallEnabled)) {
                    selfVideoViewHolder.callAgain.setVisibility(8);
                }
                selfVideoViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.onVideoCall != null) {
                            int n = 1;
                            if (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                n = 2;
                            }
                            FuguAgentMessageAdapter.this.onVideoCall.onVideoCallClicked(n);
                        }
                    }
                });
                break;
            }
            case 19: {
                VideoViewHolder videoViewHolder = (VideoViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                videoViewHolder.tvMsg.setText((CharSequence)this.getMessage(message, 19));
                if (message.getSentAtUtc().isEmpty()) {
                    videoViewHolder.tvTime.setVisibility(8);
                } else {
                    videoViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    videoViewHolder.tvTime.setVisibility(0);
                }
                videoViewHolder.userImage.setVisibility(8);
                if (message.getVideoCallDuration() > 0) {
                    videoViewHolder.ivCallIcon.setVisibility(0);
                    videoViewHolder.tvDuration.setVisibility(0);
                    videoViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(message.getVideoCallDuration()) + " at "));
                } else {
                    videoViewHolder.ivCallIcon.setVisibility(8);
                    videoViewHolder.tvDuration.setVisibility(8);
                }
                NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)videoViewHolder.llMessage.getBackground();
                ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                videoViewHolder.llRoot.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                videoViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
                videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.onVideoCall != null) {
                            int n = 1;
                            if (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                n = 2;
                            }
                            FuguAgentMessageAdapter.this.onVideoCall.onVideoCallClicked(n);
                        }
                    }
                });
                break;
            }
            case 0: {
                String string2;
                DateViewHolder dateViewHolder = (DateViewHolder)viewHolder;
                HeaderItem headerItem = (HeaderItem)this.items.get(n);
                if (headerItem.getDate().isEmpty()) {
                    dateViewHolder.tvDate.setVisibility(8);
                } else {
                    DateUtils.getInstance();
                    string2 = DateUtils.getDate(headerItem.getDate());
                    dateViewHolder.tvDate.setText((CharSequence)string2);
                    dateViewHolder.tvDate.setVisibility(0);
                }
                string2 = (GradientDrawable)dateViewHolder.tvDate.getBackground();
                string2.setStroke((int)this.context.getResources().getDimension(R.dimen.fugu_border_width), this.hippoColorConfig.getHippoBorderColor());
                dateViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChatDateText());
                break;
            }
            case 1: {
                Object object;
                final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                otherMessageViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherMessageViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setAutoLinkMask(15);
                otherMessageViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                otherMessageViewHolder.userImage.setVisibility(8);
                if (message.getMessage().isEmpty()) {
                    otherMessageViewHolder.tvMsg.setVisibility(4);
                    object = new LinearLayout.LayoutParams(-2, -1);
                    ((LinearLayout.LayoutParams)object).weight = 1.0f;
                    ((LinearLayout.LayoutParams)object).gravity = 0x800005;
                    otherMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)object);
                } else {
                    otherMessageViewHolder.tvMsg.setText((CharSequence)message.getMessage());
                    object = message.getMessage().replace(" ", "&nbsp;");
                    otherMessageViewHolder.tvMsg.setText((CharSequence)Html.fromHtml((String)((String)object).replace("\n", "<br /> ")));
                    otherMessageViewHolder.tvMsg.setVisibility(0);
                }
                otherMessageViewHolder.tvUserName.setText((CharSequence)message.getfromName());
                if (message.getSentAtUtc().isEmpty()) {
                    otherMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    otherMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    otherMessageViewHolder.tvTime.setVisibility(0);
                }
                object = "";
                if (!TextUtils.isEmpty((CharSequence)message.getfromName())) {
                    object = message.getfromName();
                }
                this.setOtherTypeView(n, message, (String)object, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.tvUserName, otherMessageViewHolder.llRoot, otherMessageViewHolder.tvMsg);
                this.setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, message.getIntegrationSource());
                if (!message.getThumbnailUrl().isEmpty()) {
                    new RequestOptions();
                    RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                    Glide.with((FragmentActivity)this.context).load(message.getThumbnailUrl()).apply((BaseRequestOptions)requestOptions).into(otherMessageViewHolder.ivMsgImage);
                    otherMessageViewHolder.rlImageMessage.setVisibility(0);
                } else {
                    otherMessageViewHolder.rlImageMessage.setVisibility(8);
                }
                otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguAgentMessageAdapter.this.showImageDialog((Context)FuguAgentMessageAdapter.this.context, message.getImageUrl(), otherMessageViewHolder.ivMsgImage, message);
                    }
                });
                this.customViewUI(message, (Context)this.context, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.rlCustomAction, otherMessageViewHolder.tvActionTitle, otherMessageViewHolder.tvActionTitleDescription, otherMessageViewHolder.llTextualContent, otherMessageViewHolder.ivActionImage, otherMessageViewHolder.rvActionDescription, otherMessageViewHolder.rvActionButtons, otherMessageViewHolder.vwActionButtonDivider);
                break;
            }
            case 2: {
                Object object;
                final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                selfMessageViewHolder.tvName.setVisibility(0);
                selfMessageViewHolder.tvName.setText((CharSequence)message.getfromName());
                if (message.getMessage().isEmpty()) {
                    selfMessageViewHolder.tvMsg.setVisibility(4);
                    object = new LinearLayout.LayoutParams(-2, -1);
                    ((LinearLayout.LayoutParams)object).weight = 1.0f;
                    ((LinearLayout.LayoutParams)object).gravity = 0x800005;
                    selfMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)object);
                } else {
                    selfMessageViewHolder.tvMsg.setText((CharSequence)message.getMessage());
                    object = message.getMessage().replace("  ", "&nbsp;");
                    selfMessageViewHolder.tvMsg.setText((CharSequence)Html.fromHtml((String)((String)object).replace("\n", "<br />")));
                    selfMessageViewHolder.tvMsg.setVisibility(0);
                }
                if (message.getSentAtUtc().isEmpty()) {
                    selfMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    selfMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    selfMessageViewHolder.tvTime.setVisibility(0);
                }
                this.setSelfTypeView(n, message, selfMessageViewHolder.llRoot, selfMessageViewHolder.tvName, selfMessageViewHolder.llChat, selfMessageViewHolder.rlMessages, selfMessageViewHolder.tvMsg, selfMessageViewHolder.tvTime);
                this.setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, message.getIntegrationSource());
                if (!TextUtils.isEmpty((CharSequence)message.getThumbnailUrl()) || !TextUtils.isEmpty((CharSequence)message.getLocalImagePath())) {
                    if (message.getMessageStatus() == 4 || message.getMessageStatus() == 5 || message.getMessageStatus() == 6) {
                        object = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                        Glide.with((FragmentActivity)this.context).load(new File(message.getLocalImagePath())).apply((BaseRequestOptions)object).into(selfMessageViewHolder.ivMsgImage);
                        if (message.getMessageStatus() == 5 || message.getMessageStatus() == 6) {
                            selfMessageViewHolder.pbLoading.setVisibility(8);
                            selfMessageViewHolder.btnRetry.setVisibility(0);
                            selfMessageViewHolder.btnCancel.setVisibility(0);
                        } else {
                            selfMessageViewHolder.pbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            selfMessageViewHolder.btnCancel.setVisibility(8);
                        }
                    } else {
                        object = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
                        Glide.with((FragmentActivity)this.context).load(message.getThumbnailUrl()).apply((BaseRequestOptions)object).into(selfMessageViewHolder.ivMsgImage);
                        selfMessageViewHolder.pbLoading.setVisibility(8);
                        selfMessageViewHolder.btnRetry.setVisibility(8);
                        selfMessageViewHolder.btnCancel.setVisibility(8);
                    }
                    selfMessageViewHolder.rlImageMessage.setVisibility(0);
                } else {
                    selfMessageViewHolder.rlImageMessage.setVisibility(8);
                }
                selfMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (message.getMessageStatus() == 4 || message.getMessageStatus() == 5) {
                            return;
                        }
                        FuguAgentMessageAdapter.this.showImageDialog((Context)FuguAgentMessageAdapter.this.context, message.getImageUrl(), selfMessageViewHolder.ivMsgImage, message);
                    }
                });
                if (message.getIsMessageExpired() == 1 && message.getMessageType() != 10) {
                    selfMessageViewHolder.llRetry.setVisibility(0);
                    selfMessageViewHolder.tvCancel.setVisibility(0);
                    selfMessageViewHolder.tvTryAgain.setTag((Object)n);
                    selfMessageViewHolder.tvCancel.setTag((Object)n);
                    selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                String string2 = message.getMuid();
                                int n = selfMessageViewHolder.getAdapterPosition();
                                FuguAgentMessageAdapter.this.mOnRetry.onMessageRetry(string2, n);
                            }
                        }
                    });
                    selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            int n = selfMessageViewHolder.getAdapterPosition();
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                String string2 = message.getMuid();
                                FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(string2, n);
                            }
                        }
                    });
                } else {
                    selfMessageViewHolder.llRetry.setVisibility(8);
                    selfMessageViewHolder.tvCancel.setVisibility(8);
                }
                try {
                    switch (message.getMessageStatus()) {
                        case 4: 
                        case 5: 
                        case 6: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        case 3: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            break;
                        }
                        case 1: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        case 2: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                        default: {
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(0);
                            selfMessageViewHolder.ivMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            selfMessageViewHolder.pbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            String string2 = message.getMuid();
                            int n = selfMessageViewHolder.getAdapterPosition();
                            if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                                FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(string2, n);
                            }
                        }
                    }
                });
                selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            String string2 = message.getMuid();
                            int n = selfMessageViewHolder.getAdapterPosition();
                            FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(string2, n);
                        }
                    }
                });
                this.customViewUI(message, (Context)this.context, selfMessageViewHolder.llChat, selfMessageViewHolder.rlCustomAction, selfMessageViewHolder.tvActionTitle, selfMessageViewHolder.tvActionTitleDescription, selfMessageViewHolder.llTextualContent, selfMessageViewHolder.ivActionImage, selfMessageViewHolder.rvActionDescription, selfMessageViewHolder.rvActionButtons, selfMessageViewHolder.vwActionButtonDivider);
                break;
            }
            case 3: {
                AssignmentViewHolder assignmentViewHolder = (AssignmentViewHolder)viewHolder;
                Message message = ((EventItem)this.items.get(n)).getEvent();
                assignmentViewHolder.tvAssignment.setText((CharSequence)Html.fromHtml((String)message.getMessage()));
                break;
            }
            case 10: {
                Integer n3;
                final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                this.setSelfMessageBackground((View)sentFileViewHolder.llRoot, (View)sentFileViewHolder.llMessage, n);
                NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)sentFileViewHolder.llMessage.getBackground();
                ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                sentFileViewHolder.circleProgress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                String string3 = Util.getExtension(message.getFileName());
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = Util.getExtension(message.getFileUrl());
                }
                if ((n3 = (Integer)IMAGE_MAP.get(string3.toLowerCase())) != null) {
                    sentFileViewHolder.ivFileImage.setImageResource(n3.intValue());
                } else {
                    sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                sentFileViewHolder.tvFileName.setText((CharSequence)message.getFileName());
                if (string3.length() > 4) {
                    string3 = string3.substring(0, 4) + "..";
                }
                sentFileViewHolder.tvFileExtension.setText((CharSequence)string3);
                if (!TextUtils.isEmpty((CharSequence)message.getFileSize())) {
                    try {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)message.getFileSize());
                    }
                    catch (Exception exception) {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)message.getFileSize());
                    }
                }
                this.setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, message.getIntegrationSource());
                this.messageStatusTick((Activity)this.context, sentFileViewHolder.ivMessageState, message);
                this.setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, message, n);
                this.setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, message, n);
                this.setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, message);
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                if (!message.isAudioPlaying()) {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(sentFileViewHolder.llMessage, message, sentFileViewHolder.ivFilePlay, n);
                sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int n = sentFileViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(message.getMuid(), n);
                        }
                    }
                });
                break;
            }
            case 11: {
                String string4;
                ReceivedFileViewHolder receivedFileViewHolder = (ReceivedFileViewHolder)viewHolder;
                Message message = ((EventItem)this.items.get(n)).getEvent();
                receivedFileViewHolder.userImage.setVisibility(8);
                receivedFileViewHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setIntegrationSource(receivedFileViewHolder.messageSourceType, receivedFileViewHolder.messageSourceType1, message.getIntegrationSource());
                String string5 = "";
                if (!TextUtils.isEmpty((CharSequence)message.getfromName())) {
                    string5 = message.getfromName();
                }
                this.setFileMessageOther((View)receivedFileViewHolder.llRoot, (View)receivedFileViewHolder.llMessage, n, receivedFileViewHolder.tvUserName, string5);
                NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)receivedFileViewHolder.llMessage.getBackground();
                ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                String string6 = Util.getExtension(message.getFileUrl());
                Integer n4 = (Integer)IMAGE_MAP.get(string6.toLowerCase());
                if (n4 != null) {
                    receivedFileViewHolder.ivFileImage.setImageResource(n4.intValue());
                } else {
                    receivedFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                receivedFileViewHolder.tvFileName.setText((CharSequence)message.getFileName());
                String string7 = string4 = TextUtils.isEmpty((CharSequence)message.getFileExtension()) ? string6 : message.getFileExtension();
                if (string4.length() > 4) {
                    string4 = string4.substring(0, 4) + "..";
                }
                receivedFileViewHolder.tvFileExtension.setText((CharSequence)string4);
                receivedFileViewHolder.tvFileSize.setText((CharSequence)message.getFileSize());
                this.setFileDownLoadStatus(receivedFileViewHolder.ivFileImage, receivedFileViewHolder.ivFilePlay, receivedFileViewHolder.progressBar, receivedFileViewHolder.ivFileDownload, receivedFileViewHolder.ivFileUpload, message, n);
                this.setDownloadClick(receivedFileViewHolder.ivFileDownload, receivedFileViewHolder.progressBar, message, n);
                if (!message.isAudioPlaying()) {
                    receivedFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    receivedFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(receivedFileViewHolder.llMessage, message, receivedFileViewHolder.ivFilePlay, n);
                break;
            }
            case 12: {
                final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                this.setSelfMessageBackground((View)selfVideoMessageViewHolder.llRoot, (View)selfVideoMessageViewHolder.llImageMessage, n);
                NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)selfVideoMessageViewHolder.llImageMessage.getBackground();
                ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                selfVideoMessageViewHolder.circle_progress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, message.getIntegrationSource());
                this.setTime(selfVideoMessageViewHolder.tvImageTime, message.getSentAtUtc());
                this.setMessageStatus(selfVideoMessageViewHolder.ivMessageState, message.getMessageStatus(), true);
                if (!TextUtils.isEmpty((CharSequence)message.getThumbnailUrl())) {
                    this.setImage((Activity)this.context, selfVideoMessageViewHolder.ivImageMsg, message.getThumbnailUrl());
                } else {
                    selfVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setImageHeightAndWidth((ImageView)selfVideoMessageViewHolder.ivImageMsg, selfVideoMessageViewHolder.rlImageMessage, selfVideoMessageViewHolder.llImageMessage, message, true);
                selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        String string2 = Util.getFileName(message.getFileName(), message.getMuid());
                        String string3 = FileManager.getInstance().getLocalPath(string2, FuguAppConstant.FOLDER_TYPE.get(message.getDocumentType()));
                        if (TextUtils.isEmpty((CharSequence)string3)) {
                            string3 = message.getFileUrl();
                        }
                        Intent intent = new Intent((Context)FuguAgentMessageAdapter.this.context, VideoPlayerActivity.class);
                        intent.putExtra("url", string3);
                        intent.putExtra("title", message.getFileName());
                        FuguAgentMessageAdapter.this.context.startActivity(intent);
                    }
                });
                this.setVideoUiStatus(true, message, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay, selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress);
                selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int n = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onMessageCancel(message.getMuid(), n);
                        }
                    }
                });
                selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int n = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguAgentMessageAdapter.this.mOnRetry != null) {
                            FuguAgentMessageAdapter.this.mOnRetry.onFileMessageRetry(message.getMuid(), n);
                        }
                    }
                });
                selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        File file;
                        String string2;
                        String string3;
                        selfVideoMessageViewHolder.circle_progress.setVisibility(0);
                        selfVideoMessageViewHolder.llDownload.setVisibility(8);
                        String string4 = "video";
                        if (message.getMessageType() == 11) {
                            string4 = message.getDocumentType();
                        }
                        if (TextUtils.isEmpty((CharSequence)(string3 = message.getFileName()))) {
                            string2 = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            string3 = "Hippochat_" + string2 + ".jpg";
                        }
                        if (!(file = new File(string2 = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(string4)))).exists()) {
                            file.mkdir();
                        }
                        int n2 = FuguAgentMessageAdapter.this.downloadFileFromUrl(string2, string3, message, n);
                        message.setDownloadId(n2);
                    }
                });
                break;
            }
            case 13: {
                final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder)viewHolder;
                final Message message = ((EventItem)this.items.get(n)).getEvent();
                otherVideoMessageViewHolder.userImage.setVisibility(8);
                otherVideoMessageViewHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setTime(otherVideoMessageViewHolder.tvImageTime, message.getSentAtUtc());
                if (!TextUtils.isEmpty((CharSequence)message.getThumbnailUrl())) {
                    this.setImage((Activity)this.context, otherVideoMessageViewHolder.ivImageMsg, message.getThumbnailUrl());
                } else {
                    otherVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, message.getIntegrationSource());
                this.setImageHeightAndWidth((ImageView)otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, message, true);
                this.setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, message, n);
                String string8 = "";
                if (!TextUtils.isEmpty((CharSequence)message.getfromName())) {
                    string8 = message.getfromName();
                }
                this.setFileMessageOther((View)otherVideoMessageViewHolder.llRoot, (View)otherVideoMessageViewHolder.llImageMessage, n, otherVideoMessageViewHolder.tvUserName, string8);
                otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguAgentMessageAdapter.this.context.isNetworkAvailable()) {
                            File file;
                            String string2;
                            String string3;
                            otherVideoMessageViewHolder.progressBar.setVisibility(0);
                            otherVideoMessageViewHolder.llDownload.setVisibility(8);
                            String string4 = "video";
                            if (message.getMessageType() == 11) {
                                string4 = message.getDocumentType();
                            }
                            if (TextUtils.isEmpty((CharSequence)(string3 = message.getFileName()))) {
                                string2 = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                                string3 = "Hippochat_" + string2 + ".jpg";
                            }
                            if (!(file = new File(string2 = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(string4)))).exists()) {
                                file.mkdir();
                            }
                            int n2 = FuguAgentMessageAdapter.this.downloadFileFromUrl(string2, string3, message, n);
                            message.setDownloadId(n2);
                        } else {
                            Toast.makeText((Context)FuguAgentMessageAdapter.this.context, (CharSequence)FuguAgentMessageAdapter.this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
                        }
                    }
                });
                break;
            }
            case -1: {
                OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder)viewHolder;
                Message message = ((EventItem)this.items.get(n)).getEvent();
                otherMessageViewHolder.userImage.setVisibility(8);
                otherMessageViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherMessageViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setAutoLinkMask(15);
                otherMessageViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                String string9 = this.context.getString(R.string.unknown_message);
                if (!TextUtils.isEmpty((CharSequence)AgentCommonData.getUserData().getUnsupportedMessage())) {
                    string9 = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                otherMessageViewHolder.tvMsg.setText((CharSequence)string9);
                otherMessageViewHolder.tvMsg.setVisibility(0);
                otherMessageViewHolder.tvUserName.setText((CharSequence)message.getfromName());
                if (message.getSentAtUtc().isEmpty()) {
                    otherMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    otherMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    otherMessageViewHolder.tvTime.setVisibility(0);
                }
                String string10 = "";
                boolean bl = true;
                if (!TextUtils.isEmpty((CharSequence)message.getfromName())) {
                    string10 = message.getfromName();
                }
                this.setOtherTypeView(n, message, string10, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.tvUserName, otherMessageViewHolder.llRoot, otherMessageViewHolder.tvMsg);
                break;
            }
            case -2: {
                SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder)viewHolder;
                Message message = ((EventItem)this.items.get(n)).getEvent();
                selfMessageViewHolder.tvName.setVisibility(0);
                selfMessageViewHolder.tvName.setText((CharSequence)message.getfromName());
                String string11 = this.context.getString(R.string.unknown_message);
                if (!TextUtils.isEmpty((CharSequence)AgentCommonData.getUserData().getUnsupportedMessage())) {
                    string11 = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                selfMessageViewHolder.tvMsg.setText((CharSequence)string11);
                selfMessageViewHolder.tvMsg.setVisibility(0);
                if (message.getSentAtUtc().isEmpty()) {
                    selfMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    selfMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
                    selfMessageViewHolder.tvTime.setVisibility(0);
                }
                this.setSelfTypeView(n, message, selfMessageViewHolder.llRoot, selfMessageViewHolder.tvName, selfMessageViewHolder.llChat, selfMessageViewHolder.rlMessages, selfMessageViewHolder.tvMsg, selfMessageViewHolder.tvTime);
                break;
            }
            case 20: {
                UserConcentViewHolder userConcentViewHolder = (UserConcentViewHolder)viewHolder;
                Message message = ((EventItem)this.items.get(n)).getEvent();
                this.setBotSelfView(n, userConcentViewHolder, message);
                String string12 = "";
                if (!TextUtils.isEmpty((CharSequence)message.getSelectedBtnId())) {
                    string12 = message.getSelectedBtnId();
                }
                if (TextUtils.isEmpty((CharSequence)string12)) {
                    userConcentViewHolder.tagLayout.setVisibility(0);
                    userConcentViewHolder.tvTagsTime.setVisibility(0);
                    userConcentViewHolder.leftrootview.setVisibility(8);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (int j = 0; j < message.getContentValue().size(); ++j) {
                        arrayList.add(message.getContentValue().get(j).getBtnTitle());
                        arrayList2.add(this.hippoColorConfig.getHippoBgMessageYou());
                    }
                    userConcentViewHolder.tagLayout.setTagBorderColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTagTextColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTags(arrayList, arrayList2);
                    break;
                }
                userConcentViewHolder.leftrootview.setVisibility(0);
                userConcentViewHolder.tagLayout.setVisibility(8);
                userConcentViewHolder.tvTagsTime.setVisibility(8);
                int n5 = 0;
                for (int j = 0; j < message.getContentValue().size(); ++j) {
                    if (!string12.equalsIgnoreCase(message.getContentValue().get(j).getBtnId())) continue;
                    n5 = j;
                    break;
                }
                this.setBotOtherView(n, n5, userConcentViewHolder, message);
                break;
            }
        }
    }

    private void setBotOtherView(int n, int n2, UserConcentViewHolder userConcentViewHolder, Message message) {
        Message message2;
        userConcentViewHolder.tvMsg.setText((CharSequence)message.getContentValue().get(n2).getBtnTitle());
        userConcentViewHolder.tvUserName.setText((CharSequence)message.getfromName());
        userConcentViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
        userConcentViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
        userConcentViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
        if (message.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTime.setVisibility(8);
        } else {
            userConcentViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
            userConcentViewHolder.tvTime.setVisibility(0);
        }
        String string2 = message.getRepliedBy();
        if (n != 0 && this.getItemViewType(n - 1) == 1) {
            message2 = ((EventItem)this.items.get(n - 1)).getEvent();
            if (message.getUserId().compareTo(message2.getUserId()) != 0) {
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                userConcentViewHolder.tvUserName.setVisibility(0);
                userConcentViewHolder.tvUserName.setText((CharSequence)string2);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(8), 0, this.pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else if (n != 0 && n + 1 != this.items.size() && this.getItemViewType(n + 1) != 1) {
                userConcentViewHolder.tvUserName.setVisibility(8);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(17), this.pxToDp(1), this.pxToDp(0), this.pxToDp(2));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else {
                userConcentViewHolder.tvUserName.setVisibility(8);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            }
        } else if (n != 0 && n + 1 != this.items.size() && this.getItemViewType(n + 1) == 1) {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)string2);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
            userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        } else {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)string2);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(2));
            userConcentViewHolder.tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        }
        message2 = (NinePatchDrawable)userConcentViewHolder.llChatLeft.getBackground();
        message2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }

    private void setBotSelfView(int n, UserConcentViewHolder userConcentViewHolder, Message message) {
        userConcentViewHolder.tvNameRight.setText((CharSequence)message.getfromName());
        userConcentViewHolder.tvMsgRight.setText((CharSequence)message.getMessage());
        userConcentViewHolder.tvNameRight.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFromName());
        userConcentViewHolder.tvMsgRight.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        userConcentViewHolder.tvTimeRight.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgYou());
        if (message.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTimeRight.setVisibility(8);
        } else {
            userConcentViewHolder.tvTimeRight.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(message.getSentAtUtc())));
            userConcentViewHolder.tvTimeRight.setVisibility(0);
        }
        if (n != 0 && this.getItemViewType(n - 1) == 2 && n + 1 != this.items.size() && this.getItemViewType(n + 1) == 2) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
        } else if (n != 0 && this.getItemViewType(n - 1) == 2 && n + 1 != this.items.size() && this.getItemViewType(n + 1) != 2 || n - 1 >= 0 && this.getItemViewType(n - 1) == 2) {
            if (n == this.items.size() - 1) {
                userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            } else {
                userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(2));
            }
        } else if (n != 0 && n + 1 != this.items.size() && this.getItemViewType(n + 1) == 2) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else if (n == this.items.size() - 1) {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else {
            userConcentViewHolder.llRootRight.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(2));
        }
        if (n != 0 && this.isNotSelfViewType(n - 1)) {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            userConcentViewHolder.rlMessagesRight.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
        } else {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            userConcentViewHolder.rlMessagesRight.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(6), this.pxToDp(0));
        }
        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)userConcentViewHolder.llChatRight.getBackground();
        ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
    }

    private boolean isNotSelfViewType(int n) {
        int n2 = this.getItemViewType(n);
        return n2 != 2 && n2 != 10 && n2 != 12 && n2 != 18;
    }

    private void customViewUI(Message message, Context context, LinearLayout linearLayout, RelativeLayout relativeLayout, TextView textView, TextView textView2, LinearLayout linearLayout2, ImageView imageView, RecyclerView recyclerView, RecyclerView recyclerView2, View view) {
        if (message.getMessageType() == 12 || message.getMessageType() == 19) {
            CustomAction customAction;
            relativeLayout.setVisibility(0);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)relativeLayout.getLayoutParams();
            if (linearLayout.getBackground().getConstantState() == ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_chat_bg_left).getConstantState()) {
                layoutParams.setMargins(this.pxToDp(13), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.setMarginStart(this.pxToDp(13));
                    layoutParams.setMarginEnd(this.pxToDp(10));
                }
            } else {
                layoutParams.setMargins(this.pxToDp(10), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
            }
            if ((customAction = message.getCustomAction()) != null) {
                if (customAction.getTitle() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitle())) {
                    textView.setVisibility(0);
                    textView.setText((CharSequence)customAction.getTitle());
                } else {
                    textView.setVisibility(8);
                }
                if (customAction.getTitleDescription() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitleDescription())) {
                    textView2.setVisibility(0);
                    textView2.setText((CharSequence)customAction.getTitleDescription());
                } else {
                    textView2.setVisibility(8);
                }
                if (customAction.getImageUrl() != null && !TextUtils.isEmpty((CharSequence)customAction.getImageUrl())) {
                    linearLayout2.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                    imageView.setVisibility(0);
                    RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder));
                    Glide.with((Context)context).load(customAction.getImageUrl()).apply((BaseRequestOptions)requestOptions).into(imageView);
                } else {
                    imageView.setVisibility(8);
                    linearLayout2.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                }
                if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                    recyclerView.setVisibility(0);
                    recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
                    recyclerView.setNestedScrollingEnabled(false);
                    recyclerView.setAdapter((RecyclerView.Adapter)new CustomActionDescriptionAdapter(context, customAction.getDescriptionObjects()));
                } else {
                    recyclerView.setVisibility(8);
                }
                if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                    view.setVisibility(0);
                    recyclerView2.setVisibility(0);
                    recyclerView2.setNestedScrollingEnabled(false);
                    int n = 2;
                    int n2 = customAction.getActionButtons().size();
                    n = n2 == 1 ? 1 : (n2 % 3 == 0 ? 3 : 2);
                    boolean bl = false;
                    if (message.getUserId().intValue() == AgentCommonData.getUserData().getUserId().intValue()) {
                        bl = true;
                    }
                    recyclerView2.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, n));
                    recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(context));
                    recyclerView2.setAdapter((RecyclerView.Adapter)new CustomActionButtonsAdapter(context, customAction.getActionButtons(), bl));
                } else {
                    view.setVisibility(8);
                    recyclerView2.setVisibility(8);
                }
            }
        } else {
            relativeLayout.setVisibility(8);
        }
    }

    private void setSelfTypeView(int n, Message message, LinearLayout linearLayout, TextView textView, LinearLayout linearLayout2, RelativeLayout relativeLayout, TextView textView2, TextView textView3) {
        if (n != 0 && this.getSelfViewType(n - 1) && n + 1 != this.items.size() && this.getSelfViewType(n + 1)) {
            linearLayout.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            textView.setVisibility(8);
        } else if (n != 0 && this.getSelfViewType(n - 1) && n + 1 != this.items.size() && this.getSelfViewType(n + 1) || n - 1 >= 0 && this.getSelfViewType(n - 1)) {
            if (n == this.items.size() - 1) {
                linearLayout.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
            } else {
                linearLayout.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(2));
            }
            textView.setVisibility(8);
        } else if (n != 0 && n + 1 != this.items.size() && this.getSelfViewType(n + 1)) {
            linearLayout.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else if (n == this.items.size() - 1) {
            linearLayout.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
        } else {
            linearLayout.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(2));
        }
        if (n != 0 && !this.getSelfViewType(n - 1)) {
            linearLayout2.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            relativeLayout.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
        } else {
            linearLayout2.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            relativeLayout.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(6), this.pxToDp(0));
        }
        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)linearLayout2.getBackground();
        if (message.getMessageType() == 3) {
            ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoPrivateMsg(), PorterDuff.Mode.MULTIPLY);
        } else {
            ninePatchDrawable.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
        }
        textView.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFromName());
        textView2.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        textView2.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        textView2.setAutoLinkMask(15);
        textView3.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgYou());
    }

    private boolean getSelfViewType(int n) {
        int n2 = this.getItemViewType(n);
        return n2 == 2 || n2 == 12 || n2 == 10 || n2 == 12 || n2 == -2;
    }

    private void setOtherTypeView(int n, Message message, String string2, LinearLayout linearLayout, TextView textView, LinearLayout linearLayout2, TextView textView2) {
        Message message2;
        int n2 = this.getItemViewType(n - 1);
        int n3 = this.getItemViewType(n);
        int n4 = this.getItemViewType(n);
        if (n + 1 != this.items.size()) {
            n4 = this.getItemViewType(n + 1);
        }
        if (n != 0 && (n2 == 1 || n2 == 20 || n2 == -1)) {
            message2 = ((EventItem)this.items.get(n - 1)).getEvent();
            if (message.getUserId().compareTo(message2.getUserId()) != 0 && n2 != 20) {
                linearLayout.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                textView.setVisibility(0);
                textView.setText((CharSequence)string2);
                linearLayout2.setPadding(this.pxToDp(10), this.pxToDp(8), 0, this.pxToDp(1));
                textView.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                textView2.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else if (n != 0 && n + 1 != this.items.size() && (n4 != 1 || n4 != 20 || n4 != -1)) {
                textView.setVisibility(8);
                linearLayout.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                linearLayout2.setPadding(this.pxToDp(17), this.pxToDp(1), this.pxToDp(0), this.pxToDp(2));
                textView.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                textView2.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            } else {
                textView.setVisibility(8);
                linearLayout.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                linearLayout2.setPadding(this.pxToDp(17), this.pxToDp(1), 0, this.pxToDp(1));
                textView.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                textView2.setPadding(this.pxToDp(8), this.pxToDp(7), this.pxToDp(2), this.pxToDp(7));
            }
        } else if (n != 0 && n + 1 != this.items.size() && (n4 == 1 || n4 == 20 || n4 == -1)) {
            textView.setVisibility(0);
            textView.setText((CharSequence)string2);
            linearLayout.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            linearLayout2.setPadding(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
            textView.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            textView2.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        } else {
            textView.setVisibility(0);
            textView.setText((CharSequence)string2);
            linearLayout.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            linearLayout2.setPadding(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(2));
            textView.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
            textView2.setPadding(this.pxToDp(15), this.pxToDp(0), this.pxToDp(2), this.pxToDp(7));
        }
        message2 = (NinePatchDrawable)linearLayout.getBackground();
        message2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }

    private void setMargins(View view, int n, int n2, int n3, int n4) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            marginLayoutParams.setMargins(n, n2, n3, n4);
            view.requestLayout();
        }
    }

    private int pxToDp(int n) {
        int n2 = n;
        float f2 = this.context.getResources().getDisplayMetrics().density;
        return (int)((float)n2 * f2);
    }

    public int getItemViewType(int n) {
        return this.items.get(n).getType();
    }

    public int getItemCount() {
        return this.items.size();
    }

    private void setIntegrationSource(ImageView imageView, ImageView imageView2, int n) {
        imageView.setVisibility(8);
        imageView2.setVisibility(8);
        int n2 = this.hippoColorConfig.getHippoSourceType();
        switch (n) {
            case 5: {
                imageView.setImageResource(R.drawable.hippo_ic_email);
                imageView.setVisibility(0);
                imageView.setColorFilter((ColorFilter)new PorterDuffColorFilter(n2, PorterDuff.Mode.SRC_IN));
                break;
            }
            case 6: {
                imageView2.setVisibility(0);
                break;
            }
            case 7: {
                imageView.setImageResource(R.drawable.hippo_ic_sms);
                imageView.setVisibility(0);
                imageView.setColorFilter((ColorFilter)new PorterDuffColorFilter(n2, PorterDuff.Mode.SRC_IN));
                break;
            }
            default: {
                imageView.setVisibility(8);
                imageView2.setVisibility(8);
            }
        }
    }

    private void showImageDialog(Context context, String string2, ImageView imageView, Message message) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Intent intent = new Intent((Context)this.context, ImageDisplayActivity.class);
            Image image = new Image(message.getImageUrl(), message.getThumbnailUrl(), message.getMuid(), message.getSentAtUtc(), "");
            intent.putExtra("image", (Serializable)image);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setTimeView(TextView textView, RelativeLayout relativeLayout, View view, int n, Message message, int n2) {
        Object object = n == 1 ? (TextView)view : (LinearLayout)view;
        int n3 = 0;
        int n4 = 0;
        n3 = textView.getLineCount();
        if (n3 != 0) {
            n4 = textView.getLayout().getLineStart(n3) - textView.getLayout().getLineStart(n3 - 1);
        }
        String string2 = textView.getText().toString();
        boolean bl = n3 > 1;
        String string3 = bl ? string2.substring(textView.getText().toString().length() - n4, textView.getText().toString().length()) : textView.getText().toString();
        float f2 = (float)relativeLayout.getMeasuredWidth() - textView.getPaint().measureText(string3);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)object.getLayoutParams();
        if (f2 > (float)this.context.getResources().getDimensionPixelSize(R.dimen.height_ll_time)) {
            if (bl) {
                layoutParams.addRule(11);
                layoutParams.addRule(1, -1);
                message.setTimeIndex(2);
            } else {
                layoutParams.addRule(11, 0);
                layoutParams.addRule(1, textView.getId());
                message.setTimeIndex(3);
            }
            layoutParams.addRule(3, -1);
            layoutParams.addRule(8, textView.getId());
        } else if (!textView.getText().toString().contains("/n")) {
            layoutParams.addRule(8, -1);
            layoutParams.addRule(1, -1);
            layoutParams.addRule(3, textView.getId());
            layoutParams.addRule(11);
            message.setTimeIndex(1);
        }
        object.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private String convertSeconds(int n) {
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        int n4 = n % 60;
        String string2 = n2 > 0 ? String.valueOf(n2) + " h" : "";
        String string3 = (n3 < 10 && n3 > 0 && n2 > 0 ? "0" : "") + (n3 > 0 ? (n2 > 0 && n4 == 0 ? String.valueOf(n3) : String.valueOf(n3) + " min") : "");
        String string4 = n4 == 0 && (n2 > 0 || n3 > 0) ? "" : (n4 < 10 && (n2 > 0 || n3 > 0) ? "0" : "") + String.valueOf(n4) + " sec";
        return string2 + (n2 > 0 ? " " : "") + string3 + (n3 > 0 ? " " : "") + string4;
    }

    private String getMessage(Message message, int n) {
        String string2 = "The video call ended";
        String string3 = "you";
        if (n == 18) {
            if (message.getUserId().intValue() != AgentCommonData.getUserData().getUserId().intValue()) {
                string3 = message.getfromName();
            }
            string2 = message.getMessageState() != null && message.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? this.customerName + " missed a voice call with " + string3 : this.customerName + " missed a video call with " + string3) : (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended");
        } else {
            string3 = "You";
            if (!this.isChatAssignToMe) {
                string3 = this.agentName;
            }
            string2 = message.getMessageState() != null && message.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? string3 + " missed a voice call with " + message.getfromName() : string3 + " missed a video call with " + message.getfromName()) : (!TextUtils.isEmpty((CharSequence)message.getCallType()) && message.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended");
        }
        return string2;
    }

    private void setTime(AppCompatTextView appCompatTextView, String string2) {
        appCompatTextView.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(string2)));
    }

    private void showImageView(ImageView imageView, Message message) {
        String string2 = Util.getFileName(message.getFileName(), message.getMuid());
        String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.toString()));
        HippoLog.e("localPath", "localPath = " + string3);
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
        Glide.with((FragmentActivity)this.context).load(TextUtils.isEmpty((CharSequence)string3) ? message.getThumbnailUrl() : new File(string3)).apply((BaseRequestOptions)requestOptions).into(imageView);
    }

    private void setMessageStatus(AppCompatImageView appCompatImageView, int n, Boolean bl) {
        if (bl.booleanValue()) {
            switch (n) {
                case 1: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single_white));
                    break;
                }
                case 4: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 2: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 5: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                    break;
                }
                case 4: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 2: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 5: {
                    appCompatImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout relativeLayout, LinearLayoutCompat linearLayoutCompat, Message message, Boolean bl) {
        int n = message.getImageHeight();
        int n2 = message.getImageWidth();
        if (n != 0 && message.getImageWidth() != 0) {
            float f2 = n / n2;
            if (f2 < 1.0f) {
                relativeLayout.getLayoutParams().height = (int)((float)this.pxToDp(250) * f2);
                relativeLayout.getLayoutParams().width = this.pxToDp(250);
                linearLayoutCompat.getLayoutParams().width = bl.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            } else {
                relativeLayout.getLayoutParams().height = this.pxToDp(250);
                relativeLayout.getLayoutParams().width = this.pxToDp(250);
                linearLayoutCompat.getLayoutParams().width = bl.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            }
        } else {
            relativeLayout.getLayoutParams().height = this.pxToDp(250);
            relativeLayout.getLayoutParams().width = this.pxToDp(250);
            linearLayoutCompat.getLayoutParams().width = bl != false ? this.pxToDp(255) : this.pxToDp(252);
        }
    }

    private void setVideoDownloadStatus(LinearLayout linearLayout, ImageView imageView, TextView textView, ProgressWheel progressWheel, Message message, int n) {
        String string2 = Util.getFileName(message.getFileName(), message.getMuid());
        String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(message.getDocumentType()));
        linearLayout.setVisibility(8);
        progressWheel.setVisibility(8);
        imageView.setVisibility(8);
        if (!(TextUtils.isEmpty((CharSequence)string3) || message.getMessageStatus() != 3 && message.getMessageStatus() != 2 && message.getMessageStatus() != 1)) {
            imageView.setVisibility(0);
        } else {
            switch (message.getDownloadStatus()) {
                case 1: {
                    progressWheel.setVisibility(0);
                    break;
                }
                case 3: {
                    imageView.setVisibility(0);
                    break;
                }
                default: {
                    linearLayout.setVisibility(0);
                    textView.setText((CharSequence)message.getFileSize());
                }
            }
        }
    }

    private void setVideoUiStatus(boolean bl, Message message, LinearLayout linearLayout, ImageView imageView, AppCompatButton appCompatButton, AppCompatButton appCompatButton2, ProgressWheel progressWheel) {
        if (bl) {
            linearLayout.setVisibility(8);
            imageView.setVisibility(8);
            appCompatButton.setVisibility(8);
            appCompatButton2.setVisibility(8);
            progressWheel.setVisibility(8);
            if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                String string2 = Util.getFileName(message.getFileName(), message.getMuid());
                String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(message.getDocumentType()));
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    linearLayout.setVisibility(0);
                } else {
                    imageView.setVisibility(0);
                }
            } else if (message.getUploadStatus() == 1) {
                progressWheel.setVisibility(0);
            } else if (message.getIsMessageExpired() == 1) {
                appCompatButton.setVisibility(0);
                appCompatButton2.setVisibility(0);
            }
        }
    }

    private void setVideoUploadStatus(AppCompatTextView appCompatTextView, ProgressWheel progressWheel, AppCompatButton appCompatButton, ImageView imageView, Message message, ImageView imageView2) {
        switch (message.getUploadStatus()) {
            case 0: {
                if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                    progressWheel.setVisibility(8);
                    appCompatButton.setVisibility(8);
                    imageView.setVisibility(0);
                    break;
                }
                appCompatButton.setVisibility(0);
                progressWheel.setVisibility(8);
                imageView.setVisibility(8);
                break;
            }
            case 1: {
                progressWheel.setVisibility(0);
                appCompatButton.setVisibility(8);
                imageView.setVisibility(8);
                break;
            }
            case 3: {
                progressWheel.setVisibility(8);
                appCompatButton.setVisibility(8);
                if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                    imageView.setVisibility(0);
                    break;
                }
                imageView.setVisibility(8);
                break;
            }
            default: {
                appCompatTextView.append((CharSequence)"10");
                progressWheel.setVisibility(8);
                appCompatButton.setVisibility(8);
                if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                    imageView.setVisibility(0);
                    break;
                }
                imageView.setVisibility(8);
            }
        }
        if (message.getIsMessageExpired() == 1) {
            appCompatButton.setVisibility(0);
        } else if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
            progressWheel.setVisibility(8);
            appCompatButton.setVisibility(8);
            imageView.setVisibility(0);
            String string2 = Util.getFileName(message.getFileName(), message.getMuid());
            String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.VIDEO.toString()));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                imageView2.setVisibility(0);
                imageView.setVisibility(8);
            }
        }
    }

    private void setFileCLickListener(LinearLayoutCompat linearLayoutCompat, final Message message, final AppCompatImageView appCompatImageView, final int n) {
        appCompatImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FuguAgentMessageAdapter.this.onPlaySound(message, appCompatImageView, n);
            }
        });
        linearLayoutCompat.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                block4: {
                    try {
                        if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            return;
                        }
                        String string2 = Util.getFileName(message.getFileName(), message.getMuid());
                        String string3 = FileManager.getInstance().getLocalPath(string2, FuguAppConstant.FOLDER_TYPE.get(message.getDocumentType()));
                        if (!TextUtils.isEmpty((CharSequence)string3)) {
                            FileManager.getInstance().openFileInDevice((Context)FuguAgentMessageAdapter.this.context, string3, new FileManager.FileCopyListener(){

                                @Override
                                public void onCopingFile(boolean bl, FileuploadModel fileuploadModel) {
                                }

                                @Override
                                public void largeFileSize() {
                                }

                                @Override
                                public void onError() {
                                    Toast.makeText((Context)FuguAgentMessageAdapter.this.context, (CharSequence)FuguAgentMessageAdapter.this.context.getString(R.string.no_handler), (int)1).show();
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        if (!HippoConfig.DEBUG) break block4;
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView imageView, final AppCompatImageView appCompatImageView, ProgressWheel progressWheel, AppCompatImageView appCompatImageView2, AppCompatImageView appCompatImageView3, final Message message, final int n) {
        appCompatImageView2.setVisibility(8);
        progressWheel.setVisibility(8);
        appCompatImageView3.setVisibility(8);
        appCompatImageView.setVisibility(8);
        String string2 = Util.getFileName(message.getFileName(), message.getMuid());
        String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(message.getDocumentType()));
        HippoLog.v("localPath", "localPath ********* = " + string3);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                appCompatImageView.setVisibility(0);
            }
        } else {
            switch (message.getDownloadStatus()) {
                case 1: {
                    progressWheel.setVisibility(0);
                    break;
                }
                case 3: {
                    if (!message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) break;
                    appCompatImageView.setVisibility(0);
                    break;
                }
                default: {
                    appCompatImageView2.setVisibility(0);
                }
            }
        }
        appCompatImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FuguAgentMessageAdapter.this.onPlaySound(message, appCompatImageView, n);
            }
        });
    }

    private void setFileUploadStatus(ImageView imageView, final AppCompatImageView appCompatImageView, ProgressWheel progressWheel, AppCompatImageView appCompatImageView2, AppCompatImageView appCompatImageView3, final Message message, final int n) {
        block10: {
            block11: {
                block9: {
                    appCompatImageView2.setVisibility(8);
                    progressWheel.setVisibility(8);
                    appCompatImageView3.setVisibility(8);
                    appCompatImageView.setVisibility(8);
                    if (message.getIsMessageExpired() != 1) break block9;
                    appCompatImageView3.setVisibility(0);
                    break block10;
                }
                if (message.getMessageStatus() != 4) break block11;
                switch (message.getUploadStatus()) {
                    case 0: {
                        appCompatImageView3.setVisibility(0);
                        break;
                    }
                    case 1: {
                        progressWheel.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            appCompatImageView.setVisibility(0);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            String string2 = Util.getFileName(message.getFileName(), message.getMuid());
            String string3 = FileManager.getInstance().getLocalPath(string2, (String)FOLDER_TYPE.get(message.getDocumentType()));
            HippoLog.v("localPath", "localPath ********* = " + message.getFileName());
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                    appCompatImageView.setVisibility(0);
                }
            } else {
                appCompatImageView2.setVisibility(0);
            }
        }
        appCompatImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FuguAgentMessageAdapter.this.onPlaySound(message, appCompatImageView, n);
            }
        });
    }

    private void onPlaySound(final Message message, final AppCompatImageView appCompatImageView, final int n) {
        Object object;
        if (!TextUtils.isEmpty((CharSequence)this.context.audioMuid)) {
            if (this.context.audioMuid.equalsIgnoreCase(message.getMuid())) {
                this.context.audioMuid = "";
                message.setAudioPlaying(false);
                appCompatImageView.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                this.notifyItemChanged(n);
                return;
            }
            object = this.items.get(this.context.playingItem);
            ((EventItem)object).getEvent().setAudioPlaying(false);
            this.notifyItemChanged(this.context.playingItem);
        }
        object = Util.getFileName(message.getFileName(), message.getMuid());
        String string2 = FileManager.getInstance().getLocalPath((String)object, (String)FOLDER_TYPE.get(message.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer((Context)this.context, string2, new CommonMediaPlayer.MediaPlayerStatus(){

            @Override
            public void onPlaying() {
                message.setAudioPlaying(true);
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = message.getMuid();
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.playingItem = n;
                appCompatImageView.setImageResource(R.drawable.hippo_song_pause);
                message.setAudioPlaying(true);
                FuguAgentMessageAdapter.this.notifyItemChanged(n);
            }

            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = "";
                appCompatImageView.setImageResource(R.drawable.hippo_music_player);
                message.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguAgentMessageAdapter.this.notifyItemChanged(n);
            }

            @Override
            public void onError(MediaPlayer mediaPlayer, int n3, int n2) {
                ((FuguAgentMessageAdapter)FuguAgentMessageAdapter.this).context.audioMuid = "";
                appCompatImageView.setImageResource(R.drawable.hippo_music_player);
                message.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguAgentMessageAdapter.this.notifyItemChanged(n);
            }
        });
    }

    private void setDownloadClick(final AppCompatImageView appCompatImageView, final ProgressWheel progressWheel, final Message message, final int n) {
        if (!this.context.isNetworkAvailable()) {
            return;
        }
        appCompatImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2;
                String string3;
                if (!FuguAgentMessageAdapter.this.context.checkPermission()) {
                    FuguAgentMessageAdapter.this.context.readExternalStorage();
                    return;
                }
                progressWheel.setVisibility(0);
                appCompatImageView.setVisibility(8);
                String string4 = "image";
                if (message.getMessageType() == 11) {
                    string4 = message.getDocumentType();
                }
                if (TextUtils.isEmpty((CharSequence)(string3 = message.getFileName()))) {
                    string2 = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    string3 = "Hippochat_" + string2 + ".jpg";
                }
                string2 = Util.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(string4));
                int n2 = FuguAgentMessageAdapter.this.downloadFileFromUrl(string2, string3, message, n);
                message.setDownloadId(n2);
            }
        });
    }

    private int downloadFileFromUrl(String string2, String string3, final Message message, final int n) {
        if (!string3.contains(message.getMuid())) {
            String string4 = message.getMuid();
            String string5 = Util.getExtension(string3);
            String string6 = Util.extractFileNameWithoutSuffix(string3);
            string3 = string6 + "_" + string4 + "." + string5;
        }
        this.currentProgress = -1;
        return PRDownloader.download((String)message.getFileUrl(), (String)string2, (String)string3).build().setOnStartOrResumeListener(new OnStartOrResumeListener(){

            public void onStartOrResume() {
                HippoLog.v(TAG, "OnStartOrResumeListener");
            }
        }).setOnPauseListener(new OnPauseListener(){

            public void onPause() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_PAUSED.downloadStatus);
            }
        }).setOnProgressListener(new OnProgressListener(){

            public void onProgress(Progress progress) {
                int n = (int)(progress.currentBytes * 100L / progress.totalBytes);
                if (FuguAgentMessageAdapter.this.currentProgress < n) {
                    ++FuguAgentMessageAdapter.this.currentProgress;
                }
                message.setCurrentprogress(n);
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
            }
        }).start(new OnDownloadListener(){

            public void onDownloadComplete() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                Intent intent = FuguAgentMessageAdapter.this.getIntentExtraData(n, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguAgentMessageAdapter.this.context).sendBroadcast(intent);
            }

            public void onError(Error error) {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                Intent intent = FuguAgentMessageAdapter.this.getIntentExtraData(n, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguAgentMessageAdapter.this.context).sendBroadcast(intent);
            }
        });
    }

    private Intent getIntentExtraData(int n, int n2, String string2, int n3) {
        Intent intent = new Intent("hippo_progress_intent");
        intent.putExtra("hippo_position", n);
        intent.putExtra("hippo_progress", n2);
        intent.putExtra("muid", string2);
        intent.putExtra("hippo_statusUpload", n3);
        return intent;
    }

    private void messageStatusTick(Activity activity, ImageView imageView, Message message) {
        switch (message.getMessageStatus()) {
            case 4: 
            case 5: 
            case 6: {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_ic_waiting));
                imageView.setVisibility(0);
                imageView.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 3: {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_double));
                imageView.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                imageView.setVisibility(0);
                break;
            }
            case 1: {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_single));
                imageView.setVisibility(0);
                imageView.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 2: {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_double));
                if (Build.VERSION.SDK_INT >= 21) {
                    imageView.getDrawable().setTint(ContextCompat.getColor((Context)activity, (int)R.color.fugu_drawable_color));
                }
                imageView.setVisibility(0);
                imageView.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            default: {
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)activity, (int)R.drawable.fugu_tick_single));
                imageView.setVisibility(0);
                imageView.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
            }
        }
    }

    private void setUploadClick(AppCompatImageView appCompatImageView, ProgressWheel progressWheel, Message message) {
        appCompatImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!FuguAgentMessageAdapter.this.context.isNetworkAvailable() || FuguAgentMessageAdapter.this.mOnRetry != null) {
                    // empty if block
                }
            }
        });
    }

    private boolean setOtherMessageBackground(View view, View view2, int n, TextView textView) {
        int n2 = this.pxToDp(1);
        int n3 = this.pxToDp(6);
        int n4 = this.pxToDp(7);
        int n5 = this.pxToDp(8);
        if (this.items.size() == 1) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            view.setPadding(n5, n4, 0, n2);
            view2.setPadding(this.pxToDp(13), n3, n3, n3);
            return true;
        }
        if (n == 0) {
            view.setPadding(n5, n4, 0, n2);
            view2.setPadding(this.pxToDp(13), n3, n3, n3);
            if (textView != null) {
                textView.setPadding(n5, 0, 0, 0);
            }
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            return true;
        }
        if (this.getItemViewType(n - 1) == 1 || this.getItemViewType(n - 1) == 19 || this.getItemViewType(n - 1) == 13) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            if (textView != null) {
                textView.setVisibility(8);
            }
            view.setPadding(this.pxToDp(15), n2, 0, n2);
            view2.setPadding(n3, n3, n3, n3);
            return false;
        }
        view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        view.setPadding(n5, n4, 0, n2);
        view2.setPadding(this.pxToDp(13), n3, n3, n3);
        return true;
    }

    private boolean setSelfMessageBackground(View view, View view2, int n) {
        int n2 = this.pxToDp(1);
        int n3 = this.pxToDp(6);
        int n4 = this.pxToDp(7);
        if (this.items.size() == 1) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            view.setPadding(0, n3, n4, n2);
            view2.setPadding(n3, n3, this.pxToDp(17), n3);
            return true;
        }
        if (n == 0) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            view.setPadding(0, n3, this.pxToDp(7), n4);
            view2.setPadding(n3, n3, this.pxToDp(17), n3);
            return true;
        }
        if (this.getItemViewType(n - 1) == 2 || this.getItemViewType(n - 1) == 18 || this.getItemViewType(n - 1) == 10 || this.getItemViewType(n - 1) == 12) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            view.setPadding(0, n2, this.pxToDp(15), n2);
            view2.setPadding(n3, n3, n3, n3);
            return false;
        }
        view2.setBackgroundResource(R.drawable.hippo_chat_bg_right);
        view.setPadding(0, n3, n4, n2);
        view2.setPadding(n3, n3, this.pxToDp(17), n3);
        return true;
    }

    private boolean setFileMessageOther(View view, View view2, int n, TextView textView, String string2) {
        int n2 = this.pxToDp(1);
        int n3 = this.pxToDp(6);
        int n4 = this.pxToDp(7);
        int n5 = this.pxToDp(8);
        if (this.items.size() == 1) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            view.setPadding(n5, n4, 0, n2);
            view2.setPadding(this.pxToDp(13), n3, n3, n3);
            if (textView != null) {
                textView.setVisibility(0);
                textView.setText((CharSequence)string2);
            } else if (TextUtils.isEmpty((CharSequence)string2)) {
                textView.setVisibility(8);
            }
            return true;
        }
        if (n == 0) {
            view.setPadding(n5, n4, 0, n2);
            view2.setPadding(this.pxToDp(13), n3, n3, n3);
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            if (textView != null) {
                textView.setVisibility(0);
                textView.setText((CharSequence)string2);
            } else if (TextUtils.isEmpty((CharSequence)string2)) {
                textView.setVisibility(8);
            }
            return true;
        }
        if (this.getItemViewType(n - 1) == 1 || this.getItemViewType(n - 1) == 19 || this.getItemViewType(n - 1) == 13 || this.getItemViewType(n - 1) == 11) {
            view2.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
            view.setPadding(this.pxToDp(15), n2, 0, n2);
            view2.setPadding(n3, n3, n3, n3);
            if (textView != null) {
                textView.setVisibility(8);
            }
            return true;
        }
        view2.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        view.setPadding(n5, n4, 0, n2);
        view2.setPadding(this.pxToDp(13), n3, n3, n3);
        if (textView != null) {
            textView.setVisibility(0);
            textView.setText((CharSequence)string2);
        } else if (TextUtils.isEmpty((CharSequence)string2)) {
            textView.setVisibility(8);
        }
        return true;
    }

    private void setImage(Activity activity, AppCompatImageView appCompatImageView, String string2) {
        try {
            HippoLog.e(TAG, "thumbnailUrl = " + string2);
            RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder));
            Glide.with((Activity)activity).load(string2).apply((BaseRequestOptions)requestOptions).into((ImageView)appCompatImageView);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class DateViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvDate;

        public DateViewHolder(View view) {
            super(view);
            this.tvDate = (TextView)view.findViewById(R.id.tvDate);
        }
    }

    class AssignmentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvAssignment;

        public AssignmentViewHolder(View view) {
            super(view);
            this.tvAssignment = (TextView)view.findViewById(R.id.tvAssignment);
        }
    }

    class OtherVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private LinearLayout llDownload;
        private TextView tvUserName;
        private TextView tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime;
        private AppCompatTextView tvImgWithText;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public OtherVideoMessageViewHolder(final View view, final OnRecyclerListener onRecyclerListener) {
            super(view);
            this.llRoot = (LinearLayoutCompat)view.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)view.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)view.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)view.findViewById(R.id.rlImageMessage);
            this.tvUserName = (TextView)view.findViewById(R.id.tvUserName);
            this.tvFileSize = (TextView)view.findViewById(R.id.tvFileSize);
            this.ivImageMsg = (AppCompatImageView)view.findViewById(R.id.ivImageMsg);
            this.tvImageTime = (AppCompatTextView)view.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (AppCompatTextView)view.findViewById(R.id.tvImgWithText);
            this.ivPlay = (ImageView)view.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)view.findViewById(R.id.ivDownload);
            this.progressBar = (ProgressWheel)view.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)view.findViewById(R.id.user_image);
            this.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view2) {
                    onRecyclerListener.onItemClick((View)OtherVideoMessageViewHolder.this.llRoot, view, OtherVideoMessageViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    class SelfVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llDownload;
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatImageView ivMessageState;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private AppCompatTextView tvImageTime;
        private TextView tvFileSize;
        private TextView tvImgWithText;
        private AppCompatButton btnRetry;
        private AppCompatButton btnCancel;
        private ProgressWheel circle_progress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SelfVideoMessageViewHolder(View view) {
            super(view);
            this.llRoot = (LinearLayoutCompat)view.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)view.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)view.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)view.findViewById(R.id.rlImageMessage);
            this.ivImageMsg = (AppCompatImageView)view.findViewById(R.id.ivImageMsg);
            this.ivPlay = (ImageView)view.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)view.findViewById(R.id.ivDownload);
            this.ivMessageState = (AppCompatImageView)view.findViewById(R.id.ivMessageState);
            this.tvFileSize = (TextView)view.findViewById(R.id.tvFileSize);
            this.tvImageTime = (AppCompatTextView)view.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (TextView)view.findViewById(R.id.tvImgWithText);
            this.circle_progress = (ProgressWheel)view.findViewById(R.id.circle_progress);
            this.btnRetry = (AppCompatButton)view.findViewById(R.id.btnRetry);
            this.btnCancel = (AppCompatButton)view.findViewById(R.id.btnCancel);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
        }
    }

    class SentFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llImages;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFileUpload;
        private ImageView ivFileImage;
        private ImageView ivMessageState;
        private ProgressWheel circleProgress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SentFileViewHolder(@NonNull View view) {
            super(view);
            this.llRoot = (LinearLayoutCompat)view.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)view.findViewById(R.id.llMessage);
            this.llImages = (LinearLayoutCompat)view.findViewById(R.id.llImages);
            this.tvFileName = (TextView)view.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)view.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)view.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)view.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)view.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)view.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)view.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)view.findViewById(R.id.ivFileUpload);
            this.ivMessageState = (ImageView)view.findViewById(R.id.ivMessageState);
            this.circleProgress = (ProgressWheel)view.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
        }
    }

    class ReceivedFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llFile;
        private LinearLayoutCompat llImages;
        private TextView tvUserName;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private ImageView ivFileImage;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileUpload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public ReceivedFileViewHolder(@NonNull View view) {
            super(view);
            this.llRoot = (LinearLayoutCompat)view.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)view.findViewById(R.id.llMessage);
            this.llFile = (LinearLayoutCompat)view.findViewById(R.id.llFile);
            this.llImages = (LinearLayoutCompat)view.findViewById(R.id.llImages);
            this.tvUserName = (TextView)view.findViewById(R.id.tvUserName);
            this.tvFileName = (TextView)view.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)view.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)view.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)view.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)view.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)view.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)view.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)view.findViewById(R.id.ivFileUpload);
            this.progressBar = (ProgressWheel)view.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)view.findViewById(R.id.user_image);
        }
    }

    class VideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;
        private ImageView userImage;
        private LinearLayout llMessage;
        private LinearLayout llRoot;

        public VideoViewHolder(View view) {
            super(view);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.callAgain = (TextView)view.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)view.findViewById(R.id.tvDuration);
            this.userImage = (ImageView)view.findViewById(R.id.user_image);
            this.ivCallIcon = (ImageView)view.findViewById(R.id.ivCallIcon);
            this.llMessage = (LinearLayout)view.findViewById(R.id.llMessage);
            this.llRoot = (LinearLayout)view.findViewById(R.id.llMessage);
        }
    }

    class SelfVideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;

        public SelfVideoViewHolder(View view) {
            super(view);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.callAgain = (TextView)view.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)view.findViewById(R.id.tvDuration);
            this.ivCallIcon = (ImageView)view.findViewById(R.id.ivCallIcon);
        }
    }

    class UserConcentViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout main_root;
        private LinearLayout llRootRight;
        private LinearLayout llChatRight;
        private LinearLayout llTimeRight;
        private RelativeLayout rlMessagesRight;
        private TextView tvNameRight;
        private TextView tvMsgRight;
        private TextView tvTimeRight;
        private ImageView ivMessageStateRight;
        private TagContainerLayout tagLayout;
        private TextView tvTagsTime;
        private LinearLayout llChatLeft;
        private LinearLayout llTime;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private LinearLayout leftrootview;

        public UserConcentViewHolder(@NonNull View view) {
            super(view);
            this.main_root = (LinearLayout)view.findViewById(R.id.main_root);
            this.llRootRight = (LinearLayout)view.findViewById(R.id.llRootRight);
            this.llChatRight = (LinearLayout)view.findViewById(R.id.llChatRight);
            this.llTimeRight = (LinearLayout)view.findViewById(R.id.llTimeRight);
            this.rlMessagesRight = (RelativeLayout)view.findViewById(R.id.rlMessagesRight);
            this.tvNameRight = (TextView)view.findViewById(R.id.tvNameRight);
            this.tvMsgRight = (TextView)view.findViewById(R.id.tvMsgRight);
            this.tvTimeRight = (TextView)view.findViewById(R.id.tvTimeRight);
            this.ivMessageStateRight = (ImageView)view.findViewById(R.id.ivMessageStateRight);
            this.tagLayout = (TagContainerLayout)view.findViewById(R.id.tagLayout);
            this.tvTagsTime = (TextView)view.findViewById(R.id.tvTagsTime);
            this.llChatLeft = (LinearLayout)view.findViewById(R.id.llChatLeft);
            this.llTime = (LinearLayout)view.findViewById(R.id.llTime);
            this.tvUserName = (TextView)view.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.leftrootview = (LinearLayout)view.findViewById(R.id.leftrootview);
        }
    }

    class SelfMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llRoot;
        private LinearLayout llTime;
        private TextView tvMsg;
        private TextView tvTime;
        private TextView tvName;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private LinearLayout llChat;
        private ImageView ivMessageState;
        private ImageView ivMsgImage;
        private ProgressBar pbLoading;
        private Button btnRetry;
        private Button btnCancel;
        private TextView tvTryAgain;
        private TextView tvCancel;
        private LinearLayout llRetry;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SelfMessageViewHolder(View view) {
            super(view);
            this.llRoot = (LinearLayout)view.findViewById(R.id.llRoot);
            this.llTime = (LinearLayout)view.findViewById(R.id.llTime);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.tvName = (TextView)view.findViewById(R.id.tvName);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.llChat = (LinearLayout)view.findViewById(R.id.llMessageBg);
            this.rlImageMessage = (RelativeLayout)view.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)view.findViewById(R.id.rlMessages);
            this.ivMessageState = (ImageView)view.findViewById(R.id.ivMessageState);
            this.ivMsgImage = (ImageView)view.findViewById(R.id.ivMsgImage);
            this.pbLoading = (ProgressBar)view.findViewById(R.id.pbLoading);
            this.btnRetry = (Button)view.findViewById(R.id.btnRetry);
            this.btnCancel = (Button)view.findViewById(R.id.btnCancel);
            this.tvTryAgain = (TextView)view.findViewById(R.id.tvTryAgain);
            this.tvCancel = (TextView)view.findViewById(R.id.tvCancel);
            this.llRetry = (LinearLayout)view.findViewById(R.id.llRetry);
            this.rlCustomAction = (RelativeLayout)view.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)view.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)view.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)view.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)view.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = view.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)view.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)view.findViewById(R.id.llTextualContent);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
        }
    }

    class OtherMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llRoot;
        private LinearLayout llChatLeft;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private ImageView ivMsgImage;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView userImage;

        public OtherMessageViewHolder(View view) {
            super(view);
            this.llRoot = (LinearLayout)view.findViewById(R.id.llRoot);
            this.llChatLeft = (LinearLayout)view.findViewById(R.id.llMessageBg);
            this.tvUserName = (TextView)view.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)view.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.rlImageMessage = (RelativeLayout)view.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)view.findViewById(R.id.rlMessages);
            this.ivMsgImage = (ImageView)view.findViewById(R.id.ivMsgImage);
            this.rlCustomAction = (RelativeLayout)view.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)view.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)view.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)view.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)view.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = view.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)view.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)view.findViewById(R.id.llTextualContent);
            this.messageSourceType = (ImageView)view.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)view.findViewById(R.id.message_source_type1);
            this.userImage = (ImageView)view.findViewById(R.id.user_image);
        }
    }

    public static interface OnRetryListener {
        public void onRetry(String var1, String var2, int var3, String var4);

        public void onMessageRetry(String var1, int var2);

        public void onMessageCancel(String var1, int var2);

        public void onFileMessageRetry(String var1, int var2);
    }
}

