/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.model.broadcastResponse.User;
import com.hippo.database.CommonData;
import java.util.List;

public class FleetListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<User> arrayList;
    private LayoutInflater inflater;
    private int type = 1;
    private HippoColorConfig hippoColorConfig;

    public FleetListAdapter(Context context, int n, List<User> list) {
        this.arrayList = list;
        this.type = n;
        this.inflater = LayoutInflater.from((Context)context);
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, viewGroup, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int n) {
        User user = this.arrayList.get(n);
        viewHolder.textView.setText((CharSequence)user.getFullName());
        viewHolder.textView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        if (this.type == 3) {
            viewHolder.checkBox.setVisibility(8);
        }
        viewHolder.textView.setTypeface(null, 0);
        viewHolder.checkBox.setChecked(user.isSelected());
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RadioButton radioButton;
        LinearLayout mainLayout;

        public ViewHolder(View view) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)view.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)view.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)view.findViewById(R.id.main_layout);
            this.radioButton.setVisibility(8);
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ViewHolder.this.getAdapterPosition();
                    if (n == 0) {
                        boolean bl = !((User)FleetListAdapter.this.arrayList.get(0)).isSelected();
                        for (int j = 0; j < FleetListAdapter.this.arrayList.size(); ++j) {
                            ((User)FleetListAdapter.this.arrayList.get(j)).setSelected(bl);
                        }
                    } else {
                        ((User)FleetListAdapter.this.arrayList.get(n)).setSelected(!((User)FleetListAdapter.this.arrayList.get(n)).isSelected());
                        if (!((User)FleetListAdapter.this.arrayList.get(n)).isSelected()) {
                            ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(false);
                        } else {
                            for (int j = 1; j < FleetListAdapter.this.arrayList.size(); ++j) {
                                if (!((User)FleetListAdapter.this.arrayList.get(j)).isSelected()) {
                                    ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(false);
                                    break;
                                }
                                ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(true);
                            }
                        }
                    }
                    FleetListAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }
}

