/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.text.Html;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.ItemClickListener;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class ChatListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ItemClickListener {
    private static final String TAG = ChatListAdapter.class.getSimpleName();
    private Context context;
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    private RecyclerView recyclerView;
    private Integer userId;
    private Callback callback;
    private ArrayList<Object> conversationList;
    private boolean isAllChatClicked;
    private int fragmentType;

    public ChatListAdapter(Integer n, boolean bl, int n2, ArrayList<Object> arrayList, Callback callback, RecyclerView recyclerView) {
        this.userId = n;
        this.isAllChatClicked = bl;
        this.fragmentType = n2;
        this.conversationList = arrayList;
        this.callback = callback;
        this.recyclerView = recyclerView;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        if (n == 2) {
            View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_list_item_header, viewGroup, false);
            return new ViewHolderHeader(view);
        }
        if (n == 3) {
            View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_custom_loading_list_item, viewGroup, false);
            return new ProgressBarViewHolder(view);
        }
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_list_item_chat, viewGroup, false);
        return new ViewHolder(view, this);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder instanceof ViewHolder) {
            String[] stringArray;
            ViewHolder viewHolder2 = (ViewHolder)viewHolder;
            Conversation conversation = (Conversation)this.conversationList.get(n);
            if (conversation.getMessage_type() == 18) {
                viewHolder2.tvMessage.setText((CharSequence)this.getMessageData(conversation));
            } else if (conversation.getMessage_type() == 11) {
                viewHolder2.tvMessage.setText((CharSequence)this.getFileMessageData(conversation));
            } else if (conversation.getMessage_type() == 19) {
                viewHolder2.tvMessage.setText((CharSequence)"Payment initiated");
            } else if (!TextUtils.isEmpty((CharSequence)conversation.getMessage())) {
                if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(this.userId)) {
                    viewHolder2.tvMessage.setText((CharSequence)("You: " + Html.fromHtml((String)conversation.getMessage())));
                } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(this.userId)) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        stringArray = conversation.getLast_sent_by_full_name().split("\\ ");
                        viewHolder2.tvMessage.setText((CharSequence)(stringArray[0] + ": " + Html.fromHtml((String)conversation.getMessage())));
                    } else {
                        viewHolder2.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                    }
                } else {
                    viewHolder2.tvMessage.setText((CharSequence)Html.fromHtml((String)conversation.getMessage()));
                }
            } else if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(this.userId)) {
                viewHolder2.tvMessage.setText((CharSequence)"You sent a photo");
            } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(this.userId)) {
                if (conversation.getLast_sent_by_full_name().contains(" ")) {
                    stringArray = conversation.getLast_sent_by_full_name().split("\\ ");
                    viewHolder2.tvMessage.setText((CharSequence)(stringArray[0] + " sent a photo"));
                } else {
                    viewHolder2.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + " sent a Photo"));
                }
            } else {
                viewHolder2.tvMessage.setText((CharSequence)"You received a photo");
            }
            boolean bl = conversation.isA2AChat();
            if (conversation.getAgentName() != null && !conversation.getAgentName().isEmpty() && this.isAllChatClicked && !bl) {
                viewHolder2.tvAgentName.setVisibility(0);
                viewHolder2.tvAgentName.setText((CharSequence)conversation.getAgentName());
            } else {
                viewHolder2.tvAgentName.setVisibility(8);
            }
            viewHolder2.tvName.setText((CharSequence)conversation.getLabel());
            if (!TextUtils.isEmpty((CharSequence)conversation.getBotChannelName())) {
                viewHolder2.tvChannelName.setVisibility(0);
                viewHolder2.tvChannelName.setText((CharSequence)conversation.getBotChannelName());
            } else {
                viewHolder2.tvChannelName.setVisibility(8);
            }
            if (!conversation.getUnreadCount().equals(0)) {
                viewHolder2.tvUnread.setVisibility(0);
                viewHolder2.tvUnread.setText((CharSequence)String.valueOf(conversation.getUnreadCount()));
            } else {
                viewHolder2.tvUnread.setVisibility(8);
            }
            float f2 = this.context.getResources().getDisplayMetrics().density;
            if (conversation.getStatus().intValue() == MessageMode.CLOSED_CHAT.getOrdinal()) {
                viewHolder2.tvClosed.setVisibility(0);
                float f3 = this.context.getResources().getDimension(R.dimen.fugu_name_width);
                viewHolder2.tvName.setMaxWidth((int)f3);
                viewHolder2.tvName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                viewHolder2.tvMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                viewHolder2.tvTime.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)viewHolder2.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(3.0f * f2), (int)(50.0f * f2), 0);
                viewHolder2.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                viewHolder2.tvUnassigned.setBackgroundResource(R.drawable.hippo_bg_tag_color_rounded);
                viewHolder2.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
            } else {
                viewHolder2.tvClosed.setVisibility(8);
                viewHolder2.tvClosed.setFilters(new InputFilter[]{new InputFilter.LengthFilter(R.dimen.fugu_name_width_unClose)});
                float f4 = this.context.getResources().getDimension(R.dimen.fugu_name_width_unClose);
                viewHolder2.tvName.setMaxWidth((int)f4);
                viewHolder2.tvName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                viewHolder2.tvMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                viewHolder2.tvTime.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)viewHolder2.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(-2.0f * f2), (int)(50.0f * f2), 0);
                viewHolder2.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                viewHolder2.tvUnassigned.setBackgroundResource(R.drawable.hippo_bg_unassigned_color_rounded);
                viewHolder2.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.hippo_white));
            }
            if (conversation.getAgentId() <= 0) {
                viewHolder2.tvUnassigned.setVisibility(0);
            } else {
                viewHolder2.tvUnassigned.setVisibility(8);
            }
            if (conversation.getOverlay() != null && conversation.getOverlay().intValue() != Overlay.DEFAULT.getOrdinal()) {
                viewHolder2.tvOverlay.setVisibility(0);
                if (conversation.getOverlay().intValue() == Overlay.OPEN_CHAT.getOrdinal()) {
                    viewHolder2.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_chat_re_opened, 0, 0, 0);
                    viewHolder2.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_green_95));
                    viewHolder2.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_re_opend));
                } else if (conversation.getOverlay().intValue() == Overlay.CLOSED_CHAT.getOrdinal()) {
                    viewHolder2.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_fugu_chat_close, 0, 0, 0);
                    viewHolder2.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_black_95));
                    viewHolder2.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_closed));
                } else if (conversation.getOverlay().intValue() == Overlay.ASSIGNMENT.getOrdinal()) {
                    viewHolder2.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_fugu_chat_assigned, 0, 0, 0);
                    viewHolder2.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_yellow_95));
                    viewHolder2.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_assigned));
                }
            } else {
                viewHolder2.tvOverlay.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getCreatedAt())) {
                TextView textView = viewHolder2.tvTime;
                DateUtils.getInstance();
                textView.setText((CharSequence)DateUtils.getDateTimeToShow(conversation.getCreatedAt()));
            }
        } else if (viewHolder instanceof ViewHolderHeader) {
            ViewHolderHeader viewHolderHeader = (ViewHolderHeader)viewHolder;
            viewHolderHeader.tvHeader.setText((CharSequence)("2 " + this.context.getResources().getString(R.string.fugu_open_conversations)));
        }
    }

    public int getItemCount() {
        if (this.conversationList == null || this.conversationList.size() == 0) {
            return 0;
        }
        return this.conversationList.size();
    }

    public int getItemViewType(int n) {
        if (this.conversationList.get(n) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    @Override
    public void onItemClick(View view, View view2) {
        int n = this.recyclerView.getChildLayoutPosition(view2);
        if (n != -1 && view.getId() == R.id.rlChat) {
            Conversation conversation = (Conversation)this.conversationList.get(n);
            this.callback.onClick(n, this.fragmentType, conversation);
        }
    }

    private String getFileMessageData(Conversation conversation) {
        String string2 = "You sent a file";
        if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(AgentCommonData.getUserData().getUserId())) {
            string2 = "You sent a file";
        } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(AgentCommonData.getUserData().getUserId())) {
            if (conversation.getLast_sent_by_full_name().contains(" ")) {
                String[] stringArray = conversation.getLast_sent_by_full_name().split("\\ ");
                string2 = stringArray[0] + " sent a file";
            } else {
                string2 = conversation.getLast_sent_by_full_name() + " sent a file";
            }
        } else {
            string2 = "You received a file";
        }
        return string2;
    }

    private String getMessageData(Conversation conversation) {
        String string2 = "The video call ended";
        String string3 = "Customer";
        String string4 = "video";
        String string5 = "You";
        if (!TextUtils.isEmpty((CharSequence)conversation.getCallType()) && conversation.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            string4 = "Voice";
        }
        if (conversation.getMessageState() != null && conversation.getMessageState() == 2) {
            if (conversation.getLast_sent_by_user_type() == 1) {
                string3 = conversation.getLast_sent_by_full_name();
                if (!this.isChatAssignToMe(conversation)) {
                    string5 = conversation.getAgentName();
                }
                string2 = string5 + " missed a " + string4 + " call with " + string3;
            } else {
                string5 = conversation.getLast_sent_by_id().intValue() == AgentCommonData.getUserData().getUserId().intValue() ? "you" : conversation.getLast_sent_by_full_name();
                string2 = string3 + " missed a " + string4 + " call with " + string5;
            }
        } else {
            string2 = "The " + string4 + " call ended";
        }
        return string2;
    }

    private boolean isChatAssignToMe(Conversation conversation) {
        return conversation.getAgentId().intValue() == AgentCommonData.getUserData().getUserId().intValue();
    }

    public static interface Callback {
        public void onClick(int var1, int var2, Conversation var3);
    }

    private static class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View view) {
            super(view);
        }
    }

    public static class ProgressBarItem {
    }

    public class ViewHolderHeader
    extends RecyclerView.ViewHolder {
        public TextView tvHeader;

        public ViewHolderHeader(View view) {
            super(view);
            this.tvHeader = (TextView)view.findViewById(R.id.tvHeader);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public RelativeLayout rlChat;
        public TextView tvMessage;
        public TextView tvName;
        public TextView tvChannelName;
        public TextView tvTime;
        public TextView tvUnread;
        public TextView tvClosed;
        public TextView tvTyping;
        public TextView tvOverlay;
        public TextView tvTagged;
        public TextView tvUnassigned;
        public TextView tvAgentName;

        public ViewHolder(final View view, final ItemClickListener itemClickListener) {
            super(view);
            this.rlChat = (RelativeLayout)view.findViewById(R.id.rlChat);
            this.tvMessage = (TextView)view.findViewById(R.id.tvMessage);
            this.tvName = (TextView)view.findViewById(R.id.tvName);
            this.tvChannelName = (TextView)view.findViewById(R.id.tvChannelName);
            this.tvTime = (TextView)view.findViewById(R.id.tvTime);
            this.tvUnread = (TextView)view.findViewById(R.id.tvUnread);
            this.tvClosed = (TextView)view.findViewById(R.id.tvClosed);
            this.tvTyping = (TextView)view.findViewById(R.id.tvTyping);
            this.tvTagged = (TextView)view.findViewById(R.id.tvTagged);
            this.tvUnassigned = (TextView)view.findViewById(R.id.tvUnassigned);
            this.tvAgentName = (TextView)view.findViewById(R.id.tvAgentName);
            this.tvOverlay = (TextView)view.findViewById(R.id.tvOverlay);
            this.rlChat.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view2) {
                    itemClickListener.onItemClick((View)ViewHolder.this.rlChat, view);
                }
            });
            this.tvOverlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                }
            });
        }
    }
}

