/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadcastUser;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class BroadcastDetailAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BroadcastDetailAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadcastUser> arrayList = new ArrayList();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public BroadcastDetailAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadcastUser> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        this.hippoColorConfig = CommonData.getColorConfig();
        if (n == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_layout_broadcast_item_detail, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int n) {
        if (viewHolder instanceof ViewHolder) {
            ViewHolder viewHolder2 = (ViewHolder)viewHolder;
            BroadcastUser broadcastUser = this.arrayList.get(n);
            viewHolder2.tvTitle.setText((CharSequence)broadcastUser.getFullName());
            if (!TextUtils.isEmpty((CharSequence)broadcastUser.getLastActivity())) {
                String string2 = DateUtils.getInstance().convertToLocal(broadcastUser.getLastActivity(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
                viewHolder2.tvStatus.setText((CharSequence)("Read at " + string2));
            } else {
                viewHolder2.tvStatus.setText((CharSequence)"Delivered");
            }
            if (!TextUtils.isEmpty((CharSequence)broadcastUser.getRepliedOn())) {
                viewHolder2.chatIcon.setVisibility(0);
            } else {
                viewHolder2.chatIcon.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int n) {
        try {
            if (this.arrayList.get(n).getUserId().equals(-1)) {
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean bl, boolean bl2) {
        boolean bl3;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl4 = bl3 = this.arrayList.get(this.arrayList.size() - 1).getUserId() != null && this.arrayList.get(this.arrayList.size() - 1).getUserId() == -1;
        if (bl) {
            if (!bl3) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (bl2) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && bl2) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean bl, int n) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(bl);
        this.progressBarDisplayRunnable.setPosition(n);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static BroadcastUser progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadcastUser getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new BroadcastUser(-1);
            }
            return progressBarModel;
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View view) {
            super(view);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout llLayout;
        private RelativeLayout chatIcon;
        private TextView tvTitle;
        private TextView tvStatus;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.llLayout = (RelativeLayout)view.findViewById(R.id.ll_layout);
            this.chatIcon = (RelativeLayout)view.findViewById(R.id.chat_icon);
            this.tvTitle = (TextView)view.findViewById(R.id.tvTitle);
            this.tvStatus = (TextView)view.findViewById(R.id.tvStatus);
            this.tvTitle.setTextColor(BroadcastDetailAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.tvStatus.setTextColor(BroadcastDetailAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.llLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (BroadcastDetailAdapter.this.onItemClickListener != null) {
                        BroadcastDetailAdapter.this.onItemClickListener.onClickItem(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

