/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util.permissionHelper;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.hippo.agent.Util.permissionHelper.Permissions;
import com.hippo.agent.Util.permissionHelper.PermissionsResultAction;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PermissionsManager {
    private static final String TAG = PermissionsManager.class.getSimpleName();
    private final Set<String> mPendingRequests = new HashSet<String>(1);
    private final Set<String> mPermissions = new HashSet<String>(1);
    private final List<WeakReference<PermissionsResultAction>> mPendingActions = new ArrayList<WeakReference<PermissionsResultAction>>(1);
    private static PermissionsManager mInstance = null;

    public static PermissionsManager getInstance() {
        if (mInstance == null) {
            mInstance = new PermissionsManager();
        }
        return mInstance;
    }

    private PermissionsManager() {
        this.initializePermissionsMap();
    }

    private synchronized void initializePermissionsMap() {
        Field[] fieldArray;
        for (Field field : fieldArray = Manifest.permission.class.getFields()) {
            String string2 = null;
            try {
                string2 = (String)field.get("");
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)TAG, (String)"Could not access field", (Throwable)illegalAccessException);
            }
            this.mPermissions.add(string2);
        }
    }

    @NonNull
    private synchronized String[] getManifestPermissions(@NonNull Activity activity) {
        String[] stringArray;
        PackageInfo packageInfo = null;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            Log.d((String)TAG, (String)activity.getPackageName());
            packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"A problem occurred when retrieving permissions", (Throwable)nameNotFoundException);
        }
        if (packageInfo != null && (stringArray = packageInfo.requestedPermissions) != null) {
            for (String string2 : stringArray) {
                Log.d((String)TAG, (String)("Manifest contained permission: " + string2));
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private synchronized void addPendingAction(@NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        if (permissionsResultAction == null) {
            return;
        }
        permissionsResultAction.registerPermissions(stringArray);
        this.mPendingActions.add(new WeakReference<PermissionsResultAction>(permissionsResultAction));
    }

    private synchronized void removePendingAction(@Nullable PermissionsResultAction permissionsResultAction) {
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        while (iterator.hasNext()) {
            WeakReference<PermissionsResultAction> weakReference = iterator.next();
            if (weakReference.get() != permissionsResultAction && weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    public synchronized boolean hasPermission(@Nullable Context context, @NonNull String string2) {
        return context != null && (ActivityCompat.checkSelfPermission((Context)context, (String)string2) == 0 || !this.mPermissions.contains(string2));
    }

    public synchronized boolean hasAllPermissions(@Nullable Context context, @NonNull String[] stringArray) {
        if (context == null) {
            return false;
        }
        boolean bl = true;
        for (String string2 : stringArray) {
            bl &= this.hasPermission(context, string2);
        }
        return bl;
    }

    public synchronized void requestAllManifestPermissionsIfNecessary(@Nullable Activity activity, @Nullable PermissionsResultAction permissionsResultAction) {
        if (activity == null) {
            return;
        }
        String[] stringArray = this.getManifestPermissions(activity);
        this.requestPermissionsIfNecessaryForResult(activity, stringArray, permissionsResultAction);
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@Nullable Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        if (activity == null) {
            return;
        }
        this.addPendingAction(stringArray, permissionsResultAction);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM(activity, stringArray, permissionsResultAction);
        } else {
            List<String> list = this.getPermissionsListToRequest(activity, stringArray, permissionsResultAction);
            if (list.isEmpty()) {
                this.removePendingAction(permissionsResultAction);
            } else {
                String[] stringArray2 = list.toArray(new String[list.size()]);
                this.mPendingRequests.addAll(list);
                ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray2, (int)1);
            }
        }
    }

    public synchronized void requestPermissionsIfNecessaryForResult(@NonNull Fragment fragment, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        FragmentActivity fragmentActivity = fragment.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        this.addPendingAction(stringArray, permissionsResultAction);
        if (Build.VERSION.SDK_INT < 23) {
            this.doPermissionWorkBeforeAndroidM((Activity)fragmentActivity, stringArray, permissionsResultAction);
        } else {
            List<String> list = this.getPermissionsListToRequest((Activity)fragmentActivity, stringArray, permissionsResultAction);
            if (list.isEmpty()) {
                this.removePendingAction(permissionsResultAction);
            } else {
                String[] stringArray2 = list.toArray(new String[list.size()]);
                this.mPendingRequests.addAll(list);
                fragment.requestPermissions(stringArray2, 1);
            }
        }
    }

    public synchronized void notifyPermissionsChange(@NonNull String[] stringArray, @NonNull int[] nArray) {
        int n = stringArray.length;
        if (nArray.length < n) {
            n = nArray.length;
        }
        Iterator<WeakReference<PermissionsResultAction>> iterator = this.mPendingActions.iterator();
        block0: while (iterator.hasNext()) {
            PermissionsResultAction permissionsResultAction = (PermissionsResultAction)iterator.next().get();
            for (int j = 0; j < n; ++j) {
                if (permissionsResultAction != null && !permissionsResultAction.onResult(stringArray[j], nArray[j])) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (int j = 0; j < n; ++j) {
            this.mPendingRequests.remove(stringArray[j]);
        }
    }

    private void doPermissionWorkBeforeAndroidM(@NonNull Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        for (String string2 : stringArray) {
            if (permissionsResultAction == null) continue;
            if (!this.mPermissions.contains(string2)) {
                permissionsResultAction.onResult(string2, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)string2) != 0) {
                permissionsResultAction.onResult(string2, Permissions.DENIED);
                continue;
            }
            permissionsResultAction.onResult(string2, Permissions.GRANTED);
        }
    }

    @NonNull
    private List<String> getPermissionsListToRequest(@NonNull Activity activity, @NonNull String[] stringArray, @Nullable PermissionsResultAction permissionsResultAction) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (!this.mPermissions.contains(string2)) {
                if (permissionsResultAction == null) continue;
                permissionsResultAction.onResult(string2, Permissions.NOT_FOUND);
                continue;
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)string2) != 0) {
                if (this.mPendingRequests.contains(string2)) continue;
                arrayList.add(string2);
                continue;
            }
            if (permissionsResultAction == null) continue;
            permissionsResultAction.onResult(string2, Permissions.GRANTED);
        }
        return arrayList;
    }
}

