/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.customview.widget.ViewDragHelper;
import com.hippo.R;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.Util.tagview.TagView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TagContainerLayout
extends ViewGroup {
    private int mVerticalInterval;
    private ArrayList<Integer> mColorArrayList;
    private int mHorizontalInterval;
    private float mBorderWidth = 0.5f;
    private float mBorderRadius = 10.0f;
    private float mSensitivity = 1.0f;
    private int mChildHeight;
    private int mBorderColor = Color.parseColor((String)"#22FF0000");
    private int mBackgroundColor = Color.parseColor((String)"#11FF0000");
    private int mGravity = 3;
    private int mMaxLines = 0;
    private int mTagMaxLength = 42;
    private float mTagBorderWidth = 0.5f;
    private float mTagBorderRadius = 15.0f;
    private float mTagTextSize = 14.0f;
    private int mTagTextDirection = 3;
    private int mTagHorizontalPadding = 10;
    private int mTagVerticalPadding = 8;
    private int mTagBorderColor = -1;
    private int mTagBackgroundColor = Color.parseColor((String)"#33F44336");
    private int mTagTextColor = -1;
    private Typeface mTagTypeface = Typeface.DEFAULT;
    private boolean isTagViewClickable;
    private List<String> mTags;
    private boolean mDragEnable;
    private int mTagViewState = 0;
    private float mTagBdDistance = 2.75f;
    private TagView.OnTagClickListener mOnTagClickListener;
    private boolean mTagSupportLettersRTL = false;
    private Paint mPaint;
    private RectF mRectF;
    private ViewDragHelper mViewDragHelper;
    private List<View> mChildViews;
    private int[] mViewPos;
    private int mTheme = 1;
    private static final float DEFAULT_INTERVAL = 5.0f;
    private static final int TAG_MIN_LENGTH = 3;
    private int mRippleDuration = 1000;
    private int mRippleColor;
    private int mRippleAlpha = 128;
    private boolean mEnableCross = false;
    private float mCrossAreaWidth = 0.0f;
    private float mCrossAreaPadding = 10.0f;
    private int mCrossColor = -16777216;
    private float mCrossLineWidth = 1.0f;
    private int mTagBackgroundResource;

    public TagContainerLayout(Context context) {
        this(context, null);
    }

    public TagContainerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TagContainerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet, n);
    }

    private void init(Context context, AttributeSet attributeSet, int n) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AndroidTagView, n, 0);
        this.mVerticalInterval = (int)typedArray.getDimension(R.styleable.AndroidTagView_vertical_interval, Utils.dp2px(context, 5.0f));
        this.mHorizontalInterval = (int)typedArray.getDimension(R.styleable.AndroidTagView_horizontal_interval, Utils.dp2px(context, 5.0f));
        this.mBorderWidth = typedArray.getDimension(R.styleable.AndroidTagView_container_border_width, Utils.dp2px(context, this.mBorderWidth));
        this.mBorderRadius = typedArray.getDimension(R.styleable.AndroidTagView_container_border_radius, Utils.dp2px(context, this.mBorderRadius));
        this.mTagBdDistance = typedArray.getDimension(R.styleable.AndroidTagView_tag_bd_distance, Utils.dp2px(context, this.mTagBdDistance));
        this.mBorderColor = typedArray.getColor(R.styleable.AndroidTagView_container_border_color, this.mBorderColor);
        this.mBackgroundColor = typedArray.getColor(R.styleable.AndroidTagView_container_background_color, this.mBackgroundColor);
        this.mDragEnable = typedArray.getBoolean(R.styleable.AndroidTagView_container_enable_drag, false);
        this.mSensitivity = typedArray.getFloat(R.styleable.AndroidTagView_container_drag_sensitivity, this.mSensitivity);
        this.mGravity = typedArray.getInt(R.styleable.AndroidTagView_container_gravity, this.mGravity);
        this.mMaxLines = typedArray.getInt(R.styleable.AndroidTagView_container_max_lines, this.mMaxLines);
        this.mTagMaxLength = typedArray.getInt(R.styleable.AndroidTagView_tag_max_length, this.mTagMaxLength);
        this.mTheme = typedArray.getInt(R.styleable.AndroidTagView_tag_theme, this.mTheme);
        this.mTagBorderWidth = typedArray.getDimension(R.styleable.AndroidTagView_tag_border_width, Utils.dp2px(context, this.mTagBorderWidth));
        this.mTagBorderRadius = typedArray.getDimension(R.styleable.AndroidTagView_tag_corner_radius, Utils.dp2px(context, this.mTagBorderRadius));
        this.mTagHorizontalPadding = (int)typedArray.getDimension(R.styleable.AndroidTagView_tag_horizontal_padding, Utils.dp2px(context, this.mTagHorizontalPadding));
        this.mTagVerticalPadding = (int)typedArray.getDimension(R.styleable.AndroidTagView_tag_vertical_padding, Utils.dp2px(context, this.mTagVerticalPadding));
        this.mTagTextSize = typedArray.getDimension(R.styleable.AndroidTagView_tag_text_size, Utils.sp2px(context, this.mTagTextSize));
        this.mTagBorderColor = typedArray.getColor(R.styleable.AndroidTagView_tag_border_color, this.mTagBorderColor);
        this.mTagBackgroundColor = typedArray.getColor(R.styleable.AndroidTagView_tag_background_color, this.mTagBackgroundColor);
        this.mTagTextColor = typedArray.getColor(R.styleable.AndroidTagView_tag_text_color, this.mTagTextColor);
        this.mTagTextDirection = typedArray.getInt(R.styleable.AndroidTagView_tag_text_direction, this.mTagTextDirection);
        this.isTagViewClickable = typedArray.getBoolean(R.styleable.AndroidTagView_tag_clickable, false);
        this.mRippleColor = typedArray.getColor(R.styleable.AndroidTagView_tag_ripple_color, Color.parseColor((String)"#EEEEEE"));
        this.mRippleAlpha = typedArray.getInteger(R.styleable.AndroidTagView_tag_ripple_alpha, this.mRippleAlpha);
        this.mRippleDuration = typedArray.getInteger(R.styleable.AndroidTagView_tag_ripple_duration, this.mRippleDuration);
        this.mEnableCross = typedArray.getBoolean(R.styleable.AndroidTagView_tag_enable_cross, this.mEnableCross);
        this.mCrossAreaWidth = typedArray.getDimension(R.styleable.AndroidTagView_tag_cross_width, Utils.dp2px(context, this.mCrossAreaWidth));
        this.mCrossAreaPadding = typedArray.getDimension(R.styleable.AndroidTagView_tag_cross_area_padding, Utils.dp2px(context, this.mCrossAreaPadding));
        this.mCrossColor = typedArray.getColor(R.styleable.AndroidTagView_tag_cross_color, this.mCrossColor);
        this.mCrossLineWidth = typedArray.getDimension(R.styleable.AndroidTagView_tag_cross_line_width, Utils.dp2px(context, this.mCrossLineWidth));
        this.mTagSupportLettersRTL = typedArray.getBoolean(R.styleable.AndroidTagView_tag_support_letters_rlt, this.mTagSupportLettersRTL);
        this.mTagBackgroundResource = typedArray.getResourceId(R.styleable.AndroidTagView_tag_background, this.mTagBackgroundResource);
        typedArray.recycle();
        this.mPaint = new Paint(1);
        this.mRectF = new RectF();
        this.mChildViews = new ArrayList<View>();
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)this.mSensitivity, (ViewDragHelper.Callback)new DragHelperCallBack());
        this.setWillNotDraw(false);
        this.setTagMaxLength(this.mTagMaxLength);
        this.setTagHorizontalPadding(this.mTagHorizontalPadding);
        this.setTagVerticalPadding(this.mTagVerticalPadding);
        if (this.isInEditMode()) {
            this.addTag("sample tag");
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.measureChildren(n, n2);
        int n3 = this.getChildCount();
        int n4 = n3 == 0 ? 0 : this.getChildLines(n3);
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = View.MeasureSpec.getMode((int)n2);
        if (n3 == 0) {
            this.setMeasuredDimension(0, 0);
        } else if (n7 == Integer.MIN_VALUE || n7 == 0) {
            this.setMeasuredDimension(n5, (this.mVerticalInterval + this.mChildHeight) * n4 - this.mVerticalInterval + this.getPaddingTop() + this.getPaddingBottom());
        } else {
            this.setMeasuredDimension(n5, n6);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mRectF.set(0.0f, 0.0f, (float)n, (float)n2);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view;
        int n5;
        int n6 = this.getChildCount();
        if (n6 <= 0) {
            return;
        }
        int n7 = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n8 = this.getMeasuredWidth() - this.getPaddingRight();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingLeft();
        int n11 = 0;
        this.mViewPos = new int[n6 * 2];
        for (n5 = 0; n5 < n6; ++n5) {
            view = this.getChildAt(n5);
            if (view.getVisibility() == 8) continue;
            int n12 = view.getMeasuredWidth();
            if (this.mGravity == 17) {
                int n13;
                int n14;
                if (n10 + n12 - this.getPaddingLeft() > n7) {
                    n14 = this.getMeasuredWidth() - this.mViewPos[(n5 - 1) * 2] - this.getChildAt(n5 - 1).getMeasuredWidth() - this.getPaddingRight();
                    for (n13 = n11; n13 < n5; ++n13) {
                        this.mViewPos[n13 * 2] = this.mViewPos[n13 * 2] + n14 / 2;
                    }
                    n11 = n5;
                    n10 = this.getPaddingLeft();
                    n9 += this.mChildHeight + this.mVerticalInterval;
                }
                this.mViewPos[n5 * 2] = n10;
                this.mViewPos[n5 * 2 + 1] = n9;
                n10 += n12 + this.mHorizontalInterval;
                if (n5 != n6 - 1) continue;
                n14 = this.getMeasuredWidth() - this.mViewPos[n5 * 2] - view.getMeasuredWidth() - this.getPaddingRight();
                for (n13 = n11; n13 < n6; ++n13) {
                    this.mViewPos[n13 * 2] = this.mViewPos[n13 * 2] + n14 / 2;
                }
                continue;
            }
            if (this.mGravity == 5) {
                if (n8 - n12 < this.getPaddingLeft()) {
                    n8 = this.getMeasuredWidth() - this.getPaddingRight();
                    n9 += this.mChildHeight + this.mVerticalInterval;
                }
                this.mViewPos[n5 * 2] = n8 - n12;
                this.mViewPos[n5 * 2 + 1] = n9;
                n8 -= n12 + this.mHorizontalInterval;
                continue;
            }
            if (n10 + n12 - this.getPaddingLeft() > n7) {
                n10 = this.getPaddingLeft();
                n9 += this.mChildHeight + this.mVerticalInterval;
            }
            this.mViewPos[n5 * 2] = n10;
            this.mViewPos[n5 * 2 + 1] = n9;
            n10 += n12 + this.mHorizontalInterval;
        }
        for (n5 = 0; n5 < this.mViewPos.length / 2; ++n5) {
            view = this.getChildAt(n5);
            view.layout(this.mViewPos[n5 * 2], this.mViewPos[n5 * 2 + 1], this.mViewPos[n5 * 2] + view.getMeasuredWidth(), this.mViewPos[n5 * 2 + 1] + this.mChildHeight);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        this.mPaint.setColor(this.mBorderColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.mViewDragHelper.shouldInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mViewDragHelper.processTouchEvent(motionEvent);
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mViewDragHelper.continueSettling(true)) {
            this.requestLayout();
        }
    }

    private int getChildLines(int n) {
        int n2 = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n3 = 1;
        int n4 = 0;
        for (int j = 0; j < n; ++j) {
            View view = this.getChildAt(j);
            int n5 = view.getMeasuredWidth() + this.mHorizontalInterval;
            int n6 = view.getMeasuredHeight();
            int n7 = this.mChildHeight = j == 0 ? n6 : Math.min(this.mChildHeight, n6);
            if ((n4 += n5) - this.mHorizontalInterval <= n2) continue;
            ++n3;
            n4 = n5;
        }
        return this.mMaxLines <= 0 ? n3 : this.mMaxLines;
    }

    private void onSetTag() {
        if (this.mTags == null) {
            throw new RuntimeException("NullPointer exception!");
        }
        this.removeAllTags();
        if (this.mTags.size() == 0) {
            return;
        }
        for (int j = 0; j < this.mTags.size(); ++j) {
            this.onAddTag(this.mTags.get(j), this.mChildViews.size());
        }
        this.postInvalidate();
    }

    private void onAddTag(String string2, int n) {
        if (n < 0 || n > this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        TagView tagView = new TagView(this.getContext(), string2);
        this.initTagView(tagView, n);
        this.mChildViews.add(n, tagView);
        if (n < this.mChildViews.size()) {
            for (int j = n; j < this.mChildViews.size(); ++j) {
                this.mChildViews.get(j).setTag((Object)j);
            }
        } else {
            tagView.setTag(n);
        }
        this.addView(tagView, n);
    }

    private void initTagView(TagView tagView, int n) {
        if (this.mColorArrayList != null && this.mColorArrayList.size() > 0) {
            if (this.mColorArrayList.size() == this.mTags.size()) {
                ArrayList<Integer> arrayList = this.mColorArrayList;
                tagView.setTagBackgroundColor(arrayList.get(n));
                if (this.mTagBorderColor == -1) {
                    tagView.setTagBorderColor(arrayList.get(n));
                } else {
                    tagView.setTagBorderColor(this.mTagBorderColor);
                }
                tagView.setTagTextColor(this.mTagTextColor);
                tagView.setTagMaxLength(this.mTagMaxLength);
                tagView.setTextDirection(this.mTagTextDirection);
                tagView.setTypeface(this.mTagTypeface);
                tagView.setBorderWidth(this.mTagBorderWidth);
                tagView.setBorderRadius(this.mTagBorderRadius);
                tagView.setTextSize(this.mTagTextSize);
                tagView.setHorizontalPadding(this.mTagHorizontalPadding);
                tagView.setVerticalPadding(this.mTagVerticalPadding);
                tagView.setIsViewClickable(this.isTagViewClickable);
                tagView.setBdDistance(this.mTagBdDistance);
                tagView.setOnTagClickListener(this.mOnTagClickListener);
                tagView.setRippleAlpha(this.mRippleAlpha);
                tagView.setRippleColor(this.mRippleColor);
                tagView.setRippleDuration(this.mRippleDuration);
                tagView.setEnableCross(this.mEnableCross);
                tagView.setCrossAreaWidth(this.mCrossAreaWidth);
                tagView.setCrossAreaPadding(this.mCrossAreaPadding);
                tagView.setCrossColor(this.mCrossColor);
                tagView.setCrossLineWidth(this.mCrossLineWidth);
                tagView.setTagSupportLettersRTL(this.mTagSupportLettersRTL);
                tagView.setBackgroundResource(this.mTagBackgroundResource);
            } else {
                throw new RuntimeException("Illegal color list!");
            }
        }
    }

    private void invalidateTags() {
        for (View view : this.mChildViews) {
            TagView tagView = (TagView)view;
            tagView.setOnTagClickListener(this.mOnTagClickListener);
        }
    }

    private void onRemoveTag(int n) {
        if (n < 0 || n >= this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        this.mChildViews.remove(n);
        this.removeViewAt(n);
        for (int j = n; j < this.mChildViews.size(); ++j) {
            this.mChildViews.get(j).setTag((Object)j);
        }
    }

    private int[] onGetNewPosition(View view) {
        int n;
        int n2 = view.getLeft();
        int n3 = view.getTop();
        int n4 = this.mViewPos[(Integer)view.getTag() * 2];
        int n5 = this.mViewPos[(Integer)view.getTag() * 2 + 1];
        int n6 = Math.abs(n3 - n5);
        for (n = 0; n < this.mViewPos.length / 2; ++n) {
            if (Math.abs(n3 - this.mViewPos[n * 2 + 1]) >= n6) continue;
            n5 = this.mViewPos[n * 2 + 1];
            n6 = Math.abs(n3 - this.mViewPos[n * 2 + 1]);
        }
        n = 0;
        int n7 = 0;
        for (int j = 0; j < this.mViewPos.length / 2; ++j) {
            if (this.mViewPos[j * 2 + 1] != n5) continue;
            if (n == 0) {
                n4 = this.mViewPos[j * 2];
                n7 = Math.abs(n2 - n4);
            } else if (Math.abs(n2 - this.mViewPos[j * 2]) < n7) {
                n4 = this.mViewPos[j * 2];
                n7 = Math.abs(n2 - n4);
            }
            ++n;
        }
        return new int[]{n4, n5};
    }

    private int onGetCoordinateReferPos(int n, int n2) {
        int n3 = 0;
        for (int j = 0; j < this.mViewPos.length / 2; ++j) {
            if (n != this.mViewPos[j * 2] || n2 != this.mViewPos[j * 2 + 1]) continue;
            n3 = j;
        }
        return n3;
    }

    private void onChangeView(View view, int n, int n2) {
        this.mChildViews.remove(n2);
        this.mChildViews.add(n, view);
        for (View view2 : this.mChildViews) {
            view2.setTag((Object)this.mChildViews.indexOf(view2));
        }
        this.removeViewAt(n2);
        this.addView(view, n);
    }

    private int ceilTagBorderWidth() {
        return (int)Math.ceil(this.mTagBorderWidth);
    }

    public int getTagViewState() {
        return this.mTagViewState;
    }

    public float getTagBdDistance() {
        return this.mTagBdDistance;
    }

    public void setTagBdDistance(float f2) {
        this.mTagBdDistance = Utils.dp2px(this.getContext(), f2);
    }

    public void setTags(List<String> list) {
        this.mTags = list;
        this.onSetTag();
    }

    public void setTags(List<String> list, ArrayList<Integer> arrayList) {
        this.mTags = list;
        this.mColorArrayList = arrayList;
        this.onSetTag();
    }

    public void setTags(String ... stringArray) {
        this.mTags = Arrays.asList(stringArray);
        this.onSetTag();
    }

    public void addTag(String string2) {
        this.addTag(string2, this.mChildViews.size());
    }

    public void addTag(String string2, int n) {
        this.onAddTag(string2, n);
        this.postInvalidate();
    }

    public void removeTag(int n) {
        this.onRemoveTag(n);
        this.postInvalidate();
    }

    public void removeAllTags() {
        this.mChildViews.clear();
        this.removeAllViews();
        this.postInvalidate();
    }

    public void setOnTagClickListener(TagView.OnTagClickListener onTagClickListener) {
        this.mOnTagClickListener = onTagClickListener;
        this.invalidateTags();
    }

    public String getTagText(int n) {
        return ((TagView)this.mChildViews.get(n)).getText();
    }

    public List<String> getTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (View view : this.mChildViews) {
            if (!(view instanceof TagView)) continue;
            arrayList.add(((TagView)view).getText());
        }
        return arrayList;
    }

    public void setDragEnable(boolean bl) {
        this.mDragEnable = bl;
    }

    public boolean getDragEnable() {
        return this.mDragEnable;
    }

    public void setVerticalInterval(float f2) {
        this.mVerticalInterval = (int)Utils.dp2px(this.getContext(), f2);
        this.postInvalidate();
    }

    public int getVerticalInterval() {
        return this.mVerticalInterval;
    }

    public void setHorizontalInterval(float f2) {
        this.mHorizontalInterval = (int)Utils.dp2px(this.getContext(), f2);
        this.postInvalidate();
    }

    public int getHorizontalInterval() {
        return this.mHorizontalInterval;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float f2) {
        this.mBorderWidth = f2;
    }

    public float getBorderRadius() {
        return this.mBorderRadius;
    }

    public void setBorderRadius(float f2) {
        this.mBorderRadius = f2;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int n) {
        this.mBorderColor = n;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int n) {
        this.mGravity = n;
    }

    public float getSensitivity() {
        return this.mSensitivity;
    }

    public void setSensitivity(float f2) {
        this.mSensitivity = f2;
    }

    public void setMaxLines(int n) {
        this.mMaxLines = n;
        this.postInvalidate();
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setTagMaxLength(int n) {
        this.mTagMaxLength = n < 3 ? 3 : n;
    }

    public int getTagMaxLength() {
        return this.mTagMaxLength;
    }

    public void setTheme(int n) {
        this.mTheme = n;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public boolean getIsTagViewClickable() {
        return this.isTagViewClickable;
    }

    public void setIsTagViewClickable(boolean bl) {
        this.isTagViewClickable = bl;
    }

    public float getTagBorderWidth() {
        return this.mTagBorderWidth;
    }

    public void setTagBorderWidth(float f2) {
        this.mTagBorderWidth = f2;
    }

    public float getTagBorderRadius() {
        return this.mTagBorderRadius;
    }

    public void setTagBorderRadius(float f2) {
        this.mTagBorderRadius = f2;
    }

    public float getTagTextSize() {
        return this.mTagTextSize;
    }

    public void setTagTextSize(float f2) {
        this.mTagTextSize = f2;
    }

    public int getTagHorizontalPadding() {
        return this.mTagHorizontalPadding;
    }

    public void setTagHorizontalPadding(int n) {
        int n2 = this.ceilTagBorderWidth();
        this.mTagHorizontalPadding = n < n2 ? n2 : n;
    }

    public int getTagVerticalPadding() {
        return this.mTagVerticalPadding;
    }

    public void setTagVerticalPadding(int n) {
        int n2 = this.ceilTagBorderWidth();
        this.mTagVerticalPadding = n < n2 ? n2 : n;
    }

    public int getTagBorderColor() {
        return this.mTagBorderColor;
    }

    public void setTagBorderColor(int n) {
        this.mTagBorderColor = n;
    }

    public int getTagBackgroundColor() {
        return this.mTagBackgroundColor;
    }

    public void setTagBackgroundColor(int n) {
        this.mTagBackgroundColor = n;
    }

    public int getTagTextColor() {
        return this.mTagTextColor;
    }

    public void setTagTextDirection(int n) {
        this.mTagTextDirection = n;
    }

    public Typeface getTagTypeface() {
        return this.mTagTypeface;
    }

    public void setTagTypeface(Typeface typeface) {
        this.mTagTypeface = typeface;
    }

    public int getTagTextDirection() {
        return this.mTagTextDirection;
    }

    public void setTagTextColor(int n) {
        this.mTagTextColor = n;
    }

    public int getRippleAlpha() {
        return this.mRippleAlpha;
    }

    public void setRippleAlpha(int n) {
        this.mRippleAlpha = n;
    }

    public int getRippleColor() {
        return this.mRippleColor;
    }

    public void setRippleColor(int n) {
        this.mRippleColor = n;
    }

    public int getRippleDuration() {
        return this.mRippleDuration;
    }

    public void setRippleDuration(int n) {
        this.mRippleDuration = n;
    }

    public int getCrossColor() {
        return this.mCrossColor;
    }

    public void setCrossColor(int n) {
        this.mCrossColor = n;
    }

    public float getCrossAreaPadding() {
        return this.mCrossAreaPadding;
    }

    public void setCrossAreaPadding(float f2) {
        this.mCrossAreaPadding = f2;
    }

    public boolean isEnableCross() {
        return this.mEnableCross;
    }

    public void setEnableCross(boolean bl) {
        this.mEnableCross = bl;
    }

    public float getCrossAreaWidth() {
        return this.mCrossAreaWidth;
    }

    public void setCrossAreaWidth(float f2) {
        this.mCrossAreaWidth = f2;
    }

    public float getCrossLineWidth() {
        return this.mCrossLineWidth;
    }

    public void setCrossLineWidth(float f2) {
        this.mCrossLineWidth = f2;
    }

    public boolean isTagSupportLettersRTL() {
        return this.mTagSupportLettersRTL;
    }

    public void setTagSupportLettersRTL(boolean bl) {
        this.mTagSupportLettersRTL = bl;
    }

    public TagView getTagView(int n) {
        if (n < 0 || n >= this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        return (TagView)this.mChildViews.get(n);
    }

    public int getTagBackgroundResource() {
        return this.mTagBackgroundResource;
    }

    public void setTagBackgroundResource(@DrawableRes int n) {
        this.mTagBackgroundResource = n;
    }

    private class DragHelperCallBack
    extends ViewDragHelper.Callback {
        private DragHelperCallBack() {
        }

        public void onViewDragStateChanged(int n) {
            super.onViewDragStateChanged(n);
            TagContainerLayout.this.mTagViewState = n;
        }

        public boolean tryCaptureView(View view, int n) {
            TagContainerLayout.this.requestDisallowInterceptTouchEvent(true);
            return TagContainerLayout.this.mDragEnable;
        }

        public int clampViewPositionHorizontal(View view, int n, int n2) {
            int n3 = TagContainerLayout.this.getPaddingLeft();
            int n4 = TagContainerLayout.this.getWidth() - view.getWidth() - TagContainerLayout.this.getPaddingRight();
            return Math.min(Math.max(n, n3), n4);
        }

        public int clampViewPositionVertical(View view, int n, int n2) {
            int n3 = TagContainerLayout.this.getPaddingTop();
            int n4 = TagContainerLayout.this.getHeight() - view.getHeight() - TagContainerLayout.this.getPaddingBottom();
            return Math.min(Math.max(n, n3), n4);
        }

        public int getViewHorizontalDragRange(View view) {
            return TagContainerLayout.this.getMeasuredWidth() - view.getMeasuredWidth();
        }

        public int getViewVerticalDragRange(View view) {
            return TagContainerLayout.this.getMeasuredHeight() - view.getMeasuredHeight();
        }

        public void onViewReleased(View view, float f2, float f3) {
            super.onViewReleased(view, f2, f3);
            TagContainerLayout.this.requestDisallowInterceptTouchEvent(false);
            int[] nArray = TagContainerLayout.this.onGetNewPosition(view);
            int n = TagContainerLayout.this.onGetCoordinateReferPos(nArray[0], nArray[1]);
            TagContainerLayout.this.onChangeView(view, n, (Integer)view.getTag());
            TagContainerLayout.this.mViewDragHelper.settleCapturedViewAt(nArray[0], nArray[1]);
            TagContainerLayout.this.invalidate();
        }
    }
}

