/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.model.ContentValue;
import java.util.ArrayList;

public class TagsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    public ArrayList<ContentValue> arrayList = new ArrayList();
    private HippoColorConfig hippoColorConfig;
    private Context mContext;
    private OnTagClicked onTagClicked;

    public TagsAdapter(ArrayList<ContentValue> arrayList, HippoColorConfig hippoColorConfig, OnTagClicked onTagClicked) {
        this.arrayList = arrayList;
        this.hippoColorConfig = hippoColorConfig;
        this.onTagClicked = onTagClicked;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        this.mContext = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_tag_view, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        viewHolder.tagView.setText((CharSequence)this.arrayList.get(n).getBtnTitle());
        viewHolder.tagView.setTextColor(this.hippoColorConfig.getHippoBotConcentText());
        try {
            Drawable drawable2 = viewHolder.tagView.getBackground();
            if (drawable2 instanceof ShapeDrawable) {
                ((ShapeDrawable)drawable2).getPaint().setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
            } else if (drawable2 instanceof GradientDrawable) {
                ((GradientDrawable)drawable2).setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
                ((GradientDrawable)drawable2).setStroke(2, this.hippoColorConfig.getHippoBotConcentText());
            } else if (drawable2 instanceof ColorDrawable) {
                ((ColorDrawable)drawable2).setColor(this.hippoColorConfig.getHippoBotConcentBtnBg());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public static interface OnTagClicked {
        public void onClick(int var1, ContentValue var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tagView;

        public ViewHolder(@NonNull View view) {
            super(view);
            this.tagView = (TextView)view.findViewById(R.id.tagView);
            this.tagView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (TagsAdapter.this.onTagClicked != null) {
                        TagsAdapter.this.onTagClicked.onClick(ViewHolder.this.getAdapterPosition(), TagsAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition()));
                    }
                }
            });
        }
    }
}

