/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.model.FuguConversation;
import com.hippo.utils.ColorGenerator;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.TextDrawable;
import java.util.ArrayList;

public class FuguChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private Typeface customBold;
    private Typeface customNormal;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> arrayList, String string2, Long l, String string3, Callback callback, String string4, boolean bl) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = arrayList;
        this.activity = activity;
        this.userName = string2;
        this.businessName = string3;
        this.userId = l;
        this.callback = callback;
        this.enUserId = string4;
        this.customBold = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/montserrat_semibold.otf");
        this.customNormal = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/montserrat_regular.otf");
    }

    private RequestOptions getRequestOptions(String string2) {
        Object object;
        ColorGenerator colorGenerator = ColorGenerator.MATERIAL;
        int n = colorGenerator.getColor(string2.trim());
        int n2 = this.hippoColorConfig.getHippoActionBarBg();
        Resources resources = this.activity.getResources();
        float f2 = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)resources.getDisplayMetrics());
        string2 = string2.trim();
        char c2 = ' ';
        if (TextUtils.isEmpty((CharSequence)string2)) {
            object = CommonData.getUserDetails().getData().getBusinessName();
            c2 = object.trim().charAt(0);
        } else {
            c2 = string2.trim().charAt(0);
        }
        object = TextDrawable.builder().buildRoundRect((c2 + "").toUpperCase(), n, Math.round(f2));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).fitCenter()).priority(Priority.HIGH)).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)object);
        this.options.error((Drawable)object);
        return this.options;
    }

    public void updateList(ArrayList<FuguConversation> arrayList) {
        this.fuguConversationList = arrayList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        View view = this.inflater.inflate(R.layout.fugu_item_channels, viewGroup, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        try {
            final ChannelViewHolder channelViewHolder = (ChannelViewHolder)viewHolder;
            final FuguConversation fuguConversation = this.fuguConversationList.get(n);
            channelViewHolder.tvChannelName.setText((CharSequence)fuguConversation.getLabel());
            channelViewHolder.tvChannelName.setTextColor(this.hippoColorConfig.getHippoListTextColorPrimary());
            channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoListTextColorSecondary());
            if (fuguConversation.getMessage_type() == 18) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)this.getMessageData(fuguConversation)));
            } else if (TextUtils.isEmpty((CharSequence)fuguConversation.getMessage())) {
                if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                        if (fuguConversation.getMessage_type() == 10) {
                            channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.fugu_attachment)));
                        } else if (fuguConversation.getMessage_type() == 11) {
                            channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.hippo_attachment_file)));
                        } else {
                            channelViewHolder.tvMessage.setText((CharSequence)"You sent a message");
                        }
                    } else if (fuguConversation.getMessage_type() == 10) {
                        channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.fugu_attachment)));
                    } else if (fuguConversation.getMessage_type() == 11) {
                        channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.hippo_attachment_file)));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)(fuguConversation.getLast_sent_by_full_name().trim() + " sent a message"));
                    }
                }
            } else if (fuguConversation.getMessage().contains("\n")) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage().replaceAll("\n", " ")));
                if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                    HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                    HippoLog.e("error", fuguConversation.getUserId() + "");
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + fuguConversation.getMessage())));
                    }
                } else if (fuguConversation.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage()));
                }
            } else if (!TextUtils.isEmpty((CharSequence)fuguConversation.getLast_sent_by_full_name())) {
                HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                HippoLog.e("error", fuguConversation.getUserId() + "");
                if (HippoConfig.getInstance().getUserData().getUserId().compareTo(fuguConversation.getLast_sent_by_id()) == 0) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(fuguConversation.getLast_sent_by_full_name().trim() + ": " + fuguConversation.getMessage())));
                }
            } else if (fuguConversation.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + fuguConversation.getMessage())));
            } else {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)fuguConversation.getMessage()));
            }
            try {
                channelViewHolder.tvChannelName.setTypeface(this.customBold);
                channelViewHolder.tvDate.setTypeface(this.customNormal);
                channelViewHolder.closed.setTypeface(this.customBold);
                channelViewHolder.tvMessage.setTypeface(this.customNormal);
                channelViewHolder.circularTvMessageCount.setTypeface(this.customNormal);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelDateText());
            if (fuguConversation.getUnreadCount() > 0) {
                channelViewHolder.circularTvMessageCount.setVisibility(0);
                channelViewHolder.circularTvMessageCount.setText((CharSequence)String.valueOf(fuguConversation.getUnreadCount()));
                channelViewHolder.tvDate.setTypeface(this.customBold);
            } else {
                channelViewHolder.circularTvMessageCount.setVisibility(8);
                channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoChannelReadMessage());
                channelViewHolder.tvMessage.setTypeface(this.customBold);
            }
            String string2 = fuguConversation.getLabel().trim().substring(0, 1).toUpperCase();
            Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(string2)).load(fuguConversation.getChannelImage()).into(channelViewHolder.ivChannelIcon);
            channelViewHolder.ivChannelIcon.setVisibility(0);
            try {
                if (fuguConversation.getChannelId() == null || fuguConversation.getChannelId().intValue() < 0) {
                    channelViewHolder.tvDate.setVisibility(8);
                } else {
                    channelViewHolder.tvDate.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(fuguConversation.getDateTime()), true));
                    channelViewHolder.tvDate.setVisibility(0);
                }
            }
            catch (Exception exception) {
                channelViewHolder.tvDate.setVisibility(8);
            }
            if (fuguConversation.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal()) {
                channelViewHolder.closed.setTextColor(this.hippoColorConfig.getHippoActionBarBg());
                channelViewHolder.closed.setText((CharSequence)"closed");
                channelViewHolder.closed.setVisibility(0);
                channelViewHolder.mainLayout.setBackgroundColor(-1);
            } else {
                channelViewHolder.closed.setVisibility(8);
                channelViewHolder.mainLayout.setBackgroundColor(-1);
            }
            channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    channelViewHolder.circularTvMessageCount.setVisibility(8);
                    fuguConversation.setUnreadCount(0);
                    FuguConversation fuguConversation2 = new FuguConversation();
                    fuguConversation2.setLabel(fuguConversation.getLabel());
                    fuguConversation2.setChannelId(fuguConversation.getChannelId());
                    fuguConversation2.setLabelId(fuguConversation.getLabelId());
                    fuguConversation2.setDefaultMessage(fuguConversation.getMessage());
                    fuguConversation2.setChannelStatus(fuguConversation.getChannelStatus());
                    fuguConversation2.setChannelImage(fuguConversation.getChannelImage());
                    fuguConversation2.setBusinessName(FuguChannelsAdapter.this.businessName);
                    fuguConversation2.setUserId(FuguChannelsAdapter.this.userId);
                    fuguConversation2.setEnUserId(FuguChannelsAdapter.this.enUserId);
                    fuguConversation2.setOpenChat(true);
                    fuguConversation2.setUserName(FuguChannelsAdapter.this.userName);
                    fuguConversation2.setIsTimeSet(1);
                    fuguConversation2.setChatType(fuguConversation.getChatType());
                    fuguConversation2.setStatus(fuguConversation.getStatus());
                    fuguConversation2.setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                    FuguChannelsAdapter.this.callback.onClick(fuguConversation2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.fuguConversationList.size();
    }

    private String getMessageData(FuguConversation fuguConversation) {
        String string2 = "The video call ended";
        String string3 = "video";
        if (!TextUtils.isEmpty((CharSequence)fuguConversation.getCallType()) && fuguConversation.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            string3 = "voice";
        }
        string2 = fuguConversation.getMessageState() != null && fuguConversation.getMessageState() == 2 ? (fuguConversation.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId()) ? "Customer missed a " + string3 + " call with you" : "You missed a " + string3 + " call with " + fuguConversation.getLast_sent_by_full_name()) : "The " + string3 + " call ended";
        return string2;
    }

    public static interface Callback {
        public void onClick(FuguConversation var1);
    }

    class footerView
    extends RecyclerView.ViewHolder {
        public footerView(@NonNull View view) {
            super(view);
        }
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private RelativeLayout mainLayout;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private ImageView ivChannelIcon;
        private TextView circularTvMessageCount;
        private TextView closed;

        ChannelViewHolder(View view) {
            super(view);
            this.rlRoot = (RelativeLayout)view.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)view.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)view.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)view.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)view.findViewById(R.id.ivChannelIcon);
            this.circularTvMessageCount = (TextView)view.findViewById(R.id.circularTvMessageCount);
            this.closed = (TextView)view.findViewById(R.id.closed);
            this.mainLayout = (RelativeLayout)view.findViewById(R.id.main_layout);
        }
    }
}

