/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.adapter.QRCallback;
import com.hippo.model.Message;
import com.hippo.utils.Utils;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import java.util.ArrayList;
import java.util.Objects;

public class DataFormAdapter
extends RecyclerView.Adapter<QRViewHolder> {
    private static final String TAG = DataFormAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<String> arrayList;
    private QRCallback qrCallback;
    private ArrayList<Question> question = new ArrayList();
    private Message currentFormMsg;
    private FragmentManager fragmentManager;

    public DataFormAdapter(Message message, QRCallback qRCallback, FragmentManager fragmentManager) {
        this.currentFormMsg = message;
        this.qrCallback = qRCallback;
        this.fragmentManager = fragmentManager;
        this.question.clear();
        try {
            if (message.getContentValue() != null && message.getContentValue().size() > 0 && message.getContentValue().get(0).getQuestions() != null) {
                for (int j = 0; j < message.getContentValue().get(0).getQuestions().size(); ++j) {
                    if (message.getValues() == null || message.getValues().size() <= j) {
                        this.question.add(new Question(message.getContentValue().get(0).getQuestions().get(j), null, message.getContentValue().get(0).getData_type().get(j), message.getContentValue().get(0).getTextValue(), message.getContentValue().get(0).getCountryCode()));
                        return;
                    }
                    this.question.add(new Question(message.getContentValue().get(0).getQuestions().get(j), message.getValues().get(j), message.getContentValue().get(0).getData_type().get(j), null, null));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public QRViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        this.context = viewGroup.getContext();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_data_form, viewGroup, false);
        return new QRViewHolder(view, new MyFormEditTextListener());
    }

    @RequiresApi(api=19)
    public void onBindViewHolder(QRViewHolder qRViewHolder, int n) {
        if (Objects.equals(this.question.get((int)n).type, "phone")) {
            qRViewHolder.title.setText((CharSequence)(this.question.get(n).getQuestion() + " with country code"));
            qRViewHolder.title.setText((CharSequence)"Enter your phone");
        } else {
            qRViewHolder.title.setText((CharSequence)this.question.get(n).getQuestion());
        }
        try {
            if (n == 0) {
                qRViewHolder.countView.setVisibility(0);
                qRViewHolder.countView.setText((CharSequence)(this.question.size() + "/" + this.currentFormMsg.getContentValue().get(0).getQuestions().size()));
            } else {
                qRViewHolder.countView.setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.question.get(n).isAnswered()) {
            qRViewHolder.etInputData.setText((CharSequence)this.question.get(n).getAnswer());
            qRViewHolder.etInputData.setEnabled(false);
            qRViewHolder.etInputData.setFocusable(false);
            qRViewHolder.etInputData.setFocusableInTouchMode(false);
            qRViewHolder.etInputData.setClickable(false);
            qRViewHolder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_tick));
            qRViewHolder.arrowBgView.setVisibility(8);
            qRViewHolder.countryView.setVisibility(8);
        } else {
            qRViewHolder.etInputData.setHint((CharSequence)this.question.get(n).getQuestion());
            qRViewHolder.myCustomEditTextListener.updatePosition(this.currentFormMsg, n);
            qRViewHolder.etInputData.setEnabled(true);
            qRViewHolder.etInputData.setSingleLine(true);
            qRViewHolder.etInputData.setFocusable(true);
            qRViewHolder.etInputData.setFocusableInTouchMode(true);
            qRViewHolder.etInputData.setClickable(true);
            qRViewHolder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_arrow));
            qRViewHolder.arrowBgView.setVisibility(0);
            if (this.currentFormMsg.getIsSkipEvent() == 0 && this.currentFormMsg.isSkipButton() && n == this.question.size() - 1) {
                qRViewHolder.btnSkip.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.question.get((int)n).text)) {
                qRViewHolder.etInputData.setText((CharSequence)this.question.get((int)n).text);
            }
            switch (this.question.get((int)n).type) {
                case "Number": {
                    qRViewHolder.etInputData.setInputType(8194);
                    qRViewHolder.etInputData.setSingleLine(true);
                    break;
                }
                case "email": {
                    qRViewHolder.etInputData.setInputType(33);
                    break;
                }
                case "phone": {
                    qRViewHolder.etInputData.setInputType(3);
                    qRViewHolder.countryView.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)this.question.get((int)n).countryCode)) {
                        qRViewHolder.countryView.setText((CharSequence)this.question.get((int)n).countryCode);
                        break;
                    }
                    String string2 = this.getDefaultCode();
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        qRViewHolder.countryView.setText((CharSequence)this.getDefaultCode());
                        break;
                    }
                    qRViewHolder.countryView.setText((CharSequence)"+91");
                }
            }
        }
    }

    public int getItemCount() {
        return this.question == null ? 0 : this.question.size();
    }

    public boolean isValid(String string2, EditText editText, String string3, TextView textView) {
        boolean bl;
        if (string2.isEmpty()) {
            textView.setText((CharSequence)"Field can't be empty");
            textView.setVisibility(0);
            return false;
        }
        String string4 = null;
        switch (string3) {
            case "Number": {
                bl = Utils.isNumeric(string2);
                string4 = bl ? null : "Enter numeric values only";
                break;
            }
            case "email": {
                bl = Utils.isEmailValid(string2);
                string4 = bl ? null : "Enter valid email";
                break;
            }
            case "phone": {
                bl = Utils.isValidPhoneNumber(string2);
                string4 = bl ? null : "Enter valid phone number";
                break;
            }
            default: {
                bl = true;
            }
        }
        editText.requestFocus();
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            textView.setVisibility(0);
            textView.setText((CharSequence)string4);
        } else {
            textView.setVisibility(8);
        }
        return bl;
    }

    private String getDefaultCode() {
        try {
            CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).build();
            return countryPicker.getCountryFromSIM().getDialCode();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void openPicker(final TextView textView, final EditText editText) {
        CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                textView.setText((CharSequence)country.getDialCode());
                DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(country.getDialCode());
                editText.requestFocus();
            }
        }).build();
        countryPicker.showDialog(this.fragmentManager);
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private Message currentOrderItem;
        private int position;

        public void updatePosition(Message message, int n) {
            this.currentOrderItem = message;
            this.position = n;
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            if (this.currentOrderItem != null) {
                this.currentOrderItem.setComment(charSequence.toString());
            }
        }

        public void afterTextChanged(Editable editable) {
            if (this.currentOrderItem != null) {
                DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(editable.toString());
            }
        }
    }

    public class Question {
        String question;
        String answer;
        String type;
        String text;
        String countryCode;
        boolean isAnswered;

        public Question(String string2, String string3, String string4, String string5, String string6) {
            this.question = string2;
            this.answer = string3;
            this.type = string4;
            this.text = string5;
            this.countryCode = string6;
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.isAnswered = true;
            }
        }

        public String getQuestion() {
            return this.question;
        }

        public void setQuestion(String string2) {
            this.question = string2;
        }

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String string2) {
            this.answer = string2;
        }

        public boolean isAnswered() {
            return this.isAnswered;
        }

        public void setAnswered(boolean bl) {
            this.isAnswered = bl;
        }
    }

    public class QRViewHolder
    extends RecyclerView.ViewHolder {
        public MyFormEditTextListener myCustomEditTextListener;
        ImageView actionView;
        ImageView arrowBgView;
        private EditText etInputData;
        private TextView tvError;
        private TextView title;
        private TextView countView;
        private TextView countryView;
        private TextView btnSkip;

        public QRViewHolder(View view, MyFormEditTextListener myFormEditTextListener) {
            super(view);
            this.etInputData = (EditText)view.findViewById(R.id.etInputData);
            this.myCustomEditTextListener = myFormEditTextListener;
            this.etInputData.addTextChangedListener((TextWatcher)myFormEditTextListener);
            this.title = (TextView)view.findViewById(R.id.title_view);
            this.tvError = (TextView)view.findViewById(R.id.tvError);
            this.countView = (TextView)view.findViewById(R.id.count_view);
            this.countryView = (TextView)view.findViewById(R.id.country_picker);
            this.actionView = (ImageView)view.findViewById(R.id.action_view);
            this.arrowBgView = (ImageView)view.findViewById(R.id.arrow_background_view);
            this.btnSkip = (TextView)view.findViewById(R.id.btnSkip);
            this.actionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (DataFormAdapter.this.isValid(DataFormAdapter.this.currentFormMsg.getComment(), QRViewHolder.this.etInputData, ((Question)((DataFormAdapter)DataFormAdapter.this).question.get((int)QRViewHolder.this.getAdapterPosition())).type, QRViewHolder.this.tvError)) {
                        if (QRViewHolder.this.countryView.getVisibility() == 0) {
                            String string2 = DataFormAdapter.this.currentFormMsg.getComment();
                            DataFormAdapter.this.currentFormMsg.setComment(QRViewHolder.this.countryView.getText().toString().trim() + string2);
                        }
                        DataFormAdapter.this.qrCallback.onFormClickListener(QRViewHolder.this.getAdapterPosition(), DataFormAdapter.this.currentFormMsg);
                        DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(null);
                        DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(null);
                    }
                }
            });
            this.btnSkip.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DataFormAdapter.this.qrCallback.skipFormCallback(DataFormAdapter.this.currentFormMsg);
                }
            });
            this.countryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DataFormAdapter.this.openPicker(QRViewHolder.this.countryView, QRViewHolder.this.etInputData);
                }
            });
        }
    }
}

