/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.adapter.AgentViewListener;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.model.Message;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.showmoretextview.ShowMoreTextView;

public class AgentSnapAdapter
extends RecyclerView.Adapter<ViewHolder>
implements OnRecyclerListener {
    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private AgentViewListener viewListener;
    private OnRecyclerListener itemClickListener;
    private Message message;

    public AgentSnapAdapter(Context context, Message message, AgentViewListener agentViewListener) {
        this.mContext = context;
        this.viewListener = agentViewListener;
        this.message = message;
        this.itemClickListener = this.itemClickListener;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        return new ViewHolder(this.mLayoutInflater.inflate(R.layout.hippo_agent_snap_itam, viewGroup, false), this);
    }

    public long getItemId(int n) {
        try {
            return Integer.parseInt(this.message.getContentValue().get(n).getCardId());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int n) {
        viewHolder.agentName.setText((CharSequence)this.message.getContentValue().get(n).getTitle());
        String string2 = this.message.getContentValue().get(n).getDescription();
        if (n == 0) {
            viewHolder.fakeView.setVisibility(0);
        } else {
            viewHolder.fakeView.setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            viewHolder.userSubCategory.setVisibility(8);
        } else {
            viewHolder.userSubCategory.setVisibility(0);
            viewHolder.userSubCategory.setText(string2);
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)this.message.getContentValue().get(n).getRatingValue())) {
                viewHolder.starLayout.setVisibility(0);
                viewHolder.starText.setText((CharSequence)("" + this.message.getContentValue().get(n).getRatingValue()));
            } else {
                viewHolder.starLayout.setVisibility(8);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            viewHolder.starLayout.setVisibility(8);
        }
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder));
        Glide.with((Context)this.mContext).load(this.message.getContentValue().get(n).getImageUrl()).apply((BaseRequestOptions)requestOptions).into((ImageView)viewHolder.userImageView);
    }

    public int getItemCount() {
        int n = 0;
        if (this.message != null && this.message.getContentValue() != null) {
            n = this.message.getContentValue().size();
        }
        return n;
    }

    @Override
    public void onItemClick(View view, View view2, int n) {
    }

    @Override
    public void onItemClick(View view, int n) {
    }

    private void showDialog(String string2) {
        new AlertDialog.Builder(this.mContext).setMessage((CharSequence)string2).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        }).setCancelable(true).show();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private CardView cardview;
        private AppCompatImageView userImageView;
        private AppCompatTextView agentName;
        private ShowMoreTextView userSubCategory;
        private View fakeView;
        private RatingBar ratingBar;
        private RelativeLayout starLayout;
        private TextView starText;
        private ImageView info;
        private LinearLayout info_layout;

        public ViewHolder(@NonNull View view, OnRecyclerListener onRecyclerListener) {
            super(view);
            this.cardview = (CardView)view.findViewById(R.id.cardView);
            this.userImageView = (AppCompatImageView)view.findViewById(R.id.userImage);
            this.agentName = (AppCompatTextView)view.findViewById(R.id.agentName);
            this.ratingBar = (RatingBar)view.findViewById(R.id.ratingBar2);
            this.starLayout = (RelativeLayout)view.findViewById(R.id.starLayout);
            this.starText = (TextView)view.findViewById(R.id.starText);
            this.userSubCategory = (ShowMoreTextView)view.findViewById(R.id.agentDesc);
            this.userSubCategory.setShowingLine(2);
            this.info = (ImageView)view.findViewById(R.id.info);
            this.info_layout = (LinearLayout)view.findViewById(R.id.info_layout);
            this.fakeView = view.findViewById(R.id.fakeView);
            this.userSubCategory.setVisibility(8);
            this.cardview.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (AgentSnapAdapter.this.viewListener != null) {
                        String string2 = AgentSnapAdapter.this.message.getContentValue().get(ViewHolder.this.getAdapterPosition()).getCardId();
                        AgentSnapAdapter.this.viewListener.onCardClickListener(AgentSnapAdapter.this.message, string2, ViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.info_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (AgentSnapAdapter.this.viewListener != null) {
                        String string2 = AgentSnapAdapter.this.message.getContentValue().get(ViewHolder.this.getAdapterPosition()).getCardId();
                        AgentSnapAdapter.this.viewListener.onShowProfile(AgentSnapAdapter.this.message, string2, ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

