/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.database.CommonData;
import com.hippo.model.MakePayment;
import com.hippo.model.PaymentResponse;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.payment.PaymentConstants;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.loadingBox.ProgressWheel;
import retrofit2.Callback;

public class PaymentDialogFragment
extends DialogFragment {
    private RelativeLayout rootToolbar;
    private ImageView ivBackBtn;
    private TextView tvToolbarName;
    private ImageView userImageIcon;
    private ImageView ivVideoView;
    private ImageView ivAudioView;
    private ImageView ivHistoryView;
    private RelativeLayout loadingLayout;
    private ProgressWheel progressWheel;
    private TextView textView;
    private MakePayment paymentData;
    private ProgressBar pbWebPageLoader;
    private WebView webView;
    private HippoColorConfig hippoColorConfig;
    private FuguChatActivity chatActivity;
    public OnInputListener onInputListener;
    private AddedPaymentGateway paymentGateway;
    String url = "";

    static PaymentDialogFragment newInstance(String string2, String string3, AddedPaymentGateway addedPaymentGateway) {
        PaymentDialogFragment paymentDialogFragment = new PaymentDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("paymentData", string3);
        bundle.putBoolean("fullScreen", true);
        bundle.putString("paymentGateway", new Gson().toJson((Object)addedPaymentGateway));
        paymentDialogFragment.setArguments(bundle);
        return paymentDialogFragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        return layoutInflater.inflate(R.layout.activity_webview, viewGroup, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        String string2 = "Payment";
        this.rootToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.userImageIcon = (ImageView)view.findViewById(R.id.user_image);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.ivVideoView = (ImageView)view.findViewById(R.id.ivVideoView);
        this.ivAudioView = (ImageView)view.findViewById(R.id.ivAudioView);
        this.ivHistoryView = (ImageView)view.findViewById(R.id.ivHistoryView);
        this.loadingLayout = (RelativeLayout)view.findViewById(R.id.loadingLayout);
        this.progressWheel = (ProgressWheel)view.findViewById(R.id.circle_progress);
        this.textView = (TextView)view.findViewById(R.id.text);
        this.hippoColorConfig = CommonData.getColorConfig();
        this.rootToolbar.setBackgroundColor(this.hippoColorConfig.getHippoActionBarBg());
        this.tvToolbarName.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.tvToolbarName.setText((CharSequence)string2);
        this.pbWebPageLoader = (ProgressBar)view.findViewById(R.id.pbWebPageLoader);
        this.webView = (WebView)view.findViewById(R.id.webView);
        this.userImageIcon.setVisibility(8);
        this.ivVideoView.setVisibility(8);
        this.ivAudioView.setVisibility(8);
        this.ivHistoryView.setVisibility(8);
        this.setWebViewProperties(this.webView);
        this.webView.addJavascriptInterface((Object)new MyJavaScriptInterface(), "android");
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PaymentDialogFragment.this.onInputListener != null) {
                    PaymentDialogFragment.this.onInputListener.closeFragment();
                }
                PaymentDialogFragment.this.dismiss();
            }
        });
        this.webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.handleLayout(1);
            this.webView.loadUrl(this.url);
        } else {
            this.handleLayout(0);
            this.createPaymentLink(this.paymentData);
        }
    }

    private void handleLayout(int n) {
        if (n == 0) {
            this.loadingLayout.setVisibility(0);
            this.webView.setVisibility(8);
        } else if (n == 2) {
            this.progressWheel.setVisibility(8);
            this.textView.setText((CharSequence)"Something went wrong! \n Please try again");
        } else {
            this.loadingLayout.setVisibility(8);
            this.webView.setVisibility(0);
        }
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient((WebViewClient)new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(0);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(0);
        }
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView webView3, boolean bl, boolean bl2, Message message) {
                WebView webView2 = new WebView((Context)PaymentDialogFragment.this.getActivity());
                webView2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                if ((long)PaymentDialogFragment.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    webView.addView((View)webView2);
                }
                if ((long)PaymentDialogFragment.this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
                    PaymentDialogFragment.this.setWebViewProperties(webView2);
                } else {
                    PaymentDialogFragment.this.setWebViewProperties(webView);
                }
                WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
                webViewTransport.setWebView(webView2);
                message.sendToTarget();
                return true;
            }

            public void onCloseWindow(WebView webView2) {
                HippoLog.e("onCloseWindow", webView2 + "");
                webView.removeView((View)webView2);
                super.onCloseWindow(webView2);
            }

            public boolean onJsAlert(WebView webView2, String string2, String string3, JsResult jsResult) {
                HippoLog.e("URL onJsAlert", string2 + "");
                return super.onJsAlert(webView2, string2, string3, jsResult);
            }
        });
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.onInputListener = (OnInputListener)this.getActivity();
        }
        catch (ClassCastException classCastException) {
            HippoLog.e("TAG", "onAttach: " + classCastException.getMessage());
        }
        this.chatActivity = (FuguChatActivity)this.getActivity();
    }

    public void onResume() {
        super.onResume();
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.onInputListener != null) {
            this.onInputListener.closeFragment();
        }
        super.onDismiss(dialogInterface);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ivBackBtn) {
            // empty if block
        }
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.url = this.getArguments().getString("url");
        this.paymentData = (MakePayment)new Gson().fromJson(this.getArguments().getString("paymentData"), MakePayment.class);
        this.paymentGateway = (AddedPaymentGateway)new Gson().fromJson(this.getArguments().getString("paymentGateway"), AddedPaymentGateway.class);
        HippoLog.e("URL", "URL = " + this.url);
        boolean bl = true;
        if (this.getArguments() != null) {
            bl = this.getArguments().getBoolean("fullScreen");
        }
        this.setStyle(0, R.style.FullScreenDialogStyle);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    private boolean onOverrideUrlLoading(WebView webView, String string2) {
        HippoLog.e("loaded URL", string2 + " <<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer(string2);
        String string3 = "";
        String string4 = "";
        if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.RAZORPAY.intValue) {
            string3 = urlQuerySanitizer.getValue("rzp_payment_id");
        } else if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.BILLPLZ.intValue) {
            string3 = urlQuerySanitizer.getValue("billplz[id]");
        } else if ((long)this.paymentGateway.getGatewayId().intValue() == PaymentConstants.PaymentValue.PAYFORT.intValue) {
            string3 = urlQuerySanitizer.getValue("transactionId");
            string4 = urlQuerySanitizer.getValue("job_payment_detail_id");
        } else {
            string3 = urlQuerySanitizer.getValue("transactionId") != null ? urlQuerySanitizer.getValue("transactionId") : urlQuerySanitizer.getValue("transaction_id");
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            webView.loadUrl(string2);
            if (string2.contains("success") || string2.contains("Success")) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PaymentDialogFragment.this.dismiss();
                    }
                }, 1500L);
            } else if (string2.contains("error.html")) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PaymentDialogFragment.this.dismiss();
                    }
                }, 1500L);
            }
        }
        return true;
    }

    private void createPaymentLink(MakePayment makePayment) {
        if (this.chatActivity.isNetworkAvailable()) {
            makePayment.setPayment_gateway_id(this.paymentGateway.getGatewayId());
            makePayment.setIs_multi_gateway_flow(1);
            makePayment.setDevice_details(CommonData.deviceDetailString((Context)this.getActivity()));
            makePayment.setApp_version(251);
            makePayment.setDevice_id(UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity()));
            makePayment.setSource_type(1);
            makePayment.setDevice_type(1);
            RestClient.getApiInterface().createPaymentLink(makePayment).enqueue((Callback)new ResponseResolver<PaymentResponse>((Activity)this.getActivity(), Boolean.valueOf(false), Boolean.valueOf(true)){

                @Override
                public void success(PaymentResponse paymentResponse) {
                    if (!TextUtils.isEmpty((CharSequence)paymentResponse.getData().getPaymentUrl())) {
                        PaymentDialogFragment.this.handleLayout(1);
                        PaymentDialogFragment.this.webView.loadUrl(paymentResponse.getData().getPaymentUrl());
                    } else {
                        PaymentDialogFragment.this.handleLayout(2);
                    }
                }

                @Override
                public void failure(APIError aPIError) {
                    PaymentDialogFragment.this.handleLayout(2);
                }
            });
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    class MyJavaScriptInterface {
        MyJavaScriptInterface() {
        }

        @JavascriptInterface
        public void onUrlChange(String string2) {
            Log.d((String)"hydrated", (String)("onUrlChange" + string2));
        }
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
            return PaymentDialogFragment.this.onOverrideUrlLoading(webView, webResourceRequest.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            return PaymentDialogFragment.this.onOverrideUrlLoading(webView, string2);
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            super.onPageStarted(webView, string2, bitmap);
        }

        public void onPageFinished(WebView webView, String string2) {
            try {
                if (PaymentDialogFragment.this.pbWebPageLoader != null) {
                    PaymentDialogFragment.this.pbWebPageLoader.setVisibility(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.onPageFinished(webView, string2);
        }
    }

    public static interface OnInputListener {
        public void closeFragment();
    }
}

