/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.Image;
import com.hippo.utils.HippoLog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.PhotoView;
import com.hippo.utils.swipeLayout.frame.SwipeableLayout;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.util.List;

public class ImageDisplayActivityNew
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private SwipeableLayout swipeableLayout;
    private PhotoView ivImageBig;
    private ImageView ivImageGif;
    private Toolbar toolbar;
    private ImageView ivBack;
    private FrameLayout colorContainer;
    private ImageView ivDownload;
    private Image imageUrl = null;
    private int swipedFromDefault = 1;
    private float lastPerc = 0.0f;
    private boolean isTopBarVisivle = true;

    @Override
    protected void onCreate(Bundle bundle) {
        String string2;
        super.onCreate(bundle);
        this.setContentView(R.layout.hippo_activity_new_image);
        this.imageUrl = (Image)this.getIntent().getSerializableExtra("image");
        this.swipeableLayout = (SwipeableLayout)this.findViewById(R.id.swipeableLayout);
        this.ivImageBig = (PhotoView)this.findViewById(R.id.ivImageBigNew);
        this.ivImageGif = (ImageView)this.findViewById(R.id.ivImageGif);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.ivDownload = (ImageView)this.findViewById(R.id.ivDownload);
        this.colorContainer = (FrameLayout)this.findViewById(R.id.colorContainer);
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImageDisplayActivityNew.this.checkPermission()) {
                    ImageDisplayActivityNew.this.downloadFile(ImageDisplayActivityNew.this.imageUrl.getImageUrl());
                } else {
                    ImageDisplayActivityNew.this.requestPermission();
                }
            }
        });
        this.swipeableLayout.setOnLayoutPercentageChangeListener(new OnLayoutPercentageChangeListener(){

            @Override
            public void percentageX(float f2) {
                super.percentageX(f2);
            }

            @Override
            public void percentageY(float f2) {
                super.percentageY(f2);
                HippoLog.e("percent change", "percentage = " + f2);
                if (ImageDisplayActivityNew.this.lastPerc != 1.0f) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f - f2);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f - f2);
                }
                ImageDisplayActivityNew.this.lastPerc = f2;
            }
        });
        this.swipeableLayout.setLayoutShiftListener(new LayoutShiftListener(){

            @Override
            public void onLayoutShifted(float f2, float f3, boolean bl) {
                HippoLog.e("position Y", "positionY" + f3);
                if (!bl && ImageDisplayActivityNew.this.lastPerc != 1.0f && ImageDisplayActivityNew.this.swipedFromDefault == 1) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f);
                }
            }
        });
        this.swipeableLayout.setOnSwipedListener(new OnLayoutSwipedListener(){

            @Override
            public void onLayoutSwiped(int n) {
                ImageDisplayActivityNew.this.swipedFromDefault = n;
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.ivImageBig.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImageDisplayActivityNew.this.isTopBarVisivle) {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(-150.0f).setDuration(100L);
                } else {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(0.0f).setDuration(100L);
                }
                ImageDisplayActivityNew.this.isTopBarVisivle = !ImageDisplayActivityNew.this.isTopBarVisivle;
            }
        });
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).dontTransform();
        this.supportPostponeEnterTransition();
        if (Build.VERSION.SDK_INT >= 21) {
            this.ivImageBig.setTransitionName(this.imageUrl.getTransitionName());
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = Util.getExtension(this.imageUrl.getImageUrl()))) && string2.equalsIgnoreCase("gif")) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setDuration(500L);
            objectAnimator.setStartDelay(200L);
            objectAnimator.start();
            this.supportStartPostponedEnterTransition();
            this.ivImageGif.setVisibility(0);
            this.ivImageBig.setVisibility(8);
            ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this).asGif().load(this.imageUrl.getImageUrl()).error(R.drawable.hippo_placeholder)).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.ivImageGif);
        } else {
            Glide.with((FragmentActivity)this).load(this.imageUrl.getImageUrl()).apply((BaseRequestOptions)requestOptions).into((Target)new SimpleTarget<Drawable>(){

                public void onResourceReady(@NonNull Drawable drawable2, @Nullable Transition<? super Drawable> transition) {
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)ImageDisplayActivityNew.this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                    objectAnimator.setDuration(500L);
                    objectAnimator.setStartDelay(200L);
                    objectAnimator.start();
                    ImageDisplayActivityNew.this.supportStartPostponedEnterTransition();
                    ImageDisplayActivityNew.this.ivImageBig.setImageDrawable(drawable2);
                }
            });
        }
        this.ivImageBig.setOnDoubleTap(new OnDoubleTap(){

            @Override
            public void onDoubleTap(float f2) {
                if (f2 <= 1.0f) {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(true);
                } else {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(false);
                }
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.supportFinishAfterTransition();
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult(n, stringArray, nArray, this);
    }

    private Long downloadFile(String string2) {
        String string3 = Util.extractFileNameWithoutSuffix(string2);
        String string4 = Util.getExtension(string2);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        if (AgentCommonData.isAgentFlow()) {
            request.setDescription((CharSequence)AgentCommonData.getUserData().getBusinessName());
        } else {
            request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
        }
        request.setTitle((CharSequence)string3);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        String string5 = Util.getOrCreateDirectoryPath(FuguAppConstant.DocumentType.IMAGE.toString());
        request.setDestinationInExternalPublicDir(string5, string3 + string4);
        request.setMimeType("image/jpeg");
        DownloadManager downloadManager = (DownloadManager)this.getSystemService("download");
        if (downloadManager != null) {
            return downloadManager.enqueue(request);
        }
        return null;
    }

    private void requestPermission() {
        EasyPermissions.requestPermissions((Activity)this, this.getString(R.string.vw_rationale_storage), 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private boolean checkPermission() {
        return EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    @Override
    public void onPermissionsGranted(int n, @NonNull List<String> list) {
        if (this.imageUrl != null && !TextUtils.isEmpty((CharSequence)this.imageUrl.getImageUrl())) {
            this.downloadFile(this.imageUrl.getImageUrl());
        }
    }

    @Override
    public void onPermissionsDenied(int n, @NonNull List<String> list) {
        ToastUtil.getInstance((Context)this).showToast(this.getString(R.string.hippo_storage_permission));
    }
}

