/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.CaptureUserData;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.GroupingTag;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoNotificationConfig;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.HippoChannelsAdapter;
import com.hippo.apis.ApiGetConversation;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UnreadCountModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.StringUtil;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.fileUpload.Prefs;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import retrofit2.Callback;

public class FuguChannelsActivity
extends FuguBaseActivity
implements Animation.AnimationListener,
SwipeRefreshLayout.OnRefreshListener {
    private final String TAG = FuguChannelsActivity.class.getSimpleName();
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;
    private RelativeLayout rlRoot;
    private SwipeRefreshLayout swipeRefresh;
    private RecyclerView rvChannels;
    private TextView tvNoInternet;
    private TextView tvNewConversation;
    private final int READ_PHONE_PERMISSION = 101;
    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;
    private final int IS_HIT_REQUIRED = 200;
    public static boolean isRefresh = false;
    public static Long readChannelId = -1L;
    public static Long readLabelId = -1L;
    private TextView tvPoweredBy;
    private HippoColorConfig hippoColorConfig;
    @SuppressLint(value={"StaticFieldLeak"})
    private static LinearLayout llInternet;
    @SuppressLint(value={"StaticFieldLeak"})
    private static TextView tvStatus;
    private boolean isScreenOpen = false;
    private boolean isFirstTimeOpen = true;
    private boolean isFromHistory = false;
    private Long openedChannelId = -1L;
    private ImageView llNoConversation;
    private TextView noConversationTextView;
    private Button createBtn;
    private HippoChannelsAdapter hippoChannelsAdapter;
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean isPagingApiInProgress;
    private HippoChannelsAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> fuguConversationList = new ArrayList();
    BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!FuguChannelsActivity.this.isScreenOpen) {
                    return;
                }
                JSONObject jSONObject = new JSONObject(intent.getStringExtra("message"));
                HippoLog.d("receiver", "Got message: " + jSONObject.toString());
                boolean bl = false;
                boolean bl2 = false;
                if (jSONObject.has("notification_type") && jSONObject.getInt("notification_type") == 5) {
                    FuguChannelsActivity.this.getConversations();
                } else {
                    FuguConversation fuguConversation;
                    int n;
                    if (jSONObject.has("channel_id") && jSONObject.getLong("channel_id") > 0L && (n = FuguChannelsActivity.this.fuguConversationList.indexOf(new FuguConversation(jSONObject.getLong("channel_id")))) != -1) {
                        bl = true;
                    }
                    if (jSONObject.has("label_id") && jSONObject.getLong("label_id") > 0L) {
                        for (n = 0; n < FuguChannelsActivity.this.fuguConversationList.size(); ++n) {
                            if (!(FuguChannelsActivity.this.fuguConversationList.get(n) instanceof FuguConversation) || (fuguConversation = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(n)).getLabelId().longValue() != jSONObject.getLong("label_id")) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl && !bl2) {
                        FuguChannelsActivity.this.getConversations();
                    } else if (jSONObject.has("new_message") && jSONObject.has("channel_id")) {
                        n = FuguChannelsActivity.this.fuguConversationList.indexOf(new FuguConversation(jSONObject.getLong("channel_id")));
                        if (n > -1) {
                            if (FuguChannelsActivity.this.fuguConversationList.get(n) instanceof FuguConversation) {
                                fuguConversation = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(n);
                                fuguConversation.setDateTime(jSONObject.getString("date_time").replace("+00:00", ".000Z"));
                                if (jSONObject.has("new_message")) {
                                    fuguConversation.setMessage(jSONObject.getString("new_message"));
                                }
                                if (HippoNotificationConfig.pushChannelId.compareTo(jSONObject.getLong("channel_id")) != 0) {
                                    fuguConversation.setUnreadCount(fuguConversation.getUnreadCount() + 1);
                                } else {
                                    fuguConversation.setUnreadCount(0);
                                }
                                fuguConversation.setLast_sent_by_id(jSONObject.getLong("last_sent_by_id"));
                                fuguConversation.setLast_sent_by_full_name(jSONObject.getString("last_sent_by_full_name"));
                                if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                                    FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                                }
                                FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                            }
                        } else {
                            FuguChannelsActivity.this.getConversations();
                        }
                    } else if (jSONObject.has("new_message") && jSONObject.has("label_id")) {
                        n = -1;
                        for (int j = 0; j < FuguChannelsActivity.this.fuguConversationList.size(); ++j) {
                            FuguConversation fuguConversation2;
                            if (!(FuguChannelsActivity.this.fuguConversationList.get(j) instanceof FuguConversation) || (fuguConversation2 = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(j)).getLabelId().compareTo(jSONObject.getLong("label_id")) != 0) continue;
                            n = j;
                            break;
                        }
                        if (n > -1) {
                            if (FuguChannelsActivity.this.fuguConversationList.get(n) instanceof FuguConversation) {
                                FuguConversation fuguConversation3 = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(n);
                                fuguConversation3.setDateTime(jSONObject.getString("date_time").replace("+00:00", ".000Z"));
                                if (jSONObject.has("new_message")) {
                                    fuguConversation3.setMessage(jSONObject.getString("new_message"));
                                }
                                if (HippoNotificationConfig.pushLabelId.compareTo(jSONObject.getLong("label_id")) != 0) {
                                    fuguConversation3.setUnreadCount(fuguConversation3.getUnreadCount() + 1);
                                } else {
                                    fuguConversation3.setUnreadCount(0);
                                }
                                fuguConversation3.setLast_sent_by_id(jSONObject.getLong("last_sent_by_id"));
                                fuguConversation3.setLast_sent_by_full_name(jSONObject.getString("last_sent_by_full_name"));
                                if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                                    FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                                }
                                FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                            }
                        } else {
                            FuguChannelsActivity.this.getConversations();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();
    int pageStart = 1;
    int pageEnd = 0;
    int defaultPageSize = 20;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.fugu_activity_channels);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mMessageReceiver, new IntentFilter("notification_received"));
        this.initViews();
        this.decideAppFlow();
        HippoConfig.getInstance().setChannelActivity(true);
    }

    private void initViews() {
        this.isFromHistory = this.getIntent().getBooleanExtra("from_history", false);
        this.openedChannelId = this.getIntent().getLongExtra("channelId", -1L);
        this.hippoColorConfig = CommonData.getColorConfig();
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(toolbar);
        String string2 = this.getIntent().getStringExtra("title");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = CommonData.getChatTitle();
        }
        this.setToolbar(toolbar, string2);
        this.appVersion = this.getIntent().getIntExtra("appVersion", 0);
        this.rlRoot = (RelativeLayout)this.findViewById(R.id.rlRoot);
        this.swipeRefresh = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefresh);
        this.swipeRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.rvChannels = (RecyclerView)this.findViewById(R.id.rvChannels);
        this.createBtn = (Button)this.findViewById(R.id.createBtn);
        this.tvNoInternet = (TextView)this.findViewById(R.id.tvNoInternet);
        this.tvNewConversation = (TextView)this.findViewById(R.id.tvNewConversation);
        this.tvPoweredBy = (TextView)this.findViewById(R.id.tvPoweredBy);
        tvStatus = (TextView)this.findViewById(R.id.tvStatus);
        llInternet = (LinearLayout)this.findViewById(R.id.llInternet);
        this.llNoConversation = (ImageView)this.findViewById(R.id.llNoConversation);
        this.noConversationTextView = (TextView)this.findViewById(R.id.noConversationTextView);
        this.configColors();
        if (!this.isNetworkAvailable()) {
            llInternet.setVisibility(0);
            llInternet.setBackgroundColor(Color.parseColor((String)"#FF0000"));
            tvStatus.setText(R.string.fugu_not_connected_to_internet);
        }
        this.createBtn.setText((CharSequence)this.getString(R.string.talk_to));
        this.rvChannels.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                if ((n2 > 0 || n2 < 0) && FuguChannelsActivity.this.createBtn.getVisibility() == 0) {
                    FuguChannelsActivity.this.createBtn.setVisibility(8);
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int n) {
                if (n == 0) {
                    FuguChannelsActivity.this.createBtn.setVisibility(0);
                }
                super.onScrollStateChanged(recyclerView, n);
            }
        });
        this.createBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FuguChannelsActivity.this.createConversation();
            }
        });
    }

    private void decideAppFlow() {
        if (CommonData.getUserDetails() != null && CommonData.getConversationList().size() > 0 || this.isFromHistory || CommonData.getUpdatedDetails().getData().isMultiChannelLabelMapping()) {
            this.setUpUI();
            this.getConversations(true);
        } else {
            this.sendUserDetails();
        }
    }

    private void setApiHit() {
        if (CommonData.getUserDetails() != null && CommonData.getConversationList().size() > 0 || this.isFromHistory) {
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setUpUI() {
        this.tvNoInternet.setVisibility(8);
        this.swipeRefresh.setVisibility(0);
        FuguPutUserDetailsResponse.Data data = CommonData.getUserDetails().getData();
        this.label = data.getBusinessName();
        this.businessName = data.getBusinessName();
        this.userId = data.getUserId();
        this.enUserId = data.getEn_user_id();
        if (!TextUtils.isEmpty((CharSequence)data.getFullName())) {
            this.userName = data.getFullName();
        }
        this.fuguConversationList.clear();
        try {
            if (CommonData.getConversationList().size() > 0) {
                this.fuguConversationList.addAll(CommonData.getConversationList());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setRecyclerViewData();
        this.setPoweredByText(data);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
    }

    public void onRefresh() {
        this.getConversations(false);
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
    }

    public void onAnimationRepeat(Animation animation) {
    }

    @Override
    protected void onResume() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancelAll();
        }
        super.onResume();
        this.isScreenOpen = true;
        if (isRefresh) {
            isRefresh = false;
            try {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    if (!(this.fuguConversationList.get(j) instanceof FuguConversation)) continue;
                    FuguConversation fuguConversation = (FuguConversation)this.fuguConversationList.get(j);
                    if (readChannelId > -1L && fuguConversation.getChannelId() > -1L && fuguConversation.getChannelId().compareTo(readChannelId) == 0) {
                        fuguConversation.setUnreadCount(0);
                        if (this.hippoChannelsAdapter != null) {
                            this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                    } else {
                        if (readLabelId <= -1L || fuguConversation.getLabelId() <= -1L || fuguConversation.getLabelId().compareTo(readLabelId) != 0) continue;
                        fuguConversation.setUnreadCount(0);
                        if (this.hippoChannelsAdapter != null) {
                            this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.updateCount(this.fuguConversationList);
        }
        if (!this.isFirstTimeOpen) {
            this.setApiHit();
        }
        this.isFirstTimeOpen = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.isScreenOpen = false;
        this.isFirstTimeOpen = false;
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        HippoLog.d(this.TAG, "Permission callback called-------" + n);
        switch (n) {
            case 101: {
                if (HippoConfig.getInstance().getTargetSDKVersion() > 22 && nArray.length > 0 && nArray[0] == 0) {
                    this.sendUserDetails();
                    break;
                }
                if (HippoConfig.getInstance().getTargetSDKVersion() <= 22 && nArray.length > 0 && nArray[0] == 0) {
                    this.sendUserDetails();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Go to Settings and grant permission to access phone state", (int)1).show();
                this.finish();
            }
        }
    }

    private void configColors() {
        this.rlRoot.setBackgroundColor(this.hippoColorConfig.getHippoChannelBg());
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        if (Build.VERSION.SDK_INT >= 16) {
            this.tvNewConversation.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        } else {
            this.tvNewConversation.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        }
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.swipeRefresh.setColorSchemeColors(new int[]{this.hippoColorConfig.getHippoThemeColorPrimary()});
        this.tvNoInternet.setTextColor(this.hippoColorConfig.getHippoThemeColorSecondary());
    }

    protected void onDestroy() {
        super.onDestroy();
        HippoConfig.getInstance().setChannelActivity(false);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mMessageReceiver);
        readChannelId = null;
        readLabelId = null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.tvNoInternet) {
            if (CommonData.getUserDetails() != null) {
                this.getConversations();
            } else {
                this.sendUserDetails();
            }
        } else if (view.getId() == R.id.tvNewConversation) {
            Intent intent = new Intent((Context)this, FuguChatActivity.class);
            FuguConversation fuguConversation = new FuguConversation();
            fuguConversation.setUserId(this.userId);
            fuguConversation.setLabel(this.label);
            fuguConversation.setUserName(this.userName);
            fuguConversation.setStatus(1);
            fuguConversation.setEnUserId(this.enUserId);
            intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
            this.startActivityForResult(intent, 200);
        } else if (view.getId() == R.id.tvPoweredBy) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)"https://fuguchat.com"));
            this.startActivity(intent);
        }
    }

    private void sendUserDetails() {
        if (this.isNetworkAvailable()) {
            Object object;
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = null;
            try {
                jsonObject = gson.toJsonTree((Object)new FuguDeviceDetails(this.appVersion).getDeviceDetails()).getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            CaptureUserData captureUserData = null;
            if (captureUserData == null) {
                captureUserData = HippoConfig.getInstance().getUserData();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HippoConfig.getInstance();
            if (HippoConfig.getmResellerToken() != null) {
                hashMap.put("reseller_token", HippoConfig.getmResellerToken());
                hashMap.put("reference_id", String.valueOf(HippoConfig.getmReferenceId()));
            } else {
                hashMap.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            }
            hashMap.put("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this));
            hashMap.put("app_type", HippoConfig.getInstance().getAppType());
            hashMap.put("device_type", 1);
            hashMap.put("app_version", "2.5.1");
            hashMap.put("device_details", jsonObject);
            if (captureUserData != null) {
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getUserUniqueKey())) {
                    hashMap.put("user_unique_key", captureUserData.getUserUniqueKey().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getFullName())) {
                    hashMap.put("full_name", captureUserData.getFullName().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getEmail())) {
                    hashMap.put("email", captureUserData.getEmail().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)captureUserData.getPhoneNumber())) {
                    object = captureUserData.getPhoneNumber().replaceAll("[^\\d.]", "");
                    hashMap.put("phone_number", object);
                }
                if (!TextUtils.isEmpty((CharSequence)CommonData.getImagePath())) {
                    hashMap.put("user_image", CommonData.getImagePath());
                }
                if (!captureUserData.getTags().isEmpty()) {
                    object = new ArrayList();
                    for (GroupingTag groupingTag : captureUserData.getTags()) {
                        GroupingTag groupingTag2 = new GroupingTag();
                        if (!TextUtils.isEmpty((CharSequence)groupingTag.getTagName())) {
                            groupingTag2.setTagName(groupingTag.getTagName());
                        }
                        if (groupingTag.getTeamId() != null) {
                            groupingTag2.setTeamId(groupingTag.getTeamId());
                        }
                        if (TextUtils.isEmpty((CharSequence)groupingTag.getTagName()) && groupingTag.getTeamId() == null) continue;
                        ((ArrayList)object).add(groupingTag2);
                    }
                    hashMap.put("grouping_tags", new Gson().toJson(object));
                } else {
                    hashMap.put("grouping_tags", "[]");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(object = CommonData.getAttributes().getDeviceToken()))) {
                hashMap.put("device_token", object);
            }
            if (captureUserData != null && !captureUserData.getCustom_attributes().isEmpty()) {
                hashMap.put("custom_attributes", new JSONObject(captureUserData.getCustom_attributes()));
            }
            HippoLog.e(this.TAG + "sendUserDetails map", "==" + hashMap.toString());
            if (!TextUtils.isEmpty((CharSequence)HippoConfig.getmResellerToken())) {
                this.apiPutUserDetailReseller(hashMap);
            } else {
                this.apiPutUserDetail(hashMap);
            }
        } else {
            this.tvNoInternet.setVisibility(0);
            this.swipeRefresh.setVisibility(8);
            this.tvNewConversation.setVisibility(HippoConfig.getInstance().isShowCreateBtn() ? 0 : 8);
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> hashMap) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CommonParams commonParams = new CommonParams.Builder().putMap(hashMap).build();
        RestClient.getApiInterface().putUserDetails(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)FuguChannelsActivity.this).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)FuguChannelsActivity.this).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)FuguChannelsActivity.this).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)FuguChannelsActivity.this).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                FuguChannelsActivity.this.setUpUI();
                try {
                    if (fuguPutUserDetailsResponse.getData().getFuguConversations().size() == 0) {
                        Intent intent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                        FuguConversation fuguConversation = new FuguConversation();
                        fuguConversation.setBusinessName(CommonData.getChatTitle());
                        fuguConversation.setOpenChat(true);
                        fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                        fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                        fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                        intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                        FuguChannelsActivity.this.startActivity(intent);
                        FuguChannelsActivity.this.finish();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void failure(APIError aPIError) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(aPIError.getMessage());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (aPIError.getStatusCode() == 403) {
                    Toast.makeText((Context)FuguChannelsActivity.this, (CharSequence)aPIError.getMessage(), (int)0).show();
                    FuguChannelsActivity.this.finish();
                } else {
                    FuguChannelsActivity.this.tvNoInternet.setVisibility(0);
                    FuguChannelsActivity.this.swipeRefresh.setVisibility(8);
                    FuguChannelsActivity.this.tvNewConversation.setVisibility(8);
                }
            }
        });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> hashMap) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CommonParams commonParams = new CommonParams.Builder().putMap(hashMap).build();
        RestClient.getApiInterface().putUserDetailsReseller(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)FuguChannelsActivity.this).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)FuguChannelsActivity.this).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)FuguChannelsActivity.this).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)FuguChannelsActivity.this).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                FuguChannelsActivity.this.setUpUI();
                try {
                    if (fuguPutUserDetailsResponse.getData().getFuguConversations().size() == 0) {
                        Intent intent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                        FuguConversation fuguConversation = new FuguConversation();
                        fuguConversation.setBusinessName(CommonData.getChatTitle());
                        fuguConversation.setOpenChat(true);
                        fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                        fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                        fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                        intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                        FuguChannelsActivity.this.startActivity(intent);
                        FuguChannelsActivity.this.finish();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void failure(APIError aPIError) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(aPIError.getMessage());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (aPIError.getStatusCode() == 403) {
                    Toast.makeText((Context)FuguChannelsActivity.this, (CharSequence)aPIError.getMessage(), (int)0).show();
                    FuguChannelsActivity.this.finish();
                } else {
                    FuguChannelsActivity.this.tvNoInternet.setVisibility(0);
                    FuguChannelsActivity.this.swipeRefresh.setVisibility(8);
                    FuguChannelsActivity.this.tvNewConversation.setVisibility(8);
                }
            }
        });
    }

    private void getConversations() {
        this.getConversations(this.isFromHistory);
    }

    private void getConversations(boolean bl) {
        if (this.isNetworkAvailable()) {
            new ApiGetConversation((Activity)this, new ApiGetConversation.CallbackListener(){

                @Override
                public void onSuccess(FuguGetConversationsResponse fuguGetConversationsResponse) {
                    try {
                        for (int j = 0; j < fuguGetConversationsResponse.getData().getFuguConversationList().size(); ++j) {
                            String string2 = fuguGetConversationsResponse.getData().getFuguConversationList().get(j).getMessage().replaceAll("<", "&lt;");
                            String string3 = string2.replaceAll(">", "&gt;");
                            fuguGetConversationsResponse.getData().getFuguConversationList().get(j).setMessage(string3);
                        }
                        CommonData.setConversationList(fuguGetConversationsResponse.getData().getFuguConversationList());
                        FuguChannelsActivity.this.fuguConversationList.clear();
                        FuguChannelsActivity.this.fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                        FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                        if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                            FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                        FuguChannelsActivity.this.swipeRefresh.setRefreshing(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void onFailure() {
                    FuguChannelsActivity.this.swipeRefresh.setRefreshing(false);
                }
            }).getConversation(this.enUserId, 1, bl, false);
        } else {
            this.swipeRefresh.setRefreshing(false);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 200 && n2 == -1) {
            FuguConversation fuguConversation = (FuguConversation)new Gson().fromJson(intent.getStringExtra("conversation"), FuguConversation.class);
            if (fuguConversation != null && fuguConversation.getLabelId().compareTo(-1L) != 0) {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    FuguConversation fuguConversation2;
                    if (!(this.fuguConversationList.get(j) instanceof FuguConversation) || (fuguConversation2 = (FuguConversation)this.fuguConversationList.get(j)).getLabelId().compareTo(fuguConversation.getLabelId()) != 0) continue;
                    fuguConversation2.setChannelId(fuguConversation.getChannelId());
                    fuguConversation2.setMessage(fuguConversation.getDefaultMessage());
                    fuguConversation2.setDateTime(fuguConversation.getDateTime());
                    fuguConversation2.setChannelStatus(fuguConversation.getChannelStatus());
                    fuguConversation2.setIsTimeSet(1);
                    fuguConversation2.setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                    fuguConversation2.setUserId(fuguConversation.getLast_sent_by_id());
                    fuguConversation2.setEnUserId(fuguConversation.getEnUserId());
                    fuguConversation2.setLast_message_status(fuguConversation.getLast_message_status());
                    fuguConversation2.setChatType(fuguConversation.getChatType());
                    if (this.hippoChannelsAdapter != null) {
                        this.hippoChannelsAdapter.updateList(this.fuguConversationList);
                    }
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            } else if (fuguConversation != null && fuguConversation.getLabelId().compareTo(-1L) == 0) {
                for (int j = 0; j < this.fuguConversationList.size(); ++j) {
                    FuguConversation fuguConversation3;
                    if (!(this.fuguConversationList.get(j) instanceof FuguConversation) || (fuguConversation3 = (FuguConversation)this.fuguConversationList.get(j)).getChannelId().compareTo(fuguConversation.getChannelId()) != 0) continue;
                    fuguConversation3.setChannelId(fuguConversation.getChannelId());
                    fuguConversation3.setMessage(fuguConversation.getDefaultMessage());
                    fuguConversation3.setDateTime(fuguConversation.getDateTime());
                    fuguConversation3.setChannelStatus(fuguConversation.getChannelStatus());
                    fuguConversation3.setIsTimeSet(1);
                    fuguConversation3.setLast_sent_by_id(fuguConversation.getLast_sent_by_id());
                    fuguConversation3.setLast_message_status(fuguConversation.getLast_message_status());
                    fuguConversation3.setChatType(fuguConversation.getChatType());
                    if (this.hippoChannelsAdapter != null) {
                        this.hippoChannelsAdapter.updateList(this.fuguConversationList);
                    }
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            }
        }
        try {
            if (CommonData.getIsNewChat()) {
                this.getConversations();
                CommonData.setIsNewchat(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRecyclerViewData() {
        this.hippoChannelsAdapter = new HippoChannelsAdapter((Activity)this, this.fuguConversationList, this.userName, this.userId, this.businessName, new HippoChannelsAdapter.Callback(){

            @Override
            public void onClick(FuguConversation fuguConversation) {
                Intent intent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                intent.putExtra("is_from_history", FuguChannelsActivity.this.isFromHistory);
                intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                FuguChannelsActivity.this.startActivityForResult(intent, 200);
            }
        }, this.enUserId);
        this.updateCount(this.fuguConversationList);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.rvChannels.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        if (this.hippoChannelsAdapter != null) {
            this.rvChannels.setAdapter((RecyclerView.Adapter)this.hippoChannelsAdapter);
        }
    }

    private void setPoweredByText(FuguPutUserDetailsResponse.Data data) {
        if (!data.getWhiteLabel().booleanValue()) {
            try {
                this.poweredByView(this.getString(R.string.fugu_powered_by), this.getString(R.string.fugu_text), this.hippoColorConfig);
            }
            catch (Exception exception) {
                if (Build.VERSION.SDK_INT >= 24) {
                    String string2 = "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getFuguRunsOnColor()) + "> " + this.getString(R.string.fugu_text) + "</font>";
                    this.tvPoweredBy.setText((CharSequence)Html.fromHtml((String)string2));
                } else {
                    String string3 = "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getFuguRunsOnColor()) + "> " + this.getString(R.string.fugu_text) + "</font>";
                    this.tvPoweredBy.setText((CharSequence)Html.fromHtml((String)string3));
                }
                this.tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(this.hippoColorConfig.getHippoChannelItemBg(), this.hippoColorConfig.getHippoChannelItemBgPressed()));
            }
        } else {
            this.tvPoweredBy.setVisibility(8);
        }
    }

    private void poweredByView(String string2, String string3, HippoColorConfig hippoColorConfig) throws Exception {
        String string4 = string3 != null ? string3 : "Hippo";
        String string5 = string2 + " " + string4;
        Log.v((String)this.TAG, (String)("totalString = " + string5));
        SpannableString spannableString = new SpannableString((CharSequence)string5);
        spannableString.setSpan((Object)new StyleSpan(1), String.valueOf(string2).length(), string5.length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(hippoColorConfig.getFuguRunsOnColor()), String.valueOf(string2).length(), string5.length(), 0);
        spannableString.setSpan((Object)new RelativeSizeSpan(0.8f), 0, String.valueOf(string2).length(), 0);
        this.tvPoweredBy.setText((CharSequence)spannableString);
        this.tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
    }

    private void updateCount(ArrayList<Object> arrayList) {
        try {
            int n = 0;
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            for (int j = 0; j < arrayList.size(); ++j) {
                FuguConversation fuguConversation;
                if (!(arrayList.get(j) instanceof FuguConversation) || (fuguConversation = (FuguConversation)arrayList.get(j)).getUnreadCount() <= 0) continue;
                UnreadCountModel unreadCountModel = new UnreadCountModel(fuguConversation.getChannelId(), fuguConversation.getLabelId(), fuguConversation.getUnreadCount());
                this.unreadCountModels.add(unreadCountModel);
                n += fuguConversation.getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
            HippoLog.e(this.TAG, "unreadCountModels: " + new Gson().toJson(this.unreadCountModels));
            HippoLog.v(this.TAG, "unreadCountModels size = " + this.unreadCountModels.size());
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toggleProgressBarVisibility(boolean bl) {
        if (bl) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new HippoChannelsAdapter.ProgressBarItem();
            }
            if (!this.fuguConversationList.contains(this.progressBarItem)) {
                this.fuguConversationList.add(this.progressBarItem);
                this.rvChannels.post(new Runnable(){

                    @Override
                    public void run() {
                        FuguChannelsActivity.this.hippoChannelsAdapter.notifyItemInserted(FuguChannelsActivity.this.fuguConversationList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.fuguConversationList.contains(this.progressBarItem)) {
            this.fuguConversationList.remove(this.progressBarItem);
            this.hippoChannelsAdapter.notifyItemRemoved(this.fuguConversationList.size() - 1);
        }
    }

    private void getHistory() {
        this.pageStart = this.pageStart > 0 ? this.pageStart : 1;
        this.pageEnd = this.pageStart + this.defaultPageSize - 1;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("app_secret_key", HippoConfig.getInstance().getAppKey());
        hashMap.put("channel_status", "[2]");
        hashMap.put("device_type", "Android");
        hashMap.put("app_version", String.valueOf(251));
        hashMap.put("page_offset", this.pageStart);
        hashMap.put("row_count", this.pageEnd);
        CommonParams commonParams = new CommonParams.Builder().addAll(hashMap).build();
        RestClient.getApiInterface().getConversation(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguGetConversationsResponse>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                try {
                    for (int j = 0; j < fuguGetConversationsResponse.getData().getFuguConversationList().size(); ++j) {
                        String string2 = fuguGetConversationsResponse.getData().getFuguConversationList().get(j).getMessage().replaceAll("<", "&lt;");
                        String string3 = string2.replaceAll(">", "&gt;");
                        fuguGetConversationsResponse.getData().getFuguConversationList().get(j).setMessage(string3);
                    }
                    CommonData.setConversationList(fuguGetConversationsResponse.getData().getFuguConversationList());
                    FuguChannelsActivity.this.fuguConversationList.clear();
                    FuguChannelsActivity.this.fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                    FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                    FuguChannelsActivity.this.swipeRefresh.setRefreshing(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void failure(APIError aPIError) {
            }
        });
    }

    private void createConversation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("New Conversation");
        ChatByUniqueIdAttributes chatByUniqueIdAttributes = new ChatByUniqueIdAttributes.Builder().setTransactionId("").setUserUniqueKey(HippoConfig.getInstance().getUserData().getUserUniqueKey()).setTags(arrayList).setInsertBotId(true).build();
        HippoConfig.getInstance().openChatByUniqueId(chatByUniqueIdAttributes);
    }

    private void showDialog() {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Are you sure you want to logout?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Prefs.with((Context)FuguChannelsActivity.this).remove("access_token");
                Prefs.with((Context)FuguChannelsActivity.this).remove("user_unique_key");
                HippoConfig.clearHippoData((Activity)FuguChannelsActivity.this);
                FuguChannelsActivity.this.finish();
                LibApp.getInstance().openMainScreen();
            }
        }).setNegativeButton((CharSequence)"N0", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        }).setCancelable(false).show();
    }

    private void viewAnimate(boolean bl) {
        if (bl) {
            TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(this.createBtn.getHeight() + 100));
            translateAnimation.setDuration(300L);
            translateAnimation.setFillAfter(true);
            this.createBtn.startAnimation((Animation)translateAnimation);
            this.createBtn.setVisibility(8);
        } else {
            TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)(this.createBtn.getHeight() + 100), 0.0f);
            translateAnimation.setDuration(300L);
            translateAnimation.setFillAfter(true);
            if (this.createBtn.getVisibility() == 8) {
                this.createBtn.startAnimation((Animation)translateAnimation);
            }
            this.createBtn.setVisibility(0);
        }
    }
}

