/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.AgentUnreadCountListener;
import com.hippo.HippoConfig;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.UnreadCountData;
import com.hippo.agent.model.unreadResponse.UnreadCountResponse;
import com.hippo.agent.model.unreadResponse.UserUnreadCount;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Callback;

public class UnreadCountHelper
implements UnreadListener {
    private static final String TAG = UnreadCountHelper.class.getSimpleName();
    private static UnreadCountHelper instance;
    private static Type listType;

    private UnreadCountHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static UnreadCountHelper getInstance() {
        if (instance == null) {
            Class<UnreadCountHelper> clazz = UnreadCountHelper.class;
            // MONITORENTER : com.hippo.UnreadCountHelper.class
            if (instance == null) {
                instance = new UnreadCountHelper();
                instance.setHelperListener();
            }
            // MONITOREXIT : clazz
        }
        instance.checkHelperListener();
        return instance;
    }

    private void setHelperListener() {
        HippoConfig.getInstance().addUIListener(UnreadListener.class, this);
    }

    private void checkHelperListener() {
        HippoConfig.getInstance().addOrUpdateUIListener(UnreadListener.class, this);
    }

    @Override
    public void pushUpdateCount(String string2, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (bl) {
            object3 = (ArrayList)new Gson().fromJson(string2, listType);
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                UnreadCountData object4 = AgentCommonData.getUnreadCount((String)object);
                if (object4 == null || TextUtils.isEmpty((CharSequence)object4.getUserUniqueKey())) continue;
                int unreadCountData = object4.getCount();
                object4.setCount(++unreadCountData);
                AgentCommonData.addUnreadCount((String)object, object4);
            }
        } else {
            object3 = AgentCommonData.getUnreadCount(string2);
            if (object3 == null || TextUtils.isEmpty((CharSequence)((UnreadCountData)object3).getUserUniqueKey())) {
                return;
            }
            int n = ((UnreadCountData)object3).getCount();
            ((UnreadCountData)object3).setCount(++n);
            AgentCommonData.addUnreadCount(string2, object3);
        }
        object3 = AgentCommonData.getUnreadCount();
        object2 = new HashMap();
        for (Map.Entry entry : ((HashMap)object3).entrySet()) {
            UnreadCountData unreadCountData = (UnreadCountData)entry.getValue();
            ((HashMap)object2).put((String)entry.getKey(), unreadCountData.getCount());
        }
        object = new Gson().toJson(object2);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount((String)object);
        }
    }

    @Override
    public void updateOpenChannelCount(ArrayList<String> arrayList, int n) {
        Object object;
        for (String object22 : arrayList) {
            object = AgentCommonData.getUnreadCount(object22);
            if (object == null || TextUtils.isEmpty((CharSequence)((UnreadCountData)object).getUserUniqueKey())) continue;
            int n2 = ((UnreadCountData)object).getCount();
            if ((n2 -= n) < 0) {
                n2 = 0;
            }
            ((UnreadCountData)object).setCount(n2);
            AgentCommonData.addUnreadCount(object22, (UnreadCountData)object);
        }
        HashMap<String, UnreadCountData> hashMap = AgentCommonData.getUnreadCount();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (Map.Entry entry : hashMap.entrySet()) {
            UnreadCountData unreadCountData = (UnreadCountData)entry.getValue();
            hashMap2.put((String)entry.getKey(), unreadCountData.getCount());
        }
        object = new Gson().toJson(hashMap2);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount((String)object);
        }
    }

    @Override
    public void getUnreadCount() {
        HashMap<String, UnreadCountData> hashMap = AgentCommonData.getUnreadCount();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (Map.Entry<String, UnreadCountData> entry : hashMap.entrySet()) {
            UnreadCountData unreadCountData = entry.getValue();
            hashMap2.put(entry.getKey(), unreadCountData.getCount());
        }
        String string2 = new Gson().toJson(hashMap2);
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            HippoConfig.getInstance().getAgentCountListener().unreadCount(string2);
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> arrayList) {
        if (arrayList == null) {
            arrayList = AgentCommonData.getAgentUniqueKey();
        }
        if (HippoConfig.getInstance().getAgentCountListener() != null) {
            this.getUpdatedUnreadCount(arrayList, HippoConfig.getInstance().getAgentCountListener());
        }
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> arrayList, AgentUnreadCountListener agentUnreadCountListener) {
        UserData userData = AgentCommonData.getUserData();
        if (arrayList == null) {
            arrayList = AgentCommonData.getAgentUniqueKey();
        }
        if (userData == null || arrayList == null) {
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", userData.getAccessToken()).add("user_unique_key", new Gson().toJson(arrayList)).add("response_type", 1).build(2);
        RestClient.getAgentApiInterface().getUnreadCount(commonParams.getMap()).enqueue((Callback)new ResponseResolver<UnreadCountResponse>(){

            @Override
            public void success(UnreadCountResponse unreadCountResponse) {
                try {
                    AgentCommonData.clearUnreadCount();
                    HashMap<String, UnreadCountData> hashMap = new HashMap<String, UnreadCountData>();
                    for (UserUnreadCount object2 : unreadCountResponse.getData().getUserUnreadCount()) {
                        UnreadCountData unreadCountData = new UnreadCountData();
                        unreadCountData.setUserUniqueKey(object2.getUserUniqueKey());
                        unreadCountData.setHippoUserId(object2.getUserId());
                        unreadCountData.setCount(object2.getUnreadCount());
                        hashMap.put(object2.getUserUniqueKey(), unreadCountData);
                    }
                    AgentCommonData.addAllUnreadCount(hashMap);
                    HashMap hashMap2 = new HashMap();
                    for (Map.Entry<String, UnreadCountData> entry : hashMap.entrySet()) {
                        UnreadCountData unreadCountData = entry.getValue();
                        hashMap2.put(entry.getKey(), unreadCountData.getCount());
                    }
                    String string2 = new Gson().toJson((Object)hashMap2);
                    if (HippoConfig.getInstance().getAgentCountListener() != null) {
                        HippoConfig.getInstance().getAgentCountListener().unreadCount(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void failure(APIError aPIError) {
            }
        });
    }

    @Override
    public void addTotalPushUnread(Integer n) {
        try {
            Integer n2 = AgentCommonData.getTotalUnreadCount(n);
            if (n2 == null) {
                n2 = 0;
            }
            n2 = n2 + 1;
            HashMap<Integer, Integer> hashMap = AgentCommonData.addTotalUnreadCount(n, n2);
            int n3 = 0;
            for (Integer n4 : hashMap.values()) {
                n3 += n4.intValue();
            }
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void sendTotalUnreadCount() {
        HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
        HippoLog.i(TAG, "totalUnreadCount: " + new Gson().toJson(hashMap));
        int n = 0;
        for (Integer n2 : hashMap.values()) {
            n += n2.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(n);
        }
    }

    static {
        listType = new TypeToken<ArrayList<String>>(){}.getType();
    }
}

