/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import com.downloader.PRDownloader;
import com.downloader.PRDownloaderConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.AgentUnreadCountListener;
import com.hippo.CallData;
import com.hippo.CaptureUserData;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.FayeCallDate;
import com.hippo.HippoConfigAttributes;
import com.hippo.HippoInitCallback;
import com.hippo.HippoLifeCycle;
import com.hippo.HippoTicketAttributes;
import com.hippo.MobileCampaignBuilder;
import com.hippo.OnApiCallback;
import com.hippo.R;
import com.hippo.UnreadCount;
import com.hippo.UnreadCountFor;
import com.hippo.UnreadCountHelper;
import com.hippo.activity.CampaignActivity;
import com.hippo.activity.ChannelActivity;
import com.hippo.activity.CustomerInitalActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.DialogPop;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.AgentListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.LoginResponse;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.apis.GetPaymentGateway;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.dialog.SingleBtnDialog;
import com.hippo.model.AppUpdateModel;
import com.hippo.model.CustomAttributes;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UserInfoModel;
import com.hippo.receiver.FuguNetworkStateReceiver;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.service.HippoService;
import com.hippo.support.HippoSupportActivity;
import com.hippo.utils.CustomAlertDialog;
import com.hippo.utils.HippoLog;
import com.hippo.utils.StringUtil;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.UnreadCountApi;
import com.hippo.utils.Utils;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.loadingBox.LoadingBox;
import faye.ConnectionManager;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.json.JSONObject;
import retrofit2.Callback;

public class HippoConfig
implements FuguAppConstant {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private CaptureUserData userData;
    private static HippoConfigAttributes configAttributes;
    private String serverUrl = "";
    private int homeUpIndicatorDrawableId = -1;
    private int videoCallNotificationDrawable = R.drawable.hippo_default_notif_icon;
    private int videoCallDrawableId = -1;
    private int audioCallDrawableId = -1;
    private int chatInfoDrawable = -1;
    private int homeIconDrawable = -1;
    private int broadcastDrawable = -1;
    private int icSend = -1;
    private int chatScreenBg = -1;
    public String appKey = "";
    private String appType = "1";
    private HippoConfigAttributes attributes;
    private static String mResellerToken;
    private static int mReferenceId;
    protected Context context;
    private Activity activity;
    private long lastClickTime = 0L;
    private boolean isDataCleared = true;
    public static boolean DEBUG;
    private boolean isChannelActivity;
    private static boolean isUnreadRequired;
    public static boolean progressLoader;
    private boolean setSkipNumber;
    private HippoInitCallback initCallback;
    String title = "";
    String userUniqueKey = "";
    String transactionId = "";
    private ArrayList<String> strings;
    String email;
    private AgentUnreadCountListener unreadCount;
    private HashMap<String, Long> channelIds = new HashMap();
    private int targetSDKVersion = 0;
    private UnreadCount callbackListener;
    private boolean openAgentScreen;
    private boolean apiInProgress;
    private String chatTitle = "Chat";
    private Queue<String> objectQueue = new LinkedList<String>();
    private AgentUnreadCountListener countListener;
    private Map<Class<? extends AgentListener>, Collection<? extends AgentListener>> agentListeners;
    private CallData callData;
    private FayeCallDate fayeCallDate;
    private HippoLifeCycle lifeCycle;
    private Integer botId = null;
    private Boolean skipBot = null;
    private String skipBotReasion = "";
    private boolean showCreateBtn = false;
    public OnApiCallback onApiCallback;
    private MobileCampaignBuilder campaignBuilder;
    private HashMap<String, Integer> questions = new HashMap();
    private HashMap<Integer, String> suggestions = new HashMap();
    private HashMap<Integer, ArrayList<Integer>> mapping = new HashMap();
    private String agentEmail;
    private boolean isSingleChannelTransactionId;
    static int count;
    DialogPop dialogPop;
    private boolean serviceStarted;
    private int WAIT_TIME = 2000;
    private boolean closed;

    public int getHomeUpIndicatorDrawableId() {
        return this.homeUpIndicatorDrawableId;
    }

    public void setHomeUpIndicatorDrawableId(int n) {
        this.homeUpIndicatorDrawableId = n;
    }

    public int getChatScreenBg() {
        return this.chatScreenBg;
    }

    public void setChatScreenBg(int n) {
        this.chatScreenBg = n;
    }

    public int getIcSend() {
        return this.icSend;
    }

    public void setIcSend(int n) {
        this.icSend = n;
    }

    private HippoConfig() {
    }

    public static long getMaxSize() {
        try {
            Long l = 0x1900000L;
            l = AgentCommonData.isAgentFlow() ? AgentCommonData.getUserData().getMaxFileSize() : CommonData.getUserDetails().getData().getMaxFileSize();
            return l;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            return 0x1900000L;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public static HippoConfig getInstance() {
        if (hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    private HippoConfigAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = CommonData.getAttributes();
        }
        return this.attributes;
    }

    public HippoInitCallback getInitCallback() {
        return this.initCallback;
    }

    private void setInitCallback(HippoInitCallback hippoInitCallback) {
        this.initCallback = hippoInitCallback;
    }

    public boolean isSetSkipNumber() {
        return this.setSkipNumber;
    }

    public void setSetSkipNumber(boolean bl) {
        this.setSkipNumber = bl;
    }

    public static HippoConfig initHippoConfig(Activity activity, HippoConfigAttributes hippoConfigAttributes) {
        return HippoConfig.initHippoConfig(activity, hippoConfigAttributes, null);
    }

    public static HippoConfig initHippoConfig(Activity activity, HippoConfigAttributes hippoConfigAttributes, HippoInitCallback hippoInitCallback) {
        block7: {
            count = 0;
            hippoConfig = HippoConfig.getInstance();
            hippoConfig.setInitCallback(hippoInitCallback);
            Paper.init((Context)activity);
            DEBUG = hippoConfigAttributes.isShowLog();
            HippoConfig.getInstance().activity = activity;
            AgentCommonData.setAgentLoginInit(hippoConfigAttributes.isManager());
            if (TextUtils.isEmpty((CharSequence)hippoConfigAttributes.getProvider())) {
                new CustomAlertDialog.Builder((Context)activity).setMessage("Provider cannot be null").setPositiveButton("Ok", new CustomAlertDialog.CustomDialogInterface.OnClickListener(){

                    @Override
                    public void onClick() {
                        HippoConfig.getInstance().activity.finish();
                    }
                }).show();
            } else {
                CommonData.setProvider(hippoConfigAttributes.getProvider());
            }
            if (hippoConfigAttributes.getColorConfig() != null) {
                CommonData.setColorConfig(hippoConfigAttributes.getColorConfig());
            }
            if (CommonData.getUpdatedDetails() != null && CommonData.getUpdatedDetails().getData() != null && hippoInitCallback != null) {
                ConnectionManager.INSTANCE.initFayeConnection();
                hippoInitCallback.hasData();
                progressLoader = false;
                GetPaymentGateway.INSTANCE.getPaymentGatewaysList(null);
            }
            if (!TextUtils.isEmpty((CharSequence)hippoConfigAttributes.getImagePath())) {
                CommonData.setUserImagePath(hippoConfigAttributes.getImagePath());
            }
            try {
                CommonData.saveDeviceToken(hippoConfigAttributes.getDeviceToken());
            }
            catch (Exception exception) {
                if (!DEBUG) break block7;
                exception.printStackTrace();
            }
        }
        CommonData.saveFuguConfigAttribute(hippoConfigAttributes);
        HippoLog.v("inside initHippoConfig", "inside initHippoConfig");
        hippoConfig.setFuguConfig(activity, hippoConfigAttributes);
        return hippoConfig;
    }

    private void initDownloader() {
        PRDownloaderConfig pRDownloaderConfig = PRDownloaderConfig.newBuilder().setDatabaseEnabled(true).setReadTimeout(30000).setConnectTimeout(30000).build();
        PRDownloader.initialize((Context)this.activity, (PRDownloaderConfig)pRDownloaderConfig);
    }

    private void setFuguConfig(final Activity activity, HippoConfigAttributes hippoConfigAttributes) {
        String string2;
        String string3 = string2 = TextUtils.isEmpty((CharSequence)hippoConfigAttributes.getEnvironment()) ? "live" : hippoConfigAttributes.getEnvironment();
        if (string2 != null && string2.equalsIgnoreCase("test")) {
            HippoConfig.getInstance().serverUrl = "https://hippo-api-dev.fuguchat.com:3011";
            CommonData.setServerUrl("https://hippo-api-dev.fuguchat.com:3011");
        } else if (string2 != null && string2.equalsIgnoreCase("dev")) {
            HippoConfig.getInstance().serverUrl = "https://hippo-api-dev.fuguchat.com:3002";
            CommonData.setServerUrl("https://hippo-api-dev.fuguchat.com:3002");
        } else if (string2 != null && string2.equalsIgnoreCase("dev3004")) {
            HippoConfig.getInstance().serverUrl = "https://hippo-api-dev.fuguchat.com:3004";
            CommonData.setServerUrl("https://hippo-api-dev.fuguchat.com:3004");
        } else if (string2 != null && string2.equalsIgnoreCase("beta-live")) {
            HippoConfig.getInstance().serverUrl = "https://beta-live-api.fuguchat.com";
            CommonData.setServerUrl("https://beta-live-api.fuguchat.com");
        } else {
            HippoConfig.getInstance().serverUrl = "https://api.hippochat.io";
            CommonData.setServerUrl("https://api.hippochat.io");
        }
        this.attributes = hippoConfigAttributes;
        this.registerNetworkListener((Context)activity);
        if (hippoConfigAttributes.isManager()) {
            this.initHippoManager(activity, hippoConfigAttributes);
        } else if (!TextUtils.isEmpty((CharSequence)CommonData.getUserCountryCode())) {
            this.initHippoCustomer(activity, hippoConfigAttributes);
        } else {
            new ApiPutUserDetails(activity, null).getUserContryInfo(hippoConfigAttributes, new ApiPutUserDetails.UserCallback(){

                @Override
                public void onSuccess(UserInfoModel userInfoModel, HippoConfigAttributes hippoConfigAttributes) {
                    HippoConfig.this.initHippoCustomer(activity, hippoConfigAttributes);
                }
            });
        }
    }

    private void initHippoCustomer(Activity activity, HippoConfigAttributes hippoConfigAttributes) {
        HippoConfig.getInstance().appKey = hippoConfigAttributes.getAppKey();
        HippoConfig.getInstance().appType = hippoConfigAttributes.getAppType();
        if (HippoConfig.getInstance().appKey != null) {
            CommonData.setAppSecretKey(HippoConfig.getInstance().appKey);
        }
        CommonData.setAppType(HippoConfig.getInstance().appType);
        CommonData.clearLeftTimeInSec();
        this.updateUserDetails(activity, hippoConfigAttributes);
    }

    private void initHippoManager(Activity activity, HippoConfigAttributes hippoConfigAttributes) {
        AgentCommonData.setPagerOrder(hippoConfigAttributes.isReversePageOrder());
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = hippoConfigAttributes.getAppType();
        CommonData.setAppType(HippoConfig.getInstance().appType);
        if (hippoConfigAttributes.isWhitelabel()) {
            CommonParams commonParams = new CommonParams.Builder().add("agent_secret_key", hippoConfigAttributes.getAuthToken()).add("device_type", 1).add("device_token", hippoConfig.getAttributes().getDeviceToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_details", CommonData.deviceDetails((Context)activity)).add("app_version", 251).add("app_version_code", 251).add("source", String.valueOf(2)).add("app_type", this.appType).build(2);
            this.getAgentToken(activity, commonParams.getMap(), hippoConfigAttributes.getCustomAttributes());
        } else {
            CommonParams commonParams = new CommonParams.Builder().add("auth_token", hippoConfigAttributes.getAuthToken()).add("device_type", 1).add("device_token", hippoConfig.getAttributes().getDeviceToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_details", CommonData.deviceDetails((Context)activity)).add("app_version", 251).add("app_version_code", 251).add("source", String.valueOf(2)).add("app_type", this.appType).build(2);
            this.agentTokenVerfy(activity, commonParams.getMap(), hippoConfigAttributes.getCustomAttributes());
        }
    }

    private void updateUserDetails(Activity activity, final HippoConfigAttributes hippoConfigAttributes) {
        HippoConfig.getInstance().isDataCleared = false;
        CommonData.setIsDataCleared(false);
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = hippoConfigAttributes.getAppType();
        HippoConfig.getInstance().userData = hippoConfigAttributes.getCaptureUserData() == null ? new CaptureUserData() : hippoConfigAttributes.getCaptureUserData();
        CommonData.saveUserData(HippoConfig.getInstance().userData);
        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

            @Override
            public void onSuccess() {
                if (HippoConfig.this.getInitCallback() != null) {
                    HippoConfig.this.getInitCallback().onPutUserResponse();
                }
                if (hippoConfigAttributes.isUnreadCount()) {
                    HippoConfig.this.getUnreadCount(HippoConfig.getInstance().activity, CommonData.getUserDetails().getData().getEn_user_id());
                }
            }

            @Override
            public void onFailure() {
                if (HippoConfig.this.getInitCallback() != null) {
                    HippoConfig.this.getInitCallback().onErrorResponse();
                }
            }
        }).sendUserDetails(hippoConfigAttributes.getResellerToken(), hippoConfigAttributes.getReferenceId());
    }

    private void getAgentToken(final Activity activity, final Map<String, Object> map, final HashMap<String, Object> hashMap) {
        this.apiInProgress = true;
        RestClient.getAgentApiInterface().getAgentToken(map).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                CommonParams.Builder builder = new CommonParams.Builder();
                builder.add("access_token", loginResponse.getUserData().getAccessToken());
                builder.add("device_type", 1);
                builder.add("device_token", hippoConfig.getAttributes().getDeviceToken());
                builder.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity));
                builder.add("device_details", CommonData.deviceDetails((Context)activity));
                builder.add("source", String.valueOf(2));
                builder.add("app_version", 251);
                builder.add("app_version_code", 251);
                builder.add("app_type", map.get("app_type"));
                if (hashMap != null && hashMap.size() > 0 && !hashMap.isEmpty()) {
                    builder.add("custom_attributes", new JSONObject((Map)hashMap));
                }
                CommonParams commonParams = builder.build(2);
                HippoConfig.this.agentTokenLogin(activity, commonParams.getMap());
            }

            @Override
            public void failure(APIError aPIError) {
                LoadingBox.hide();
                Log.e((String)TAG, (String)("Token not verified: " + aPIError.getMessage()));
                HippoConfig.this.clearLocalData();
                HippoConfig.this.apiInProgress = false;
            }
        });
    }

    private void agentTokenVerfy(final Activity activity, final Map<String, Object> map, final HashMap<String, Object> hashMap) {
        this.apiInProgress = true;
        RestClient.getAgentApiInterface().verifyAuthToken(map).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                CommonParams.Builder builder = new CommonParams.Builder();
                builder.add("access_token", loginResponse.getUserData().getAccessToken());
                builder.add("device_type", 1);
                builder.add("device_token", hippoConfig.getAttributes().getDeviceToken());
                builder.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity));
                builder.add("device_details", CommonData.deviceDetails((Context)activity));
                builder.add("source", String.valueOf(2));
                builder.add("app_version", 251);
                builder.add("app_version_code", 251);
                builder.add("app_type", map.get("app_type"));
                if (hashMap != null && hashMap.size() > 0 && !hashMap.isEmpty()) {
                    builder.add("custom_attributes", new JSONObject((Map)hashMap));
                }
                CommonParams commonParams = builder.build(2);
                HippoConfig.this.agentTokenLogin(activity, commonParams.getMap());
            }

            @Override
            public void failure(APIError aPIError) {
                LoadingBox.hide();
                Log.e((String)TAG, (String)("Token not verified: " + aPIError.getMessage()));
                HippoConfig.this.clearLocalData();
                HippoConfig.this.apiInProgress = false;
            }
        });
    }

    private void agentTokenLogin(final Activity activity, Map<String, Object> map) {
        RestClient.getAgentApiInterface().login(map).enqueue((Callback)new ResponseResolver<LoginResponse>(){

            @Override
            public void success(LoginResponse loginResponse) {
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode().intValue()) {
                        Paper.book((String)"hippo.paperdb").delete("hippo_user_data");
                        Paper.book((String)"hippo.paperdb").delete("hippo_tags");
                        AgentCommonData.saveUserData(loginResponse.getUserData());
                        AgentCommonData.saveTags(loginResponse.getUserData().getTags());
                        CommonData.setUserId(String.valueOf(loginResponse.getUserData().getUserId()));
                        HippoConfig.this.apiInProgress = false;
                        HippoConfig.getInstance().isDataCleared = false;
                        HippoConfig.this.checkSavedQueue();
                    } else {
                        Toast.makeText((Context)activity, (CharSequence)loginResponse.getMessage(), (int)0).show();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                HippoConfig.this.apiInProgress = false;
                LoadingBox.hide();
            }

            @Override
            public void failure(APIError aPIError) {
                HippoConfig.this.apiInProgress = false;
                HippoConfig.this.clearLocalData();
                Log.e((String)TAG, (String)("Agent Login failed: " + aPIError.getMessage()));
                LoadingBox.hide();
            }
        });
    }

    private void checkSavedQueue() {
        Iterator iterator = this.objectQueue.iterator();
        while (iterator.hasNext()) {
            String string2;
            switch (string2 = (String)iterator.next()) {
                case "open_agent_screen": {
                    Intent intent = new Intent(this.activity.getApplicationContext(), AgentListActivity.class);
                    intent.putExtra("title", this.chatTitle);
                    this.activity.startActivity(intent);
                    break;
                }
                case "get_agent_count": {
                    UnreadCountHelper.getInstance().getUpdatedUnreadCount(this.strings, this.unreadCount);
                    break;
                }
                case "start_conversation": {
                    Conversation conversation;
                    Object object;
                    if (!TextUtils.isEmpty((CharSequence)this.userUniqueKey) && !TextUtils.isEmpty((CharSequence)this.transactionId)) {
                        object = new Conversation();
                        ((Conversation)object).setChannelId(-1L);
                        ((Conversation)object).setChannelName("dummyChannelName");
                        ((Conversation)object).setStatus(-2);
                        ((Conversation)object).setAgentId(-2);
                        ((Conversation)object).setUserUniqueKeys(this.userUniqueKey);
                        ((Conversation)object).setLabel(this.title);
                        ((Conversation)object).setUnreadCount(0);
                        conversation = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                        conversation.putExtra("conversation", new Gson().toJson(object, Conversation.class));
                        conversation.putExtra("create_chat", true);
                        conversation.putExtra("transactionId", this.transactionId);
                        conversation.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
                        this.activity.startActivity((Intent)conversation);
                        break;
                    }
                    object = new Intent(this.activity.getApplicationContext(), AgentListActivity.class);
                    object.putExtra("title", this.title);
                    if (!TextUtils.isEmpty((CharSequence)this.userUniqueKey)) {
                        object.putExtra("user_unique_key", this.userUniqueKey);
                    }
                    this.activity.startActivity((Intent)object);
                    break;
                }
                case "agent_total_count": {
                    this.getTotalUnreadCount();
                    break;
                }
                case "send_broadcast_message": {
                    Object object = new Intent(this.activity.getApplicationContext(), AgentBroadcastActivity.class);
                    object.putExtra("title", this.title);
                    this.activity.startActivity((Intent)object);
                    break;
                }
                case "open_one_two_one": {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(this.title);
                    conversation.setUnreadCount(0);
                    Intent intent = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                    intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    intent.putExtra("create_chat", true);
                    intent.putExtra("is_one_two_one", true);
                    intent.putExtra("one_two_one_email", this.email);
                    this.activity.startActivity(intent);
                    break;
                }
            }
        }
        this.objectQueue.clear();
    }

    public void startOneToOneConversation(String string2) {
        if (AgentCommonData.isAgentFlow()) {
            if (Utils.isEmailValid(string2)) {
                if (AgentCommonData.getUserData() == null || this.apiInProgress) {
                    this.objectQueue.add("open_one_two_one");
                    this.email = string2;
                    LoadingBox.showOn(this.activity);
                    if (!this.apiInProgress) {
                        this.initHippoManager(this.activity, hippoConfig.getAttributes());
                    }
                } else {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(this.title);
                    conversation.setUnreadCount(0);
                    Intent intent = new Intent(this.activity.getApplicationContext(), AgentChatActivity.class);
                    intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    intent.putExtra("create_chat", true);
                    intent.putExtra("is_one_two_one", true);
                    intent.putExtra("one_two_one_email", string2);
                    this.activity.startActivity(intent);
                }
            } else {
                Log.e((String)TAG, (String)"Enter valid email");
            }
        } else {
            Log.e((String)TAG, (String)"Can't call this method in Client flow");
        }
    }

    public void sendBroadcastMessage(Activity activity, String string2) {
        if (AgentCommonData.isAgentFlow()) {
            if (!this.getAttributes().isBroadcastEnabled()) {
                Log.e((String)TAG, (String)"Broadcast isn't enabled");
                return;
            }
            if (AgentCommonData.getUserData() == null || this.apiInProgress) {
                this.title = string2;
                this.objectQueue.add("send_broadcast_message");
                LoadingBox.showOn(activity);
                if (!this.apiInProgress) {
                    this.initHippoManager(activity, hippoConfig.getAttributes());
                }
            } else {
                Intent intent = new Intent(activity.getApplicationContext(), AgentBroadcastActivity.class);
                intent.putExtra("title", string2);
                activity.startActivity(intent);
            }
        } else {
            Log.e((String)TAG, (String)"Can't call this method in Client flow");
        }
    }

    public void openConversation(Activity activity, String string2) {
        AgentCommonData.setMainTitle(string2);
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.title = string2;
            this.objectQueue.add("open_agent_screen");
            LoadingBox.showOn(activity);
            if (!this.apiInProgress) {
                this.initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", string2);
            activity.startActivity(intent);
        }
    }

    public void openConversationFor(Activity activity, String string2, String string3) {
        this.openConversationFor(activity, string2, string3, "");
    }

    public void openConversationFor(Activity activity, String string2, String string3, String string4) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.title = string3;
            this.userUniqueKey = string2;
            this.transactionId = string4;
            this.objectQueue.add("start_conversation");
            LoadingBox.showOn(activity);
            if (!this.apiInProgress) {
                this.initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string4)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(-1L);
            conversation.setChannelName("dummyChannelName");
            conversation.setStatus(-2);
            conversation.setAgentId(-2);
            conversation.setUserUniqueKeys(string2);
            conversation.setLabel(string3);
            conversation.setUnreadCount(0);
            Intent intent = new Intent(activity.getApplicationContext(), AgentChatActivity.class);
            intent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
            intent.putExtra("create_chat", true);
            intent.putExtra("transactionId", string4);
            intent.putExtra("fragment_type", FragmentType.USER_CHAT.getOrdinal());
            activity.startActivity(intent);
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", string3);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                intent.putExtra("user_unique_key", string2);
            }
            activity.startActivity(intent);
        }
    }

    public void setUnreadCount(AgentUnreadCountListener agentUnreadCountListener) {
        this.unreadCount = agentUnreadCountListener;
    }

    public void getUnreadCountFor(ArrayList<String> arrayList) {
        AgentCommonData.setAgentUniqueKey(arrayList);
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.strings = arrayList;
            this.objectQueue.add("get_agent_count");
            if (!this.apiInProgress) {
                this.initHippoManager(this.activity, hippoConfig.getAttributes());
            }
        } else {
            UnreadCountHelper.getInstance().getUpdatedUnreadCount(arrayList);
        }
    }

    public void getTotalUnreadCount() {
        block5: {
            try {
                ActivityManager activityManager = (ActivityManager)this.activity.getSystemService("activity");
                List list = activityManager.getRunningTasks(10);
                if (((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getClassName().equals("com.hippo.agent.AgentChatActivity")) {
                    UnreadCountHelper.getInstance().sendTotalUnreadCount();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.getTotalUnreadCountData();
            }
            catch (Exception exception) {
                if (!DEBUG) break block5;
                exception.printStackTrace();
            }
        }
    }

    private void getTotalUnreadCountData() throws Exception {
        if (HippoConfig.getInstance().getCallbackListener() == null) {
            Log.e((String)TAG, (String)"Set CallbackListener first");
            return;
        }
        if (AgentCommonData.getUserData() == null || this.apiInProgress) {
            this.objectQueue.add("agent_total_count");
            if (!this.apiInProgress) {
                this.initHippoManager(this.activity, hippoConfig.getAttributes());
            }
        } else {
            int[] nArray = new int[]{ConversationMode.ALL.getOrdinal(), ConversationMode.DEFAULT.getOrdinal()};
            UserData userData = AgentCommonData.getUserData();
            String string2 = String.valueOf(userData.getEnUserId());
            String string3 = userData.getAccessToken();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("en_user_id", string2);
            hashMap.put("access_token", string3);
            hashMap.put("status", "[1]");
            hashMap.put("device_type", 1);
            hashMap.put("type", Arrays.toString(nArray));
            CommonParams commonParams = new CommonParams.Builder().addAll(hashMap).build(2);
            RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>(){

                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    try {
                        if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                            HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
                            int n = 0;
                            for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                                n += conversation.getUnreadCount().intValue();
                            }
                            AgentCommonData.addTotalUnreadCount(hashMap);
                            UnreadCountHelper.getInstance().sendTotalUnreadCount();
                            if (HippoConfig.getInstance().getCallbackListener() != null) {
                                HippoConfig.getInstance().getCallbackListener().count(n);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError aPIError) {
                }
            });
        }
    }

    public static void clearHippoData(Activity activity) {
        try {
            if (AgentCommonData.isAgentFlow()) {
                HippoConfig.logoutAgent(activity);
            } else {
                HippoConfig.logOutUser(activity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hippoConfig.clearLocalData();
            Prefs.with((Context)activity).removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearLocalData() {
        HippoConfig.getInstance().isDataCleared = true;
        CommonData.setIsDataCleared(true);
        try {
            CommonData.clearData();
            AgentCommonData.clearAgentData();
            this.userData = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAppKey() {
        if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            this.appKey = CommonData.getAppSecretKey();
        }
        return this.appKey;
    }

    public static String getmResellerToken() {
        if (TextUtils.isEmpty((CharSequence)mResellerToken)) {
            mResellerToken = CommonData.getResellerToken();
        }
        return mResellerToken;
    }

    public static int getmReferenceId() {
        if (mReferenceId == -1) {
            mReferenceId = CommonData.getReferenceId();
        }
        return mReferenceId;
    }

    public String getAppType() {
        return HippoConfig.getInstance().appType;
    }

    public boolean isDataCleared() {
        return this.isDataCleared;
    }

    public boolean isChannelActivity() {
        return this.isChannelActivity;
    }

    public void setChannelActivity(boolean bl) {
        this.isChannelActivity = bl;
    }

    public void setRideTime(long l) {
        if (l > 0L) {
            CommonData.setLeftTimeInSec(l);
        } else {
            CommonData.clearLeftTimeInSec();
        }
    }

    public void stopOnlineStatus(Activity activity) {
        CommonData.clearLeftTimeInSec();
        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        }).stopRideStatus();
    }

    public void discartEstimatedTime() {
        CommonData.clearLeftTimeInSec();
    }

    public void setTitle(String string2) {
        CommonData.setChatTitle(string2);
    }

    public void showConversations(Activity activity, final String string2) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        if (AgentCommonData.isAgentFlow()) {
            Log.e((String)TAG, (String)"Can't call this method with manager flow");
            return;
        }
        CommonData.setChatTitle(string2);
        if (CommonData.isFirstTimeWithNotification() || CommonData.getConversationList() != null && CommonData.getConversationList().size() <= 0) {
            if (!TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getUserData().getEnUserId())) {
                this.caseElse(string2);
            } else {
                new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                    @Override
                    public void onSuccess() {
                        CommonData.setNotificationFirstClick(false);
                        HippoConfig.this.caseElse(string2);
                    }

                    @Override
                    public void onFailure() {
                        CommonData.setNotificationFirstClick(false);
                    }
                }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), progressLoader, true);
            }
        } else {
            this.caseElse(string2);
        }
    }

    public void openChat(Activity activity, Long l) {
        if (HippoConfig.getInstance().activity == null || HippoConfig.getInstance().context == null) {
            HippoConfig.getInstance().activity = activity;
            HippoConfig.getInstance().context = activity;
        }
        this.openChat(activity, l, null);
    }

    public void openChat(Activity activity, Long l, String string2) {
        this.openChat(activity, l, string2, false);
    }

    public void openChat(final Activity activity, final Long l, final String string2, final boolean bl) {
        if (HippoConfig.getInstance().getUserData() == null || this.userData.getUserId().compareTo(-1L) == 0) {
            HippoLog.v("In openChat before FuguChatActivity", "userData null");
            ApiPutUserDetails apiPutUserDetails = new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    Intent intent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
                    FuguConversation fuguConversation = new FuguConversation();
                    fuguConversation.setLabelId(l);
                    fuguConversation.setLabel(string2);
                    fuguConversation.setOpenChat(true);
                    fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                    fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                    fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                    intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                    activity.startActivity(intent);
                    if (bl) {
                        activity.finish();
                    }
                }

                @Override
                public void onFailure() {
                }
            });
            HippoConfig.getInstance();
            String string3 = HippoConfig.getmResellerToken();
            HippoConfig.getInstance();
            apiPutUserDetails.sendUserDetails(string3, HippoConfig.getmReferenceId());
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation fuguConversation = new FuguConversation();
            fuguConversation.setLabelId(l);
            fuguConversation.setLabel(string2);
            fuguConversation.setOpenChat(true);
            fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
            activity.startActivity(intent);
            if (bl) {
                activity.finish();
            }
        }
    }

    public void openChatByUniqueId(ChatByUniqueIdAttributes chatByUniqueIdAttributes) {
        String string2 = chatByUniqueIdAttributes.getTransactionId();
        String string3 = chatByUniqueIdAttributes.getUserUniqueKey();
        ArrayList<String> arrayList = chatByUniqueIdAttributes.getOtherUserUniqueKeys();
        String string4 = chatByUniqueIdAttributes.getChannelName();
        ArrayList<String> arrayList2 = chatByUniqueIdAttributes.getTags();
        int n = 0;
        String[] stringArray = chatByUniqueIdAttributes.getMessage();
        ArrayList<String> arrayList3 = chatByUniqueIdAttributes.getGroupingTags();
        String string5 = chatByUniqueIdAttributes.isSupportTicket() ? "1" : "0";
        CustomAttributes customAttributes = chatByUniqueIdAttributes.getCustomAttributes();
        boolean bl = chatByUniqueIdAttributes.isInsertBotId();
        boolean bl2 = chatByUniqueIdAttributes.isSkipBot();
        if (!TextUtils.isEmpty((CharSequence)chatByUniqueIdAttributes.getAgentEmail())) {
            this.setAgentEmail(chatByUniqueIdAttributes.getAgentEmail());
        }
        this.setSingleChannelTransactionId(chatByUniqueIdAttributes.isSingleChannelTransactionId());
        this.showGroupChat(string2, string3, arrayList, string4, arrayList2, n, stringArray, arrayList3, string5, customAttributes, bl, bl2);
    }

    private void showGroupChat(final String string2, final String string3, final ArrayList<String> arrayList, final String string4, final ArrayList<String> arrayList2, final int n, final String[] stringArray, final ArrayList<String> arrayList3, final String string5, final CustomAttributes customAttributes, final boolean bl, final boolean bl2) {
        HippoLog.i("showGroupChat", "In ShowGroupChat");
        if (HippoConfig.getInstance().getUserData() == null || this.getUserData().getUserId().compareTo(-1L) == 0) {
            new ApiPutUserDetails(this.activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    HippoConfig.this.showGroupChats(string2, string3, arrayList, string4, arrayList2, n, stringArray, arrayList3, string5, customAttributes, bl, bl2);
                }

                @Override
                public void onFailure() {
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), true);
        } else {
            this.showGroupChats(string2, string3, arrayList, string4, arrayList2, n, stringArray, arrayList3, string5, customAttributes, bl, bl2);
        }
    }

    private void showGroupChats(String string2, String string3, ArrayList<String> arrayList, String string4, ArrayList<String> arrayList2, int n, String[] stringArray, ArrayList<String> arrayList3, String string5, CustomAttributes customAttributes, boolean bl, boolean bl2) {
        HippoLog.i("showGroupChat", "userData not null");
        Intent intent = new Intent(this.activity.getApplicationContext(), FuguChatActivity.class);
        HippoLog.d("UserName", "showGroupChat" + HippoConfig.getInstance().getUserData().getUserId());
        FuguConversation fuguConversation = new FuguConversation();
        fuguConversation.setLabelId(-1L);
        fuguConversation.setLabel(CommonData.getUserDetails().getData().getBusinessName());
        fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
        intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
        n = arrayList != null && arrayList.size() > 0 && !TextUtils.isEmpty((CharSequence)arrayList.get(0)) ? 2 : 3;
        intent.putExtra("chat_type", n);
        intent.putExtra("isInsertBotId", bl);
        intent.putExtra("single_chat_trans_id", this.getSingleChannelTransactionId());
        if (bl2) {
            intent.putExtra("is_skip_bot", 1);
            intent.putExtra("skipCreateChannel", false);
        }
        Gson gson = new GsonBuilder().create();
        JsonArray jsonArray = null;
        JsonArray jsonArray2 = null;
        if (arrayList != null) {
            jsonArray = gson.toJsonTree(arrayList).getAsJsonArray();
        }
        if (arrayList2 != null) {
            jsonArray2 = gson.toJsonTree(arrayList2).getAsJsonArray();
        }
        FuguCreateConversationParams fuguCreateConversationParams = new FuguCreateConversationParams();
        fuguCreateConversationParams.setAppSecretKey(HippoConfig.getInstance().getAppKey());
        fuguCreateConversationParams.setChannelName(string4);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            fuguCreateConversationParams.setTransactionId(string2);
        }
        fuguCreateConversationParams.setLabelId(-1L);
        fuguCreateConversationParams.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        fuguCreateConversationParams.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        fuguCreateConversationParams.setChatType(n);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            fuguCreateConversationParams.setUserUniqueKey(string3);
        }
        n = 0;
        if (arrayList != null && arrayList.size() > 0 && !TextUtils.isEmpty((CharSequence)arrayList.get(0))) {
            fuguCreateConversationParams.setOtherUserUniqueKeys(jsonArray);
            n = arrayList != null ? (arrayList.size() > 1 ? 1 : 1) : 0;
        }
        fuguCreateConversationParams.setChatType(n);
        if (stringArray != null && stringArray.length > 0 && !TextUtils.isEmpty((CharSequence)stringArray[0])) {
            fuguCreateConversationParams.setUser_first_messages(stringArray);
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            fuguCreateConversationParams.setTags(arrayList2);
        }
        try {
            if (customAttributes != null) {
                fuguCreateConversationParams.setCustomAttributes(customAttributes);
            }
            if (!TextUtils.isEmpty((CharSequence)string5) && Integer.parseInt(string5) == 1) {
                fuguCreateConversationParams.setIsSupportTicket(Integer.parseInt(string5));
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                fuguCreateConversationParams.setGroupingTags(arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)fuguCreateConversationParams.getEnUserId()) && fuguCreateConversationParams.getUserId() == -1L) {
            Log.e((String)TAG, (String)"UserID can't be -1");
            return;
        }
        intent.putExtra("peer_chat_params", new Gson().toJson((Object)fuguCreateConversationParams, FuguCreateConversationParams.class));
        this.activity.startActivity(intent);
    }

    public void showFAQSupport(HippoTicketAttributes hippoTicketAttributes) {
        if (SystemClock.elapsedRealtime() - this.lastClickTime < 1000L) {
            return;
        }
        if (hippoTicketAttributes != null) {
            this.openSupportScreen(hippoTicketAttributes.getmFaqName(), hippoTicketAttributes.getmTransactionId());
        } else {
            this.openSupportScreen(null, null);
        }
        this.lastClickTime = SystemClock.elapsedRealtime();
    }

    private void openSupportScreen(final String string2, final String string3) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HippoConfig.this.openFuguSupportActivity(string2, string3);
            }
        }, 100L);
    }

    private static void logoutAgent(Activity activity) throws Exception {
        if (AgentCommonData.getUserData() != null) {
            CommonParams commonParams = new CommonParams.Builder().add("access_token", AgentCommonData.getUserData().getAccessToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_type", 1).add("app_version", 251).add("source_type", String.valueOf(1)).build(2);
            RestClient.getAgentApiInterface().logout(commonParams.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(){

                @Override
                public void success(LoginResponse loginResponse) {
                }

                @Override
                public void failure(APIError aPIError) {
                }
            });
        }
    }

    private static void logOutUser(Activity activity) throws Exception {
        if (HippoConfig.getInstance().getUserData() != null && HippoConfig.getInstance().getUserData().getEnUserId() != null) {
            CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId()).add("app_version", "2.5.1").add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_type", 1).build();
            RestClient.getApiInterface().logOut(commonParams.getMap()).enqueue((Callback)new ResponseResolver<CommonResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(false)){

                @Override
                public void success(CommonResponse commonResponse) {
                }

                @Override
                public void failure(APIError aPIError) {
                }
            });
        }
    }

    private void openUserInitForm() {
        Intent intent = new Intent(this.activity.getApplicationContext(), CustomerInitalActivity.class);
        this.activity.startActivity(intent);
    }

    private void caseOne(String string2) {
        HippoLog.e("Case 1", "case 1");
        if (CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            this.openUserInitForm();
        } else {
            Intent intent = new Intent(this.activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation fuguConversation = new FuguConversation();
            fuguConversation.setBusinessName(string2);
            fuguConversation.setOpenChat(true);
            fuguConversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            fuguConversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            fuguConversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
            this.activity.startActivity(intent);
        }
    }

    private void caseElse(String string2) {
        HippoLog.e("Case else", "case else");
        if (CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            this.openUserInitForm();
        } else {
            try {
                Intent intent = new Intent(this.activity.getApplicationContext(), ChannelActivity.class);
                intent.putExtra("title", string2);
                intent.putExtra("hasPager", this.getAttributes().getAdditionalInfo().isHasChannelPager());
                intent.putExtra("appVersion", this.getAppVersion());
                this.activity.startActivity(intent);
            }
            catch (Exception exception) {
                Intent intent = new Intent(this.activity.getApplicationContext(), ChannelActivity.class);
                intent.putExtra("title", string2);
                intent.putExtra("hasPager", "false");
                intent.putExtra("appVersion", this.getAppVersion());
                this.activity.startActivity(intent);
            }
        }
    }

    private void openFuguSupportActivity(String string2, String string3) {
        Intent intent = new Intent(this.activity.getApplicationContext(), HippoSupportActivity.class);
        intent.putExtra("support_id", string2);
        intent.putExtra("support_transaction_id", string3);
        this.activity.startActivity(intent);
    }

    private int getAppVersion() {
        try {
            if (this.activity != null) {
                return HippoConfig.getInstance().activity.getPackageManager().getPackageInfo((String)HippoConfig.getInstance().activity.getPackageName(), (int)0).versionCode;
            }
            return 205;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 205;
        }
    }

    public CaptureUserData getUserData() {
        return this.getUserData(true);
    }

    public CaptureUserData getUserData(boolean bl) {
        if (this.userData == null) {
            this.userData = CommonData.getUserData();
        }
        if (bl) {
            try {
                if (TextUtils.isEmpty((CharSequence)this.userData.getEnUserId())) {
                    FuguPutUserDetailsResponse fuguPutUserDetailsResponse = CommonData.getUpdatedDetails();
                    if (fuguPutUserDetailsResponse != null && fuguPutUserDetailsResponse.getData() != null && !TextUtils.isEmpty((CharSequence)fuguPutUserDetailsResponse.getData().getEn_user_id())) {
                        this.userData.setEnUserId(fuguPutUserDetailsResponse.getData().getEn_user_id());
                        this.userData.setUserId(fuguPutUserDetailsResponse.getData().getUserId());
                        this.userData.setFullName(fuguPutUserDetailsResponse.getData().getFullName());
                        this.userData.setEmail(fuguPutUserDetailsResponse.getData().getEmail());
                    } else if (this.context != null) {
                        this.userData.setEnUserId(Prefs.with(this.context).getString("en_user_id", ""));
                        this.userData.setUserId(Prefs.with(this.context).getLong("user_id", -1L));
                        this.userData.setFullName(Prefs.with(this.context).getString("full_name", ""));
                        this.userData.setEmail(Prefs.with(this.context).getString("email", ""));
                    }
                }
            }
            catch (Exception exception) {
                if (DEBUG) {
                    exception.printStackTrace();
                }
                try {
                    if (this.context != null) {
                        this.userData.setEnUserId(Prefs.with(this.context).getString("en_user_id", ""));
                        this.userData.setUserId(Prefs.with(this.context).getLong("user_id", -1L));
                        this.userData.setFullName(Prefs.with(this.context).getString("full_name", ""));
                        this.userData.setEmail(Prefs.with(this.context).getString("email", ""));
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return this.userData;
    }

    public void getUnreadCount() {
        this.getUnreadCount(this.activity, HippoConfig.getInstance().getUserData().getEnUserId());
    }

    private void getUnreadCount(Activity activity, String string2) {
        new UnreadCountApi().getConversations(activity, string2, new UnreadCountApi.CountUnread(){

            @Override
            public void countValue(int n) {
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(n);
                }
            }
        });
    }

    public void fetchUnreadCountForRequest(ChatByUniqueIdAttributes chatByUniqueIdAttributes, UnreadCountFor unreadCountFor) {
        if (AgentCommonData.isAgentFlow()) {
            Log.e((String)TAG, (String)"Can't call this method with manager flow");
            return;
        }
        String string2 = chatByUniqueIdAttributes.getTransactionId();
        ArrayList<String> arrayList = chatByUniqueIdAttributes.getOtherUserUniqueKeys();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Toast.makeText((Context)this.activity, (int)R.string.hippo_empty_transaction_id, (int)0).show();
            return;
        }
        if (arrayList == null || arrayList.size() == 0) {
            Toast.makeText((Context)this.activity, (int)R.string.hippo_empty_other_user_unique_keys, (int)0).show();
            return;
        }
        new UnreadCountApi().getChannelUnreadCount(this.activity, HippoConfig.getInstance().getUserData().getEnUserId(), string2, HippoConfig.getInstance().getUserData().getUserUniqueKey(), arrayList, unreadCountFor);
    }

    public void setChannelIds(String string2, Long l) {
        this.channelIds.put(string2, l);
    }

    public Long getChannelId(String string2) {
        return this.channelIds.get(string2);
    }

    public int getTargetSDKVersion() {
        return this.targetSDKVersion;
    }

    public boolean isPermissionGranted(Context context, String string2) {
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(HippoConfig.getInstance().activity.getPackageName(), 0);
            if (applicationInfo != null) {
                this.targetSDKVersion = applicationInfo.targetSdkVersion;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.targetSDKVersion > 22) {
            return ContextCompat.checkSelfPermission((Context)context, (String)string2) == 0;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)string2) == 0;
    }

    public boolean askUserToGrantPermission(Activity activity, String string2, String string3, int n) {
        HippoLog.e(TAG, "permissions" + string2);
        return this.askUserToGrantPermission(activity, new String[]{string2}, string3, n);
    }

    public boolean askUserToGrantPermission(Activity activity, String[] stringArray, String string2, int n) {
        String string3 = null;
        for (String string4 : stringArray) {
            if (this.isPermissionGranted((Context)activity, string4)) continue;
            string3 = string4;
            break;
        }
        if (string3 == null) {
            return true;
        }
        boolean bl = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, string3);
        if (bl) {
            if (string2 == null) {
                string2 = "Please grant permission";
            }
            Toast.makeText((Context)activity, (CharSequence)string2, (int)0).show();
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)n);
        }
        return false;
    }

    public UnreadCount getCallbackListener() {
        return this.callbackListener;
    }

    public void setCallbackListener(UnreadCount unreadCount) {
        this.callbackListener = unreadCount;
    }

    public AgentUnreadCountListener getAgentCountListener() {
        return this.countListener;
    }

    public void setCountForCallbackListener(AgentUnreadCountListener agentUnreadCountListener) {
        this.countListener = agentUnreadCountListener;
    }

    private <T extends AgentListener> Collection<T> getOrCreateUIListeners(Class<T> clazz) {
        Collection<? extends AgentListener> collection;
        if (this.agentListeners == null) {
            this.agentListeners = new HashMap<Class<? extends AgentListener>, Collection<? extends AgentListener>>();
        }
        if ((collection = this.agentListeners.get(clazz)) == null) {
            collection = new ArrayList<AgentListener>();
            this.agentListeners.put(clazz, collection);
        }
        return collection;
    }

    public <T extends AgentListener> Collection<T> getUIListeners(Class<T> clazz) {
        return Collections.unmodifiableCollection(this.getOrCreateUIListeners(clazz));
    }

    public <T extends AgentListener> void addUIListener(Class<T> clazz, T t) {
        this.getOrCreateUIListeners(clazz).add(t);
    }

    public <T extends AgentListener> void addOrUpdateUIListener(Class<T> clazz, T t) {
        try {
            if (this.getUIListeners(clazz).size() == 0) {
                this.getOrCreateUIListeners(clazz).add(t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends AgentListener> void removeUIListener(Class<T> clazz, T t) {
        this.getOrCreateUIListeners(clazz).remove(t);
    }

    private void registerNetworkListener(Context context) {
        try {
            context.registerReceiver((BroadcastReceiver)new FuguNetworkStateReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FayeCallDate getFayeCallDate() {
        return this.fayeCallDate;
    }

    public void setFayeCallDate(FayeCallDate fayeCallDate) {
        this.fayeCallDate = fayeCallDate;
    }

    public CallData getCallData() {
        return this.callData;
    }

    public void setCallListener(CallData callData) {
        this.callData = callData;
    }

    public void setLifeCyclerListener(HippoLifeCycle hippoLifeCycle) {
        this.lifeCycle = hippoLifeCycle;
    }

    public HippoLifeCycle getLifeCyclerListener() {
        return this.lifeCycle;
    }

    public void setBotGroupId(Integer n) {
        CommonData.setBotId(n);
        this.botId = n;
    }

    public Integer getBotId() {
        if (this.botId == null) {
            this.botId = CommonData.getBotId();
        }
        return this.botId;
    }

    public boolean isShowCreateBtn() {
        return this.showCreateBtn;
    }

    public void setShowCreateBtn(boolean bl) {
        this.showCreateBtn = bl;
    }

    public void setSkipBotReasion(String string2) {
        this.skipBotReasion = this.skipBotReasion;
    }

    public void setSkipBot(boolean bl) {
        CommonData.skipBot(bl);
    }

    public boolean getSkipBot() {
        this.skipBot = CommonData.getSkipBot();
        return this.skipBot;
    }

    public String getSkipBotReason() {
        return this.skipBotReasion;
    }

    public void startCall(Context context, String string2, String string3, String string4, String string5, ArrayList<String> arrayList, String string6, String string7, String string8) {
        if (string2.equalsIgnoreCase("video") && !CommonData.getVideoCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (string2.equalsIgnoreCase("audio") && !CommonData.getAudioCallStatus()) {
            Toast.makeText((Context)context, (CharSequence)"This feature not supported", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            Toast.makeText((Context)context, (CharSequence)"TransactionId can't be null", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            Toast.makeText((Context)context, (CharSequence)"User unique key can't be null", (int)0).show();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string5)) {
            Toast.makeText((Context)context, (CharSequence)"other user name can't be null", (int)0).show();
            return;
        }
        if (arrayList == null || arrayList.size() == 0) {
            Toast.makeText((Context)context, (CharSequence)"Otheruser unique key can't be null", (int)0).show();
            return;
        }
        Gson gson = new GsonBuilder().create();
        JsonArray jsonArray = null;
        JsonArray jsonArray2 = null;
        if (arrayList != null) {
            jsonArray = gson.toJsonTree(arrayList).getAsJsonArray();
        }
        FuguCreateConversationParams fuguCreateConversationParams = new FuguCreateConversationParams(HippoConfig.getInstance().getAppKey(), (Long)-1L, string3, string4, jsonArray, string3, jsonArray2, HippoConfig.getInstance().getUserData().getEnUserId());
        Long l = CommonData.getUserDetails().getData().getUserId();
        String string9 = string5;
        if (HippoConfig.getInstance().getCallData() != null) {
            HippoConfig.getInstance().getCallData().onExternalClick(context, string2, l, string9, new Gson().toJson((Object)fuguCreateConversationParams, FuguCreateConversationParams.class), string6, string8);
        } else {
            Log.e((String)TAG, (String)"Please call setCallListener before this method");
        }
    }

    public OnApiCallback getOnApiCallback() {
        return this.onApiCallback;
    }

    public void setApiListener(OnApiCallback onApiCallback) {
        this.onApiCallback = onApiCallback;
    }

    public MobileCampaignBuilder getMobileCampaignBuilder() {
        if (this.campaignBuilder == null) {
            this.campaignBuilder = CommonData.getCampaignBuilder();
        }
        return this.campaignBuilder;
    }

    public void setCampaignBuilder(MobileCampaignBuilder mobileCampaignBuilder) {
        this.campaignBuilder = mobileCampaignBuilder;
    }

    public void openMobileCampaigns(Activity activity, MobileCampaignBuilder mobileCampaignBuilder) {
        this.campaignBuilder = mobileCampaignBuilder;
        Intent intent = new Intent((Context)activity, CampaignActivity.class);
        activity.startActivity(intent);
    }

    public HashMap<String, Integer> getQuestions() {
        return this.questions;
    }

    public void setQuestions(HashMap<String, Integer> hashMap) {
        this.questions = hashMap;
    }

    public HashMap<Integer, String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(HashMap<Integer, String> hashMap) {
        this.suggestions = hashMap;
    }

    public HashMap<Integer, ArrayList<Integer>> getMapping() {
        return this.mapping;
    }

    public void setMapping(HashMap<Integer, ArrayList<Integer>> hashMap) {
        this.mapping = hashMap;
    }

    public void setAgentEmail(String string2) {
        this.agentEmail = string2;
    }

    public String getAgentEmail() {
        return this.agentEmail;
    }

    public boolean getSingleChannelTransactionId() {
        return this.isSingleChannelTransactionId;
    }

    public void setSingleChannelTransactionId(boolean bl) {
        this.isSingleChannelTransactionId = bl;
    }

    public void isChatScreenBackBtnRequired(boolean bl) {
        CommonData.setNewBackBtn(bl);
    }

    private int getVersion(Activity activity) {
        try {
            PackageInfo packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return 102;
        }
    }

    private String getBundle(Activity activity) {
        try {
            PackageInfo packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "com.buddy.customer";
        }
    }

    public void checkAutoUpdate(final Activity activity) {
        if (++count > 1) {
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", hippoConfig.getAppKey()).add("bundle_id", this.getBundle(activity)).add("app_type", 1).add("app_version", this.getVersion(activity)).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)activity)).add("device_type", 1).add("source_type", 7).build();
        RestClient.getApiInterface().updateApp(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AppUpdateModel>(){

            @Override
            public void success(AppUpdateModel appUpdateModel) {
                CommonData.saveVersionInfo(appUpdateModel);
                Prefs.with((Context)activity).save("force_update_version", false);
                HippoLog.e("version", "version = " + HippoConfig.this.getVersion(activity));
                if (appUpdateModel.getData().getCriticalVersion() > HippoConfig.this.getVersion(activity)) {
                    Prefs.with((Context)activity).save("force_update_version", true);
                    HippoConfig.this.SingleBtnUpdateWindow(activity, appUpdateModel);
                } else if (HippoConfig.this.isAvailable(activity, appUpdateModel)) {
                    HippoConfig.this.showUpdatePopup((Context)activity);
                }
            }

            @Override
            public void failure(APIError aPIError) {
            }
        });
    }

    private void SingleBtnUpdateWindow(final Activity activity, final AppUpdateModel appUpdateModel) {
        try {
            SingleBtnDialog.with((Context)activity).setMessage(appUpdateModel.getData().getMessaage()).hideHeading().setCancelableOnTouchOutside(false).setCancelable(false).setCallback(new SingleBtnDialog.OnActionPerformed(){

                @Override
                public void positive() {
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)appUpdateModel.getData().getDownloadLink()));
                    activity.startActivity(intent);
                    activity.finish();
                }
            }).show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isAvailable(Activity activity, AppUpdateModel appUpdateModel) {
        boolean bl;
        int n = Prefs.with((Context)activity).getInt("last_displayed_version", 0);
        long l = Prefs.with((Context)activity).getLong("last_update_displayed", 0L);
        boolean bl2 = bl = System.currentTimeMillis() - l > appUpdateModel.getData().getSoftUpdateRetry() * 60L * 1000L;
        if (this.getVersion(activity) < appUpdateModel.getData().getLatestVersion() && (n < appUpdateModel.getData().getLatestVersion() || bl)) {
            Prefs.with((Context)activity).save("last_displayed_version", appUpdateModel.getData().getLatestVersion());
            Prefs.with((Context)activity).save("last_update_displayed", System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public void showUpdatePopup(final Context context) {
        AppUpdateModel appUpdateModel = CommonData.getVersionInfo();
        if (appUpdateModel == null) {
            return;
        }
        String string2 = appUpdateModel.getData().getMessaage();
        final String string3 = appUpdateModel.getData().getDownloadLink();
        if (this.dialogPop == null) {
            this.dialogPop = new DialogPop();
        }
        this.dialogPop.alertPopupWithTwoButton(context, "", string2, "OK", "Cancel", new DialogPop.Callback(){

            @Override
            public void onPositiveClick() {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string3));
                context.startActivity(intent);
            }

            @Override
            public void onNegativeClick() {
            }
        });
    }

    public void setAppName(String string2) {
        CommonData.setAppName(string2);
    }

    public void onCheckActity(final Activity activity) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                HippoLog.v(TAG, "onActivityCreated " + activity.getClass().getSimpleName());
                HippoConfig.this.startHippoService(activity);
            }
        }, (long)this.WAIT_TIME);
    }

    public void onServiceStarted() {
        if (this.serviceStarted) {
            return;
        }
        this.closed = false;
        Log.i((String)TAG, (String)"onServiceStarted in HippoConfig");
        this.onInitialized();
    }

    public void onServiceDestroy() {
        Log.i((String)TAG, (String)"onServiceDestroy");
        if (this.closed) {
            Log.i((String)TAG, (String)"onServiceDestroy closed");
            return;
        }
        this.onClose();
    }

    private void onInitialized() {
    }

    private void onClose() {
        Log.i((String)TAG, (String)"onClose1");
        this.closed = true;
        this.serviceStarted = false;
        Log.i((String)TAG, (String)"onClose2");
    }

    private synchronized void startHippoService(Activity activity) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                activity.startForegroundService(HippoService.createIntent((Context)activity));
            } else {
                activity.startService(HippoService.createIntent((Context)activity));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAdditionalInfo(boolean bl, Long l) {
        CommonData.directScreens(bl);
        CommonData.setConstantLabelId(l);
    }

    static {
        mReferenceId = -1;
        DEBUG = false;
        progressLoader = true;
        count = 0;
    }
}

