/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.a;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocket;
import org.java_websocket.c;
import org.java_websocket.c.d;
import org.java_websocket.c.f;
import org.java_websocket.c.h;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.Framedata;

public abstract class a
extends org.java_websocket.a
implements Runnable,
WebSocket {
    protected URI uri = null;
    private c engine = null;
    private Socket socket = null;
    private OutputStream ostream;
    private Proxy proxy = Proxy.NO_PROXY;
    private Thread writeThread;
    private Thread connectReadThread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    private int connectTimeout = 0;

    public a(URI uRI) {
        this(uRI, new org.java_websocket.drafts.a());
    }

    public a(URI uRI, Draft draft) {
        this(uRI, draft, null, 0);
    }

    public a(URI uRI, Map<String, String> map) {
        this(uRI, new org.java_websocket.drafts.a(), map);
    }

    public a(URI uRI, Draft draft, Map<String, String> map) {
        this(uRI, draft, map, 0);
    }

    public a(URI uRI, Draft draft, Map<String, String> map, int n2) {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = uRI;
        this.draft = draft;
        this.headers = map;
        this.connectTimeout = n2;
        this.setTcpNoDelay(false);
        this.setReuseAddr(false);
        this.engine = new c(this, draft);
    }

    public URI getURI() {
        return this.uri;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void reconnect() {
        this.reset();
        this.connect();
    }

    public boolean reconnectBlocking() throws InterruptedException {
        this.reset();
        return this.connectBlocking();
    }

    private void reset() {
        Thread thread = Thread.currentThread();
        if (thread == this.writeThread || thread == this.connectReadThread) {
            throw new IllegalStateException("You cannot initialize a reconnect out of the websocket thread. Use reconnect in another thread to insure a successful cleanup.");
        }
        try {
            this.closeBlocking();
            if (this.writeThread != null) {
                this.writeThread.interrupt();
                this.writeThread = null;
            }
            if (this.connectReadThread != null) {
                this.connectReadThread.interrupt();
                this.connectReadThread = null;
            }
            this.draft.a();
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            this.onError(exception);
            this.engine.b(1006, exception.getMessage());
            return;
        }
        this.connectLatch = new CountDownLatch(1);
        this.closeLatch = new CountDownLatch(1);
        this.engine = new c(this, this.draft);
    }

    public void connect() {
        if (this.connectReadThread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.connectReadThread = new Thread(this);
        this.connectReadThread.setName("WebSocketConnectReadThread-" + this.connectReadThread.getId());
        this.connectReadThread.start();
    }

    public boolean connectBlocking() throws InterruptedException {
        this.connect();
        this.connectLatch.await();
        return this.engine.e();
    }

    public boolean connectBlocking(long l2, TimeUnit timeUnit) throws InterruptedException {
        this.connect();
        return this.connectLatch.await(l2, timeUnit) && this.engine.e();
    }

    public void close() {
        if (this.writeThread != null) {
            this.engine.a(1000);
        }
    }

    public void closeBlocking() throws InterruptedException {
        this.close();
        this.closeLatch.await();
    }

    public void send(String string) throws NotYetConnectedException {
        this.engine.a(string);
    }

    public void send(byte[] byArray) throws NotYetConnectedException {
        this.engine.a(byArray);
    }

    public <T> T getAttachment() {
        return this.engine.p();
    }

    public <T> void setAttachment(T t) {
        this.engine.a(t);
    }

    @Override
    protected Collection<WebSocket> getConnections() {
        return Collections.singletonList(this.engine);
    }

    public void sendPing() throws NotYetConnectedException {
        this.engine.b();
    }

    @Override
    public void run() {
        InputStream inputStream;
        try {
            boolean bl = false;
            if (this.socket == null) {
                this.socket = new Socket(this.proxy);
                bl = true;
            } else if (this.socket.isClosed()) {
                throw new IOException();
            }
            this.socket.setTcpNoDelay(this.isTcpNoDelay());
            this.socket.setReuseAddress(this.isReuseAddr());
            if (!this.socket.isBound()) {
                this.socket.connect(new InetSocketAddress(this.uri.getHost(), this.getPort()), this.connectTimeout);
            }
            if (bl && "wss".equals(this.uri.getScheme())) {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                this.socket = sSLSocketFactory.createSocket(this.socket, this.uri.getHost(), this.getPort(), true);
            }
            inputStream = this.socket.getInputStream();
            this.ostream = this.socket.getOutputStream();
            this.sendHandshake();
        }
        catch (Exception exception) {
            this.onWebsocketError(this.engine, exception);
            this.engine.b(-1, exception.getMessage());
            return;
        }
        this.writeThread = new Thread(new a());
        this.writeThread.start();
        byte[] byArray = new byte[c.a];
        try {
            int n2;
            while (!this.isClosing() && !this.isClosed() && (n2 = inputStream.read(byArray)) != -1) {
                this.engine.a(ByteBuffer.wrap(byArray, 0, n2));
            }
            this.engine.a();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
            this.engine.b(1006, runtimeException.getMessage());
        }
        this.connectReadThread = null;
    }

    private int getPort() {
        int n2 = this.uri.getPort();
        if (n2 == -1) {
            String string = this.uri.getScheme();
            if ("wss".equals(string)) {
                return 443;
            }
            if ("ws".equals(string)) {
                return 80;
            }
            throw new IllegalArgumentException("unknown scheme: " + string);
        }
        return n2;
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String string = this.uri.getRawPath();
        String string2 = this.uri.getRawQuery();
        String string3 = string == null || string.length() == 0 ? "/" : string;
        if (string2 != null) {
            string3 = string3 + '?' + string2;
        }
        int n2 = this.getPort();
        String string4 = this.uri.getHost() + (n2 != 80 && n2 != 443 ? ":" + n2 : "");
        d d2 = new d();
        d2.a(string3);
        d2.a("Host", string4);
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                d2.a(entry.getKey(), entry.getValue());
            }
        }
        this.engine.a(d2);
    }

    public WebSocket.READYSTATE getReadyState() {
        return this.engine.i();
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        this.onMessage(string);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.onMessage(byteBuffer);
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket webSocket, Framedata framedata) {
        this.onFragment(framedata);
    }

    @Override
    public final void onWebsocketOpen(WebSocket webSocket, f f2) {
        this.startConnectionLostTimer();
        this.onOpen((h)f2);
        this.connectLatch.countDown();
    }

    @Override
    public final void onWebsocketClose(WebSocket webSocket, int n2, String string, boolean bl) {
        this.stopConnectionLostTimer();
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
        this.onClose(n2, string, bl);
        this.connectLatch.countDown();
        this.closeLatch.countDown();
    }

    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        this.onError(exception);
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n2, String string) {
        this.onCloseInitiated(n2, string);
    }

    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n2, String string, boolean bl) {
        this.onClosing(n2, string, bl);
    }

    public void onCloseInitiated(int n2, String string) {
    }

    public void onClosing(int n2, String string, boolean bl) {
    }

    public WebSocket getConnection() {
        return this.engine;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket webSocket) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket webSocket) {
        if (this.socket != null) {
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        return null;
    }

    public abstract void onOpen(h var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer byteBuffer) {
    }

    @Deprecated
    public void onFragment(Framedata framedata) {
    }

    private void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            this.onWebsocketError(this, iOException);
        }
    }

    public void setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        this.proxy = proxy;
    }

    public void setSocket(Socket socket) {
        if (this.socket != null) {
            throw new IllegalStateException("socket has already been set");
        }
        this.socket = socket;
    }

    public void sendFragmentedFrame(Framedata.Opcode opcode, ByteBuffer byteBuffer, boolean bl) {
        this.engine.a(opcode, byteBuffer, bl);
    }

    public boolean isOpen() {
        return this.engine.e();
    }

    public boolean isFlushAndClose() {
        return this.engine.g();
    }

    public boolean isClosed() {
        return this.engine.h();
    }

    public boolean isClosing() {
        return this.engine.f();
    }

    @Deprecated
    public boolean isConnecting() {
        return this.engine.d();
    }

    public boolean hasBufferedData() {
        return this.engine.c();
    }

    public void close(int n2) {
        this.engine.l();
    }

    public void close(int n2, String string) {
        this.engine.a(n2, string);
    }

    public void closeConnection(int n2, String string) {
        this.engine.b(n2, string);
    }

    public void send(ByteBuffer byteBuffer) throws IllegalArgumentException, NotYetConnectedException {
        this.engine.b(byteBuffer);
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.engine.sendFrame(framedata);
    }

    public void sendFrame(Collection<Framedata> collection) {
        this.engine.a(collection);
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.engine.k();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.engine.j();
    }

    public String getResourceDescriptor() {
        return this.uri.getPath();
    }

    private void handleIOException(IOException iOException) {
        if (iOException instanceof SSLException) {
            this.onError(iOException);
        }
        this.engine.a();
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketWriteThread-" + Thread.currentThread().getId());
            try {
                try {
                    while (!Thread.interrupted()) {
                        ByteBuffer byteBuffer = ((a)a.this).engine.c.take();
                        a.this.ostream.write(byteBuffer.array(), 0, byteBuffer.limit());
                        a.this.ostream.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    for (ByteBuffer byteBuffer : ((a)a.this).engine.c) {
                        a.this.ostream.write(byteBuffer.array(), 0, byteBuffer.limit());
                        a.this.ostream.flush();
                    }
                }
            }
            catch (IOException iOException) {
                a.this.handleIOException(iOException);
            }
            finally {
                a.this.closeSocket();
                a.this.writeThread = null;
            }
        }
    }
}

